/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.clustered;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorsCluster;
import com.gigaspaces.internal.remoting.routing.clustered.SpaceProxyLoadBalancingStrategy;
import com.gigaspaces.internal.utils.concurrent.CyclicAtomicInteger;
import com.gigaspaces.internal.utils.concurrent.VolatileArray;
import java.util.Arrays;
import java.util.Collection;

@InternalApi
public class RoundRobinLoadBalancingStrategy
extends SpaceProxyLoadBalancingStrategy {
    private final String[] _membersNames;
    private final VolatileArray<RemoteOperationsExecutorProxy> _members;
    private final CyclicAtomicInteger _defaultLoadBalancer;
    private final CyclicAtomicInteger[] _operationsLoadBalancers;

    public RoundRobinLoadBalancingStrategy(RemoteOperationsExecutorsCluster cluster, Collection<String> membersNames, int numOfOperationsTypes) {
        super(cluster);
        int size = membersNames.size();
        this._membersNames = membersNames.toArray(new String[size]);
        Arrays.sort(this._membersNames);
        this._members = new VolatileArray(size);
        this._defaultLoadBalancer = new CyclicAtomicInteger(size - 1);
        this._operationsLoadBalancers = new CyclicAtomicInteger[numOfOperationsTypes];
        for (int i = 0; i < this._operationsLoadBalancers.length; ++i) {
            this._operationsLoadBalancers[i] = new CyclicAtomicInteger(size - 1);
        }
    }

    @Override
    public RemoteOperationsExecutorProxy getCandidate(RemoteOperationRequest<?> request) {
        CyclicAtomicInteger loadBalancer = request == null ? this._defaultLoadBalancer : this._operationsLoadBalancers[request.getOperationCode()];
        int memberId = loadBalancer.getAndIncrement();
        RemoteOperationsExecutorProxy candidate = this._members.get(memberId);
        if (candidate != null) {
            return candidate;
        }
        int numOfMembers = this._membersNames.length;
        for (int offset = 1; offset < numOfMembers; ++offset) {
            int index = memberId + offset;
            if (index >= numOfMembers) {
                index -= numOfMembers;
            }
            if ((candidate = this._members.get(index)) == null) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public void onMemberConnected(RemoteOperationsExecutorProxy connectedMember) {
        this._members.set(this.indexOf(connectedMember.getName()), connectedMember);
    }

    @Override
    public void onMemberDisconnected(String disconnectedMemberName) {
        this._members.set(this.indexOf(disconnectedMemberName), null);
    }

    private int indexOf(String memberName) {
        return Arrays.binarySearch(this._membersNames, memberName);
    }

    @Override
    protected void updateActiveProxy(RemoteOperationsExecutorProxy newActiveProxy) {
        if (newActiveProxy != null) {
            this.onMemberConnected(newActiveProxy);
        }
    }
}

