/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.clustered;

import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.RemoteOperationRouterException;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorsCluster;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SpaceProxyLoadBalancingStrategy {
    protected final RemoteOperationsExecutorsCluster _cluster;
    protected final Logger _logger;
    protected final Object _lock;

    public SpaceProxyLoadBalancingStrategy(RemoteOperationsExecutorsCluster cluster) {
        this._cluster = cluster;
        this._logger = this._cluster.getLogger();
        this._lock = new Object();
    }

    public abstract RemoteOperationsExecutorProxy getCandidate(RemoteOperationRequest<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteOperationsExecutorProxy findActiveMember(RemoteOperationRequest<?> request, long initialFailureTime, RemoteOperationsExecutorProxy oldCandidate) throws InterruptedException {
        Object object = this._lock;
        synchronized (object) {
            RemoteOperationsExecutorProxy newCandidate = this.getCandidate(request);
            if (newCandidate != oldCandidate && newCandidate != null) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Active server" + this._cluster.getPartitionDesc() + " was updated from " + (oldCandidate == null ? "null" : oldCandidate.getName()) + " to " + newCandidate.getName());
                }
                this._cluster.disconnect(oldCandidate);
                return newCandidate;
            }
            long remainingTime = this._cluster.getRemainingTime(request, initialFailureTime);
            if (remainingTime <= 0L) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Timeout expired while searching for active server" + this._cluster.getPartitionDesc() + " " + this._cluster.getElapsedTime(initialFailureTime));
                }
                return null;
            }
            try {
                RemoteOperationsExecutorProxy activeProxy = this._cluster.getAvailableMember(true, remainingTime);
                this.updateActiveProxy(activeProxy);
                if (activeProxy == null) {
                    String timeoutErrorMessage = this._cluster.generateTimeoutErrorMessage(initialFailureTime, request);
                    if (this._logger.isLoggable(Level.SEVERE)) {
                        this._logger.log(Level.SEVERE, timeoutErrorMessage);
                    }
                    request.setRemoteOperationExecutionError(new RemoteException(timeoutErrorMessage));
                }
                return activeProxy;
            }
            catch (RemoteOperationRouterException e) {
                request.setRemoteOperationExecutionError(e);
                return null;
            }
        }
    }

    public RemoteOperationsExecutorProxy findActiveMemberUninterruptibly(RemoteOperationRequest<?> request, long initialFailureTime, RemoteOperationsExecutorProxy proxy) {
        try {
            return this.findActiveMember(request, initialFailureTime, proxy);
        }
        catch (InterruptedException e) {
            request.setRemoteOperationExecutionError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteOperationsExecutorProxy findAnyAvailableMember(boolean activeOnly) {
        RemoteOperationsExecutorProxy activeProxy = this.getCandidate(null);
        if (RemoteOperationsExecutorProxy.isAvailable(activeProxy, activeOnly)) {
            return activeProxy;
        }
        try {
            RemoteOperationsExecutorProxy result;
            long timeout = this._cluster.getConfig().getActiveServerLookupTimeout();
            if (activeOnly) {
                Object object = this._lock;
                synchronized (object) {
                    result = this._cluster.getAvailableMember(true, timeout);
                    this.updateActiveProxy(result);
                }
            } else {
                result = this._cluster.getAvailableMember(false, timeout);
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (RemoteOperationRouterException e) {
            return null;
        }
    }

    public void onMemberConnected(RemoteOperationsExecutorProxy connectedMember) {
    }

    public void onMemberDisconnected(String disconnectedMemberName) {
    }

    protected abstract void updateActiveProxy(RemoteOperationsExecutorProxy var1);
}

