/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.embedded;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.internal.remoting.RemoteOperationFutureListener;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.RemoteOperationResult;
import com.gigaspaces.internal.remoting.RemoteOperationsExecutor;
import com.gigaspaces.internal.remoting.routing.AbstractRemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.utils.concurrent.ContextClassLoaderRunnable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;

@InternalApi
public class EmbeddedRemoteOperationRouter
extends AbstractRemoteOperationRouter {
    protected final RemoteOperationsExecutorProxy _memberProxy;
    private final int _partitionId;
    private final String _partitionDesc;
    private final String _name;
    protected final RemoteOperationsExecutor _executor;
    private final Executor _asyncExecutor;

    public EmbeddedRemoteOperationRouter(RemoteOperationsExecutorProxy memberProxy, int partitionId, String name, Executor asyncExecutor) {
        super(name);
        this._name = name;
        this._memberProxy = memberProxy;
        this._partitionId = partitionId;
        this._partitionDesc = this._partitionId == -1 ? "" : " for partition #" + (this._partitionId + 1);
        this._executor = memberProxy.getExecutor();
        this._asyncExecutor = asyncExecutor;
        if (this._logger.isLoggable(Level.CONFIG)) {
            this._logger.log(Level.CONFIG, "Initialized embedded router" + this.getPartitionDesc() + " - member=[" + memberProxy.getName() + "]");
        }
    }

    public RemoteOperationsExecutor getExecutor() {
        return this._executor;
    }

    @Override
    public <T extends RemoteOperationResult> void execute(RemoteOperationRequest<T> request) throws InterruptedException {
        this.executeImpl(request, false);
    }

    private <T extends RemoteOperationResult> void executeImpl(RemoteOperationRequest<T> request, boolean oneway) {
        if (!this.beforeOperationExecution(request)) {
            return;
        }
        try {
            RemoteOperationResult result = null;
            this.logBeforeExecute(this._memberProxy, request, oneway);
            if (oneway) {
                this._executor.executeOperationOneway(request);
            } else {
                result = (RemoteOperationResult)this._executor.executeOperation(request);
            }
            this.logAfterExecute(this._memberProxy, request, result, oneway);
            request.setRemoteOperationResult(result);
            this.afterOperationExecution(request);
        }
        catch (RemoteException e) {
            this.logExecutionFailure(this._memberProxy, request, e, oneway);
            request.setRemoteOperationExecutionError(e);
        }
    }

    protected boolean beforeOperationExecution(RemoteOperationRequest<?> request) {
        return true;
    }

    protected void afterOperationExecution(RemoteOperationRequest<?> request) {
    }

    @Override
    public <T extends RemoteOperationResult> RemoteOperationFutureListener<T> createFutureListener(RemoteOperationRequest<T> request, AsyncFutureListener<Object> listener) {
        return new RemoteOperationFutureListener(this._logger, listener);
    }

    @Override
    public <T extends RemoteOperationResult> void executeAsync(RemoteOperationRequest<T> request, RemoteOperationFutureListener<T> futureListener) {
        if (!this.beforeOperationExecution(request)) {
            futureListener.onOperationCompletion(request, this._memberProxy);
            return;
        }
        this.logBeforeExecuteAsync(this._memberProxy, request);
        this._asyncExecutor.execute(new AsyncOperationExecutor<T>(request, futureListener));
    }

    @Override
    public void executeOneway(RemoteOperationRequest<?> request) throws InterruptedException {
        this.executeImpl(request, true);
    }

    @Override
    public RemoteOperationsExecutorProxy getCachedMember() {
        return this._memberProxy;
    }

    @Override
    public RemoteOperationsExecutorProxy getAnyAvailableMember() {
        return this._memberProxy;
    }

    @Override
    public RemoteOperationsExecutorProxy getAnyActiveMember() {
        try {
            return this._memberProxy.isActiveQuiesceTokenAware() ? this._memberProxy : null;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public void getAllAvailableMembers(List<RemoteOperationsExecutorProxy> availableMembers) {
        availableMembers.add(this._memberProxy);
    }

    @Override
    public void close() {
    }

    private String getPartitionDesc() {
        return this._partitionDesc;
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public String getName() {
        return this._name;
    }

    private class AsyncOperationExecutor<T extends RemoteOperationResult>
    extends ContextClassLoaderRunnable {
        private final RemoteOperationRequest<T> _request;
        private final RemoteOperationFutureListener<T> _futureListener;

        public AsyncOperationExecutor(RemoteOperationRequest<T> request, RemoteOperationFutureListener<T> listener) {
            this._request = request;
            this._futureListener = listener;
        }

        @Override
        protected void execute() {
            try {
                T result = EmbeddedRemoteOperationRouter.this._executor.executeOperation(this._request);
                EmbeddedRemoteOperationRouter.this.logAfterExecuteAsync(EmbeddedRemoteOperationRouter.this._memberProxy, this._request, result);
                this._request.setRemoteOperationResult(result);
                EmbeddedRemoteOperationRouter.this.afterOperationExecution(this._request);
            }
            catch (RemoteException e) {
                EmbeddedRemoteOperationRouter.this.logAsyncExecutionFailure(EmbeddedRemoteOperationRouter.this._memberProxy, this._request, e);
                this._request.setRemoteOperationExecutionError(e);
            }
            if (this._futureListener != null) {
                this._futureListener.onOperationCompletion(this._request, EmbeddedRemoteOperationRouter.this._memberProxy);
            }
        }
    }
}

