/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.partitioned;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.internal.remoting.RemoteOperationFutureListener;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.RemoteOperationResult;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class BroadcastOperationFutureListener<T extends RemoteOperationResult>
extends RemoteOperationFutureListener<T> {
    private final RemoteOperationRequest<T> _mainRequest;
    private final PartitionedClusterRemoteOperationRouter _router;
    private final List<T> _previousResults;
    private final int _startPartitionId;

    public BroadcastOperationFutureListener(RemoteOperationRequest<T> mainRequest, AsyncFutureListener<Object> listener, PartitionedClusterRemoteOperationRouter router, boolean getResultOnCompletion) {
        super(router.getLogger(), listener, getResultOnCompletion);
        this._mainRequest = mainRequest;
        this._router = router;
        this._previousResults = new ArrayList<T>();
        this._startPartitionId = router.getNextDistributionPartitionId(mainRequest);
    }

    @Override
    protected boolean onOperationResultArrival(RemoteOperationRequest<T> partitionRequest) {
        T partitionResult = partitionRequest.getRemoteOperationResult();
        boolean continueProcessing = this._mainRequest.processPartitionResult(partitionResult, this._previousResults, this._router.getNumOfPartitions());
        if (!continueProcessing || this._previousResults.size() + 1 >= this._router.getNumOfPartitions()) {
            return true;
        }
        if (this._mainRequest == partitionRequest) {
            this._mainRequest.setRemoteOperationResult(null);
        }
        this._previousResults.add(partitionResult);
        if (this._mainRequest.getPartitionedClusterExecutionType() == PartitionedClusterExecutionType.BROADCAST_SEQUENTIAL) {
            int partitionId = (this.getStartPartitionId() + this._previousResults.size()) % this._router.getNumOfPartitions();
            this._router.getPartitionRouter(partitionId).executeAsync(this._mainRequest, this);
        }
        return false;
    }

    @Override
    protected Object getResult(RemoteOperationRequest<T> request) throws Exception {
        return this._mainRequest.getAsyncFinalResult();
    }

    public int getStartPartitionId() {
        return this._startPartitionId;
    }
}

