/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.partitioned;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.internal.quiesce.QuiesceTokenProviderImpl;
import com.gigaspaces.internal.remoting.RemoteOperationFutureListener;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.RemoteOperationResult;
import com.gigaspaces.internal.remoting.routing.AbstractRemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.RemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.RemoteOperationRouterException;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorsCluster;
import com.gigaspaces.internal.remoting.routing.partitioned.BroadcastOperationFutureListener;
import com.gigaspaces.internal.remoting.routing.partitioned.CoordinatorFactory;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterUtils;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherOperationFutureListener;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherRemoteOperationRequest;
import com.gigaspaces.internal.utils.concurrent.CyclicAtomicInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class PartitionedClusterRemoteOperationRouter
extends AbstractRemoteOperationRouter {
    private static final RemoteOperationsExecutorProxy _dummyProxy = new RemoteOperationsExecutorProxy("dummy", null, new QuiesceTokenProviderImpl());
    private final RemoteOperationRouter[] _partitions;
    private final CoordinatorFactory _listenerFactory;
    private final RemoteOperationsExecutorsCluster _partitionedCluster;
    private final CyclicAtomicInteger[] _roundRobinPreciseIndexes;
    private final boolean _broadcastDisabled;
    private int _roundRobinApproxIndex = 0;

    public PartitionedClusterRemoteOperationRouter(String name, RemoteOperationRouter[] partitions, CoordinatorFactory coordinatorFactory, boolean broadcastDisabled, int numberOfPerciseRoundRobingOperations, RemoteOperationsExecutorsCluster partitionedCluster) {
        super(name);
        this._partitions = partitions;
        this._listenerFactory = coordinatorFactory;
        this._broadcastDisabled = broadcastDisabled;
        this._partitionedCluster = partitionedCluster;
        this._roundRobinPreciseIndexes = new CyclicAtomicInteger[numberOfPerciseRoundRobingOperations];
        for (int i = 0; i < this._roundRobinPreciseIndexes.length; ++i) {
            this._roundRobinPreciseIndexes[i] = new CyclicAtomicInteger(this.getNumOfPartitions() - 1);
        }
        if (this._logger.isLoggable(Level.CONFIG)) {
            this._logger.log(Level.CONFIG, "Initialized partitioned cluster router - number of partitions = " + partitions.length);
        }
    }

    public int getNumOfPartitions() {
        return this._partitions.length;
    }

    public RemoteOperationRouter getPartitionRouter(int partitionId) {
        return this._partitions[partitionId];
    }

    public int getNextPreciseDistributionPartitionId(int groupingCode) {
        return this._roundRobinPreciseIndexes[groupingCode].getAndIncrement();
    }

    public int getNextApproxDistributionPartitionId() {
        int currentIndex;
        do {
            ++this._roundRobinApproxIndex;
            if (currentIndex >= 0) continue;
            this._roundRobinApproxIndex = 0;
        } while (currentIndex < 0);
        return currentIndex % this.getNumOfPartitions();
    }

    @Override
    public <T extends RemoteOperationResult> void execute(RemoteOperationRequest<T> request) throws InterruptedException {
        PartitionedClusterExecutionType executionType = request.getPartitionedClusterExecutionType();
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "Starting partitioned execution (" + (Object)((Object)executionType) + ") of " + request.toString());
        }
        switch (executionType) {
            case SINGLE: {
                this.executeSingle(request, false);
                break;
            }
            case BROADCAST_SEQUENTIAL: {
                this.assertBroadcastEnabled();
                this.executeBroadcastSequential(request);
                break;
            }
            case BROADCAST_CONCURRENT: {
                this.assertBroadcastEnabled();
                this.executeBroadcastConcurrent(request);
                break;
            }
            case SCATTER_SEQUENTIAL: {
                this.executeScatterSequential((ScatterGatherRemoteOperationRequest)request);
                break;
            }
            case SCATTER_CONCURRENT: {
                this.executeScatterConcurrent((ScatterGatherRemoteOperationRequest)request);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported PartitionedClusterExecutionType: " + (Object)((Object)executionType));
            }
        }
    }

    @Override
    public <T extends RemoteOperationResult> RemoteOperationFutureListener<T> createFutureListener(RemoteOperationRequest<T> request, AsyncFutureListener<Object> listener) {
        PartitionedClusterExecutionType executionType = request.getPartitionedClusterExecutionType();
        switch (executionType) {
            case SINGLE: {
                return new RemoteOperationFutureListener(this._logger, listener);
            }
            case BROADCAST_SEQUENTIAL: 
            case BROADCAST_CONCURRENT: {
                return this._listenerFactory.createAsyncBroadcastListener(request, listener, this);
            }
            case SCATTER_SEQUENTIAL: 
            case SCATTER_CONCURRENT: {
                return this._listenerFactory.createAsyncScatterGatherListener((ScatterGatherRemoteOperationRequest)request, listener, this);
            }
        }
        throw new IllegalStateException("Unsupported PartitionedClusterExecutionType: " + (Object)((Object)executionType));
    }

    @Override
    public <T extends RemoteOperationResult> void executeAsync(RemoteOperationRequest<T> request, RemoteOperationFutureListener<T> futureListener) {
        PartitionedClusterExecutionType executionType = request.getPartitionedClusterExecutionType();
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "Starting async partitioned execution (" + (Object)((Object)executionType) + ") of " + request.toString());
        }
        switch (executionType) {
            case SINGLE: {
                this.executeSingleAsync(request, futureListener);
                break;
            }
            case BROADCAST_SEQUENTIAL: {
                this.assertBroadcastEnabled();
                this.executeBroadcastSequentialAsync(request, (BroadcastOperationFutureListener)futureListener);
                break;
            }
            case BROADCAST_CONCURRENT: {
                this.assertBroadcastEnabled();
                this.executeBroadcastConcurrentAsync(request, (BroadcastOperationFutureListener)futureListener);
                break;
            }
            case SCATTER_SEQUENTIAL: {
                this.executeScatterSequentialAsync((ScatterGatherRemoteOperationRequest)request, (ScatterGatherOperationFutureListener)futureListener);
                break;
            }
            case SCATTER_CONCURRENT: {
                this.executeScatterConcurrentAsync((ScatterGatherRemoteOperationRequest)request, (ScatterGatherOperationFutureListener)futureListener);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported PartitionedClusterExecutionType: " + (Object)((Object)executionType));
            }
        }
    }

    @Override
    public void executeOneway(RemoteOperationRequest<?> request) throws InterruptedException {
        PartitionedClusterExecutionType executionType = request.getPartitionedClusterExecutionType();
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "Starting oneway partitioned execution (" + (Object)((Object)executionType) + ") of " + request.toString());
        }
        switch (executionType) {
            case SINGLE: {
                this.executeSingle(request, true);
                break;
            }
            case SCATTER_CONCURRENT: {
                this.executeScatterConcurrentOneway((ScatterGatherRemoteOperationRequest)request);
                break;
            }
            case BROADCAST_CONCURRENT: {
                this.assertBroadcastEnabled();
                this.executeBroadcastConcurrentOneway(request);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported PartitionedClusterExecutionType: " + (Object)((Object)executionType));
            }
        }
    }

    private <T extends RemoteOperationResult> void executeSingle(RemoteOperationRequest<T> request, boolean oneway) throws InterruptedException {
        Object routingValue = request.getPartitionedClusterRoutingValue(this);
        int partitionId = PartitionedClusterUtils.getPartitionId(routingValue, this._partitions.length);
        if (partitionId == -1) {
            request.setRemoteOperationExecutionError(new RemoteOperationRouterException("Cannot execute operation on partitioned cluster without routing value"));
            return;
        }
        if (oneway) {
            this._partitions[partitionId].executeOneway(request);
        } else {
            this._partitions[partitionId].execute(request);
        }
    }

    private <T extends RemoteOperationResult> void executeSingleAsync(RemoteOperationRequest<T> request, RemoteOperationFutureListener<T> listener) {
        Object routingValue = request.getPartitionedClusterRoutingValue(this);
        int partitionId = PartitionedClusterUtils.getPartitionId(routingValue, this._partitions.length);
        if (partitionId == -1) {
            request.setRemoteOperationExecutionError(new RemoteOperationRouterException("Cannot execute operation on partitioned cluster without routing value"));
            if (listener != null) {
                listener.onOperationCompletion(request, _dummyProxy);
            }
            return;
        }
        this._partitions[partitionId].executeAsync(request, listener);
    }

    private <T extends RemoteOperationResult> void executeBroadcastSequential(RemoteOperationRequest<T> request) throws InterruptedException {
        int startIndex = this.getNextDistributionPartitionId(request);
        ArrayList<T> previousResults = new ArrayList<T>();
        for (int i = 0; i < this._partitions.length; ++i) {
            int index = (i + startIndex) % this._partitions.length;
            request.setRemoteOperationResult(null);
            this._partitions[index].execute(request);
            T partitionResult = request.getRemoteOperationResult();
            boolean continueProcessing = request.processPartitionResult(partitionResult, previousResults, this._partitions.length);
            if (!continueProcessing) break;
            previousResults.add(partitionResult);
        }
    }

    public int getNextDistributionPartitionId(RemoteOperationRequest<?> request) {
        return request.requiresPartitionedPreciseDistribution() ? this.getNextPreciseDistributionPartitionId(request.getPreciseDistributionGroupingCode()) : this.getNextApproxDistributionPartitionId();
    }

    private <T extends RemoteOperationResult> void executeBroadcastSequentialAsync(RemoteOperationRequest<T> request, BroadcastOperationFutureListener<T> listener) {
        int startPartitionId = listener.getStartPartitionId();
        this._partitions[startPartitionId].executeAsync(request, listener);
    }

    private <T extends RemoteOperationResult> void executeBroadcastConcurrent(RemoteOperationRequest<T> request) throws InterruptedException {
        BroadcastOperationFutureListener<T> listener = this._listenerFactory.createSyncBroadcastListener(request, this);
        this.executeBroadcastConcurrentAsync(request, listener);
        listener.waitForCompletion();
    }

    private <T extends RemoteOperationResult> void executeBroadcastConcurrentAsync(RemoteOperationRequest<T> request, BroadcastOperationFutureListener<T> listener) {
        RemoteOperationRequest<T> isolatedCopy = request.createCopy(-1);
        for (int i = 0; i < this._partitions.length; ++i) {
            this._partitions[i].executeAsync(isolatedCopy.createCopy(i), listener);
        }
    }

    private void executeBroadcastConcurrentOneway(RemoteOperationRequest<?> request) throws InterruptedException {
        RemoteOperationRequest<?> isolatedCopy = request.createCopy(-1);
        for (int i = 0; i < this._partitions.length; ++i) {
            this._partitions[i].executeOneway(isolatedCopy.createCopy(i));
        }
    }

    private <T extends RemoteOperationResult> void executeScatterSequential(ScatterGatherRemoteOperationRequest<T> request) throws InterruptedException {
        ScatterGatherOperationFutureListener<T> listener = this._listenerFactory.createSyncScatterGatherListener(request, this);
        request.scatterIndexesToPartitions(listener);
        ArrayList previousPartitions = new ArrayList();
        for (int partitionId : listener.getPartitionIds()) {
            ScatterGatherRemoteOperationRequest<T> partitionRequest = listener.getPartitionRequest(partitionId, request);
            this._partitions[partitionId].execute(partitionRequest);
            request.processPartitionResult(partitionRequest, previousPartitions);
            previousPartitions.add(partitionRequest);
        }
    }

    private <T extends RemoteOperationResult> void executeScatterSequentialAsync(ScatterGatherRemoteOperationRequest<T> request, ScatterGatherOperationFutureListener<T> listener) {
        request.scatterIndexesToPartitions(listener);
        int firstPartitionId = listener.getPartitionIds()[0];
        ScatterGatherRemoteOperationRequest<T> partitionRequest = listener.getPartitionRequest(firstPartitionId, request);
        this._partitions[firstPartitionId].executeAsync(partitionRequest, listener);
    }

    private <T extends RemoteOperationResult> void executeScatterConcurrent(ScatterGatherRemoteOperationRequest<T> request) throws InterruptedException {
        ScatterGatherOperationFutureListener<T> listener = this._listenerFactory.createSyncScatterGatherListener(request, this);
        this.executeScatterConcurrentAsync(request, listener);
        listener.waitForCompletion();
    }

    private <T extends RemoteOperationResult> void executeScatterConcurrentAsync(ScatterGatherRemoteOperationRequest<T> request, ScatterGatherOperationFutureListener<T> listener) {
        request.scatterIndexesToPartitions(listener);
        for (int partitionId : listener.getPartitionIds()) {
            ScatterGatherRemoteOperationRequest<T> partitionRequest = listener.getPartitionRequest(partitionId, request);
            this._partitions[partitionId].executeAsync(partitionRequest, listener);
        }
    }

    private void executeScatterConcurrentOneway(ScatterGatherRemoteOperationRequest<?> request) throws InterruptedException {
        ScatterGatherOperationFutureListener<?> listener = this._listenerFactory.createSyncScatterGatherListener(request, this);
        request.scatterIndexesToPartitions(listener);
        for (int partitionId : listener.getPartitionIds()) {
            ScatterGatherRemoteOperationRequest<?> partitionRequest = listener.getPartitionRequest(partitionId, request);
            this._partitions[partitionId].executeOneway(partitionRequest);
        }
    }

    @Override
    public RemoteOperationsExecutorProxy getAnyAvailableMember() {
        return this.getAvailableMember(false, this._partitionedCluster.getConfig().getActiveServerLookupTimeout());
    }

    @Override
    public RemoteOperationsExecutorProxy getAnyActiveMember() {
        return this.getAvailableMember(true, this._partitionedCluster.getConfig().getActiveServerLookupTimeout());
    }

    private RemoteOperationsExecutorProxy getAvailableMember(boolean activeOnly, long timeout) {
        for (int i = 0; i < this.getNumOfPartitions(); ++i) {
            RemoteOperationsExecutorProxy member = this.getPartitionRouter(i).getCachedMember();
            if (!RemoteOperationsExecutorProxy.isAvailable(member, activeOnly)) continue;
            return member;
        }
        try {
            return this._partitionedCluster.getAvailableMember(activeOnly, timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (RemoteOperationRouterException e) {
            return null;
        }
    }

    @Override
    public void getAllAvailableMembers(List<RemoteOperationsExecutorProxy> availableMembers) {
        for (int i = 0; i < this.getNumOfPartitions(); ++i) {
            this.getPartitionRouter(i).getAllAvailableMembers(availableMembers);
        }
    }

    @Override
    public void close() {
        this._partitionedCluster.close();
        for (RemoteOperationRouter partition : this._partitions) {
            partition.close();
        }
    }

    private void assertBroadcastEnabled() {
        if (this._broadcastDisabled) {
            throw new IllegalArgumentException("Can not perform broadcast. Broadcast is disabled by the cluster configuration property 'cluster-config.groups.group.load-bal-policy.default.broadcast-condition=broadcast-disabled'.");
        }
    }

    public Logger getLogger() {
        return this._logger;
    }
}

