/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.partitioned;

import com.gigaspaces.api.InternalApi;

@InternalApi
public class PartitionedClusterUtils {
    public static final int NO_PARTITION = -1;
    private static final boolean PRECISE_LONG_ROUTING = !Boolean.getBoolean("com.gs.disable-precise-long-routing");

    private PartitionedClusterUtils() {
    }

    public static int getPartitionId(Object routingValue, int numOfPartitions) {
        if (routingValue == null) {
            return -1;
        }
        if (routingValue instanceof Long && PRECISE_LONG_ROUTING) {
            return (int)(PartitionedClusterUtils.safeAbs((Long)routingValue) % (long)numOfPartitions);
        }
        return PartitionedClusterUtils.safeAbs(routingValue.hashCode()) % numOfPartitions;
    }

    public static int safeAbs(int value) {
        return value == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(value);
    }

    private static long safeAbs(long value) {
        return value == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(value);
    }

    public static int extractPartitionIdFromSpaceName(String spaceName) {
        if (spaceName == null || spaceName.length() == 0) {
            return -1;
        }
        String partitionPrefix = "_container";
        int pos = spaceName.indexOf("_container");
        if (pos == -1) {
            return -1;
        }
        int routing = 0;
        pos += "_container".length();
        char c = spaceName.charAt(pos++);
        while (c >= '0' && c <= '9') {
            routing = routing * 10 + (c - 48);
            c = spaceName.charAt(pos++);
        }
        return routing - 1;
    }
}

