/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.partitioned;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.IntegerObjectMap;
import com.gigaspaces.internal.remoting.RemoteOperationFutureListener;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.RemoteOperationResult;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterUtils;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherPartitionInfo;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherRemoteOperationRequest;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class ScatterGatherOperationFutureListener<T extends RemoteOperationResult>
extends RemoteOperationFutureListener<T> {
    private final IntegerObjectMap<ScatterGatherRemoteOperationRequest<T>> _map;
    private final ScatterGatherRemoteOperationRequest<T> _mainRequest;
    private final PartitionedClusterRemoteOperationRouter _router;
    private final List<ScatterGatherRemoteOperationRequest<T>> _previousResults;
    private int[] _partitionIds;

    public ScatterGatherOperationFutureListener(ScatterGatherRemoteOperationRequest<T> mainRequest, AsyncFutureListener<Object> listener, PartitionedClusterRemoteOperationRouter router, boolean getResultOnCompletion) {
        super(router.getLogger(), listener, getResultOnCompletion);
        this._mainRequest = mainRequest;
        this._router = router;
        this._previousResults = new ArrayList<ScatterGatherRemoteOperationRequest<T>>();
        this._map = CollectionsFactory.getInstance().createIntegerObjectMap();
    }

    public void mapValuesByHashCode(Object[] array, ScatterGatherRemoteOperationRequest<T> request) {
        for (int i = 0; i < array.length; ++i) {
            this.mapIndexToPartition(i, this.getPartitionIdByHashcode(array[i]), request);
        }
    }

    public int getPartitionIdByHashcode(Object value) {
        return PartitionedClusterUtils.getPartitionId(value, this._router.getNumOfPartitions());
    }

    public int getNextDistributionPartitionId() {
        return this._router.getNextDistributionPartitionId(this._mainRequest);
    }

    public void mapIndexToPartition(int index, int partitionId, ScatterGatherRemoteOperationRequest<T> request) {
        if (partitionId != -1) {
            this.addPartition(partitionId, request).add(index);
        } else {
            for (int i = 0; i < this._router.getNumOfPartitions(); ++i) {
                this.addPartition(i, request).add(index);
            }
        }
    }

    public ScatterGatherPartitionInfo addPartition(int partitionId, ScatterGatherRemoteOperationRequest<T> request) {
        ScatterGatherRemoteOperationRequest partitionRequest = this._map.get(partitionId);
        if (partitionRequest == null) {
            partitionRequest = (ScatterGatherRemoteOperationRequest)request.createCopy(partitionId);
            this._map.put(partitionId, partitionRequest);
        }
        return partitionRequest.getPartitionInfo();
    }

    public int[] getPartitionIds() {
        if (this._partitionIds == null) {
            this._partitionIds = this._map.keys();
        }
        return this._partitionIds;
    }

    public int getNumOfPartitions() {
        return this._router.getNumOfPartitions();
    }

    public ScatterGatherRemoteOperationRequest<T> getPartitionRequest(int partitionId, ScatterGatherRemoteOperationRequest<T> mainRequest) {
        ScatterGatherRemoteOperationRequest<T> partitionRequest = this._map.get(partitionId);
        partitionRequest.loadPartitionData(mainRequest);
        return partitionRequest;
    }

    @Override
    protected boolean onOperationResultArrival(RemoteOperationRequest<T> request) {
        ScatterGatherRemoteOperationRequest<T> partitionRequest = (ScatterGatherRemoteOperationRequest<T>)request;
        boolean continueProcessing = this._mainRequest.processPartitionResult(partitionRequest, this._previousResults);
        if (this._mainRequest == partitionRequest) {
            this._mainRequest.setRemoteOperationResult(null);
        }
        if (!continueProcessing || this._previousResults.size() + 1 >= this._map.size()) {
            return true;
        }
        this._previousResults.add(partitionRequest);
        if (this._mainRequest.getPartitionedClusterExecutionType() == PartitionedClusterExecutionType.SCATTER_SEQUENTIAL) {
            int partitionId = this.getPartitionIds()[this._previousResults.size()];
            partitionRequest = this.getPartitionRequest(partitionId, this._mainRequest);
            this._router.getPartitionRouter(partitionId).executeAsync(partitionRequest, this);
        }
        return false;
    }

    @Override
    protected Object getResult(RemoteOperationRequest<T> request) throws Exception {
        return this._mainRequest.getAsyncFinalResult();
    }
}

