/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.serialization;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.serialization.IClassSerializer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.space.InternalSpaceException;

@InternalApi
public class ExternalizableClassSerializer
implements IClassSerializer<Externalizable> {
    private final byte _code;
    private final Class<?> _type;
    private final PlatformLogicalVersion _since;

    public ExternalizableClassSerializer(byte code, Class<?> type, PlatformLogicalVersion since) {
        this._code = code;
        this._type = type;
        this._since = since;
    }

    @Override
    public byte getCode() {
        return this._code;
    }

    @Override
    public void write(ObjectOutput out, Externalizable obj) throws IOException {
        obj.writeExternal(out);
    }

    @Override
    public Externalizable read(ObjectInput in) throws IOException, ClassNotFoundException {
        Externalizable result;
        try {
            result = (Externalizable)this._type.newInstance();
        }
        catch (InstantiationException e) {
            throw new InternalSpaceException("Failed to create an instance of type [" + this._type.getName() + "].", e);
        }
        catch (IllegalAccessException e) {
            throw new InternalSpaceException("Failed to create an instance of type [" + this._type.getName() + "].", e);
        }
        result.readExternal(in);
        return result;
    }
}

