/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.metadata;

import com.gigaspaces.annotation.pojo.FifoSupport;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.EntryTypeDesc;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.ITypeIntrospector;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.metadata.SpaceIdType;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.query.extension.metadata.TypeQueryExtensions;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

@InternalApi
public class InactiveTypeDesc
implements ITypeDesc {
    private static final long serialVersionUID = 1L;
    private String _className;
    private String[] _superClassesNames;
    private transient String _description;

    public InactiveTypeDesc() {
    }

    public InactiveTypeDesc(String className, String[] superClassesNames) {
        this._className = className;
        this._superClassesNames = superClassesNames;
    }

    public String toString() {
        if (this._description == null) {
            this._description = this.generateDescription();
        }
        return this._description;
    }

    private String generateDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("typeName=").append(this._className).append(", ");
        sb.append("superTypesNames=").append(Arrays.toString(this._superClassesNames));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getTypeName() {
        return this._className;
    }

    @Override
    public String getTypeSimpleName() {
        return StringUtils.getSuffix(this._className, ".");
    }

    @Override
    public String[] getSuperClassesNames() {
        return this._superClassesNames;
    }

    @Override
    public boolean isInactive() {
        return true;
    }

    @Override
    public ITypeDesc clone() {
        try {
            return (ITypeDesc)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Class<? extends Object> getObjectClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<? extends SpaceDocument> getDocumentWrapperClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isExternalizable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supports(EntryType entryType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITypeIntrospector getIntrospector(EntryType objectType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryTypeDesc getEntryTypeDesc(EntryType entryType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCodeBase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIdPropertyName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIdentifierPropertyId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SpaceIdType getSpaceIdType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAutoGenerateId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAutoGenerateRouting() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBlobstoreEnabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsDynamicProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsOptimisticLocking() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PropertyInfo[] getProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumOfFixedProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PropertyInfo getFixedProperty(int propertyID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFixedPropertyPosition(String propertyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PropertyInfo getFixedProperty(String propertyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumOfIndexedProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndexedPropertyID(int propertyID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getPropertiesNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getPropertiesTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getPropertiesIndexTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDefaultPropertyName() {
        throw new UnsupportedOperationException();
    }

    public boolean[] getIndexedFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryType getObjectType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getRestrictSuperClassesNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRoutingPropertyId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRoutingPropertyName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getChecksum() {
        throw new UnsupportedOperationException();
    }

    public boolean hasInvalidFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFifoSupported() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFifoDefault() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FifoSupport getFifoSupport() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSystemType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReplicable() {
        throw new UnsupportedOperationException();
    }

    public boolean isValidField(String fieldName) {
        throw new UnsupportedOperationException();
    }

    public void setIndexedFields(boolean[] indexedFields) {
        throw new UnsupportedOperationException();
    }

    public void setReplicable(boolean replicable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, SpaceIndex> getIndexes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SpaceIndexType getIndexType(String indexName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getDotnetDynamicPropertiesStorageType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDotnetDocumentWrapperTypeName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    private final void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        this._className = IOUtils.readString(in);
        this._superClassesNames = IOUtils.readStringArray(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    private final void serialize(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._className);
        IOUtils.writeStringArray(out, this._superClassesNames);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public boolean isAllPropertiesObjectStorageType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StorageType getStorageType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFifoGroupingPropertyPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getFifoGroupingIndexesPaths() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConcreteType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSuperTypeName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeQueryExtensions getQueryExtensions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Serializable getVersionedSerializable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SpaceIndex> getCompoundIndexes() {
        return null;
    }

    @Override
    public boolean anyCompoundIndex() {
        return false;
    }

    @Override
    public String getPrimitivePropertiesWithoutNullValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSequenceNumber() {
        return false;
    }

    @Override
    public int getSequenceNumberFixedPropertyID() {
        return -1;
    }
}

