/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.IDuplicateOperationFilter;
import com.gigaspaces.internal.utils.collections.IAddOnlySet;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.OperationID;

@InternalApi
public class BackupFailoverOperationIDFilter
implements IDuplicateOperationFilter {
    private final IAddOnlySet<OperationID> _duplicateFilter;
    private final long _duplicateProtectionTimeInterval;
    private volatile boolean _backup;
    private volatile long _timeStampOfChangeFromBackupToPrimary;
    private volatile boolean _activeDuplicateProtection;

    public BackupFailoverOperationIDFilter(IAddOnlySet<OperationID> duplicateFilter, long duplicateProtectionTimeInterval) {
        this._duplicateFilter = duplicateFilter;
        this._duplicateProtectionTimeInterval = duplicateProtectionTimeInterval;
    }

    @Override
    public boolean contains(OperationID operationID) {
        if (operationID == null) {
            return false;
        }
        if (!this._activeDuplicateProtection) {
            return false;
        }
        long currentTime = SystemTime.timeMillis();
        if (currentTime - this._timeStampOfChangeFromBackupToPrimary > this._duplicateProtectionTimeInterval) {
            this._activeDuplicateProtection = false;
            this._duplicateFilter.clear();
            return false;
        }
        return this._duplicateFilter.contains(operationID);
    }

    @Override
    public void add(OperationID operationID) {
        if (this._backup) {
            this._duplicateFilter.add(operationID);
        }
    }

    @Override
    public void onBecomeBackup() {
        this._backup = true;
    }

    @Override
    public void onBecomePrimary() {
        if (this._backup) {
            this._timeStampOfChangeFromBackupToPrimary = SystemTime.timeMillis();
            this._activeDuplicateProtection = true;
        } else {
            this._backup = false;
            this._activeDuplicateProtection = false;
        }
    }

    @Override
    public void clear() {
        this._duplicateFilter.clear();
        this._activeDuplicateProtection = false;
        this._backup = false;
        this._timeStampOfChangeFromBackupToPrimary = 0L;
    }
}

