/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public abstract class BatchQueryOperationContext {
    private List<IEntryPacket> _results;
    private int _numResults;
    private List<Throwable> _exceptions;
    private final int _maxEntries;
    private final int _minEntries;
    protected HashSet<String> _processedUids;

    public BatchQueryOperationContext(ITemplatePacket template, int maxEntries, int minEntries) {
        this._maxEntries = maxEntries;
        this._minEntries = minEntries;
        if (this.keepResultsInBatchContext()) {
            this._results = this.createResultList(template, maxEntries);
        }
        this.createProcessedUidsIfNeeded();
    }

    protected List<IEntryPacket> createResultList(ITemplatePacket template, int maxEntries) {
        if (template.getMultipleUIDs() != null) {
            return new ArrayList<IEntryPacket>(Math.min(template.getMultipleUIDs().length, maxEntries));
        }
        return new LinkedList<IEntryPacket>();
    }

    public void addResult(IEntryPacket result) {
        if (this.keepResultsInBatchContext()) {
            this._results.add(result);
        }
        ++this._numResults;
    }

    protected boolean keepResultsInBatchContext() {
        return true;
    }

    protected void setResults(List<IEntryPacket> _results) {
        this._results = _results;
    }

    public List<IEntryPacket> getResults() {
        return this._results;
    }

    public int getNumResults() {
        return this._numResults;
    }

    public List<Throwable> getExceptions() {
        return this._exceptions;
    }

    public void setExceptions(List<Throwable> exceptions) {
        this._exceptions = exceptions;
    }

    public boolean reachedMinEntries() {
        return this._numResults >= this._minEntries;
    }

    public boolean reachedMaxEntries() {
        return this._numResults >= this._maxEntries;
    }

    public abstract void onException(Throwable var1);

    public boolean needToProcessExecption() {
        return true;
    }

    public boolean needProcessEntriesForReturnedResult() {
        return true;
    }

    public IEntryPacket[] processReturnedValueForBatchOperation(ITemplateHolder template) {
        IEntryPacket[] results = null;
        if (template.getBatchOperationContext().needProcessEntriesForReturnedResult()) {
            if (template.isReturnOnlyUid()) {
                String[] uids = new String[template.getBatchOperationContext().getResults().size()];
                int i = 0;
                for (IEntryPacket entryPacket : template.getBatchOperationContext().getResults()) {
                    uids[i++] = entryPacket.getUID();
                }
                results = new ITemplatePacket[]{TemplatePacketFactory.createUidsResponsePacket(uids)};
            } else {
                results = template.getBatchOperationContext().getResults().toArray(new IEntryPacket[template.getBatchOperationContext().getResults().size()]);
            }
        }
        return results;
    }

    public int getMaxEntries() {
        return this._maxEntries;
    }

    public int getMinEntries() {
        return this._minEntries;
    }

    public boolean hasAnyEntries() {
        return this._numResults > 0;
    }

    protected void createProcessedUidsIfNeeded() {
    }

    public boolean isInProcessedUids(String uid) {
        return this._processedUids != null && this._processedUids.contains(uid);
    }

    public void addToProcessedUidsIfNeeded(String uid) {
        if (this._processedUids != null) {
            this._processedUids.add(uid);
        }
    }

    public boolean isClear() {
        return false;
    }
}

