/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class CompositeSpaceModeListener
implements ISpaceModeListener {
    private final List<ISpaceModeListener> listeners = new ArrayList<ISpaceModeListener>();

    @Override
    public synchronized void afterSpaceModeChange(SpaceMode newMode) throws RemoteException {
        for (ISpaceModeListener listener : this.listeners) {
            listener.afterSpaceModeChange(newMode);
        }
    }

    @Override
    public synchronized void beforeSpaceModeChange(SpaceMode newMode) throws RemoteException {
        for (ISpaceModeListener listener : this.listeners) {
            listener.beforeSpaceModeChange(newMode);
        }
    }

    public synchronized void addListener(ISpaceModeListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(ISpaceModeListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void clear() {
        this.listeners.clear();
    }
}

