/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.gigaspaces.internal.utils.collections.IAddOnlySet;
import com.j_spaces.core.OperationID;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class DuplicateOperationIDFilter
implements IAddOnlySet<OperationID> {
    private final Set<OperationID> _operationIds = new ConcurrentHashSet<OperationID>();
    private final Queue<OperationID> _orderOfOperations = new ConcurrentLinkedQueue<OperationID>();
    private final AtomicInteger _size = new AtomicInteger(0);
    private final int _lastOperationCountToKeep;

    public DuplicateOperationIDFilter(int lastOperationCountToKeep) {
        this._lastOperationCountToKeep = lastOperationCountToKeep;
    }

    @Override
    public boolean contains(OperationID operationID) {
        if (operationID == null) {
            return false;
        }
        return this._operationIds.contains(operationID);
    }

    @Override
    public void add(OperationID operationID) {
        OperationID poll;
        if (operationID == null) {
            return;
        }
        this._operationIds.add(operationID);
        this._orderOfOperations.offer(operationID);
        if (this._size.incrementAndGet() > this._lastOperationCountToKeep && (poll = this._orderOfOperations.poll()) != null) {
            this._operationIds.remove(poll);
        }
    }

    @Override
    public void clear() {
        this._operationIds.clear();
        this._orderOfOperations.clear();
        this._size.set(0);
    }
}

