/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.FifoGroupsSearch;
import com.gigaspaces.internal.server.space.FifoSearch;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.EntryDeletedException;
import com.j_spaces.core.TemplateDeletedException;
import com.j_spaces.core.TransactionConflictException;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.XtnData;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.cache.fifoGroup.IFifoGroupIterator;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.locks.ILockObject;
import java.util.Collection;
import java.util.List;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class FifoGroupsHandler {
    private final SpaceEngine _spaceEngine;
    private final CacheManager _cacheManager;

    public FifoGroupsHandler(SpaceEngine spaceEngine) {
        this._spaceEngine = spaceEngine;
        this._cacheManager = this._spaceEngine.getCacheManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IEntryHolder getMatchedEntryAndOperateSA_Scan(Context context, ITemplateHolder template, boolean makeWaitForInfo, boolean useSCN, IScanListIterator<IEntryCacheInfo> toScan) throws TransactionException, TemplateDeletedException, SAException {
        long leaseFilter = SystemTime.timeMillis();
        boolean needMatch = !toScan.isAlreadyMatched();
        int alreadyMatchedFixedPropertyIndexPos = toScan.getAlreadyMatchedFixedPropertyIndexPos();
        String alreadyMatchedIndexPath = toScan.getAlreadyMatchedIndexPath();
        try {
            while (toScan.hasNext()) {
                IEntryCacheInfo pEntry = toScan.next();
                if (pEntry == null) continue;
                IEntryHolder res = this._spaceEngine.getMatchedEntryAndOperateSA_Entry(context, template, makeWaitForInfo, needMatch, alreadyMatchedFixedPropertyIndexPos, alreadyMatchedIndexPath, leaseFilter, useSCN, pEntry);
                if (res != null) {
                    IEntryHolder iEntryHolder = res;
                    return iEntryHolder;
                }
                if (!context.isFifoGroupScanEncounteredXtnConflict()) continue;
                context.setFifoGroupScanEncounteredXtnConflict(false);
                if (!toScan.isIterator()) continue;
                ((IFifoGroupIterator)toScan).nextGroup();
            }
            IEntryHolder iEntryHolder = null;
            return iEntryHolder;
        }
        finally {
            toScan.releaseScan();
            if (context.isPendingExpiredEntriesExist() && this._cacheManager.getTemplatesManager().anyNotifyLeaseTemplates()) {
                try {
                    this._spaceEngine.getLeaseManager().forceLeaseReaperCycle(false);
                }
                catch (InterruptedException interruptedException) {}
                context.setPendingExpiredEntriesExist(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMatchedEntriesAndOperateSA_Scan(Context context, ITemplateHolder template, IScanListIterator<IEntryCacheInfo> toScan, boolean makeWaitForInfo, IServerTypeDesc entryTypeDesc) throws TransactionException, TemplateDeletedException, SAException {
        long leaseFilter = SystemTime.timeMillis();
        boolean needMatch = !toScan.isAlreadyMatched();
        int alreadyMatchedFixedPropertyIndexPos = toScan.getAlreadyMatchedFixedPropertyIndexPos();
        String alreadyMatchedIndexPath = toScan.getAlreadyMatchedIndexPath();
        try {
            while (toScan != null && toScan.hasNext()) {
                IEntryCacheInfo pEntry = toScan.next();
                if (pEntry == null) continue;
                this._spaceEngine.getMatchedEntriesAndOperateSA_Entry(context, template, needMatch, alreadyMatchedFixedPropertyIndexPos, alreadyMatchedIndexPath, leaseFilter, pEntry, makeWaitForInfo, entryTypeDesc);
                if (template.getBatchOperationContext().getNumResults() >= template.getBatchOperationContext().getMaxEntries()) {
                    return;
                }
                if (!context.isFifoGroupScanEncounteredXtnConflict()) continue;
                context.setFifoGroupScanEncounteredXtnConflict(false);
                if (!toScan.isIterator()) continue;
                ((IFifoGroupIterator)toScan).nextGroup();
            }
        }
        finally {
            if (toScan != null) {
                toScan.releaseScan();
            }
            if (toScan.isIterator()) {
                // empty if block
            }
            if (context.isPendingExpiredEntriesExist() && this._cacheManager.getTemplatesManager().anyNotifyLeaseTemplates()) {
                try {
                    this._spaceEngine.getLeaseManager().forceLeaseReaperCycle(false);
                }
                catch (InterruptedException interruptedException) {}
                context.setPendingExpiredEntriesExist(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scanNonNotifyTemplate(ITemplateHolder template, IEntryHolder entrySubject, Context context, boolean ifExist) throws EntryDeletedException, SAException, TemplateDeletedException {
        IServerTypeDesc serverTypeDesc = this._spaceEngine.getTypeTableEntry(template.getClassName());
        IScanListIterator<IEntryCacheInfo> toScan = this._cacheManager.getFifoGroupCacheImpl().getScannableEntriesByIndexValue(context, template, entrySubject, serverTypeDesc);
        if (toScan == null) {
            return;
        }
        long leaseFilter = SystemTime.timeMillis();
        boolean needMatch = true;
        int alreadyMatchedFixedPropertyIndexPos = toScan.getAlreadyMatchedFixedPropertyIndexPos();
        String alreadyMatchedIndexPath = toScan.getAlreadyMatchedIndexPath();
        try {
            while (toScan.hasNext()) {
                IEntryCacheInfo pEntry = toScan.next();
                if (pEntry == null) continue;
                IEntryHolder res = this._spaceEngine.getMatchedEntryAndOperateSA_Entry(context, template, ifExist, needMatch, alreadyMatchedFixedPropertyIndexPos, alreadyMatchedIndexPath, leaseFilter, false, pEntry);
                if (res != null) {
                    if (this._spaceEngine.getTemplateScanner().match(context, entrySubject, template)) {
                        context.setExhaustedFifoGroupsTemplatesSearch(true);
                    }
                    return;
                }
                if (!context.isFifoGroupScanEncounteredXtnConflict()) continue;
                context.setFifoGroupScanEncounteredXtnConflict(false);
                if (!toScan.isIterator()) continue;
                ((IFifoGroupIterator)toScan).nextGroup();
            }
        }
        catch (TransactionException transactionException) {
        }
        finally {
            toScan.releaseScan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNeedFgOnlyScanOnXtnEnd(Context context, XtnEntry xtnEntry) throws SAException {
        try {
            if (!this._cacheManager.isMemorySpace() && this._cacheManager.isEvictableCachePolicy() || !xtnEntry.getXtnData().anyEntriesForFifoGroupScan()) {
                return;
            }
            if (this._cacheManager.getFifoGroupCacheImpl().getNumOfTemplates() == 0) {
                return;
            }
            List<IEntryHolder> entries = xtnEntry.getXtnData().getEntriesForFifoGroupScan();
            if (entries != null) {
                for (IEntryHolder entry : entries) {
                    try {
                        this._spaceEngine.getTemplateScanner().scanNonNotifyTemplates(context, entry, null, FifoSearch.NO, FifoGroupsSearch.EXCLUSIVE);
                    }
                    catch (EntryDeletedException entryDeletedException) {}
                }
            }
        }
        finally {
            xtnEntry.getXtnData().resetEntriesForFifoGroupsScan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareForFifoGroupsAfterXtnScans(Context context, XtnEntry xtnEntry) throws SAException {
        block6: {
            try (ISAdapterIterator entriesIter = null;){
                IEntryHolder entry;
                entriesIter = this._cacheManager.makeUnderXtnEntriesIter(context, xtnEntry, 2, false);
                if (entriesIter == null) break block6;
                XtnData pXtn = xtnEntry.getXtnData();
                while ((entry = (IEntryHolder)entriesIter.next()) != null) {
                    if (!this._cacheManager.getTypeData(entry.getServerTypeDesc()).hasFifoGroupingIndex()) continue;
                    pXtn.addToEntriesForFifoGroupScan(entry);
                }
            }
        }
    }

    void fifoGroupsOnOperationAction(Context context, IEntryHolder entry, ITemplateHolder template, IServerTypeDesc tte) throws TransactionConflictException {
        Object val = this._cacheManager.getTypeData(tte).getFifoGroupingIndex().getIndexValue(entry.getEntryData());
        if (context.isMultipleOperation() && context.isFifoGroupValueForMiltipleOperations(val)) {
            return;
        }
        if (!this._cacheManager.testAndSetFGCacheForEntry(context, entry, template, template.getXidOriginated() == null, tte)) {
            throw SpaceEngine.TX_CONFLICT_EXCEPTION;
        }
        template.getXidOriginated().getXtnData().addToFifoGroupsEntries(entry, val);
        if (context.isMultipleOperation()) {
            context.setToFifoGroupValueForMiltipleOperations(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemoveWaitingForInfoSAFifoGroups_EntryBased(Context context, IEntryHolder entry, ITemplateHolder template) throws SAException {
        if (template != null && template.isFifoGroupPoll() && !template.isDeleted()) {
            try {
                this.scanNonNotifyTemplate(template, entry, context, true);
            }
            catch (TemplateDeletedException templateDeletedException) {
            }
            catch (EntryDeletedException entryDeletedException) {}
        } else {
            Collection<ITemplateHolder> wfclone = null;
            ILockObject entryLock = this._cacheManager.getLockManager().getLockObject(entry);
            try {
                ILockObject iLockObject = entryLock;
                synchronized (iLockObject) {
                    wfclone = entry.getCopyOfTemplatesWaitingForEntry();
                }
            }
            finally {
                this._cacheManager.getLockManager().freeLockObject(entryLock);
            }
            if (wfclone == null || wfclone.isEmpty()) {
                return;
            }
            for (ITemplateHolder th : wfclone) {
                if (!th.isFifoGroupPoll() || th.isDeleted()) continue;
                try {
                    this.scanNonNotifyTemplate(th, entry, context, true);
                }
                catch (TemplateDeletedException ex) {
                }
                catch (EntryDeletedException entryDeletedException) {}
            }
        }
    }
}

