/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.gigaspaces.management.space.LocalViewDetails;
import com.gigaspaces.management.space.SpaceQueryDetails;
import com.gigaspaces.management.transport.ConnectionEndpointDetails;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@InternalApi
public class LocalViewRegistrations {
    private final String _spaceName;
    private final Map<String, LocalViewDetails> _localViews = new ConcurrentHashMap<String, LocalViewDetails>();
    private final ConcurrentHashSet<String> _unallowedClearOptimizationsBlobStore;

    public LocalViewRegistrations(String spaceName) {
        this._spaceName = spaceName;
        this._unallowedClearOptimizationsBlobStore = new ConcurrentHashSet();
    }

    public Map<String, LocalViewDetails> get() {
        return this._localViews;
    }

    public synchronized void add(String localViewId, ConnectionEndpointDetails connectionDetails, Collection<SpaceQueryDetails> queries) {
        LocalViewDetails localViewDetails = new LocalViewDetails(localViewId, connectionDetails, queries);
        this._localViews.put(localViewDetails.getId(), localViewDetails);
    }

    public synchronized void remove(String localViewId) {
        this._localViews.remove(localViewId);
        if (this.isEmpty()) {
            this._unallowedClearOptimizationsBlobStore.clear();
        }
    }

    private boolean isEmpty() {
        return this._localViews.isEmpty();
    }

    public void setBlobStoreClearOptimizationNotAllowed(String typeName) {
        this._unallowedClearOptimizationsBlobStore.add(typeName);
    }

    public boolean isBlobStoreClearOptimizationAllowed(IServerTypeDesc type) {
        if (this.isEmpty() || this._unallowedClearOptimizationsBlobStore.isEmpty()) {
            return true;
        }
        if (this._unallowedClearOptimizationsBlobStore.contains(type.getTypeDesc().getTypeName())) {
            return false;
        }
        for (String typeName : this._unallowedClearOptimizationsBlobStore) {
            for (IServerTypeDesc typeDesc : type.getSuperTypes()) {
                if (!typeDesc.getTypeName().equals(typeName)) continue;
                return false;
            }
        }
        return true;
    }
}

