/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.AnswerHolder;
import com.j_spaces.core.UpdateOrWriteContext;
import com.j_spaces.core.XtnEntry;

public abstract class MultipleIdsContext {
    private final int _numToAnswer;
    private final int _operationModifiers;
    private final ITemplateHolder _concentratingTemplate;
    private final long _timeOut;
    private final long _startTime;
    private final SpaceEngine _engine;
    private final XtnEntry _xtnEntry;
    private int _numAnswered;
    private final Object _lockObject;
    private volatile boolean _nonMainThreadUsed;
    private volatile boolean _answerReady;
    private final boolean[] _answered;

    public MultipleIdsContext(ITemplateHolder concentratingTemplate, int numToAnswer, int operationModifiers, long timeout, SpaceEngine engine, XtnEntry xtnEntry) {
        this._numToAnswer = numToAnswer;
        this._concentratingTemplate = concentratingTemplate;
        this._operationModifiers = operationModifiers;
        this._timeOut = timeout;
        this._answered = new boolean[numToAnswer];
        this._lockObject = new Object();
        this._engine = engine;
        this._startTime = this._timeOut != 0L ? SystemTime.timeMillis() : 0L;
        this._xtnEntry = xtnEntry;
    }

    public boolean isNeedLocking() {
        return this._nonMainThreadUsed;
    }

    public void setNonMainThreadUsed() {
        if (!this._nonMainThreadUsed) {
            this._nonMainThreadUsed = true;
        }
    }

    public Object getLockObject() {
        return this._lockObject;
    }

    public ITemplateHolder getConcentratingTemplate() {
        return this._concentratingTemplate;
    }

    public boolean isAnswerReady() {
        return this._answerReady;
    }

    public long getTimeOut() {
        return this._timeOut;
    }

    public int getOperationModifiers() {
        return this._operationModifiers;
    }

    abstract Object[] getAnswer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAnswer(Object res, int ordinal) {
        if (this._nonMainThreadUsed) {
            Object object = this._lockObject;
            synchronized (object) {
                return this.setAnswerImpl(res, ordinal);
            }
        }
        return this.setAnswerImpl(res, ordinal);
    }

    private boolean setAnswerImpl(Object res, int ordinal) {
        if (!this.isAnswerSetForOrdinal(ordinal)) {
            this.setAnswerByOrdinal(res, ordinal);
            this._answered[ordinal] = true;
            ++this._numAnswered;
            if (this._numAnswered == this._numToAnswer) {
                this.setAnswerInAnswerHolder(this._concentratingTemplate.getAnswerHolder());
                this._answerReady = true;
                return true;
            }
            return false;
        }
        return this._numAnswered == this._numToAnswer;
    }

    abstract void setAnswerByOrdinal(Object var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnswerSetForOrdinal(int ordinal) {
        if (this._nonMainThreadUsed) {
            Object object = this._lockObject;
            synchronized (object) {
                return this.isAnswerSetForOrdinal_impl(ordinal);
            }
        }
        return this.isAnswerSetForOrdinal_impl(ordinal);
    }

    abstract void setAnswerInAnswerHolder(AnswerHolder var1);

    private boolean isAnswerSetForOrdinal_impl(int ordinal) {
        return this._answered[ordinal];
    }

    public boolean isUpdateOrWriteMultiple() {
        return false;
    }

    public SpaceEngine getEngine() {
        return this._engine;
    }

    public long getStartTime() {
        return this._startTime;
    }

    boolean isExpired() {
        throw new UnsupportedOperationException();
    }

    public boolean shouldRetryUpdateOrWriteForEntry(Throwable exception, ITemplateHolder entryOpTemplate, UpdateOrWriteContext ctx, boolean spawnThread) {
        throw new UnsupportedOperationException();
    }

    public XtnEntry getXtnEntry() {
        return this._xtnEntry;
    }
}

