/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.AbstractIdsQueryPacket;
import com.j_spaces.core.AnswerPacket;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class ReadByIdsContext
implements Serializable {
    private static final long serialVersionUID = -5416359726050399719L;
    private ITemplatePacket _template;
    private boolean _accumulate;
    private IEntryPacket[] _results;
    private Map<Object, Exception> _failures;
    private int _successCount = 0;

    public ReadByIdsContext(ITemplatePacket template, boolean accumulate) {
        this._template = template;
        this._accumulate = accumulate;
        this._failures = new HashMap<Object, Exception>();
    }

    public boolean accumulate() {
        return this._accumulate;
    }

    public void initResultsEntryPackets() {
        this._results = !this.accumulate() ? null : new IEntryPacket[((AbstractIdsQueryPacket)this._template).getIds().length];
    }

    public void applyResult(AnswerPacket answerPacket, int resultIndex) {
        if (this.accumulate()) {
            this._results[resultIndex] = answerPacket.m_EntryPacket;
        } else if (answerPacket.m_EntryPacket != null) {
            ++this._successCount;
        }
    }

    public int getSuccessCount() {
        return this._successCount;
    }

    public IEntryPacket[] getResults() {
        return this._results;
    }

    public ITemplatePacket getTemplate() {
        return this._template;
    }

    public Map<Object, Exception> getFailures() {
        return this._failures;
    }

    public void addFailure(Object id, Exception e) {
        this._failures.put(id, e);
    }
}

