/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.log.JProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SpaceConfigReader {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.engine");
    private final String _fullSpaceName;

    public SpaceConfigReader(String fullSpaceName) {
        this._fullSpaceName = fullSpaceName;
    }

    public String getFullSpaceName() {
        return this._fullSpaceName;
    }

    public String getSpaceProperty(String key, String defaultValue) {
        return JProperties.getSpaceProperty(this._fullSpaceName, key, defaultValue, true);
    }

    public String getSpaceProperty(String key, String defaultValue, boolean convert) {
        return JProperties.getSpaceProperty(this._fullSpaceName, key, defaultValue, convert);
    }

    public void setSpaceProperty(String key, String value) {
        JProperties.setSpaceProperty(this._fullSpaceName, key, value);
    }

    public boolean containsSpaceProperty(String key) {
        return JProperties.containsSpaceProperty(this._fullSpaceName, key);
    }

    public void assertSpacePropertyNotExists(String key, String depracationVersion, String deletionVersion) {
        String value;
        if (_logger.isLoggable(Level.WARNING) && (value = this.getSpaceProperty(key, null)) != null) {
            _logger.log(Level.WARNING, "The setting '" + key + "' has been deprecated since " + depracationVersion + " and is not supported since " + deletionVersion + " - its value is ignored. ");
        }
    }

    public boolean getBooleanSpaceProperty(String key, String defaultValue) {
        String result = this.getSpaceProperty(key, defaultValue, true);
        return Boolean.parseBoolean(result);
    }

    public boolean getBooleanSpaceProperty(String key, String defaultValue, boolean convert) {
        String result = this.getSpaceProperty(key, defaultValue, convert);
        return Boolean.parseBoolean(result);
    }

    public int getIntSpaceProperty(String key, String defaultValue) {
        String result = this.getSpaceProperty(key, defaultValue, true);
        return Integer.parseInt(result);
    }

    public int getIntSpaceProperty(String key, String defaultValue, boolean convert) {
        String result = this.getSpaceProperty(key, defaultValue, convert);
        return Integer.parseInt(result);
    }

    public long getLongSpaceProperty(String key, String defaultValue) {
        String result = this.getSpaceProperty(key, defaultValue, true);
        return Long.parseLong(result);
    }

    public long getLongSpaceProperty(String key, String defaultValue, boolean convert) {
        String result = this.getSpaceProperty(key, defaultValue, convert);
        return Long.parseLong(result);
    }

    public float getFloatSpaceProperty(String key, String defaultValue) {
        String result = this.getSpaceProperty(key, defaultValue, true);
        return Float.parseFloat(result);
    }

    public float getFloatSpaceProperty(String key, String defaultValue, boolean convert) {
        String result = this.getSpaceProperty(key, defaultValue, convert);
        return Float.parseFloat(result);
    }

    public List<String> getListSpaceProperty(String key, String defaultValue, String separator) {
        String rawList = this.getSpaceProperty(key, defaultValue);
        if (rawList.equals(defaultValue)) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(rawList, separator);
        while (st.hasMoreElements()) {
            String item = st.nextToken();
            if (item == null || (item = item.trim()).length() == 0) continue;
            list.add(item);
        }
        return list;
    }

    public Set<String> getSetSpaceProperty(String key, String defaultValue, String separator) {
        String rawList = this.getSpaceProperty(key, defaultValue);
        if (rawList.equals(defaultValue)) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(rawList, separator);
        while (st.hasMoreElements()) {
            String item = st.nextToken();
            if (item == null || (item = item.trim()).length() == 0) continue;
            set.add(item);
        }
        return set;
    }

    public <T> T getObjectSpaceProperty(String key) {
        return JProperties.getObjectSpaceProperty(this._fullSpaceName, key);
    }
}

