/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ClearByIdsException;
import com.gigaspaces.client.ReadTakeByIdsException;
import com.gigaspaces.client.WriteMultipleException;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.client.protective.ProtectiveMode;
import com.gigaspaces.client.protective.ProtectiveModeException;
import com.gigaspaces.client.transaction.local.LocalTransactionManagerImpl;
import com.gigaspaces.client.transaction.xa.GSServerTransaction;
import com.gigaspaces.cluster.activeelection.ISpaceComponentsHandler;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.cluster.replication.ConsistencyLevelCompromisedException;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.metadata.TypeDescFactory;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.node.IReplicationNode;
import com.gigaspaces.internal.cluster.node.IReplicationNodeAdmin;
import com.gigaspaces.internal.cluster.node.IReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.FailedSyncSpaceReplicateState;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogMemberLimitationConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.OperationWeightInfo;
import com.gigaspaces.internal.cluster.node.impl.backlog.OperationWeightInfoFactory;
import com.gigaspaces.internal.cluster.node.impl.backlog.WeightInfoOperationType;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfigBuilder;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyBackupSyncIteratorHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySyncListFetcher;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceSynchronizeReplicaRequestContext;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.cluster.node.impl.view.ViewDynamicSourceGroupMemberLifeCycle;
import com.gigaspaces.internal.cluster.node.impl.view.ViewReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyReplicaState;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyResult;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaRequestContext;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.datasource.EDSAdapter;
import com.gigaspaces.internal.lrmi.stubs.LRMISpaceImpl;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.internal.query.EntryHolderAggregatorContext;
import com.gigaspaces.internal.query.explainplan.SingleExplainPlan;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterUtils;
import com.gigaspaces.internal.server.metadata.AddTypeDescResult;
import com.gigaspaces.internal.server.metadata.AddTypeDescResultType;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.AggregateOperationContext;
import com.gigaspaces.internal.server.space.BackupFailoverOperationIDFilter;
import com.gigaspaces.internal.server.space.BatchQueryOperationContext;
import com.gigaspaces.internal.server.space.ChangeInternalException;
import com.gigaspaces.internal.server.space.ChangeMultipleContext;
import com.gigaspaces.internal.server.space.ClearContext;
import com.gigaspaces.internal.server.space.DuplicateOperationIDFilter;
import com.gigaspaces.internal.server.space.FifoGroupsHandler;
import com.gigaspaces.internal.server.space.IDuplicateOperationFilter;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.server.space.LocalViewRegistrations;
import com.gigaspaces.internal.server.space.MatchResult;
import com.gigaspaces.internal.server.space.MultipleIdsContext;
import com.gigaspaces.internal.server.space.NullDuplicateOperationIDFilter;
import com.gigaspaces.internal.server.space.ReadByIdsContext;
import com.gigaspaces.internal.server.space.ReadByIdsInfo;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.SpaceUidFactory;
import com.gigaspaces.internal.server.space.TemplateScanner;
import com.gigaspaces.internal.server.space.UpdateMultipleContext;
import com.gigaspaces.internal.server.space.UpdateOrWriteMultipleContext;
import com.gigaspaces.internal.server.space.events.SpaceDataEventManager;
import com.gigaspaces.internal.server.space.metadata.ServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.space.operations.WriteEntriesResult;
import com.gigaspaces.internal.server.space.operations.WriteEntryResult;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.StorageConsistencyModes;
import com.gigaspaces.internal.server.space.replication.SpaceReplicationInitializer;
import com.gigaspaces.internal.server.space.replication.SpaceReplicationManager;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.server.storage.EntryHolderFactory;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.server.storage.ShadowEntryHolder;
import com.gigaspaces.internal.server.storage.TemplateHolder;
import com.gigaspaces.internal.server.storage.TemplateHolderFactory;
import com.gigaspaces.internal.server.storage.UserTypeEntryData;
import com.gigaspaces.internal.sync.SynchronizationStorageAdapter;
import com.gigaspaces.internal.transport.EntryPacket;
import com.gigaspaces.internal.transport.EntryPacketFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.TransportProtocolHelper;
import com.gigaspaces.lrmi.nio.IResponseContext;
import com.gigaspaces.lrmi.nio.ResponseContext;
import com.gigaspaces.management.space.SpaceQueryDetails;
import com.gigaspaces.metrics.DynamicMetricTag;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.MetricManager;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.service.SecurityContext;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.gigaspaces.server.filter.NotifyAcknowledgeFilter;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.gigaspaces.time.SystemTime;
import com.gigaspaces.utils.Pair;
import com.j_spaces.core.AbstractIdsQueryPacket;
import com.j_spaces.core.AnswerHolder;
import com.j_spaces.core.AnswerPacket;
import com.j_spaces.core.CreateException;
import com.j_spaces.core.DetailedUnusableEntryException;
import com.j_spaces.core.DropClassException;
import com.j_spaces.core.EntryArrivedPacketsFactory;
import com.j_spaces.core.EntryDeletedException;
import com.j_spaces.core.EntryTakenPacket;
import com.j_spaces.core.ExtendedAnswerHolder;
import com.j_spaces.core.FifoException;
import com.j_spaces.core.InvalidFifoTemplateException;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.core.LimitExceededException;
import com.j_spaces.core.MemoryManager;
import com.j_spaces.core.NoMatchException;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceHealthStatus;
import com.j_spaces.core.TemplateDeletedException;
import com.j_spaces.core.TransactionConflictException;
import com.j_spaces.core.TransactionNotActiveException;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.UnknownTypesException;
import com.j_spaces.core.UpdateOrWriteContext;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.XtnInfo;
import com.j_spaces.core.XtnStatus;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.admin.TemplateInfo;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.CacheOperationReason;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.TerminatingFifoXtnsInfo;
import com.j_spaces.core.cache.XtnData;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.optimizations.BlobStoreOperationOptimizations;
import com.j_spaces.core.cache.blobStore.storage.bulks.BlobStoreBulkInfo;
import com.j_spaces.core.cache.blobStore.storage.preFetch.BlobStorePreFetchIteratorBasedHandler;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.client.ClientUIDHandler;
import com.j_spaces.core.client.DuplicateIndexValueException;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.EntryVersionConflictException;
import com.j_spaces.core.client.LocalTransactionManager;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.OperationTimeoutException;
import com.j_spaces.core.client.ReadModifiers;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.TakeModifiers;
import com.j_spaces.core.client.TransactionInfo;
import com.j_spaces.core.client.UnderTxnLockedObject;
import com.j_spaces.core.client.UpdateModifiers;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.ConflictingOperationPolicy;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import com.j_spaces.core.cluster.ReplicationOperationType;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.exception.internal.EngineInternalSpaceException;
import com.j_spaces.core.exception.internal.ProxyInternalSpaceException;
import com.j_spaces.core.fifo.FifoBackgroundRequest;
import com.j_spaces.core.filters.FilterManager;
import com.j_spaces.core.filters.FilterProvider;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.IStorageAdapter;
import com.j_spaces.core.sadapter.MemorySA;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.core.server.processor.BusPacket;
import com.j_spaces.core.server.processor.CommitBusPacket;
import com.j_spaces.core.server.processor.EntryArrivedPacket;
import com.j_spaces.core.server.processor.EntryExpiredBusPacket;
import com.j_spaces.core.server.processor.EntryUnmatchedPacket;
import com.j_spaces.core.server.processor.EntryUpdatedPacket;
import com.j_spaces.core.server.processor.Processor;
import com.j_spaces.core.server.processor.RemoveWaitingForInfoSABusPacket;
import com.j_spaces.core.server.processor.RollbackBusPacket;
import com.j_spaces.core.transaction.TransactionHandler;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.WorkingGroup;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.locks.ILockObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.space.InternalSpaceException;

@InternalApi
public class SpaceEngine
implements ISpaceModeListener {
    private final Logger _logger;
    private final Logger _operationLogger;
    private final Logger _loggerConfig;
    private static final IEntryPacket EMPTY_ENTRYPACKET;
    private static final TemplateDeletedException TEMPLATE_DELETED_EXCEPTION;
    private static final EntryDeletedException ENTRY_DELETED_EXCEPTION;
    private static final NoMatchException NO_MATCH_EXCEPTION;
    static final TransactionConflictException TX_CONFLICT_EXCEPTION;
    private final FifoException _fifoException = new FifoException();
    private final SpaceImpl _spaceImpl;
    private final String _spaceName;
    private final String _containerName;
    private final String _fullSpaceName;
    private final ClusterPolicy _clusterPolicy;
    private final SpaceClusterInfo _clusterInfo;
    private final Random _random;
    private final EntryArrivedPacketsFactory _entryArrivedFactory;
    private final LocalViewRegistrations _localViewRegistrations;
    private final MetricManager _metricManager;
    private final MetricRegistrator _metricRegistrator;
    private final SpaceConfigReader _configReader;
    private final SpaceUidFactory _uidFactory;
    private final IDirectSpaceProxy _directProxy;
    private final SpaceTypeManager _typeManager;
    private final SpaceReplicationManager _replicationManager;
    private final TransactionHandler _transactionHandler;
    private final CacheManager _cacheManager;
    private final FilterManager _filterManager;
    private final SpaceDataEventManager _dataEventManager;
    private final TemplateScanner _templateScanner;
    private final FifoGroupsHandler _fifoGroupsHandler;
    private LeaseManager _leaseManager;
    private MemoryManager _memoryManager;
    private final WorkingGroup<BusPacket<Processor>> _processorWG;
    private final Processor _coreProcessor;
    private volatile long _lastEntryTimestamp;
    private final boolean _useDirtyRead;
    private final int _TTL;
    private final boolean _isLocalCache;
    private final EntryDataType _entryDataType;
    private final boolean _isReplicated;
    private final boolean _isReplicatedPersistentBlobstore;
    private final int _partitionId;
    private final int _numberOfPartitions;
    private final boolean _allowNonBlockingRead;
    private boolean _memoryRecoveryEnabled;
    private final boolean _isSyncReplication;
    private final IDuplicateOperationFilter _duplicateOperationIDFilter;
    private boolean _coldStart;
    private volatile Exception _replicationUnhealthyReason;
    private volatile Exception _unhealthyReason;
    private volatile boolean _failOverDuringRecovery;
    @Deprecated
    private final boolean _general_purpose_remove_filters;
    private final int _resultsSizeLimit;
    private final int _resultsSizeLimitMemoryCheckBatchSize;
    private ConflictingOperationPolicy _conflictingOperationPolicy;

    public SpaceEngine(SpaceImpl spaceImpl) throws CreateException, RemoteException {
        this._logger = Logger.getLogger("com.gigaspaces.space.engine." + spaceImpl.getNodeName());
        this._operationLogger = Logger.getLogger("com.gigaspaces.space.operations." + spaceImpl.getNodeName());
        this._loggerConfig = Logger.getLogger("com.gigaspaces.core.config." + spaceImpl.getNodeName());
        this._spaceImpl = spaceImpl;
        this._spaceName = spaceImpl.getName();
        this._containerName = spaceImpl.getContainerName();
        this._fullSpaceName = spaceImpl.getServiceName();
        this._clusterPolicy = spaceImpl.getClusterPolicy();
        this._clusterInfo = spaceImpl.getClusterInfo();
        this._configReader = spaceImpl.getConfigReader();
        this._isLocalCache = spaceImpl.isLocalCache();
        this._allowNonBlockingRead = this._configReader.getBooleanSpaceProperty("engine.non_blocking_read", "true");
        this._useDirtyRead = this._configReader.getBooleanSpaceProperty("engine.dirty_read", "false");
        this._TTL = this._configReader.getIntSpaceProperty("retries", "10");
        this._entryDataType = SpaceEngine.initEntryDataType(this._configReader, this._isLocalCache);
        this._general_purpose_remove_filters = Boolean.parseBoolean(System.getProperty("com.gs.engine.general_purpose_remove_filters", "false"));
        this._random = new Random();
        this._entryArrivedFactory = new EntryArrivedPacketsFactory();
        this._localViewRegistrations = new LocalViewRegistrations(this.getFullSpaceName());
        this._metricManager = MetricManager.acquire();
        this._metricRegistrator = this.createSpaceRegistrator(spaceImpl);
        this._uidFactory = new SpaceUidFactory(SpaceEngine.extractMemberIdFromContainer(spaceImpl));
        this._directProxy = spaceImpl.getSingleProxy();
        TypeDescFactory typeDescFactory = new TypeDescFactory(this._directProxy);
        this._typeManager = new SpaceTypeManager(typeDescFactory, this._configReader);
        this._numberOfPartitions = this._clusterInfo.isPartitioned() ? this._clusterInfo.getNumberOfPartitions() : 1;
        this._partitionId = this._clusterInfo.getPartitionOfMember(this._fullSpaceName);
        this._transactionHandler = new TransactionHandler(this._configReader, this);
        IStorageAdapter storageAdapter = SpaceEngine.initStorageAdapter(spaceImpl, this);
        this.verifySystemTime(storageAdapter);
        if (this.isBlobStorePersistent() && this.getClusterInfo().getNumberOfBackups() > 1) {
            throw new CreateException("BlobStore persistency is not allowed with more then a single backup");
        }
        if (this.isBlobStorePersistent()) {
            this.blobStoreOverrideConfig(spaceImpl);
        }
        this._replicationManager = new SpaceReplicationManager(new SpaceReplicationInitializer(this._configReader, this._spaceImpl, this._typeManager, storageAdapter, this));
        this._isReplicated = this._replicationManager.isReplicated();
        this._isReplicatedPersistentBlobstore = this._replicationManager.isReplicatedPersistentBlobstore();
        this._isSyncReplication = this._replicationManager.isSyncReplication();
        this._cacheManager = new CacheManager(this._configReader, this._clusterPolicy, this._typeManager, this._replicationManager.getReplicationNode(), storageAdapter, this, this._spaceImpl.getCustomProperties());
        int minThreads = this._configReader.getIntSpaceProperty("engine.min_threads", "1");
        int maxThreads = this._configReader.getIntSpaceProperty("engine.max_threads", "64");
        boolean isHighPriority = this._configReader.getBooleanSpaceProperty("engine.threads_higher_priority", "false");
        int threadPriority = isHighPriority ? 10 : 5;
        long timeout = 60000L;
        this._coreProcessor = new Processor(this);
        this._processorWG = new WorkingGroup<BusPacket<Processor>>(this._coreProcessor, threadPriority, "Processor", minThreads, maxThreads, 60000L);
        this._processorWG.start();
        this._filterManager = new FilterManager(this._typeManager, spaceImpl.getTaskProxy(), this);
        this._dataEventManager = new SpaceDataEventManager(this._directProxy, this._filterManager, spaceImpl, this._configReader);
        this._templateScanner = new TemplateScanner(this._typeManager, this._cacheManager, this._dataEventManager, this);
        this._fifoGroupsHandler = new FifoGroupsHandler(this);
        this._duplicateOperationIDFilter = this.createDuplicateOperationIDFilter();
        this._resultsSizeLimit = this._configReader.getIntSpaceProperty("engine.query.result.size.limit", "0");
        this._resultsSizeLimitMemoryCheckBatchSize = this._configReader.getIntSpaceProperty("engine.query.result.size.limit.memory.check.batch.size", "0");
        if (!this._isLocalCache) {
            this.registerSpaceMetrics(this._metricRegistrator);
        }
    }

    private void blobStoreOverrideConfig(SpaceImpl spaceImpl) {
        String replicationPolicyPath = "cluster-config.groups.group.repl-policy.";
        String redoLogCapacityFromCustomProperties = spaceImpl.getCustomProperties().getProperty(replicationPolicyPath + "redo-log-capacity");
        String redoLogMemoryCapacityFromCustomProperties = spaceImpl.getCustomProperties().getProperty(replicationPolicyPath + "redo-log-memory-capacity");
        String redoLogCompactionFromCustomProperties = spaceImpl.getCustomProperties().getProperty(replicationPolicyPath + "redo-log-compaction");
        String onRedoLogCapacityExceededFromCustomProperties = spaceImpl.getCustomProperties().getProperty(replicationPolicyPath + "on-redo-log-capacity-exceeded");
        if (redoLogCapacityFromCustomProperties == null && spaceImpl.getClusterPolicy() != null && spaceImpl.getClusterPolicy().getReplicationPolicy() != null) {
            if (this._loggerConfig.isLoggable(Level.INFO)) {
                this._loggerConfig.info("Override the cluster config property <" + replicationPolicyPath + "on-redo-log-capacity-exceeded" + ">. new value: <" + "1000000" + ">");
            }
            spaceImpl.getClusterPolicy().getReplicationPolicy().setMaxRedoLogCapacity(Integer.valueOf("1000000").intValue());
        }
        if (redoLogMemoryCapacityFromCustomProperties == null && spaceImpl.getClusterPolicy() != null && spaceImpl.getClusterPolicy().getReplicationPolicy() != null) {
            if (this._loggerConfig.isLoggable(Level.INFO)) {
                this._loggerConfig.info("Override the cluster config property <" + replicationPolicyPath + "redo-log-memory-capacity" + ">. new value: <" + "400000" + ">");
            }
            spaceImpl.getClusterPolicy().getReplicationPolicy().setMaxRedoLogMemoryCapacity(Integer.valueOf("400000").intValue());
        }
        if (onRedoLogCapacityExceededFromCustomProperties == null && spaceImpl.getClusterPolicy() != null && spaceImpl.getClusterPolicy().getReplicationPolicy() != null) {
            if (this._loggerConfig.isLoggable(Level.INFO)) {
                this._loggerConfig.info("Override the cluster config property <" + replicationPolicyPath + "on-redo-log-capacity-exceeded" + ">. new value: <" + (Object)((Object)RedoLogCapacityExceededPolicy.BLOCK_OPERATIONS) + ">");
            }
            spaceImpl.getClusterPolicy().getReplicationPolicy().setOnRedoLogCapacityExceeded(RedoLogCapacityExceededPolicy.BLOCK_OPERATIONS);
        } else if (onRedoLogCapacityExceededFromCustomProperties != null && spaceImpl.getClusterPolicy() != null && spaceImpl.getClusterPolicy().getReplicationPolicy() != null && spaceImpl.getClusterPolicy().getReplicationPolicy().getOnRedoLogCapacityExceeded().equals((Object)RedoLogCapacityExceededPolicy.DROP_OLDEST)) {
            throw new BlobStoreException("property [ " + replicationPolicyPath + "on-redo-log-capacity-exceeded" + " ] must configured as [ " + (Object)((Object)RedoLogCapacityExceededPolicy.BLOCK_OPERATIONS) + " ] ");
        }
    }

    private MetricRegistrator createSpaceRegistrator(final SpaceImpl spaceImpl) {
        String prefix = "metrics.";
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Map.Entry<Object, Object> property : spaceImpl.getCustomProperties().entrySet()) {
            String name = (String)property.getKey();
            if (!name.startsWith("metrics.")) continue;
            tags.put(name.substring("metrics.".length()), (String)property.getValue());
        }
        tags.put("space_name", spaceImpl.getName());
        tags.put("space_instance_id", spaceImpl.getInstanceId());
        HashMap<String, DynamicMetricTag> dynamicTags = new HashMap<String, DynamicMetricTag>();
        dynamicTags.put("space_active", new DynamicMetricTag(){

            @Override
            public Object getValue() {
                boolean active;
                try {
                    active = spaceImpl.isActive();
                }
                catch (RemoteException e) {
                    active = false;
                }
                return active;
            }
        });
        return this._metricManager.createRegistrator("space", tags, dynamicTags);
    }

    private void registerSpaceMetrics(MetricRegistrator registrator) {
        registrator.register(registrator.toPath("connections", "incoming", "active"), new Gauge<Integer>(){

            @Override
            public Integer getValue() throws Exception {
                return SpaceEngine.this.countIncomingConnections();
            }
        });
        registrator.register(registrator.toPath("transactions", "active"), new Gauge<Integer>(){

            @Override
            public Integer getValue() throws Exception {
                return SpaceEngine.this.countTransactions(0, 1);
            }
        });
    }

    private IDuplicateOperationFilter createDuplicateOperationIDFilter() {
        if (this.isReplicated() && this.getClusterPolicy().isPrimaryElectionAvailable()) {
            int lastOperationCountToKeep = 200000;
            DuplicateOperationIDFilter duplicateFilter = new DuplicateOperationIDFilter(lastOperationCountToKeep);
            long duplicateProtectionTimeInterval = 120000L;
            return new BackupFailoverOperationIDFilter(duplicateFilter, duplicateProtectionTimeInterval);
        }
        return new NullDuplicateOperationIDFilter();
    }

    private static IStorageAdapter initStorageAdapter(SpaceImpl spaceImpl, SpaceEngine spaceEngine) throws CreateException {
        JSpaceAttributes spaceAttributes = spaceImpl.getJspaceAttr();
        if (!spaceAttributes.isPersistent()) {
            return new MemorySA();
        }
        try {
            SpaceDataSource spaceDataSourceInstance = SpaceEngine.getSpaceDataSourceInstance(spaceAttributes);
            SpaceSynchronizationEndpoint synchronizationEndpointInterceptorInstance = SpaceEngine.getSynchronizationEndpointInstance(spaceAttributes);
            if (spaceDataSourceInstance != null || synchronizationEndpointInterceptorInstance != null) {
                return new SynchronizationStorageAdapter(spaceEngine, spaceDataSourceInstance, synchronizationEndpointInterceptorInstance);
            }
            return EDSAdapter.create(spaceEngine, spaceAttributes);
        }
        catch (Exception e) {
            throw new CreateException("Failed to load storage adapter", e);
        }
    }

    private static SpaceSynchronizationEndpoint getSynchronizationEndpointInstance(JSpaceAttributes spaceAttributes) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String synchronizationEndpointInterceptorClassName;
        SpaceSynchronizationEndpoint synchronizationEndpointInstance = spaceAttributes.getSynchronizationEndpointInstance();
        if (synchronizationEndpointInstance == null && StringUtils.hasText(synchronizationEndpointInterceptorClassName = spaceAttributes.getSynchronizationEndpointClassName())) {
            Class clazz = ClassLoaderHelper.loadClass(synchronizationEndpointInterceptorClassName);
            return (SpaceSynchronizationEndpoint)clazz.newInstance();
        }
        return synchronizationEndpointInstance;
    }

    private static SpaceDataSource getSpaceDataSourceInstance(JSpaceAttributes spaceAttributes) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String spaceDataSourceClassName;
        SpaceDataSource spaceDataSourceInstance = spaceAttributes.getSpaceDataSourceInstance();
        if (spaceDataSourceInstance == null && StringUtils.hasText(spaceDataSourceClassName = spaceAttributes.getSpaceDataSourceClassName())) {
            Class clazz = ClassLoaderHelper.loadClass(spaceDataSourceClassName);
            return (SpaceDataSource)clazz.newInstance();
        }
        return spaceDataSourceInstance;
    }

    private static EntryDataType initEntryDataType(SpaceConfigReader configReader, boolean isLocalCache) {
        if (!isLocalCache) {
            return EntryDataType.FLAT;
        }
        String entryDataTypeProperty = configReader.getSpaceProperty("dist-cache.storage-type", "reference");
        return entryDataTypeProperty.equalsIgnoreCase("reference") ? EntryDataType.USER_TYPE : EntryDataType.FLAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifySystemTime(IStorageAdapter sa) {
        boolean initializeError;
        if (!this._logger.isLoggable(Level.INFO)) return;
        Throwable initializedException = null;
        String initializedMsg = null;
        try {
            SystemTime.timeMillis();
            if (SystemInfo.singleton().timeProvider().isRelativeTime() && sa.supportsExternalDB()) {
                initializedMsg = "Limitation - Relative time is currently limited to in-memory space.";
            }
            boolean bl = initializeError = initializedMsg != null;
        }
        catch (Throwable t) {
            boolean initializeError2;
            try {
                initializedException = t;
                initializedMsg = String.valueOf(t.getCause());
                boolean bl = initializeError2 = initializedMsg != null;
            }
            catch (Throwable throwable) {
                boolean initializeError3;
                boolean bl = initializeError3 = initializedMsg != null;
                if (initializedMsg == null && SystemInfo.singleton().timeProvider().isRelativeTime()) {
                    initializedMsg = "<" + SystemInfo.singleton().timeProvider().getTimeProviderName() + "> initialized successfully";
                }
                if (initializedMsg != null) {
                    this._logger.info("System time-provider:[  " + initializedMsg + "  ] ");
                }
                if (!initializeError3) throw throwable;
                throw new RuntimeException(initializedMsg, initializedException);
            }
            if (initializedMsg == null && SystemInfo.singleton().timeProvider().isRelativeTime()) {
                initializedMsg = "<" + SystemInfo.singleton().timeProvider().getTimeProviderName() + "> initialized successfully";
            }
            if (initializedMsg != null) {
                this._logger.info("System time-provider:[  " + initializedMsg + "  ] ");
            }
            if (!initializeError2) return;
            throw new RuntimeException(initializedMsg, initializedException);
        }
        if (initializedMsg == null && SystemInfo.singleton().timeProvider().isRelativeTime()) {
            initializedMsg = "<" + SystemInfo.singleton().timeProvider().getTimeProviderName() + "> initialized successfully";
        }
        if (initializedMsg != null) {
            this._logger.info("System time-provider:[  " + initializedMsg + "  ] ");
        }
        if (!initializeError) return;
        throw new RuntimeException(initializedMsg, initializedException);
    }

    public synchronized void init(boolean loadDataFromDB, boolean considerMemoryRecovery) throws CreateException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("init(loadDataFromDB=" + loadDataFromDB + ", considerMemoryRecovery=" + considerMemoryRecovery + ")");
        }
        try {
            JSpaceAttributes spaceAttr = this._spaceImpl.getJspaceAttr();
            if (!spaceAttr.isPersistent() || this._replicationManager.isMirrorService()) {
                loadDataFromDB = false;
            }
            Properties properties = this.loadSpaceAttributeProperties(spaceAttr);
            this._cacheManager.init(properties);
            if (this._clusterPolicy != null && this._clusterPolicy.getReplicationPolicy() != null && this._clusterPolicy.getReplicationPolicy().getConflictingOperationPolicy() == null) {
                this._conflictingOperationPolicy = this._cacheManager.isMemorySpace() && this._cacheManager.isEvictableCachePolicy() ? ConflictingOperationPolicy.OVERRIDE : ConflictingOperationPolicy.DEFAULT;
            }
            this._leaseManager = new LeaseManager(this, this._spaceName, this._coreProcessor);
            this._dataEventManager.setLeaseManager(this._leaseManager);
            this._cacheManager.setLeaseManager(this._leaseManager);
            this._memoryManager = new MemoryManager(this._spaceName, this._containerName, this._cacheManager, this._leaseManager, this._spaceImpl.isPrimary());
            this._typeManager.loadSpaceTypes(this._spaceImpl.getURL());
            this._cacheManager.initCache(loadDataFromDB, properties);
            this._leaseManager.init();
            this._cacheManager.startTemplateExpirationManager();
            if (this.isReplicated() && considerMemoryRecovery && this._clusterPolicy.m_ReplicationPolicy.m_ReplicationGroupMembersNames.size() > 1) {
                ReplicationPolicy.ReplicationPolicyDescription pd = this._clusterPolicy.m_ReplicationPolicy.m_ReplMemberPolicyDescTable.get(this._clusterPolicy.m_ReplicationPolicy.m_OwnMemberName);
                if (pd.memberRecovery) {
                    this._memoryRecoveryEnabled = true;
                    if (this.hasMirror() || !loadDataFromDB || this.isEmptyPersistent()) {
                        this._coldStart = true;
                    }
                }
            }
            this._dataEventManager.init(this.isReplicated(), this.getReplicationNode());
        }
        catch (Exception ex) {
            String msg = "Failed to init [" + this._spaceName + "] space.";
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, ex);
            }
            this._processorWG.shutdown();
            this._dataEventManager.close();
            if (this._leaseManager != null) {
                this._leaseManager.close();
            }
            throw new CreateException(msg + " " + ex.getMessage(), ex);
        }
    }

    private Properties loadSpaceAttributeProperties(JSpaceAttributes spaceAttr) {
        Object blobStoreCacheFilterQueries;
        Object blobStoreDataCacheSize;
        Object blobStoreDataPolicyClass;
        Object blobStoreDataPolicy;
        Object customEvictionPolicy;
        Properties properties = new Properties();
        if (spaceAttr.isPersistent() && this._cacheManager.isCacheExternalDB()) {
            Object dataSource = spaceAttr.getCustomProperties().get("external-data-source.data-source");
            if (dataSource != null) {
                properties.put("external-data-source.data-source", dataSource);
            }
            properties.setProperty("external-data-source.data-source-class", spaceAttr.getDataSourceClass());
            properties.setProperty("external-data-source.data-class", spaceAttr.getDataClass());
            properties.setProperty("external-data-source.query-builder-class", spaceAttr.getQueryBuilderClass());
            properties.setProperty("external-data-source.supports-inheritance", String.valueOf(spaceAttr.isSupportsInheritanceEnabled()));
            properties.setProperty("external-data-source.supports-version", String.valueOf(spaceAttr.isSupportsVersionEnabled()));
            properties.setProperty("external-data-source.supports-partial-update", String.valueOf(spaceAttr.isSupportsPartialUpdateEnabled()));
            properties.setProperty("external-data-source.supports-remove-by-id", String.valueOf(spaceAttr.isSupportsRemoveByIdEnabled()));
            properties.setProperty("external-data-source.usage", spaceAttr.getUsage());
            properties.setProperty("external-data-source.init-properties-file", spaceAttr.getDataPropertiesFile());
            properties.setProperty("external-data-source.shared-iterator.enabled", String.valueOf(spaceAttr.getDataSourceSharedIteratorMode()));
            properties.setProperty("external-data-source.shared-iterator.time-to-live", String.valueOf(spaceAttr.getDataSourceSharedIteratorTimeToLive()));
        }
        if ((customEvictionPolicy = spaceAttr.getCustomProperties().get("engine.eviction_strategy_instance")) != null) {
            properties.put("engine.eviction_strategy_instance", customEvictionPolicy);
        }
        if ((blobStoreDataPolicy = spaceAttr.getCustomProperties().get("engine.blobstore_storage_handler_instance")) != null) {
            properties.put("engine.blobstore_storage_handler_instance", blobStoreDataPolicy);
        }
        if ((blobStoreDataPolicyClass = spaceAttr.getCustomProperties().get("engine.blobstore_storage_handler")) != null) {
            properties.put("engine.blobstore_storage_handler", blobStoreDataPolicyClass);
        }
        if ((blobStoreDataCacheSize = spaceAttr.getCustomProperties().get("space-config.engine.blobstore_cache_size")) != null) {
            properties.put("space-config.engine.blobstore_cache_size", blobStoreDataCacheSize);
        } else {
            properties.put("space-config.engine.blobstore_cache_size", "10000");
        }
        Object blobStorePersistent = spaceAttr.getCustomProperties().get("space-config.engine.blobstore_persistent");
        if (blobStorePersistent != null) {
            properties.put("space-config.engine.blobstore_persistent", blobStorePersistent);
        }
        if ((blobStoreCacheFilterQueries = spaceAttr.getCustomProperties().get("space-config.engine.blobstore_cache_filter_queries")) != null) {
            properties.put("space-config.engine.blobstore_cache_filter_queries", blobStoreCacheFilterQueries);
        }
        return properties;
    }

    public TemplateScanner getTemplateScanner() {
        return this._templateScanner;
    }

    public SpaceImpl getSpaceImpl() {
        return this._spaceImpl;
    }

    public Logger getOperationLogger() {
        return this._operationLogger;
    }

    public SpaceConfigReader getConfigReader() {
        return this._configReader;
    }

    public SpaceTypeManager getTypeManager() {
        return this._typeManager;
    }

    public FilterManager getFilterManager() {
        return this._filterManager;
    }

    public LeaseManager getLeaseManager() {
        return this._leaseManager;
    }

    public EntryArrivedPacketsFactory getEntryArrivedPacketsFactory() {
        return this._entryArrivedFactory;
    }

    public EntryDataType getEntryDataType() {
        return this._entryDataType;
    }

    public WorkingGroup<BusPacket<Processor>> getProcessorWG() {
        return this._processorWG;
    }

    public void invokeFilters(SpaceContext sc, int operationCode, Object subject) {
        if (this._filterManager != null && this._filterManager._isFilter[operationCode]) {
            this._filterManager.invokeFilters(operationCode, sc, subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteEntryResult write(IEntryPacket entryPacket, Transaction txn, long lease, int modifiers, boolean fromReplication, boolean origin, SpaceContext sc) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException {
        Context context;
        this.monitorMemoryUsage(true);
        this.monitorReplicationStateForModifyingOperation(txn, OperationWeightInfoFactory.create(1, WeightInfoOperationType.WRITE));
        Context context2 = context = fromReplication && this.getReplicationNode().getBlobStoreReplicaConsumeHelper() != null ? this.getReplicationNode().getBlobStoreReplicaConsumeHelper().getContext() : null;
        if (context == null) {
            context = fromReplication && this.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper() != null ? this.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper().getContext() : null;
        }
        boolean supplied_context = context != null;
        try {
            if (!supplied_context) {
                context = this._cacheManager.getCacheContext();
            }
            WriteEntryResult writeEntryResult = this.write(context, entryPacket, txn, lease, modifiers, fromReplication, origin, sc, false, false);
            return writeEntryResult;
        }
        finally {
            if (!supplied_context) {
                this._cacheManager.freeCacheContext(context);
            }
        }
    }

    private boolean isExecutedAlready(OperationID operationID) {
        return this._duplicateOperationIDFilter.contains(operationID);
    }

    private WriteEntryResult write(Context context, IEntryPacket entryPacket, Transaction txn, long lease, int modifiers, boolean fromReplication, boolean origin, SpaceContext sc, boolean reInsertedEntry, boolean fromWriteMultiple) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException {
        context.setFromReplication(fromReplication);
        context.setOrigin(origin);
        context.setOperationID(entryPacket.getOperationID());
        this.setFromGatewayIfNeeded(sc, context);
        IServerTypeDesc serverTypeDesc = this._typeManager.loadServerTypeDesc(entryPacket);
        String packetUid = entryPacket.getUID();
        if (this._isLocalCache) {
            if (packetUid == null) {
                throw new IllegalArgumentException("Write operation requires non-null object UID when using local cache. Object=" + entryPacket.toString());
            }
            if (entryPacket.getVersion() <= 0) {
                throw new IllegalArgumentException("Write operation requires object version greater than 0 when using local cache. Object=" + entryPacket.toString());
            }
        }
        if (!fromReplication) {
            if (this.isPartitionedSpace() && ProtectiveMode.isWrongRoutingUsageProtectionEnabled()) {
                if (entryPacket.getRoutingFieldValue() == null && serverTypeDesc.getTypeDesc().getRoutingPropertyName() != null && !serverTypeDesc.getTypeDesc().isAutoGenerateRouting()) {
                    this.throwNoRoutingProvidedWhenNeeded(serverTypeDesc, "writing");
                } else if (entryPacket.getRoutingFieldValue() != null) {
                    this.checkEntryRoutingValueMatchesCurrentPartition(entryPacket, serverTypeDesc, "written");
                }
            }
            if (ProtectiveMode.isTypeWithoutIdProtectionEnabled() && entryPacket.getID() == null && !serverTypeDesc.getTypeDesc().isAutoGenerateId() && serverTypeDesc.getTypeDesc().getObjectType() != EntryType.EXTERNAL_ENTRY && !ServerTypeDesc.isEntry(serverTypeDesc) && !ProtectiveMode.shouldIgnoreTypeWithoutIdProtectiveMode(serverTypeDesc.getTypeName())) {
                throw new ProtectiveModeException("Cannot introduce a type named '" + serverTypeDesc.getTypeName() + "' without an id property defined. Having a type without an id property would prevent modifying (update/change) objects of that type after they were written to the space. (you can disable this protection, though it is not recommended, by setting the following system property: " + "com.gs.protectiveMode.typeWithoutId" + "=false)");
            }
        }
        XtnEntry txnEntry = this.initTransactionEntry(txn, sc, fromReplication);
        if (!(fromReplication || this._isLocalCache || context.isFromGateway() || Modifiers.contains(modifiers, 524288))) {
            entryPacket.setVersion(1);
        }
        long current = SystemTime.timeMillis();
        String entryUid = this.getOrCreateUid(entryPacket);
        IEntryHolder eHolder = EntryHolderFactory.createEntryHolder(serverTypeDesc, entryPacket, this._entryDataType, entryUid, LeaseManager.toAbsoluteTime(lease, current), txnEntry, current, this._cacheManager.isblobStoreDataSpace() && serverTypeDesc.getTypeDesc().isBlobstoreEnabled() && !UpdateModifiers.isUpdateOnly(modifiers));
        if (!reInsertedEntry && this._filterManager._isFilter[0]) {
            this._filterManager.invokeFilters(0, sc, eHolder);
        }
        WriteEntryResult writeResult = null;
        EntryAlreadyInSpaceException entryInSpaceEx = null;
        try {
            writeResult = this._coreProcessor.handleDirectWriteSA(context, eHolder, serverTypeDesc, fromReplication, origin, reInsertedEntry, packetUid != null, !fromWriteMultiple, modifiers);
        }
        catch (EntryAlreadyInSpaceException ex) {
            entryInSpaceEx = ex;
        }
        catch (SAException ex) {
            throw new EngineInternalSpaceException(ex.toString(), ex);
        }
        if (entryInSpaceEx != null && txnEntry != null && packetUid != null && !fromReplication) {
            ServerTransaction sv;
            IEntryHolder currentEh = this._cacheManager.getEntryByUidFromPureCache(eHolder.getUID());
            ServerTransaction serverTransaction = sv = currentEh != null ? currentEh.getWriteLockTransaction() : null;
            if (sv != null && (currentEh.getWriteLockOperation() == 5 || currentEh.getWriteLockOperation() == 4) && sv.equals((Object)txnEntry.m_Transaction)) {
                if (!eHolder.getClassName().equals(currentEh.getClassName())) {
                    throw new InternalSpaceException("take + write under same transaction: must have the same classname, UID=" + currentEh.getUID() + " originalClass=" + currentEh.getClassName() + " newname=" + eHolder.getClassName(), entryInSpaceEx);
                }
                entryPacket.setVersion(0);
                try {
                    AnswerPacket ap = this.update((Context)context, (IEntryPacket)entryPacket, (Transaction)txn, (long)lease, (long)0L, (SpaceContext)sc, (boolean)fromReplication, (boolean)false, (int)4096, null, null).m_AnswerPacket;
                    if (ap.m_EntryPacket == null) {
                        throw new InternalSpaceException("take + write under same transaction: update returned no result, UID=" + currentEh.getUID() + " Class=" + currentEh.getClassName(), entryInSpaceEx);
                    }
                }
                catch (EntryNotInSpaceException ex) {
                    throw new TransactionException("Transaction [" + txnEntry.m_Transaction + "] became inactive while operation is performing.", (Throwable)((Object)ex));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                entryInSpaceEx = null;
                writeResult = context.getWriteResult();
            }
        }
        if (entryInSpaceEx != null) {
            throw entryInSpaceEx;
        }
        if (!reInsertedEntry && this._filterManager._isFilter[1]) {
            this._filterManager.invokeFilters(1, sc, eHolder);
        }
        if (context.isSyncReplFromMultipleOperation()) {
            this.performReplIfChunkReached(context);
            if (context.getReplicationContext() != null) {
                writeResult.setSyncReplicationLevel(context.getReplicationContext().getCompleted());
            }
        } else if (txn == null) {
            int level = this.performReplication(context);
            writeResult.setSyncReplicationLevel(level);
        }
        return writeResult;
    }

    private void checkIfConsistencyLevelIsCompromised(boolean fromReplication, int level) {
        if (this.isSyncReplicationEnabled() && !fromReplication && level + 1 < this.requiredConsistencyLevel()) {
            throw new ConsistencyLevelCompromisedException(level + 1);
        }
    }

    private int requiredConsistencyLevel() {
        return Integer.getInteger("com.gs.replication.required_consistency_level", 1);
    }

    public boolean isNoWriteLease(IEntryPacket entryPacket, int modifiers, boolean fromReplication) {
        return entryPacket.isNoWriteLease() || Modifiers.contains(modifiers, 262144) || fromReplication;
    }

    public GSEventRegistration notify(ITemplatePacket template, long lease, boolean fromReplication, String templateUid, SpaceContext sc, NotifyInfo info) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException {
        boolean isFifoOperation;
        this.monitorMemoryUsage(true);
        this.monitorReplicationStateForModifyingOperation(null, OperationWeightInfoFactory.create(WeightInfoOperationType.NOTIFY));
        IServerTypeDesc typeDesc = this._typeManager.loadServerTypeDesc(template);
        if (templateUid == null) {
            templateUid = this.generateUid();
        }
        info.setTemplateUID(templateUid);
        boolean bl = isFifoOperation = template.isFifo() || info.isFifo();
        if (template.getUID() != null) {
            isFifoOperation = false;
        }
        NotifyTemplateHolder tHolder = TemplateHolderFactory.createNotifyTemplateHolder(typeDesc, template, templateUid, LeaseManager.toAbsoluteTime(lease), this._dataEventManager.generateEventId(), info, isFifoOperation);
        if (info.getFilter() != null) {
            try {
                info.getFilter().init(this._directProxy, template.toObject(template.getEntryType()));
            }
            catch (Throwable e) {
                this._logger.log(Level.FINE, "initializing user filter caused an exception", e);
            }
        }
        if (this._filterManager._isFilter[4]) {
            this._filterManager.invokeFilters(4, sc, tHolder);
        }
        AnswerHolder aHolder = new AnswerHolder();
        this._coreProcessor.handleNotifyRegistration(tHolder, fromReplication, aHolder, template.getOperationID());
        if (aHolder.m_Exception != null) {
            if (aHolder.m_Exception instanceof InternalSpaceException) {
                throw (InternalSpaceException)aHolder.m_Exception;
            }
            JSpaceUtilities.throwEngineInternalSpaceException(aHolder.m_Exception.getMessage(), aHolder.m_Exception);
        }
        return aHolder.getEventRegistration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readByIds(AbstractIdsQueryPacket template, Transaction txn, boolean take, SpaceContext spaceContext, int operationModifiers, ReadByIdsContext readByIdsContext) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        IServerTypeDesc serverTypeDesc;
        ITypeDesc typeDesc;
        this.monitorMemoryUsage(false);
        if (take) {
            this.monitorReplicationStateForModifyingOperation(txn, OperationWeightInfoFactory.create(template.getIds().length, WeightInfoOperationType.TAKE));
        }
        if (ReadModifiers.isFifoGroupingPoll(operationModifiers)) {
            operationModifiers = Modifiers.remove(operationModifiers, 0x100000);
        }
        boolean uidHandling = (typeDesc = (serverTypeDesc = this._typeManager.loadServerTypeDesc(template)).getTypeDesc()).getIdPropertyName() == null || typeDesc.isAutoGenerateId();
        boolean isPersistent = !typeDesc.getIntrospector(null).isTransient(null);
        boolean supportsNonBlobStorePrefetch = isPersistent && !ReadModifiers.isMemoryOnlySearch(operationModifiers) && !this._cacheManager.isResidentEntriesCachePolicy() && this._cacheManager.getStorageAdapter().supportsGetEntries() && !serverTypeDesc.hasSubTypes();
        AbstractIdsQueryPacket idsQueryPacket = template;
        Object[] ids = idsQueryPacket.getIds();
        ReadByIdsInfo rIdsInfo = null;
        if (this._cacheManager.isResidentEntriesCachePolicy() && !uidHandling) {
            rIdsInfo = new ReadByIdsInfo(ids);
        }
        ITemplatePacket[] templatePackets = new ITemplatePacket[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            if (uidHandling) {
                templatePackets[i] = TemplatePacketFactory.createUidPacket(typeDesc, (String)ids[i], idsQueryPacket.getRouting(i), 0, template.getQueryResultType(), null);
            } else {
                templatePackets[i] = TemplatePacketFactory.createIdPacket(ids[i], idsQueryPacket.getRouting(i), 0, typeDesc, template.getQueryResultType(), null);
                if (supportsNonBlobStorePrefetch) {
                    templatePackets[i].setUID(this._uidFactory.createUidFromTypeAndId(typeDesc.getTypeName(), ids[i].toString(), false));
                }
            }
            templatePackets[i].setOperationID(template.getOperationID());
        }
        Map<String, IEntryHolder> prefetchedNonBlobStoreEntries = supportsNonBlobStorePrefetch ? this.prefetchNonBlobStoreReadByIdsEntries(ids, templatePackets, serverTypeDesc) : null;
        readByIdsContext.initResultsEntryPackets();
        Throwable[] exceptions = null;
        Context context = null;
        try {
            context = this._cacheManager.getCacheContext();
            if (take && txn == null && this._cacheManager.isBlobStoreCachePolicy() && this._cacheManager.useBlobStoreBulks()) {
                context.setBlobStoreBulkInfo(new BlobStoreBulkInfo(this._cacheManager, true));
            }
            for (int i = 0; i < ids.length; ++i) {
                try {
                    AnswerHolder answerHolder = this.unsafeRead_impl(templatePackets[i], txn, 0L, false, take, spaceContext, false, false, true, operationModifiers, rIdsInfo, prefetchedNonBlobStoreEntries, context);
                    readByIdsContext.applyResult(answerHolder.getAnswerPacket(), i);
                    continue;
                }
                catch (Exception e) {
                    if (exceptions == null) {
                        exceptions = new Exception[ids.length];
                    }
                    exceptions[i] = e;
                    readByIdsContext.addFailure(ids[i], e);
                }
            }
        }
        finally {
            RuntimeException ex = null;
            try {
                if (context.isActiveBlobStoreBulk()) {
                    context.getBlobStoreBulkInfo().bulk_flush(context, false, true);
                }
            }
            catch (RuntimeException ex1) {
                ex = ex1;
            }
            context = this._cacheManager.freeCacheContext(context);
            if (ex != null) {
                throw ex;
            }
        }
        if (exceptions != null) {
            if (readByIdsContext.accumulate()) {
                throw ReadTakeByIdsException.newException(idsQueryPacket.getIds(), readByIdsContext.getResults(), exceptions, take);
            }
            throw new ClearByIdsException(readByIdsContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IEntryHolder> prefetchNonBlobStoreReadByIdsEntries(Object[] ids, ITemplatePacket[] templatePackets, IServerTypeDesc typeDesc) throws RemoteException {
        HashMap<String, IEntryHolder> prefetchedEntries;
        block10: {
            prefetchedEntries = new HashMap<String, IEntryHolder>();
            Context context = null;
            try {
                context = this._cacheManager.getCacheContext();
                HashMap<Object, ITemplatePacket> cacheMissEntries = null;
                for (int i = 0; i < ids.length; ++i) {
                    IEntryHolder pureCacheEntry;
                    IEntryCacheInfo entryCacheInfo = this._cacheManager.getPEntryByUid(templatePackets[i].getUID());
                    if (entryCacheInfo == null) {
                        if (cacheMissEntries == null) {
                            cacheMissEntries = new HashMap<Object, ITemplatePacket>();
                        }
                        cacheMissEntries.put(ids[i], templatePackets[i]);
                        continue;
                    }
                    if (entryCacheInfo.isRecentDelete() || (pureCacheEntry = entryCacheInfo.getEntryHolder(this._cacheManager)) == null) continue;
                    prefetchedEntries.put(templatePackets[i].getUID(), pureCacheEntry);
                }
                if (cacheMissEntries == null) break block10;
                try {
                    Object[] cacheMissIds = new Object[cacheMissEntries.size()];
                    IEntryHolder[] cacheMissEntryHolders = new IEntryHolder[cacheMissEntries.size()];
                    int index = 0;
                    for (Map.Entry entry : cacheMissEntries.entrySet()) {
                        Object id = entry.getKey();
                        ITemplatePacket template = (ITemplatePacket)entry.getValue();
                        ITemplateHolder entryHolder = TemplateHolderFactory.createTemplateHolder(typeDesc, template, template.getUID(), Long.MAX_VALUE);
                        cacheMissIds[index] = id;
                        cacheMissEntryHolders[index] = entryHolder;
                        ++index;
                    }
                    Map<String, IEntryHolder> entries = this._cacheManager.getStorageAdapter().getEntries(context, cacheMissIds, typeDesc.getTypeName(), cacheMissEntryHolders);
                    if (entries != null) {
                        prefetchedEntries.putAll(entries);
                    }
                }
                catch (SAException e) {
                    throw new RemoteException("Failed prefetching entries for storage adapter", e);
                }
            }
            finally {
                context = this._cacheManager.freeCacheContext(context);
            }
        }
        return prefetchedEntries;
    }

    public AnswerHolder read(ITemplatePacket template, Transaction txn, long timeout, boolean ifExists, boolean take, SpaceContext sc, boolean returnOnlyUid, boolean fromReplication, boolean origin, int operationModifiers) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        if (Modifiers.contains(operationModifiers, 0x10000000)) {
            SingleExplainPlan.validate(timeout, this._cacheManager.isBlobStoreCachePolicy(), operationModifiers, template.getCustomQuery(), this.getClassTypeInfo(template.getTypeName()).getIndexes());
        }
        this.monitorMemoryUsage(false);
        if (take) {
            this.monitorReplicationStateForModifyingOperation(txn, OperationWeightInfoFactory.create(1, WeightInfoOperationType.TAKE));
        }
        return this.unsafeRead(template, txn, timeout, ifExists, take, sc, returnOnlyUid, fromReplication, origin, operationModifiers, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnswerHolder unsafeRead(ITemplatePacket template, Transaction txn, long timeout, boolean ifExists, boolean take, SpaceContext sc, boolean returnOnlyUid, boolean fromReplication, boolean origin, int operationModifiers, ReadByIdsInfo readByIdsInfo, Map<String, IEntryHolder> prefetchedEntries) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException, InterruptedException {
        Context context;
        Context context2 = context = fromReplication && this.getReplicationNode().getBlobStoreReplicaConsumeHelper() != null && this.getReplicationNode().getDirectPersistencyBackupSyncIteratorHandler() != null ? this.getReplicationNode().getBlobStoreReplicaConsumeHelper().getContext() : null;
        if (context == null) {
            context = fromReplication && this.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper() != null ? this.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper().getContext() : null;
        }
        boolean suppliedContext = context != null;
        try {
            if (!suppliedContext) {
                context = this._cacheManager.getCacheContext();
            }
            AnswerHolder answerHolder = this.unsafeRead_impl(template, txn, timeout, ifExists, take, sc, returnOnlyUid, fromReplication, origin, operationModifiers, readByIdsInfo, prefetchedEntries, context);
            return answerHolder;
        }
        finally {
            if (!suppliedContext) {
                context = this._cacheManager.freeCacheContext(context);
            }
        }
    }

    private AnswerHolder unsafeRead_impl(ITemplatePacket template, Transaction txn, long timeout, boolean ifExists, boolean take, SpaceContext sc, boolean returnOnlyUid, boolean fromReplication, boolean origin, int operationModifiers, ReadByIdsInfo readByIdsInfo, Map<String, IEntryHolder> prefetchedNonBlobStoreEntries, Context context) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException, InterruptedException {
        boolean isFifoOperation;
        if (take && TakeModifiers.isEvictOnly(operationModifiers)) {
            if (this._cacheManager.isResidentEntriesCachePolicy()) {
                throw new IllegalArgumentException("EVICT modifier is not supported in non-evictable policy.");
            }
            txn = null;
            timeout = 0L;
        }
        IServerTypeDesc typeDesc = this._typeManager.loadServerTypeDesc(template);
        boolean bl = isFifoOperation = template.isFifo() || ReadModifiers.isFifo(operationModifiers);
        if (isFifoOperation && !typeDesc.isFifoSupported()) {
            throw new InvalidFifoTemplateException(template.getTypeName());
        }
        if ((template.getUID() != null || template.getID() != null && template.getExtendedMatchCodes() == null) && ReadModifiers.isFifoGroupingPoll(operationModifiers)) {
            operationModifiers = Modifiers.remove(operationModifiers, 0x100000);
        }
        if (ReadModifiers.isFifoGroupingPoll(operationModifiers) && !this._cacheManager.isMemorySpace() && this._cacheManager.isEvictableCachePolicy()) {
            throw new UnsupportedOperationException(" fifo grouping not supported with persistent-LRU");
        }
        if (isFifoOperation && (template.getUID() != null || ReadModifiers.isFifoGroupingPoll(operationModifiers))) {
            isFifoOperation = false;
        }
        XtnEntry txnEntry = this.initTransactionEntry(txn, sc, fromReplication);
        String uid = null;
        if (timeout != 0L) {
            uid = this._uidFactory.createUIDFromCounter();
        }
        if (fromReplication && timeout != 0L) {
            throw new RuntimeException("operation with timeout = NO_WAIT came from replication");
        }
        IResponseContext respContext = ResponseContext.getResponseContext();
        int templateOperation = ifExists ? (take ? 5 : 3) : (take ? 4 : 2);
        long startTime = SystemTime.timeMillis();
        ITemplateHolder tHolder = TemplateHolderFactory.createTemplateHolder(typeDesc, template, uid, LeaseManager.toAbsoluteTime(timeout, startTime), txnEntry, startTime, templateOperation, respContext, returnOnlyUid, operationModifiers, isFifoOperation, fromReplication);
        tHolder.setAnswerHolder(new AnswerHolder());
        tHolder.setNonBlockingRead(this.isNonBlockingReadForOperation(tHolder));
        tHolder.setID(template.getID());
        if (take) {
            if (this._filterManager._isFilter[3] && !tHolder.isInitiatedEvictionOperation()) {
                this._filterManager.invokeFilters(3, sc, tHolder);
            }
            if (!tHolder.isInitiatedEvictionOperation()) {
                tHolder.setForAfterOperationFilter(23, sc, this._filterManager, null);
            }
        } else {
            if (this._filterManager._isFilter[2]) {
                this._filterManager.invokeFilters(2, sc, tHolder);
            }
            tHolder.setForAfterOperationFilter(22, sc, this._filterManager, null);
        }
        boolean answerSetByThisThread = false;
        context.setMainThread(true);
        context.setOperationID(template.getOperationID());
        context.setReadByIdsInfo(readByIdsInfo);
        context.setPrefetchedNonBlobStoreEntries(prefetchedNonBlobStoreEntries);
        if (ifExists) {
            this._coreProcessor.handleDirectReadIEOrTakeIESA(context, tHolder, fromReplication, origin);
        } else {
            this._coreProcessor.handleDirectReadOrTakeSA(context, tHolder, fromReplication, origin);
        }
        if (context.getReplicationContext() != null) {
            tHolder.getAnswerHolder().setSyncRelplicationLevel(context.getReplicationContext().getCompleted());
        }
        answerSetByThisThread = context.isOpResultByThread();
        int numOfEntriesMatched = context.getNumberOfEntriesMatched();
        boolean callBackMode = ResponseContext.isCallBackMode();
        if (!(callBackMode || answerSetByThisThread || tHolder.hasAnswer())) {
            this.waitForBlockingAnswer(timeout, tHolder.getAnswerHolder(), startTime, tHolder);
        }
        if (answerSetByThisThread) {
            tHolder.getAnswerHolder().throwExceptionIfExists();
            tHolder.getAnswerHolder().setNumOfEntriesMatched(numOfEntriesMatched);
            return tHolder.getAnswerHolder();
        }
        if (callBackMode) {
            return this.prepareCallBackModeAnswer(tHolder, true);
        }
        return this.prepareBlockingModeAnswer(tHolder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBlockingAnswer(long timeout, AnswerHolder aHolder, long startTime, ITemplateHolder tHolder) throws InterruptedException {
        long timeToWait = 0L;
        long expirationTimeInMillis = this.getExpirationTimeInMillis(timeout, startTime, tHolder);
        while (true) {
            if (timeout != Long.MAX_VALUE) {
                timeToWait = expirationTimeInMillis - SystemTime.timeMillis();
            }
            if (timeout != Long.MAX_VALUE && timeToWait <= 0L) break;
            AnswerHolder answerHolder = aHolder;
            synchronized (answerHolder) {
                if (!tHolder.hasAnswer()) {
                    if (timeout != Long.MAX_VALUE) {
                        aHolder.wait(timeToWait);
                    } else {
                        aHolder.wait();
                    }
                }
                if (tHolder.hasAnswer()) {
                    break;
                }
            }
        }
    }

    private long getExpirationTimeInMillis(long timeout, long startTime, ITemplateHolder tHolder) {
        if (timeout == Long.MAX_VALUE) {
            return 0L;
        }
        return tHolder.getExpirationTime() - startTime + SystemTime.timeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnswerHolder prepareBlockingModeAnswer(ITemplateHolder tHolder, boolean throwError) throws TransactionException, UnusableEntryException {
        Object object;
        block11: {
            Context context = null;
            ILockObject templateLock = this.getTemplateLockObject(tHolder);
            try {
                object = templateLock;
                synchronized (object) {
                    if (!tHolder.hasAnswer()) {
                        context = this._cacheManager.getCacheContext();
                        context.setOperationID(tHolder.getOperationID());
                        context.setOperationAnswer(tHolder, null, null);
                        if (!tHolder.isDeleted()) {
                            this._cacheManager.removeTemplate(context, tHolder, false, true, false);
                        }
                    }
                    if (throwError) {
                        tHolder.getAnswerHolder().throwExceptionIfExists();
                    }
                }
                object = tHolder.getAnswerHolder();
                if (templateLock != null) {
                    this.freeTemplateLockObject(templateLock);
                }
                if (context == null) break block11;
                this._cacheManager.freeCacheContext(context);
            }
            catch (Throwable throwable) {
                if (templateLock != null) {
                    this.freeTemplateLockObject(templateLock);
                }
                if (context != null) {
                    this._cacheManager.freeCacheContext(context);
                }
                throw throwable;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private AnswerHolder prepareCallBackModeAnswer(ITemplateHolder tHolder, boolean throwError) throws TransactionException, UnusableEntryException {
        ILockObject templateLock;
        block7: {
            templateLock = this.getTemplateLockObject(tHolder);
            try {
                ILockObject iLockObject = templateLock;
                // MONITORENTER : iLockObject
                if (!tHolder.hasAnswer()) {
                    ResponseContext.dontSendResponse();
                    this.moveTemplateToSecondPhase(tHolder);
                    AnswerHolder answerHolder = null;
                    // MONITOREXIT : iLockObject
                    if (templateLock == null) return answerHolder;
                    this.freeTemplateLockObject(templateLock);
                    return answerHolder;
                }
                if (!throwError) break block7;
            }
            catch (Throwable throwable) {
                if (templateLock == null) throw throwable;
                this.freeTemplateLockObject(templateLock);
                throw throwable;
            }
            tHolder.getAnswerHolder().throwExceptionIfExists();
        }
        AnswerHolder answerHolder = tHolder.getAnswerHolder();
        // MONITOREXIT : iLockObject
        if (templateLock == null) return answerHolder;
        this.freeTemplateLockObject(templateLock);
        return answerHolder;
    }

    private void moveTemplateToSecondPhase(ITemplateHolder template) {
        if (template.isDeleted() || !template.isInCache()) {
            return;
        }
        template.setSecondPhase();
    }

    public boolean isNonBlockingReadForOperation(ITemplateHolder tHolder) {
        return !(!this._allowNonBlockingRead || !tHolder.isReadOperation() || tHolder.isExclusiveReadLockOperation() || tHolder.getXidOriginated() != null && !this._useDirtyRead && !ReadModifiers.isDirtyRead(tHolder.getOperationModifiers()) && !ReadModifiers.isReadCommitted(tHolder.getOperationModifiers()) || tHolder.getTemplateOperation() == 3 && tHolder.getExpirationTime() != 0L);
    }

    public void snapshot(ITemplatePacket entryPacket) throws UnusableEntryException {
        ITypeDesc prev = null;
        if (this.getCacheManager().isBlobStoreCachePolicy()) {
            prev = this._typeManager.getTypeDesc(entryPacket.getTypeName());
        }
        try {
            IServerTypeDesc cur = this._typeManager.loadServerTypeDesc(entryPacket);
            if (this.getCacheManager().isBlobStoreCachePolicy() && cur.getTypeDesc() != prev) {
                this.getCacheManager().getStorageAdapter().introduceDataType(cur.getTypeDesc());
            }
        }
        catch (UnknownTypeException ute) {
            throw new ProxyInternalSpaceException(ute.toString(), ute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteEntriesResult write(IEntryPacket[] entryPackets, Transaction txn, long lease, long[] leases, int modifiers, SpaceContext sc, long timeout, boolean newRouter) throws TransactionException, RemoteException, UnknownTypesException {
        this.monitorMemoryUsage(true);
        this.monitorReplicationStateForModifyingOperation(txn, OperationWeightInfoFactory.create(entryPackets.length, WeightInfoOperationType.WRITE));
        if (UpdateModifiers.isPotentialUpdate(modifiers)) {
            if (newRouter) {
                AnswerHolder ah = this.newAdaptUpdateMultiple(entryPackets, txn, lease, leases, sc, timeout, modifiers);
                return ah != null ? ah.getUpdateMultipleResult() : null;
            }
            return this.oldAdaptUpdateMultiple(entryPackets, txn, lease, leases, sc, modifiers, newRouter);
        }
        boolean[] shouldReplicateArray = new boolean[entryPackets.length];
        IServerTypeDesc[] types = new IServerTypeDesc[entryPackets.length];
        Context context = null;
        WriteEntriesResult result = new WriteEntriesResult(entryPackets.length);
        LinkedList<Integer> unknownTypePositions = null;
        OperationID[] opIDs = new OperationID[entryPackets.length];
        boolean anyFifoClass = false;
        for (int i = 0; i < entryPackets.length; ++i) {
            opIDs[i] = entryPackets[i].getOperationID();
            try {
                IServerTypeDesc typeDesc;
                types[i] = typeDesc = this._typeManager.loadServerTypeDesc(entryPackets[i]);
                shouldReplicateArray[i] = false;
                if (this.isReplicated()) {
                    shouldReplicateArray[i] = this.shouldReplicate(ReplicationOperationType.WRITE, typeDesc, false, false);
                }
                if (anyFifoClass || !typeDesc.getTypeDesc().isFifoSupported()) continue;
                anyFifoClass = true;
                continue;
            }
            catch (UnusableEntryException e) {
                result.setError(i, (Exception)((Object)e));
                continue;
            }
            catch (UnknownTypeException e) {
                if (entryPackets[i].getTypeDescriptor() != null) {
                    result.setError(i, e);
                    continue;
                }
                if (unknownTypePositions == null) {
                    unknownTypePositions = new LinkedList<Integer>();
                }
                unknownTypePositions.add(i);
            }
        }
        if (unknownTypePositions != null) {
            throw new UnknownTypesException(unknownTypePositions);
        }
        XtnEntry txnEntry = null;
        if (txn != null) {
            txnEntry = this.attachToXtn((ServerTransaction)txn, false);
            this.attachFromGatewayStateToTransactionIfNeeded(sc, txnEntry);
        }
        try {
            context = this._cacheManager.getCacheContext();
            if (this._isSyncReplication) {
                context.setSyncReplFromMultipleOperation(true);
            }
            context.setMultipleOperation();
            context.setOperationIDs(opIDs);
            this.setFromGatewayIfNeeded(sc, context);
            if (txnEntry != null) {
                txnEntry.lock();
                try {
                    if (!txnEntry.m_Active) {
                        throw new TransactionException("The transaction is not active: " + txnEntry.m_Transaction);
                    }
                    context.setTransactionalMultipleOperation(true);
                    result = this.writeEntryPackets(entryPackets, result, context, txnEntry.m_Transaction, lease, leases, modifiers, sc, false, true);
                }
                finally {
                    txnEntry.unlock();
                }
            } else {
                if (this._cacheManager.isBlobStoreCachePolicy() && this._cacheManager.useBlobStoreBulks() && (!anyFifoClass || !this._cacheManager.isDirectPersistencyEmbeddedtHandlerUsed())) {
                    context.setBlobStoreBulkInfo(new BlobStoreBulkInfo(this._cacheManager, false));
                }
                result = this.writeEntryPackets(entryPackets, result, context, null, lease, leases, modifiers, sc, false, true);
            }
            WriteEntriesResult writeEntriesResult = result;
            return writeEntriesResult;
        }
        finally {
            RuntimeException ex = null;
            if (txnEntry != null) {
                txnEntry.decrementUsed(true);
            }
            try {
                if (context.isActiveBlobStoreBulk()) {
                    context.getBlobStoreBulkInfo().bulk_flush(context, false, true);
                }
            }
            catch (RuntimeException ex1) {
                ex = ex1;
            }
            this.replicateAndfreeCache(context);
            if (ex != null) {
                throw ex;
            }
        }
    }

    public WriteEntriesResult oldAdaptUpdateMultiple(IEntryPacket[] entries, Transaction txn, long lease, long[] leases, SpaceContext sc, int modifiers, boolean newRouter) throws RemoteException, TransactionException, UnknownTypesException {
        Object[] updateMultipleResult;
        boolean noReturnValue = UpdateModifiers.isNoReturnValue(modifiers);
        if (leases == null) {
            leases = new long[entries.length];
            for (int i = 0; i < leases.length; ++i) {
                leases[i] = lease;
            }
        }
        try {
            updateMultipleResult = UpdateModifiers.isUpdateOrWrite(modifiers) ? this.updateOrWrite(entries, txn, leases, sc, modifiers, true, newRouter) : this.updateMultiple(entries, txn, leases, sc, modifiers, newRouter);
        }
        catch (UnknownTypeException e) {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (int i = 0; i < entries.length; ++i) {
                positions.add(i);
            }
            throw new UnknownTypesException(positions);
        }
        catch (UnusableEntryException e) {
            throw new WriteMultipleException(entries.length, (Throwable)e);
        }
        WriteEntriesResult result = new WriteEntriesResult(updateMultipleResult.length);
        for (int i = 0; i < updateMultipleResult.length; ++i) {
            if (updateMultipleResult[i] == null) {
                result.setError(i, new OperationTimeoutException());
                continue;
            }
            if (updateMultipleResult[i] instanceof Exception) {
                result.setError(i, (Exception)updateMultipleResult[i]);
                continue;
            }
            if (updateMultipleResult[i] instanceof WriteEntryResult) {
                result.setResult(i, (WriteEntryResult)updateMultipleResult[i]);
                continue;
            }
            if (updateMultipleResult[i] instanceof LeaseContext) {
                LeaseContext resultLease = (LeaseContext)updateMultipleResult[i];
                IEntryPacket prevObject = (IEntryPacket)resultLease.getObject();
                WriteEntryResult writeResult = new WriteEntryResult(resultLease.getUID(), prevObject == null ? 1 : prevObject.getVersion() + 1, leases[i]);
                result.setResult(i, writeResult);
                continue;
            }
            if (!(updateMultipleResult[i] instanceof IEntryPacket) || noReturnValue) continue;
            result.setResult(i, new WriteEntryResult((IEntryPacket)updateMultipleResult[i]));
        }
        return result;
    }

    public AnswerHolder newAdaptUpdateMultiple(IEntryPacket[] entries, Transaction txn, long lease, long[] leases, SpaceContext sc, long timeout, int modifiers) throws RemoteException, TransactionException, UnknownTypesException {
        if (leases == null) {
            leases = new long[entries.length];
            Arrays.fill(leases, lease);
        }
        AnswerHolder ah = null;
        try {
            ah = UpdateModifiers.isUpdateOrWrite(modifiers) ? this.newUpdateOrWriteMultiple(entries, txn, leases, sc, timeout, modifiers) : this.newUpdateMultiple(entries, txn, leases, sc, timeout, modifiers);
        }
        catch (UnknownTypeException e) {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (int i = 0; i < entries.length; ++i) {
                positions.add(i);
            }
            throw new UnknownTypesException(positions);
        }
        catch (UnusableEntryException e) {
            throw new WriteMultipleException(entries.length, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WriteMultipleException(entries.length, (Throwable)e);
        }
        return ah;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] updateOrWrite(IEntryPacket[] entries, Transaction txn, long[] leases, SpaceContext sc, int operationModifiers, boolean fromWriteMultiple, boolean newRouter) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException {
        XtnEntry txnEntry = null;
        if (txn != null) {
            txnEntry = this.attachToXtn((ServerTransaction)txn, false);
        }
        Context context = null;
        try {
            context = this._cacheManager.getCacheContext();
            if (this._isSyncReplication) {
                context.setSyncReplFromMultipleOperation(true);
            }
            context.setMultipleOperation();
            this.setFromGatewayIfNeeded(sc, context);
            Object[] returnValues = new Object[entries.length];
            for (int i = 0; i < entries.length; ++i) {
                context.setWriteResult(null);
                try {
                    UpdateOrWriteContext ctx = new UpdateOrWriteContext(entries[i], leases[i], 0L, txn, sc, operationModifiers, !fromWriteMultiple, false, fromWriteMultiple);
                    if (txnEntry != null && context.isFromGateway() && Modifiers.contains(operationModifiers, 524288)) {
                        txnEntry.setGatewayOverrideVersion(entries[i].getUID());
                    }
                    ctx.setCacheContext(context);
                    AnswerPacket answerPacket = this._spaceImpl.updateOrWrite(ctx, newRouter);
                    if (answerPacket == null) continue;
                    if (fromWriteMultiple && answerPacket.m_leaseProxy != null) {
                        returnValues[i] = answerPacket.m_leaseProxy;
                        continue;
                    }
                    if (fromWriteMultiple && answerPacket.getWriteEntryResult() != null) {
                        returnValues[i] = answerPacket.getWriteEntryResult();
                        continue;
                    }
                    returnValues[i] = answerPacket.m_EntryPacket;
                    continue;
                }
                catch (UnknownTypeException e) {
                    throw e;
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Throwable e) {
                    returnValues[i] = e;
                }
            }
            Object[] objectArray = returnValues;
            return objectArray;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            if (txnEntry != null) {
                txnEntry.decrementUsed(true);
            }
            this.replicateAndfreeCache(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AnswerHolder newUpdateOrWriteMultiple(IEntryPacket[] entries, Transaction txn, long[] leases, SpaceContext sc, long timeout, int operationModifiers) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException, InterruptedException {
        boolean fromWriteMultiple = true;
        boolean anyFifoClass = false;
        for (int i = 0; i < entries.length; ++i) {
            IServerTypeDesc std = this._typeManager.loadServerTypeDesc(entries[i]);
            if (anyFifoClass || !std.getTypeDesc().isFifoSupported()) continue;
            anyFifoClass = true;
        }
        XtnEntry txnEntry = null;
        if (txn != null) {
            txnEntry = this.attachToXtn((ServerTransaction)txn, false);
            this.attachFromGatewayStateToTransactionIfNeeded(sc, txnEntry);
        }
        String uid = null;
        if (timeout != 0L) {
            uid = this._uidFactory.createUIDFromCounter();
        }
        IResponseContext respContext = ResponseContext.getResponseContext();
        long startTime = SystemTime.timeMillis();
        ITemplateHolder tHolder = TemplateHolderFactory.createTemplateHolder(this.getTypeManager().getServerTypeDesc(IServerTypeDesc.ROOT_TYPE_NAME), new TemplatePacket(), null, Long.MAX_VALUE, txnEntry, startTime, 7, respContext, false, operationModifiers, false);
        tHolder.setAnswerHolder(new AnswerHolder());
        UpdateOrWriteMultipleContext opContext = new UpdateOrWriteMultipleContext(tHolder, entries, leases, operationModifiers, timeout, this, txnEntry);
        tHolder.setMultipleIdsContext(opContext);
        Context context = null;
        try {
            context = this._cacheManager.getCacheContext();
            if (this._isSyncReplication) {
                context.setSyncReplFromMultipleOperation(true);
            }
            context.setMultipleOperation();
            this.setFromGatewayIfNeeded(sc, context);
            if (txn == null && this._cacheManager.isBlobStoreCachePolicy() && timeout == 0L && this._cacheManager.useBlobStoreBulks() && (!anyFifoClass || !this._cacheManager.isDirectPersistencyEmbeddedtHandlerUsed())) {
                context.setBlobStoreBulkInfo(new BlobStoreBulkInfo(this._cacheManager, false));
            }
            Context entryContext = null;
            for (int i = 0; i < entries.length; ++i) {
                entryContext = timeout != 0L ? null : context;
                context.setWriteResult(null);
                try {
                    UpdateOrWriteContext ctx = new UpdateOrWriteContext(entries[i], leases[i], timeout, txn, sc, operationModifiers, !fromWriteMultiple, false, fromWriteMultiple, tHolder, i);
                    if (txnEntry != null && context.isFromGateway() && Modifiers.contains(operationModifiers, 524288)) {
                        txnEntry.setGatewayOverrideVersion(entries[i].getUID());
                    }
                    ctx.setCacheContext(entryContext);
                    this._spaceImpl.updateOrWrite(ctx, true);
                    continue;
                }
                catch (UnknownTypeException e) {
                    throw e;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    tHolder.getMultipleIdsContext().setAnswer(e, i);
                    continue;
                }
                catch (Throwable e) {
                    tHolder.getMultipleIdsContext().setAnswer(e, i);
                }
            }
        }
        finally {
            RuntimeException ex = null;
            try {
                if (context.isActiveBlobStoreBulk()) {
                    context.getBlobStoreBulkInfo().bulk_flush(context, false, true);
                }
            }
            catch (RuntimeException ex1) {
                ex = ex1;
            }
            int completedSyncReplication = this.replicateAndfreeCache(context);
            if (tHolder.getAnswerHolder().getUpdateMultipleResult() != null) {
                for (WriteEntryResult writeEntryResult : tHolder.getAnswerHolder().getUpdateMultipleResult().getResults()) {
                    if (writeEntryResult == null) continue;
                    writeEntryResult.setSyncReplicationLevel(completedSyncReplication);
                }
            }
            if (ex != null) {
                throw ex;
            }
        }
        boolean callBackMode = ResponseContext.isCallBackMode();
        if (!callBackMode && !tHolder.hasAnswer()) {
            this.waitForBlockingAnswer(timeout, tHolder.getAnswerHolder(), startTime, tHolder);
        }
        if (tHolder.hasAnswer()) {
            return tHolder.getAnswerHolder();
        }
        if (callBackMode) {
            this.prepareCallBackModeAnswer(tHolder, false);
            return tHolder.getAnswerHolder();
        }
        this.prepareBlockingModeAnswer(tHolder, false);
        return tHolder.getAnswerHolder();
    }

    protected void setFromGatewayIfNeeded(SpaceContext sc, Context context) {
        if (sc != null) {
            context.setFromGateway(sc.isFromGateway());
        }
    }

    private WriteEntriesResult writeEntryPackets(IEntryPacket[] entryPackets, WriteEntriesResult values, Context context, ServerTransaction transaction, long lease, long[] leases, int modifiers, SpaceContext sc, boolean reInsertedEntry, boolean fromWriteMultiple) throws RemoteException, TransactionException {
        for (int i = 0; i < entryPackets.length; ++i) {
            if (values.isError(i)) continue;
            try {
                long entryLease = leases != null ? leases[i] : lease;
                WriteEntryResult writeResult = this.write(context, entryPackets[i], (Transaction)transaction, entryLease, modifiers, false, true, sc, false, true);
                values.setResult(i, writeResult);
                continue;
            }
            catch (UnusableEntryException e) {
                values.setError(i, (Exception)((Object)e));
                continue;
            }
            catch (UnknownTypeException e) {
                values.setError(i, e);
                continue;
            }
            catch (EntryAlreadyInSpaceException e) {
                values.setError(i, e);
                continue;
            }
            catch (ProtectiveModeException e) {
                values.setError(i, e);
                continue;
            }
            catch (DuplicateIndexValueException e) {
                values.setError(i, e);
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnswerHolder readMultiple(ITemplatePacket template, Transaction txn, long timeout, boolean ifExists, boolean take, SpaceContext sc, boolean returnOnlyUid, int operationModifiers, BatchQueryOperationContext batchOperationContext, List<SpaceEntriesAggregator> aggregators) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        int numOfEntriesMatched;
        boolean isFifoOperation;
        this.monitorMemoryUsage(false);
        if (Modifiers.contains(operationModifiers, 0x10000000)) {
            SingleExplainPlan.validate(timeout, this._cacheManager.isBlobStoreCachePolicy(), operationModifiers, template.getCustomQuery(), this.getClassTypeInfo(template.getTypeName()).getIndexes());
        }
        if (take) {
            this.monitorReplicationStateForModifyingOperation(txn, OperationWeightInfoFactory.create(WeightInfoOperationType.TAKE));
        }
        if (take && TakeModifiers.isEvictOnly(operationModifiers)) {
            if (this._cacheManager.isResidentEntriesCachePolicy()) {
                throw new IllegalArgumentException("EVICT modifier is not supported in non-evictable cache policy.");
            }
            txn = null;
            timeout = 0L;
        }
        if (batchOperationContext.getMaxEntries() <= 0) {
            throw new IllegalArgumentException("Max entries value should be greater then zero.");
        }
        if (batchOperationContext.getMinEntries() < 0 || batchOperationContext.getMinEntries() > batchOperationContext.getMaxEntries()) {
            throw new IllegalArgumentException("Min entries value should  not  be less then zero or greater than maxEntries.");
        }
        IServerTypeDesc typeDesc = this._typeManager.loadServerTypeDesc(template);
        boolean bl = isFifoOperation = template.isFifo() || ReadModifiers.isFifo(operationModifiers);
        if (isFifoOperation && !typeDesc.isFifoSupported()) {
            throw new InvalidFifoTemplateException(template.getTypeName());
        }
        if ((template.getUID() != null || template.getMultipleUIDs() != null || template.getID() != null && template.getExtendedMatchCodes() == null) && ReadModifiers.isFifoGroupingPoll(operationModifiers)) {
            operationModifiers = Modifiers.remove(operationModifiers, 0x100000);
        }
        if (ReadModifiers.isFifoGroupingPoll(operationModifiers) && !this._cacheManager.isMemorySpace() && this._cacheManager.isEvictableCachePolicy()) {
            throw new UnsupportedOperationException(" fifo grouping not supported with persistent-LRU");
        }
        if (isFifoOperation && (template.getUID() != null || ReadModifiers.isFifoGroupingPoll(operationModifiers)) || template.getMultipleUIDs() != null) {
            isFifoOperation = false;
        }
        if (timeout != 0L && ReadModifiers.isFifoGroupingPoll(operationModifiers)) {
            timeout = 0L;
        }
        XtnEntry txnEntry = this.initTransactionEntry(txn, sc, false);
        String uid = null;
        if (timeout != 0L) {
            uid = this._uidFactory.createUIDFromCounter();
        }
        IResponseContext respContext = ResponseContext.getResponseContext();
        int templateOperation = ifExists ? (take ? 5 : 3) : (take ? 4 : 2);
        long startTime = SystemTime.timeMillis();
        ITemplateHolder tHolder = TemplateHolderFactory.createTemplateHolder(typeDesc, template, uid, LeaseManager.toAbsoluteTime(timeout, startTime), txnEntry, startTime, templateOperation, respContext, returnOnlyUid, operationModifiers, isFifoOperation);
        tHolder.setAnswerHolder(new AnswerHolder());
        tHolder.setNonBlockingRead(this.isNonBlockingReadForOperation(tHolder));
        tHolder.setID(template.getID());
        tHolder.setBatchOperationContext(batchOperationContext);
        if (aggregators != null) {
            tHolder.setAggregatorContext(new EntryHolderAggregatorContext(aggregators, tHolder, this.getPartitionIdZeroBased()));
        }
        if (take) {
            if (this._filterManager._isFilter[13] && !tHolder.isInitiatedEvictionOperation()) {
                this._filterManager.invokeFilters(13, sc, tHolder);
            }
            if (!tHolder.isInitiatedEvictionOperation()) {
                tHolder.setForAfterOperationFilter(14, sc, this._filterManager, null);
            }
        } else {
            if (this._filterManager._isFilter[11]) {
                this._filterManager.invokeFilters(11, sc, tHolder);
            }
            tHolder.setForAfterOperationFilter(12, sc, this._filterManager, null);
        }
        Context context = null;
        boolean answerSetByThisThread = false;
        try {
            context = this._cacheManager.getCacheContext();
            context.setMainThread(true);
            context.setOperationID(template.getOperationID());
            this.setFromGatewayIfNeeded(sc, context);
            if (take && txn == null && this._cacheManager.isBlobStoreCachePolicy() && this._cacheManager.useBlobStoreBulks()) {
                context.setBlobStoreBulkInfo(new BlobStoreBulkInfo(this._cacheManager, true));
            }
            if (ifExists) {
                this._coreProcessor.handleDirectMultipleReadIEOrTakeIESA(context, tHolder);
            } else {
                this._coreProcessor.handleDirectMultipleReadTakeSA(context, tHolder);
            }
            answerSetByThisThread = context.isOpResultByThread();
            numOfEntriesMatched = context.getNumberOfEntriesMatched();
            if (take && context.getReplicationContext() != null) {
                tHolder.getAnswerHolder().setSyncRelplicationLevel(context.getReplicationContext().getCompleted());
            }
        }
        finally {
            context = this._cacheManager.freeCacheContext(context);
        }
        boolean callBackMode = ResponseContext.isCallBackMode();
        if (!(callBackMode || answerSetByThisThread || tHolder.hasAnswer())) {
            this.waitForBlockingAnswer(timeout, tHolder.getAnswerHolder(), startTime, tHolder);
        }
        if (answerSetByThisThread) {
            tHolder.getAnswerHolder().setNumOfEntriesMatched(numOfEntriesMatched);
            return tHolder.getAnswerHolder();
        }
        if (callBackMode) {
            if (this.prepareCallBackModeAnswer(tHolder, true) == null) {
                return null;
            }
        } else {
            this.prepareBlockingModeAnswer(tHolder, true);
        }
        return tHolder.getAnswerHolder();
    }

    protected void attachFromGatewayStateToTransactionIfNeeded(SpaceContext sc, XtnEntry txnEntry) {
        if (sc != null && sc.isFromGateway()) {
            txnEntry.setFromGateway();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, SingleExplainPlan> count(ITemplatePacket template, Transaction txn, SpaceContext sc, int operationModifiers) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException {
        this.monitorMemoryUsage(false);
        if (Modifiers.contains(operationModifiers, 0x10000000)) {
            SingleExplainPlan.validate(0L, this._cacheManager.isBlobStoreCachePolicy(), operationModifiers, template.getCustomQuery(), this.getClassTypeInfo(template.getTypeName()).getIndexes());
        }
        IServerTypeDesc typeDesc = this._typeManager.loadServerTypeDesc(template);
        XtnEntry txnEntry = null;
        if (txn != null) {
            txnEntry = this.attachToXtn((ServerTransaction)txn, false);
        }
        String uid = this._uidFactory.createUIDFromCounter();
        long timeMillis = SystemTime.timeMillis();
        ITemplateHolder tHolder = TemplateHolderFactory.createTemplateHolder(typeDesc, template, uid, LeaseManager.toAbsoluteTime(0L, timeMillis), txnEntry, timeMillis, 2, null, false, operationModifiers, false);
        if (this._filterManager._isFilter[2]) {
            this._filterManager.invokeFilters(2, sc, tHolder);
        }
        Integer counter = 0;
        Context context = null;
        try {
            context = this._cacheManager.getCacheContext();
            context.setOperationID(template.getOperationID());
            counter = this._cacheManager.count(context, tHolder, txnEntry);
        }
        catch (SAException ex) {
            JSpaceUtilities.throwEngineInternalSpaceException(ex.getMessage(), ex);
        }
        finally {
            if (txnEntry != null) {
                txnEntry.decrementUsed();
            }
            this._cacheManager.freeCacheContext(context);
        }
        if (tHolder instanceof TemplateHolder && ((TemplateHolder)tHolder).getExplainPlan() != null) {
            return new Pair<Integer, SingleExplainPlan>(counter, ((TemplateHolder)tHolder).getExplainPlan());
        }
        return new Pair<Integer, Object>(counter, null);
    }

    public Pair<Integer, SingleExplainPlan> clear(ITemplatePacket template, Transaction txn, SpaceContext sc, int operationModifiers) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException {
        if (Modifiers.contains(operationModifiers, 0x10000000)) {
            throw new UnsupportedOperationException("Sql explain plan is not supported for clear operation");
        }
        if (template.getTypeName() != null) {
            this._typeManager.loadServerTypeDesc(template);
        }
        int res = 0;
        AnswerHolder ah = null;
        if (template.isIdQuery()) {
            try {
                ah = this.read(template, txn, 0L, false, true, sc, false, false, true, operationModifiers);
                AnswerPacket ap = ah.getAnswerPacket();
                res = ap.m_EntryPacket != null ? 1 : 0;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else if (template.isIdsQuery()) {
            try {
                ReadByIdsContext readByIdsContext = new ReadByIdsContext(template, false);
                this.readByIds((AbstractIdsQueryPacket)template, txn, true, sc, operationModifiers, readByIdsContext);
                res = readByIdsContext.getSuccessCount();
            }
            catch (InterruptedException readByIdsContext) {}
        } else {
            ClearContext batchOperationContext = new ClearContext(template, Integer.MAX_VALUE, this._filterManager);
            try {
                ah = this.readMultiple(template, txn, 0L, false, true, sc, false, operationModifiers, batchOperationContext, null);
                if (ah.getException() != null) {
                    Exception retex = ah.getException();
                    if (retex instanceof RuntimeException) {
                        throw (RuntimeException)retex;
                    }
                    if (retex instanceof TransactionException) {
                        throw (TransactionException)((Object)retex);
                    }
                    if (retex instanceof UnusableEntryException) {
                        throw (UnusableEntryException)((Object)retex);
                    }
                    if (retex instanceof UnknownTypeException) {
                        throw (UnknownTypeException)retex;
                    }
                    if (retex instanceof RemoteException) {
                        throw (RemoteException)retex;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            res = batchOperationContext.getNumResults();
        }
        if (ah != null) {
            return new Pair<Integer, SingleExplainPlan>(res, ah.getExplainPlan());
        }
        return new Pair<Integer, Object>(res, null);
    }

    public ExtendedAnswerHolder update(IEntryPacket updated_entry, Transaction txn, long lease, long timeout, SpaceContext sc, boolean fromReplication, boolean origin, boolean newRouter, int modifiers) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException, InterruptedException {
        if (Modifiers.contains(modifiers, 0x10000000)) {
            throw new UnsupportedOperationException("Sql explain plan is not supported for update operation");
        }
        return this.update(updated_entry, txn, lease, timeout, sc, fromReplication, origin, newRouter, modifiers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedAnswerHolder update(IEntryPacket updated_entry, Transaction txn, long lease, long timeout, SpaceContext sc, boolean fromReplication, boolean origin, boolean newRouter, int modifiers, MultipleIdsContext multipleIdsContext) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException, InterruptedException {
        this.monitorMemoryUsage(true);
        this.monitorReplicationStateForModifyingOperation(txn, OperationWeightInfoFactory.create(1, WeightInfoOperationType.UPDATE));
        Context context = fromReplication && this.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper() != null ? this.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper().getContext() : null;
        boolean suppliedContext = context != null;
        try {
            if (!suppliedContext) {
                context = this._cacheManager.getCacheContext();
            }
            context.setFromReplication(fromReplication);
            context.setOrigin(origin);
            ExtendedAnswerHolder extendedAnswerHolder = this.update(context, updated_entry, txn, lease, timeout, sc, fromReplication, newRouter, modifiers, null, multipleIdsContext);
            return extendedAnswerHolder;
        }
        finally {
            if (!suppliedContext) {
                this._cacheManager.freeCacheContext(context);
            }
        }
    }

    public ExtendedAnswerHolder updateOrWrite(UpdateOrWriteContext ctx, boolean newRouter) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        return this.updateOrWrite(ctx, false, true, newRouter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtendedAnswerHolder updateOrWrite(UpdateOrWriteContext ctx, boolean fromReplication, boolean origin, boolean newRouter) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        boolean discardWriteResult = !ctx.fromWriteMultiple && (ctx.fromUpdateMultiple || ctx.isNoWriteLease());
        int versionID = ctx.packet.getVersion();
        while (true) {
            try {
                WriteEntryResult writeResult;
                block22: {
                    boolean blobstoreReplicationBackupBulks;
                    boolean inBlobStoreNewRecovery;
                    boolean bl = inBlobStoreNewRecovery = fromReplication && this.getReplicationNode().getDirectPersistencyBackupSyncIteratorHandler() != null && this.getReplicationNode().getBlobStoreReplicaConsumeHelper() != null;
                    if (inBlobStoreNewRecovery && !ctx.fromUpdateMultiple && !ctx.fromWriteMultiple && ctx.getCacheContext() == null) {
                        ctx.setCacheContext(this.getReplicationNode().getBlobStoreReplicaConsumeHelper().getContext());
                        if (ctx.getCacheContext() == null) {
                            inBlobStoreNewRecovery = false;
                        }
                    }
                    boolean bl2 = blobstoreReplicationBackupBulks = fromReplication && this.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper() != null;
                    if (blobstoreReplicationBackupBulks && !inBlobStoreNewRecovery) {
                        ctx.setCacheContext(this.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper().getContext());
                        if (ctx.getCacheContext() == null) {
                            blobstoreReplicationBackupBulks = false;
                        }
                    }
                    if (ctx.fromUpdateMultiple || ctx.fromWriteMultiple || inBlobStoreNewRecovery || blobstoreReplicationBackupBulks) {
                        Context context = null;
                        try {
                            context = ctx.getCacheContext() != null ? ctx.getCacheContext() : this._cacheManager.getCacheContext();
                            context.setFromReplication(fromReplication);
                            context.setOrigin(origin);
                            context.setOrdinalForMultipleIdsOperation(ctx.getOrdinalInMultipleIdsContext());
                            if (ctx.isUpdateOperation) {
                                ctx.packet.setVersion(versionID);
                                ExtendedAnswerHolder extendedAnswerHolder = this.update(context, ctx.packet, ctx.tx, ctx.lease, ctx.timeout, ctx.sc, fromReplication, newRouter, ctx.operationModifiers, ctx, ctx.hasConcentratingTemplate() ? ctx.getConcentratingTemplate().getMultipleIdsContext() : null);
                                return extendedAnswerHolder;
                            }
                            writeResult = this.write(context, ctx.packet, ctx.tx, ctx.lease, ctx.operationModifiers, fromReplication, origin, ctx.sc, false, true);
                            if (ctx.hasConcentratingTemplate()) {
                                ITemplateHolder tHolder;
                                if (ctx.getConcentratingTemplate().getMultipleIdsContext().setAnswer(writeResult, ctx.getOrdinalInMultipleIdsContext()) && ctx.timeout != 0L) {
                                    tHolder = TemplateHolderFactory.createUpdateTemplateHolder(this._typeManager.loadServerTypeDesc(ctx.packet), ctx.packet, null, 0L, ctx.getConcentratingTemplate().getMultipleIdsContext().getXtnEntry(), 0L, null, ctx.operationModifiers);
                                    tHolder.setAnswerHolder(new ExtendedAnswerHolder());
                                    tHolder.setMultipleIdsContext(ctx.getConcentratingTemplate().getMultipleIdsContext());
                                    tHolder.setOrdinalForEntryByIdMultipleOperation(ctx.getOrdinalInMultipleIdsContext());
                                    tHolder.setUpdateOrWriteContext(ctx);
                                    context.setOperationAnswer(tHolder, null, null);
                                }
                                tHolder = null;
                                return tHolder;
                            }
                            break block22;
                        }
                        finally {
                            if (ctx.getCacheContext() == null) {
                                this._cacheManager.freeCacheContext(context);
                            }
                        }
                    }
                    if (ctx.isUpdateOperation) {
                        ctx.packet.setVersion(versionID);
                        return this.update(ctx.packet, ctx.tx, ctx.lease, ctx.timeout, ctx.sc, fromReplication, origin, newRouter, ctx.operationModifiers);
                    }
                    writeResult = this.write(ctx.packet, ctx.tx, ctx.lease, ctx.operationModifiers, fromReplication, origin, ctx.sc);
                }
                if (newRouter) {
                    ExtendedAnswerHolder aHolder = new ExtendedAnswerHolder();
                    aHolder.m_AnswerPacket = new AnswerPacket(writeResult);
                    return aHolder;
                }
                if (discardWriteResult) {
                    return null;
                }
                LeaseContext<?> lease = writeResult.createLease(ctx.packet.getTypeName(), this.getSpaceImpl(), this.isNoWriteLease(ctx.packet, ctx.operationModifiers, fromReplication));
                ExtendedAnswerHolder aHolder = new ExtendedAnswerHolder();
                aHolder.m_AnswerPacket = new AnswerPacket(lease);
                return aHolder;
            }
            catch (EntryNotInSpaceException enise) {
                if (enise.isDeletedByOwnTxn()) {
                    throw enise;
                }
                if (!this._isLocalCache && !Modifiers.contains(ctx.operationModifiers, 524288)) {
                    versionID = 0;
                }
                ctx.isUpdateOperation = false;
                continue;
            }
            catch (EntryAlreadyInSpaceException eais) {
                ctx.isUpdateOperation = true;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExtendedAnswerHolder update(Context context, IEntryPacket updated_entry, Transaction txn, long lease, long timeout, SpaceContext sc, boolean fromReplication, boolean newRouter, int modifiers, UpdateOrWriteContext ctx, MultipleIdsContext multipleIdsContext) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException, InterruptedException {
        IServerTypeDesc serverTypeDesc = this._typeManager.loadServerTypeDesc(updated_entry);
        if (updated_entry.getUID() == null) {
            throw new DetailedUnusableEntryException("Update operation requires non-null object UID. Object=" + updated_entry.toString());
        }
        if (this._isLocalCache && updated_entry.getVersion() <= 0) {
            throw new DetailedUnusableEntryException("Update operation requires object version greater than 0 when using local cache. Object=" + updated_entry.toString());
        }
        if (!fromReplication && this.isPartitionedSpace() && ProtectiveMode.isWrongRoutingUsageProtectionEnabled()) {
            if (updated_entry.getRoutingFieldValue() == null) {
                this.throwNoRoutingProvidedWhenNeeded(serverTypeDesc, "updating");
            } else {
                this.checkEntryRoutingValueMatchesCurrentPartition(updated_entry, serverTypeDesc, "updated");
            }
        }
        context.setOperationID(updated_entry.getOperationID());
        context.setWriteResult(null);
        XtnEntry txnEntry = multipleIdsContext != null ? multipleIdsContext.getXtnEntry() : this.initTransactionEntry(txn, sc, fromReplication);
        String uid = null;
        if (timeout != 0L) {
            uid = this._uidFactory.createUIDFromCounter();
        }
        if (fromReplication && timeout != 0L) {
            throw new RuntimeException("operation with timeout = NO_WAIT came from replication");
        }
        String entryId = updated_entry.getUID();
        long startTime = SystemTime.timeMillis();
        long expiration_time = lease != 0L ? LeaseManager.toAbsoluteTime(lease, startTime) : 0L;
        IEntryPacket template = updated_entry;
        IResponseContext respContext = ResponseContext.getResponseContext();
        if (respContext != null) {
            respContext.setInvokedFromNewRouter(newRouter);
        }
        ITemplateHolder tHolder = TemplateHolderFactory.createUpdateTemplateHolder(serverTypeDesc, template, uid, LeaseManager.toAbsoluteTime(timeout, startTime), txnEntry, startTime, respContext, modifiers);
        tHolder.setAnswerHolder(new ExtendedAnswerHolder());
        if (multipleIdsContext != null) {
            tHolder.setMultipleIdsContext(multipleIdsContext);
            tHolder.setOrdinalForEntryByIdMultipleOperation(context.getOrdinalForMultipleIdsOperation());
        }
        if (ctx != null) {
            tHolder.setUpdateOrWriteContext(ctx);
        }
        tHolder.setReRegisterLeaseOnUpdate(lease != 0L);
        context.setMainThread(true);
        context.setOpResultByThread(false);
        int versionID = this._isLocalCache || context.isFromReplication() ? tHolder.getEntryData().getVersion() : Math.max(tHolder.getEntryData().getVersion() + 1, 2);
        IEntryHolder updated_eh = EntryHolderFactory.createEntryHolder(serverTypeDesc, updated_entry, this._entryDataType, entryId, expiration_time, null, SystemTime.timeMillis(), versionID, true, this._cacheManager.isblobStoreDataSpace() && serverTypeDesc.getTypeDesc().isBlobstoreEnabled() && !UpdateModifiers.isUpdateOnly(modifiers));
        tHolder.setUpdatedEntry(updated_eh);
        if (this._filterManager._isFilter[9]) {
            this._filterManager.invokeFilters(9, sc, updated_eh);
        }
        tHolder.setForAfterOperationFilter(10, sc, this._filterManager, updated_entry);
        this._coreProcessor.handleDirectUpdateSA(context, tHolder);
        if (context.getReplicationContext() != null && tHolder.getAnswerHolder().getAnswerPacket().getWriteEntryResult() != null) {
            tHolder.getAnswerHolder().getAnswerPacket().getWriteEntryResult().setSyncReplicationLevel(context.getReplicationContext().getCompleted());
        }
        boolean answerSetByThisThread = context.isOpResultByThread();
        if (multipleIdsContext != null) {
            if (!answerSetByThisThread) return null;
            if (!tHolder.getMultipleIdsContext().isUpdateOrWriteMultiple()) return null;
            if (tHolder.getAnswerHolder().getException() == null) return null;
            if (tHolder.isInCache()) return null;
            if (!(tHolder.getAnswerHolder().getException() instanceof EntryNotInSpaceException)) return null;
            if (tHolder.getMultipleIdsContext().isAnswerSetForOrdinal(tHolder.getOrdinalForEntryByIdMultipleOperation())) return null;
            throw (EntryNotInSpaceException)((Object)tHolder.getAnswerHolder().getException());
        }
        boolean callBackMode = ResponseContext.isCallBackMode();
        if (!(callBackMode || answerSetByThisThread || tHolder.hasAnswer())) {
            this.waitForBlockingAnswer(timeout, tHolder.getAnswerHolder(), startTime, tHolder);
        }
        if (answerSetByThisThread) {
            tHolder.getAnswerHolder().throwExceptionIfExists();
            return (ExtendedAnswerHolder)tHolder.getAnswerHolder();
        }
        if (callBackMode) {
            ExtendedAnswerHolder extendedAnswerHolder;
            ILockObject templateLock = this.getTemplateLockObject(tHolder);
            try {
                ILockObject iLockObject = templateLock;
                synchronized (iLockObject) {
                    if (!tHolder.hasAnswer()) {
                        ResponseContext.dontSendResponse();
                        this.moveTemplateToSecondPhase(tHolder);
                        ExtendedAnswerHolder extendedAnswerHolder2 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 6, 29, 30] lbl69 : MonitorExitStatement: MONITOREXIT : var30_27
                        if (templateLock == null) return extendedAnswerHolder2;
                        this.freeTemplateLockObject(templateLock);
                        return extendedAnswerHolder2;
                    }
                }
            }
            catch (Throwable throwable) {
                if (templateLock == null) throw throwable;
                this.freeTemplateLockObject(templateLock);
                throw throwable;
            }
            {
                tHolder.getAnswerHolder().throwExceptionIfExists();
                extendedAnswerHolder = (ExtendedAnswerHolder)tHolder.getAnswerHolder();
            }
            if (templateLock == null) return extendedAnswerHolder;
            this.freeTemplateLockObject(templateLock);
            return extendedAnswerHolder;
        }
        ILockObject templateLock = this.getTemplateLockObject(tHolder);
        try {
            Object object = templateLock;
            synchronized (object) {
                if (!tHolder.hasAnswer()) {
                    tHolder.getAnswerHolder().m_AnswerPacket = new AnswerPacket((IEntryPacket)null);
                    if (!tHolder.isDeleted()) {
                        this._cacheManager.removeTemplate(context, tHolder, false, true, false);
                    }
                }
                tHolder.getAnswerHolder().throwExceptionIfExists();
            }
            object = (ExtendedAnswerHolder)tHolder.getAnswerHolder();
            return object;
        }
        finally {
            if (templateLock != null) {
                this.freeTemplateLockObject(templateLock);
            }
        }
    }

    private XtnEntry initTransactionEntry(Transaction txn, SpaceContext sc, boolean fromReplication) throws TransactionException, RemoteException {
        if (txn == null) {
            return null;
        }
        XtnEntry txnEntry = this.attachToXtn((ServerTransaction)txn, fromReplication);
        txnEntry.setFromReplication(fromReplication);
        this.attachFromGatewayStateToTransactionIfNeeded(sc, txnEntry);
        return txnEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedAnswerHolder change(ITemplatePacket template, Transaction txn, long lease, long timeout, SpaceContext sc, boolean fromReplication, boolean origin, Collection<SpaceEntryMutator> mutators, int operationModifiers, boolean returnOnlyUid) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException, InterruptedException {
        int numOfEntriesMatched;
        boolean isFifoOperation;
        boolean byId;
        this.monitorMemoryUsage(true);
        if (Modifiers.contains(operationModifiers, 0x10000000)) {
            throw new UnsupportedOperationException("Sql explain plan is not supported for change operation");
        }
        if (!fromReplication && txn != null && !this.isLocalCache()) {
            this.getTransactionHandler().checkTransactionDisconnection(template.getOperationID(), (ServerTransaction)txn);
        }
        this.monitorReplicationStateForModifyingOperation(txn, OperationWeightInfoFactory.create(WeightInfoOperationType.CHANGE));
        IServerTypeDesc typeDesc = this._typeManager.loadServerTypeDesc(template);
        boolean bl = byId = template.getUID() != null || template.getID() != null && template.getExtendedMatchCodes() == null && template.getCustomQuery() == null;
        if (!byId) {
            return this.changeMultiple(template, txn, lease, timeout, sc, fromReplication, origin, mutators, operationModifiers, returnOnlyUid, typeDesc);
        }
        boolean bl2 = isFifoOperation = template.isFifo() || ReadModifiers.isFifo(operationModifiers);
        if (isFifoOperation && !typeDesc.isFifoSupported()) {
            throw new InvalidFifoTemplateException(template.getTypeName());
        }
        if (isFifoOperation && template.getID() != null) {
            isFifoOperation = false;
        }
        XtnEntry txnEntry = this.initTransactionEntry(txn, sc, fromReplication);
        String uid = null;
        if (timeout != 0L) {
            uid = this._uidFactory.createUIDFromCounter();
        }
        if (fromReplication && timeout != 0L) {
            throw new RuntimeException("operation with timeout not= NO_WAIT came from replication");
        }
        long startTime = SystemTime.timeMillis();
        IResponseContext respContext = ResponseContext.getResponseContext();
        ITemplateHolder tHolder = TemplateHolderFactory.createTemplateHolder(typeDesc, template, uid, LeaseManager.toAbsoluteTime(timeout, startTime), txnEntry, startTime, 7, respContext, returnOnlyUid, operationModifiers, isFifoOperation, fromReplication);
        tHolder.setAnswerHolder(new ExtendedAnswerHolder());
        tHolder.setID(template.getID());
        tHolder.setMutators(mutators);
        long expiration_time = lease != 0L ? LeaseManager.toAbsoluteTime(lease, startTime) : 0L;
        tHolder.setChangeExpiration(expiration_time);
        if (this._filterManager._isFilter[24]) {
            this._filterManager.invokeFilters(24, sc, tHolder);
        }
        tHolder.setForAfterOperationFilter(25, sc, this._filterManager, null);
        boolean answerSetByThisThread = false;
        Context context = fromReplication && this.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper() != null ? this.getReplicationNode().getBlobStoreReplicationBulkConsumeHelper().getContext() : null;
        boolean suppliedContext = context != null;
        try {
            if (!suppliedContext) {
                context = this._cacheManager.getCacheContext();
            }
            context.setMainThread(true);
            context.setOperationID(template.getOperationID());
            tHolder.setReRegisterLeaseOnUpdate(lease != 0L);
            this.setFromGatewayIfNeeded(sc, context);
            this._coreProcessor.handleDirectChangeSA(context, tHolder, fromReplication, origin);
            answerSetByThisThread = context.isOpResultByThread();
            numOfEntriesMatched = context.getNumberOfEntriesMatched();
        }
        finally {
            if (!suppliedContext) {
                this._cacheManager.freeCacheContext(context);
            }
        }
        boolean callBackMode = ResponseContext.isCallBackMode();
        if (!(callBackMode || answerSetByThisThread || tHolder.hasAnswer())) {
            this.waitForBlockingAnswer(timeout, tHolder.getAnswerHolder(), startTime, tHolder);
        }
        if (answerSetByThisThread) {
            tHolder.getAnswerHolder().setNumOfEntriesMatched(numOfEntriesMatched);
            return (ExtendedAnswerHolder)tHolder.getAnswerHolder();
        }
        if (callBackMode) {
            this.prepareCallBackModeAnswer(tHolder, false);
            return (ExtendedAnswerHolder)tHolder.getAnswerHolder();
        }
        this.prepareBlockingModeAnswer(tHolder, false);
        return (ExtendedAnswerHolder)tHolder.getAnswerHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedAnswerHolder changeMultiple(ITemplatePacket template, Transaction txn, long lease, long timeout, SpaceContext sc, boolean fromReplication, boolean origin, Collection<SpaceEntryMutator> mutators, int operationModifiers, boolean returnOnlyUid, IServerTypeDesc typeDesc) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException, InterruptedException {
        int numOfEntriesMatched;
        boolean isFifoOperation;
        if (Modifiers.contains(operationModifiers, 0x10000000)) {
            throw new UnsupportedOperationException("Sql explain plan is not supported for clear operation");
        }
        boolean bl = isFifoOperation = template.isFifo() || ReadModifiers.isFifo(operationModifiers);
        if (isFifoOperation && !typeDesc.isFifoSupported()) {
            throw new InvalidFifoTemplateException(template.getTypeName());
        }
        if (isFifoOperation && template.getID() != null) {
            isFifoOperation = false;
        }
        XtnEntry txnEntry = this.initTransactionEntry(txn, sc, fromReplication);
        String uid = null;
        if (timeout != 0L) {
            uid = this._uidFactory.createUIDFromCounter();
        }
        if (fromReplication && timeout != 0L) {
            throw new RuntimeException("operation with timeout not= NO_WAIT came from replication");
        }
        long startTime = SystemTime.timeMillis();
        IResponseContext respContext = ResponseContext.getResponseContext();
        ITemplateHolder tHolder = TemplateHolderFactory.createTemplateHolder(typeDesc, template, uid, LeaseManager.toAbsoluteTime(timeout, startTime), txnEntry, startTime, 7, respContext, returnOnlyUid, operationModifiers, isFifoOperation, fromReplication);
        tHolder.setAnswerHolder(new ExtendedAnswerHolder());
        tHolder.setID(template.getID());
        tHolder.setMutators(mutators);
        long expiration_time = lease != 0L ? LeaseManager.toAbsoluteTime(lease, startTime) : 0L;
        tHolder.setChangeExpiration(expiration_time);
        ChangeMultipleContext opContext = new ChangeMultipleContext(template, Integer.MAX_VALUE, Integer.MAX_VALUE);
        tHolder.setBatchOperationContext(opContext);
        if (this._filterManager._isFilter[24]) {
            this._filterManager.invokeFilters(24, sc, tHolder);
        }
        tHolder.setForAfterOperationFilter(25, sc, this._filterManager, null);
        Context context = null;
        boolean answerSetByThisThread = false;
        try {
            context = this._cacheManager.getCacheContext();
            context.setMainThread(true);
            context.setOperationID(template.getOperationID());
            tHolder.setReRegisterLeaseOnUpdate(lease != 0L);
            this.setFromGatewayIfNeeded(sc, context);
            if (txn == null && this._cacheManager.isBlobStoreCachePolicy() && this._cacheManager.useBlobStoreBulks()) {
                context.setBlobStoreBulkInfo(new BlobStoreBulkInfo(this._cacheManager, false));
            }
            this._coreProcessor.handleDirectMultipleChangeSA(context, tHolder);
            answerSetByThisThread = context.isOpResultByThread();
            numOfEntriesMatched = context.getNumberOfEntriesMatched();
        }
        finally {
            context = this._cacheManager.freeCacheContext(context);
        }
        boolean callBackMode = ResponseContext.isCallBackMode();
        if (!(callBackMode || answerSetByThisThread || tHolder.hasAnswer())) {
            this.waitForBlockingAnswer(timeout, tHolder.getAnswerHolder(), startTime, tHolder);
        }
        if (answerSetByThisThread) {
            tHolder.getAnswerHolder().setNumOfEntriesMatched(numOfEntriesMatched);
            return (ExtendedAnswerHolder)tHolder.getAnswerHolder();
        }
        if (callBackMode) {
            this.prepareCallBackModeAnswer(tHolder, false);
            return (ExtendedAnswerHolder)tHolder.getAnswerHolder();
        }
        this.prepareBlockingModeAnswer(tHolder, false);
        return (ExtendedAnswerHolder)tHolder.getAnswerHolder();
    }

    private void throwNoRoutingProvidedWhenNeeded(IServerTypeDesc typeDesc, String operation) throws ProtectiveModeException {
        throw new ProtectiveModeException("Operation is rejected - no routing value provided when " + operation + " an entry of type '" + typeDesc.getTypeName() + "' in a partitioned space. A routing value should be specified within the entry's property named '" + typeDesc.getTypeDesc().getRoutingPropertyName() + "'. Missing a routing value would result in a remote client not being able to locate this entry as the routing value will not match the partition the entry is located. (you can disable this protection, though it is not recommended, by setting the following system property: " + "com.gs.protectiveMode.wrongEntryRoutingUsage" + "=false)");
    }

    private void checkEntryRoutingValueMatchesCurrentPartition(IEntryPacket updated_entry, IServerTypeDesc typeDesc, String operation) throws ProtectiveModeException {
        ProtectiveModeException exception = this.createExceptionIfRoutingValueDoesntMatchesCurrentPartition(updated_entry.getRoutingFieldValue(), typeDesc, operation);
        if (exception != null) {
            throw exception;
        }
    }

    private ProtectiveModeException createExceptionIfRoutingValueDoesntMatchesCurrentPartition(Object routingValue, IServerTypeDesc typeDesc, String operation) {
        int partitionIdZeroBased = PartitionedClusterUtils.getPartitionId(routingValue, this.getNumberOfPartitions());
        if (partitionIdZeroBased != this.getPartitionIdZeroBased()) {
            if (ProtectiveMode.shouldIgnoreWrongRoutingProtectiveMode(typeDesc.getTypeName())) {
                return null;
            }
            return new ProtectiveModeException("Operation is rejected - the routing value in the " + operation + " entry of type '" + typeDesc.getTypeName() + "' does not match this space partition id. The value within the entry's routing property named '" + typeDesc.getTypeDesc().getRoutingPropertyName() + "' is " + routingValue + " which matches partition id " + (partitionIdZeroBased + 1) + " while current partition id is " + this.getPartitionIdOneBased() + ". Having a mismatching routing value would result in a remote client not being able to locate this entry as the routing value will not match the partition the entry is located. (you can disable this protection, though it is not recommended, by setting the following system property: " + "com.gs.protectiveMode.wrongEntryRoutingUsage" + "=false)");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] updateMultiple(IEntryPacket[] entries, Transaction txn, long[] leases, SpaceContext sc, int operationModifiers, boolean newRouter) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException {
        this.monitorMemoryUsage(true);
        this.monitorReplicationStateForModifyingOperation(txn, OperationWeightInfoFactory.create(entries.length, WeightInfoOperationType.UPDATE));
        for (int i = 0; i < entries.length; ++i) {
            this._typeManager.loadServerTypeDesc(entries[i]);
        }
        XtnEntry txnEntry = null;
        if (txn != null) {
            txnEntry = this.attachToXtn((ServerTransaction)txn, false);
            this.attachFromGatewayStateToTransactionIfNeeded(sc, txnEntry);
        }
        Context context = null;
        try {
            Object[] objectArray;
            context = this._cacheManager.getCacheContext();
            if (this._isSyncReplication) {
                context.setSyncReplFromMultipleOperation(true);
            }
            context.setMultipleOperation();
            this.setFromGatewayIfNeeded(sc, context);
            if (txnEntry == null) {
                Object[] objectArray2 = this.updateMultipleLoop(context, entries, leases, null, sc, operationModifiers, newRouter);
                return objectArray2;
            }
            txnEntry.lock();
            try {
                if (!txnEntry.m_Active) {
                    throw new TransactionException("The transaction is not active: " + txnEntry.m_Transaction);
                }
                context.setTransactionalMultipleOperation(true);
                objectArray = this.updateMultipleLoop(context, entries, leases, txnEntry, sc, operationModifiers, newRouter);
            }
            catch (Throwable throwable) {
                txnEntry.unlock();
                throw throwable;
            }
            txnEntry.unlock();
            return objectArray;
        }
        finally {
            if (txnEntry != null) {
                txnEntry.decrementUsed(true);
            }
            this.replicateAndfreeCache(context);
        }
    }

    private Object[] updateMultipleLoop(Context context, IEntryPacket[] entries, long[] leases, XtnEntry xtnEntry, SpaceContext sc, int operationModifiers, boolean newRouter) {
        ServerTransaction st = xtnEntry != null ? xtnEntry.m_Transaction : null;
        Object[] answer = new Object[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            try {
                if (xtnEntry != null && context.isFromGateway() && Modifiers.contains(operationModifiers, 524288)) {
                    xtnEntry.setGatewayOverrideVersion(entries[i].getUID());
                }
                AnswerPacket ap = this.update((Context)context, (IEntryPacket)entries[i], (Transaction)st, (long)leases[i], (long)0L, (SpaceContext)sc, (boolean)false, (boolean)newRouter, (int)operationModifiers, null, null).m_AnswerPacket;
                answer[i] = newRouter ? ap.getWriteEntryResult() : ap.m_EntryPacket;
                this.performReplIfChunkReached(context);
                continue;
            }
            catch (Exception ex) {
                answer[i] = ex;
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnswerHolder newUpdateMultiple(IEntryPacket[] entries, Transaction txn, long[] leases, SpaceContext sc, long timeout, int operationModifiers) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException, InterruptedException {
        int replicationLevel = 0;
        try {
            ITemplateHolder tHolder;
            long startTime;
            block21: {
                for (int i = 0; i < entries.length; ++i) {
                    this._typeManager.loadServerTypeDesc(entries[i]);
                }
                XtnEntry txnEntry = null;
                if (txn != null) {
                    txnEntry = this.attachToXtn((ServerTransaction)txn, false);
                    this.attachFromGatewayStateToTransactionIfNeeded(sc, txnEntry);
                }
                String uid = null;
                if (timeout != 0L) {
                    uid = this._uidFactory.createUIDFromCounter();
                }
                IResponseContext respContext = ResponseContext.getResponseContext();
                startTime = SystemTime.timeMillis();
                tHolder = TemplateHolderFactory.createTemplateHolder(this.getTypeManager().getServerTypeDesc(IServerTypeDesc.ROOT_TYPE_NAME), new TemplatePacket(), null, Long.MAX_VALUE, txnEntry, startTime, 7, respContext, false, operationModifiers, false);
                tHolder.setAnswerHolder(new AnswerHolder());
                UpdateMultipleContext multipleIdsContext = new UpdateMultipleContext(tHolder, entries, leases, operationModifiers, timeout, this, txnEntry);
                tHolder.setMultipleIdsContext(multipleIdsContext);
                Context context = null;
                try {
                    context = this._cacheManager.getCacheContext();
                    if (this._isSyncReplication) {
                        context.setSyncReplFromMultipleOperation(true);
                    }
                    context.setMultipleOperation();
                    context.setMainThread(true);
                    this.setFromGatewayIfNeeded(sc, context);
                    if (txnEntry == null) {
                        if (this._cacheManager.isBlobStoreCachePolicy() && this._cacheManager.useBlobStoreBulks() && timeout == 0L) {
                            context.setBlobStoreBulkInfo(new BlobStoreBulkInfo(this._cacheManager, false));
                        }
                        this.newUpdateMultipleLoop(context, tHolder, entries, leases, null, sc, operationModifiers, timeout);
                        break block21;
                    }
                    txnEntry.lock();
                    try {
                        if (!txnEntry.m_Active) {
                            throw new TransactionException("The transaction is not active: " + txnEntry.m_Transaction);
                        }
                        context.setTransactionalMultipleOperation(true);
                        this.newUpdateMultipleLoop(context, tHolder, entries, leases, txnEntry, sc, operationModifiers, timeout);
                    }
                    finally {
                        txnEntry.unlock();
                    }
                }
                finally {
                    replicationLevel = this.replicateAndfreeCache(context);
                }
            }
            boolean callBackMode = ResponseContext.isCallBackMode();
            if (!callBackMode && !tHolder.hasAnswer()) {
                this.waitForBlockingAnswer(timeout, tHolder.getAnswerHolder(), startTime, tHolder);
            }
            if (tHolder.hasAnswer()) {
                AnswerHolder answerHolder = tHolder.getAnswerHolder();
                return answerHolder;
            }
            if (callBackMode) {
                this.prepareCallBackModeAnswer(tHolder, false);
                AnswerHolder answerHolder = tHolder.getAnswerHolder();
                return answerHolder;
            }
            this.prepareBlockingModeAnswer(tHolder, false);
            AnswerHolder answerHolder = tHolder.getAnswerHolder();
            return answerHolder;
        }
        finally {
            this.checkIfConsistencyLevelIsCompromised(false, replicationLevel);
        }
    }

    private void newUpdateMultipleLoop(Context context, ITemplateHolder concentratingTemplate, IEntryPacket[] entries, long[] leases, XtnEntry xtnEntry, SpaceContext sc, int operationModifiers, long timeout) {
        ServerTransaction st = xtnEntry != null ? xtnEntry.m_Transaction : null;
        for (int i = 0; i < entries.length; ++i) {
            try {
                if (xtnEntry != null && context.isFromGateway() && Modifiers.contains(operationModifiers, 524288)) {
                    xtnEntry.setGatewayOverrideVersion(entries[i].getUID());
                }
                context.setOrdinalForMultipleIdsOperation(i);
                this.update(context, entries[i], (Transaction)st, leases[i], timeout, sc, false, true, operationModifiers, null, concentratingTemplate.getMultipleIdsContext());
                this.performReplIfChunkReached(context);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                concentratingTemplate.getMultipleIdsContext().setAnswer(e, i);
                continue;
            }
            catch (Exception ex) {
                concentratingTemplate.getMultipleIdsContext().setAnswer(ex, i);
            }
        }
    }

    public SpaceRuntimeInfo getRuntimeInfo() {
        return this.getRuntimeInfo(IServerTypeDesc.ROOT_TYPE_NAME);
    }

    public SpaceRuntimeInfo getRuntimeInfo(String typeName) {
        this.monitorMemoryUsage(false);
        return this._cacheManager.getRuntimeInfo(typeName);
    }

    public String createUIDFromCounter() {
        return this._uidFactory.createUIDFromCounter();
    }

    public synchronized void dropClass(String className) throws DropClassException {
        this._typeManager.dropClass(className);
    }

    /*
     * Exception decompiling
     */
    public int prepare(TransactionManager mgr, ServerTransaction st, boolean singleParticipant, boolean supportsTwoPhaseReplication, OperationID operationID) throws UnknownTransactionException, RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 22[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OperationWeightInfo createOperationWeightInfo(XtnEntry xtnEntry) {
        XtnData xtnData = xtnEntry.getXtnData();
        IStoredList<IEntryCacheInfo> lockedEntries = xtnData.getLockedEntries();
        int numOfLocked = 0;
        if (lockedEntries != null) {
            numOfLocked += xtnData.getNewEntries() != null ? xtnData.getNewEntries().size() : 0;
            numOfLocked += xtnData.getUpdatedEntries() != null ? xtnData.getUpdatedEntries().size() : 0;
            numOfLocked += xtnData.getTakenEntries() != null ? xtnData.getTakenEntries().size() : 0;
        }
        return OperationWeightInfoFactory.create(numOfLocked, WeightInfoOperationType.PREPARE);
    }

    protected void handleExceptionOnPrepare(TransactionManager mgr, ServerTransaction st, boolean supportsTwoPhaseReplication, XtnEntry xtnEntry) throws RemoteException {
        block4: {
            if (this._spaceImpl.isAborted()) {
                throw new RemoteException("Can not prepare transaction - space is aborting");
            }
            if (xtnEntry != null) {
                xtnEntry.setStatus(XtnStatus.ERROR);
            }
            try {
                this.abort(mgr, st, supportsTwoPhaseReplication, null);
            }
            catch (Exception ei) {
                if (!this._logger.isLoggable(Level.WARNING)) break block4;
                this._logger.log(Level.WARNING, "Exception occurred while aborting a transaction [" + st + "] which failed prepare process", ei);
            }
        }
    }

    public int prepareAndCommit(TransactionManager mgr, ServerTransaction st, OperationID operationID) throws UnknownTransactionException, RemoteException {
        int result;
        if (this._operationLogger.isLoggable(Level.FINEST)) {
            this._operationLogger.finest("preparing and committing transaction [" + this.createTransactionDetailsString(st, operationID) + "]");
        }
        if (this.isExecutedAlready(operationID)) {
            this.handleDuplicateCommitOperation(st, operationID);
            result = 5;
        } else {
            result = this.prepare(mgr, st, true, false, operationID);
            if (result == 3) {
                this.commitSA(mgr, st, false, null, true);
                result = 5;
            }
        }
        if (this._operationLogger.isLoggable(Level.FINEST)) {
            this._operationLogger.finest("prepared and committed transaction [" + this.createTransactionDetailsString(st, operationID) + "] result=" + result);
        }
        return result;
    }

    public void commit(TransactionManager mgr, ServerTransaction st, boolean supportsTwoPhaseReplication, OperationID operationID, boolean mayBeFromReplication) throws UnknownTransactionException, RemoteException {
        if (this._operationLogger.isLoggable(Level.FINEST)) {
            this._operationLogger.finest("committing transaction [" + this.createTransactionDetailsString(st, operationID) + "]");
        }
        if (this.isExecutedAlready(operationID)) {
            this.handleDuplicateCommitOperation(st, operationID);
            return;
        }
        this.monitorMemoryUsage(false);
        this.commitSA(mgr, st, supportsTwoPhaseReplication, operationID, mayBeFromReplication);
        if (this._operationLogger.isLoggable(Level.FINEST)) {
            this._operationLogger.finest("committed transaction [" + this.createTransactionDetailsString(st, operationID) + "]");
        }
    }

    public String createTransactionDetailsString(ServerTransaction st, OperationID operationID) {
        String details = st + ", OperationID=" + operationID;
        return details;
    }

    private void handleDuplicateCommitOperation(ServerTransaction st, OperationID operationID) {
        if (this._operationLogger.isLoggable(Level.FINER)) {
            this._operationLogger.finer("encountered duplicate transaction commit which may occur after failover, ignoring the operation is it is already applied to space [" + this.createTransactionDetailsString(st, operationID) + "]");
        }
    }

    public void abort(TransactionManager mgr, ServerTransaction st, boolean supportsTwoPhaseReplication, OperationID operationID) throws UnknownTransactionException {
        if (this._operationLogger.isLoggable(Level.FINEST)) {
            this._operationLogger.finest("aborting transaction [" + this.createTransactionDetailsString(st, operationID) + "]");
        }
        if (this.isExecutedAlready(operationID)) {
            this.handleDuplicateAbortOperation(st, operationID);
            return;
        }
        this.monitorMemoryUsage(false);
        this.abortSA(mgr, st, false, false, supportsTwoPhaseReplication, operationID);
        if (this._operationLogger.isLoggable(Level.FINEST)) {
            this._operationLogger.finest("aborted transaction [" + this.createTransactionDetailsString(st, operationID) + "]");
        }
    }

    private void handleDuplicateAbortOperation(ServerTransaction st, OperationID operationID) {
        if (this._operationLogger.isLoggable(Level.FINER)) {
            this._operationLogger.finer("encountered duplicate transaction abort which may occur after failover, ignoring the operation is it is already applied to space [" + this.createTransactionDetailsString(st, operationID) + "]");
        }
    }

    public List<TemplateInfo> getTemplatesInfo(String className) {
        this.monitorMemoryUsage(false);
        return this._cacheManager.getTemplatesInfo(className);
    }

    public TransactionInfo[] getTransactionsInfo(int type, int status) throws RemoteException {
        ArrayList<TransactionInfo> result = new ArrayList<TransactionInfo>();
        this.getTransactionsInfo(type, status, result);
        return result.toArray(new TransactionInfo[result.size()]);
    }

    public int countTransactions(int type, int status) throws RemoteException {
        return this.getTransactionsInfo(type, status, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTransactionsInfo(int type, int status, List<TransactionInfo> result) throws RemoteException {
        int count = 0;
        for (XtnEntry xtnInfo : this.getTransactionHandler().getXtnTable().values()) {
            xtnInfo.lock();
            try {
                Long savedLease;
                int txnType = SpaceEngine.getXtnInfoType(xtnInfo);
                if (txnType != type && type != 0 || status != 4 && status != SpaceEngine.getXtnInfoStatus(xtnInfo)) continue;
                ++count;
                if (result == null) continue;
                long lease = -1L;
                if ((txnType == 1 || txnType == 3) && (savedLease = this.getTransactionHandler().getTimedXtns().get(xtnInfo.m_Transaction)) != null) {
                    lease = savedLease - SystemTime.timeMillis() - TransactionHandler.XTN_ADDITIONAL_TIMEOUT;
                }
                result.add(new TransactionInfo(txnType, status, (Transaction)xtnInfo.m_Transaction, lease, xtnInfo.m_startTime, this._cacheManager.getNumberOfLockedObjectsUnderTxn(xtnInfo)));
            }
            finally {
                xtnInfo.unlock();
            }
        }
        return count;
    }

    private static int getXtnInfoType(XtnInfo xtnInfo) {
        int result = xtnInfo.m_Transaction instanceof GSServerTransaction ? (((GSServerTransaction)xtnInfo.m_Transaction).getId() instanceof Xid ? 3 : 1) : (xtnInfo.m_Transaction.mgr instanceof LocalTransactionManager ? 1 : 2);
        return result;
    }

    private static int getXtnInfoStatus(XtnInfo xtnInfo) {
        switch (xtnInfo.getStatus()) {
            case BEGUN: 
            case PREPARING: {
                return 1;
            }
            case PREPARED: 
            case COMMITING: {
                return 3;
            }
            case COMMITED: {
                return 5;
            }
            case ROLLING: 
            case ROLLED: {
                return 6;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UnderTxnLockedObject> getLockedObjects(Transaction txn) throws RemoteException {
        ArrayList<UnderTxnLockedObject> result;
        block22: {
            result = new ArrayList<UnderTxnLockedObject>();
            Context context = null;
            ISAdapterIterator iter = null;
            try {
                context = this._cacheManager.getCacheContext();
                XtnEntry xtnEntry = this.getTransaction((ServerTransaction)txn);
                if (xtnEntry == null) {
                    ArrayList<UnderTxnLockedObject> arrayList = result;
                    return arrayList;
                }
                xtnEntry.lock();
                try {
                    IEntryHolder entry;
                    iter = this._cacheManager.makeUnderXtnEntriesIter(context, xtnEntry, 2);
                    if (iter == null) break block22;
                    while ((entry = (IEntryHolder)iter.next()) != null) {
                        int operType;
                        int lockType;
                        ServerTransaction writeLockOwner = entry.getWriteLockTransaction();
                        if (writeLockOwner == null || !writeLockOwner.equals((Object)txn)) {
                            lockType = 1;
                            operType = 2;
                        } else {
                            lockType = 2;
                            operType = entry.getWriteLockOperation();
                        }
                        result.add(new UnderTxnLockedObject(entry.getUID(), lockType, operType, entry.getClassName()));
                    }
                }
                finally {
                    xtnEntry.unlock();
                }
            }
            catch (SAException ex) {
                throw new InternalSpaceException(ex.getMessage(), ex);
            }
            finally {
                try {
                    if (iter != null) {
                        iter.close();
                    }
                }
                catch (SAException ex) {
                    this._cacheManager.freeCacheContext(context);
                    context = null;
                    throw new InternalSpaceException(ex.getMessage(), ex);
                }
                if (context != null) {
                    this._cacheManager.freeCacheContext(context);
                }
            }
        }
        return result;
    }

    private void monitorReplicationStateForModifyingOperation(Transaction transaction, OperationWeightInfo info) {
        if (transaction != null) {
            return;
        }
        this.monitorReplicationState(info);
    }

    private void monitorReplicationState(OperationWeightInfo info) {
        if (!this._spaceImpl.isPrimary()) {
            return;
        }
        if (this.isReplicated()) {
            this.getReplicationNode().getAdmin().monitorState(info);
        }
    }

    public IServerTypeDesc getTypeTableEntry(String className) {
        return this._typeManager.getServerTypeDesc(className);
    }

    public void waitForConsistentState() {
        if (this.isReplicated()) {
            try {
                if (this.shouldFlushPendingReplication()) {
                    this.getReplicationNode().getAdmin().flushPendingReplication(this._clusterPolicy.getReplicationPolicy().getAsyncChannelShutdownTimeout(), TimeUnit.MILLISECONDS);
                }
            }
            catch (RuntimeException e) {
                if (this._logger.isLoggable(Level.SEVERE)) {
                    this._logger.log(Level.SEVERE, "Flush pending replication raised an exception:", e);
                }
                throw e;
            }
        }
    }

    private boolean shouldFlushPendingReplication() {
        SpaceHealthStatus spaceHealthStatus = this._spaceImpl.getLocalSpaceHealthStatus();
        if (!spaceHealthStatus.isHealthy()) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine(this.getFullSpaceName() + " is unhealthy [" + spaceHealthStatus.getUnhealthyReason() + "], skipping flush of pending replication packets");
            }
            return false;
        }
        return true;
    }

    public Map<String, Object> getMetricsSnapshotByPrefix(Collection<String> prefixes) {
        return this._metricManager.getSnapshotsByPrefix(prefixes);
    }

    public void close() {
        this._spaceImpl.removeInternalSpaceModeListener(this);
        this._cacheManager.closeQueryExtensionManagers();
        if (this._replicationManager != null) {
            this._replicationManager.close();
        }
        if (this._processorWG != null) {
            this._processorWG.shutdown();
        }
        if (this._leaseManager != null) {
            this._leaseManager.close();
        }
        if (this._filterManager != null) {
            this._filterManager.close();
        }
        if (this._memoryManager != null) {
            this._memoryManager.close();
        }
        if (this._cacheManager != null) {
            this._cacheManager.shutDown();
        }
        if (this._dataEventManager != null) {
            this._dataEventManager.close();
        }
        if (this._spaceImpl.getClusterFailureDetector() != null) {
            this._spaceImpl.getClusterFailureDetector().terminate();
        }
        if (this._metricRegistrator != null) {
            this._metricRegistrator.clear();
        }
        if (this._metricManager != null) {
            this._metricManager.close();
        }
    }

    public IEntryHolder getMatchedEntryAndOperateSA(Context context, ITemplateHolder template, boolean makeWaitForInfo, boolean useSCN) throws TransactionException, TemplateDeletedException, SAException {
        IEntryCacheInfo toScan;
        if (template.getUidToOperateBy() != null) {
            return this.getEntryByIdAndOperateSA(context, template, makeWaitForInfo, useSCN);
        }
        IEntryHolder res = null;
        IServerTypeDesc serverTypeDesc = this._typeManager.getServerTypeDesc(template.getClassName());
        long scnFilter = useSCN ? template.getSCN() : 0L;
        long leaseFilter = SystemTime.timeMillis();
        if (template.getID() != null && template.getExtendedMatchCodes() == null && (toScan = this._cacheManager.getEntryByUniqueId(serverTypeDesc, template.getID(), template)) != null && !toScan.isIterator() && (res = this.getMatchedEntryAndOperateSA_Entry(context, template, makeWaitForInfo, true, -1, null, leaseFilter, useSCN, (IEntryCacheInfo)toScan.next())) != null) {
            return res;
        }
        IServerTypeDesc[] subTypes = serverTypeDesc.getAssignableTypes();
        if (context.getReadByIdsInfo() != null) {
            if (context.getReadByIdsInfo().getPos() == -1) {
                context.getReadByIdsInfo().setEntries(this._cacheManager.getEntriesByUniqueIds(serverTypeDesc, context.getReadByIdsInfo().getIds(), template));
            }
            if (context.getReadByIdsInfo().getEntries()[context.getReadByIdsInfo().incrementPos()] != null && (res = this.getMatchedEntryAndOperateSA_Entry(context, template, makeWaitForInfo, true, -1, null, leaseFilter, useSCN, context.getReadByIdsInfo().getEntries()[context.getReadByIdsInfo().getPos()])) != null) {
                return res;
            }
        }
        if (this.getCacheManager().isEvictableCachePolicy() && !this._cacheManager.isMemorySpace()) {
            IScanListIterator toScan2 = this._cacheManager.makeScanableEntriesIter(context, template, serverTypeDesc, scnFilter, leaseFilter, this.isMemoryOnlyOperation(template));
            return this.getMatchedEntryAndOperateSA_Scan(context, template, makeWaitForInfo, useSCN, toScan2);
        }
        int actual = 0;
        if (subTypes.length > 1) {
            int size = subTypes.length - 1;
            if (!template.isFifoSearch()) {
                actual = this._random.nextInt(size);
            }
        }
        int k = 0;
        while (k < subTypes.length) {
            if (actual >= subTypes.length) {
                actual = 0;
            }
            if ((res = this.getMatchedEntryAndOperateSA_type(context, template, makeWaitForInfo, useSCN, leaseFilter, subTypes[actual])) != null) {
                return res;
            }
            ++k;
            ++actual;
        }
        if (template.isFifoGroupPoll() && !context.isAnyFifoGroupIndex()) {
            throw new IllegalArgumentException("fifo grouping specified but no fifo grouping property defined type=" + template.getServerTypeDesc().getTypeName());
        }
        return null;
    }

    private IEntryHolder getMatchedEntryAndOperateSA_type(Context context, ITemplateHolder template, boolean makeWaitForInfo, boolean useSCN, long leaseFilter, IServerTypeDesc typeDesc) throws TransactionException, TemplateDeletedException, SAException {
        IServerTypeDesc serverTypeDesc = this._typeManager.getServerTypeDesc(template.getClassName());
        if (template.isChangeById() && !serverTypeDesc.getTypeName().equals(template.getServerTypeDesc().getTypeName())) {
            return null;
        }
        IScanListIterator<IEntryCacheInfo> toScan = this._cacheManager.getMatchingMemoryEntriesForScanning(context, typeDesc, template, serverTypeDesc);
        if (toScan == null) {
            return null;
        }
        if (!toScan.isIterator()) {
            return this.getMatchedEntryAndOperateSA_Entry(context, template, makeWaitForInfo, true, -1, null, leaseFilter, useSCN, toScan.next());
        }
        return this.getMatchedEntryAndOperateSA_Scan(context, template, makeWaitForInfo, useSCN, toScan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEntryHolder getMatchedEntryAndOperateSA_Scan(Context context, ITemplateHolder template, boolean makeWaitForInfo, boolean useSCN, IScanListIterator<IEntryCacheInfo> toScan) throws TransactionException, TemplateDeletedException, SAException {
        if (template.isFifoGroupPoll() && toScan.isIterator()) {
            return this._fifoGroupsHandler.getMatchedEntryAndOperateSA_Scan(context, template, makeWaitForInfo, useSCN, toScan);
        }
        long leaseFilter = SystemTime.timeMillis();
        boolean needMatch = !toScan.isAlreadyMatched();
        int alreadyMatchedFixedPropertyIndexPos = toScan.getAlreadyMatchedFixedPropertyIndexPos();
        String alreadyMatchedIndexPath = toScan.getAlreadyMatchedIndexPath();
        try {
            while (toScan.hasNext()) {
                IEntryCacheInfo pEntry = toScan.next();
                if (pEntry == null) continue;
                IEntryHolder res = this.getMatchedEntryAndOperateSA_Entry(context, template, makeWaitForInfo, needMatch, alreadyMatchedFixedPropertyIndexPos, alreadyMatchedIndexPath, leaseFilter, useSCN, pEntry);
                if (res == null) continue;
                IEntryHolder iEntryHolder = res;
                return iEntryHolder;
            }
            IEntryHolder iEntryHolder = null;
            return iEntryHolder;
        }
        finally {
            toScan.releaseScan();
            if (context.isPendingExpiredEntriesExist() && this._cacheManager.getTemplatesManager().anyNotifyLeaseTemplates()) {
                try {
                    this._leaseManager.forceLeaseReaperCycle(false);
                }
                catch (InterruptedException interruptedException) {}
                context.setPendingExpiredEntriesExist(false);
            }
        }
    }

    IEntryHolder getMatchedEntryAndOperateSA_Entry(Context context, ITemplateHolder template, boolean makeWaitForInfo, boolean needMatch, int skipAlreadyMatchedFixedPropertyIndex, String skipAlreadyMatchedIndexPath, long leaseFilter, boolean useSCN, IEntryCacheInfo pEntry) throws TransactionException, TemplateDeletedException, SAException {
        IEntryHolder entry;
        long scnFilter;
        if (pEntry.isBlobStoreEntry() && !pEntry.preMatch(context, template)) {
            return null;
        }
        long l = scnFilter = useSCN ? template.getSCN() : 0L;
        if (pEntry.isBlobStoreEntry()) {
            boolean onlyIndexesPart = BlobStoreOperationOptimizations.isConsiderOptimizedForBlobstore(this, context, template, pEntry);
            entry = ((BlobStoreRefEntryCacheInfo)pEntry).getLatestEntryVersion(this._cacheManager, false, null, context, onlyIndexesPart);
        } else {
            entry = pEntry.getEntryHolder(this._cacheManager, context);
        }
        if (scnFilter != 0L && entry.getSCN() < scnFilter) {
            return null;
        }
        if (entry.isExpired(leaseFilter) && this.disqualifyExpiredEntry(entry) && template.isReadOperation()) {
            context.setPendingExpiredEntriesExist(true);
            return null;
        }
        if (needMatch && !this._templateScanner.match(context, entry, template, skipAlreadyMatchedFixedPropertyIndex, skipAlreadyMatchedIndexPath, false)) {
            return null;
        }
        if (!template.isNonBlockingRead() && entry.isDeleted()) {
            return null;
        }
        try {
            this.performTemplateOnEntrySA(context, template, entry, makeWaitForInfo);
            return entry;
        }
        catch (EntryDeletedException ex) {
            return null;
        }
        catch (NoMatchException ex) {
            return null;
        }
        catch (FifoException ex) {
            return null;
        }
        catch (TransactionConflictException ex) {
            if (template.isFifoGroupPoll()) {
                context.setFifoGroupScanEncounteredXtnConflict(true);
            }
            return null;
        }
        catch (TransactionNotActiveException ex) {
            if (ex.m_Xtn.equals((Object)template.getXidOriginatedTransaction())) {
                throw new TransactionException("Transaction not active : " + template.getXidOriginatedTransaction());
            }
            return null;
        }
    }

    private IEntryHolder getEntryByIdAndOperateSA(Context context, ITemplateHolder template, boolean makeWaitForInfo, boolean useSCN) throws TransactionException, TemplateDeletedException, SAException {
        String uid = template.getUidToOperateBy();
        if (uid == null) {
            throw new RuntimeException("internal error: getEntryByIdAndOperateSA called with null uid");
        }
        boolean replicatedFromCentralDB = this.isReplicatedFromCentralDB(context);
        boolean cacheOnly = replicatedFromCentralDB && (template.getTemplateOperation() == 7 || template.getTemplateOperation() == 5 || template.getTemplateOperation() == 4) || template.isInitiatedEvictionOperation() || template.isMemoryOnlySearch();
        IEntryHolder entry = this._cacheManager.getEntry(context, uid, template.getClassName(), template, true, false, cacheOnly);
        boolean exceptionIfNoEntry = false;
        if (template.isMatchByID()) {
            if (entry != null) {
                ITransactionalEntryData ed;
                context.setRawmatchResult(ed, (ed = entry.getTxnEntryData()).getOtherUpdateUnderXtnEntry() != null ? MatchResult.MASTER_AND_SHADOW : MatchResult.MASTER, entry, template);
            }
            exceptionIfNoEntry = !replicatedFromCentralDB && (template.getTemplateOperation() == 7 || (template.getTemplateOperation() == 3 || template.getTemplateOperation() == 5) && template.getUidToOperateBy() != null) && !template.isInitiatedEvictionOperation() && !template.isChangeById();
        } else {
            boolean bl = exceptionIfNoEntry = !replicatedFromCentralDB && template.getTemplateOperation() == 7;
        }
        if (entry == null || useSCN && template.getSCN() > entry.getSCN()) {
            if (exceptionIfNoEntry) {
                this.returnEntryNotInSpaceError(context, template, null, makeWaitForInfo);
            }
            return null;
        }
        if (!(template.isMatchByID() && !template.isChangeQuery() || this._templateScanner.match(context, entry, template))) {
            return null;
        }
        try {
            this.performTemplateOnEntrySA(context, template, entry, makeWaitForInfo);
            return entry;
        }
        catch (EntryDeletedException edx) {
            if (exceptionIfNoEntry) {
                this.returnEntryNotInSpaceError(context, template, edx, makeWaitForInfo);
            }
            return null;
        }
        catch (TransactionConflictException tcx) {
            return null;
        }
        catch (NoMatchException ex) {
            return null;
        }
        catch (FifoException ex) {
            return null;
        }
        catch (TransactionNotActiveException tnae) {
            if (template.getXidOriginatedTransaction() != null && tnae.m_Xtn.equals((Object)template.getXidOriginatedTransaction())) {
                throw new TransactionException("Transaction not active " + tnae.m_Xtn, (Throwable)tnae);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnEntryNotInSpaceError(Context context, ITemplateHolder template, EntryDeletedException edx, boolean makeWaitForInfo) {
        block10: {
            EntryNotInSpaceException exv = new EntryNotInSpaceException(template.getUidToOperateBy(), this.getFullSpaceName(), edx != null && edx.deletedByOwnTxn());
            ILockObject templateLock = null;
            try {
                if (template.isInCache() || makeWaitForInfo) {
                    ILockObject iLockObject = templateLock = this.getTemplateLockObject(template);
                    synchronized (iLockObject) {
                        if (!template.isDeleted()) {
                            context.setOperationAnswer(template, null, (Exception)((Object)exv));
                            if (template.isInCache()) {
                                this._cacheManager.removeTemplate(context, template, false, true, false);
                            }
                        }
                        break block10;
                    }
                }
                context.setOperationAnswer(template, null, (Exception)((Object)exv));
                template.setDeleted(true);
            }
            finally {
                if (templateLock != null) {
                    this.freeTemplateLockObject(templateLock);
                }
            }
        }
    }

    private void handleEntryByIdAndOperateSA(Context context, ITemplateHolder template) throws TransactionException, TemplateDeletedException, SAException {
        IEntryHolder eh = this.getEntryByIdAndOperateSA(context, template, false, false);
        this.performReplIfChunkReached(context);
    }

    public void executeOnMatchingEntries(Context context, ITemplateHolder template, boolean makeWaitForInfo) throws TransactionException, TemplateDeletedException, SAException {
        String[] multipleUids = template.getMultipleUids();
        if (multipleUids != null) {
            for (int i = 0; i < multipleUids.length && template.getBatchOperationContext().getNumResults() < template.getBatchOperationContext().getMaxEntries(); ++i) {
                if (multipleUids[i] == null) continue;
                template.setUidToOperateBy(multipleUids[i]);
                this.handleEntryByIdAndOperateSA(context, template);
            }
            return;
        }
        if (template.getUidToOperateBy() != null) {
            this.handleEntryByIdAndOperateSA(context, template);
            return;
        }
        IServerTypeDesc serverTypeDesc = this._typeManager.getServerTypeDesc(template.getClassName());
        IServerTypeDesc[] subTypes = serverTypeDesc.getAssignableTypes();
        long leaseFilter = SystemTime.timeMillis();
        if (this.getCacheManager().isEvictableCachePolicy() && !this._cacheManager.isMemorySpace()) {
            IScanListIterator toScan = this._cacheManager.makeScanableEntriesIter(context, template, serverTypeDesc, 0L, leaseFilter, this.isMemoryOnlyOperation(template));
            this.getMatchedEntriesAndOperateSA_Scan(context, template, toScan, makeWaitForInfo, null);
        } else {
            int actual = 0;
            if (subTypes.length > 1) {
                int size = subTypes.length - 1;
                if (!template.isFifoSearch()) {
                    actual = this._random.nextInt(size);
                }
            }
            int k = 0;
            while (k < subTypes.length) {
                if (actual >= subTypes.length) {
                    actual = 0;
                }
                this.getMatchedEntriesAndOperateSA_Type(context, template, subTypes[actual], makeWaitForInfo);
                if (template.getBatchOperationContext().reachedMaxEntries()) {
                    return;
                }
                ++k;
                ++actual;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMatchedEntriesAndOperateSA_Scan(Context context, ITemplateHolder template, IScanListIterator<IEntryCacheInfo> toScan, boolean makeWaitForInfo, IServerTypeDesc entryTypeDesc) throws TransactionException, TemplateDeletedException, SAException {
        if (template.isFifoGroupPoll() && toScan.isIterator()) {
            this._fifoGroupsHandler.getMatchedEntriesAndOperateSA_Scan(context, template, toScan, makeWaitForInfo, entryTypeDesc);
            return;
        }
        long leaseFilter = SystemTime.timeMillis();
        boolean needMatch = !toScan.isAlreadyMatched();
        int alreadyMatchedFixedPropertyIndexPos = toScan.getAlreadyMatchedFixedPropertyIndexPos();
        String alreadyMatchedIndexPath = toScan.getAlreadyMatchedIndexPath();
        boolean checkResultSize = 0 < this._resultsSizeLimit && !template.isReturnOnlyUid() && template.isReadMultiple();
        int resultSizeOverflow = 0;
        try {
            toScan = BlobStorePreFetchIteratorBasedHandler.createPreFetchIterIfRelevant(context, this._cacheManager, toScan, template, this._logger);
            while (toScan.hasNext()) {
                IEntryCacheInfo pEntry = toScan.next();
                if (pEntry == null) continue;
                this.getMatchedEntriesAndOperateSA_Entry(context, template, needMatch, alreadyMatchedFixedPropertyIndexPos, alreadyMatchedIndexPath, leaseFilter, pEntry, makeWaitForInfo, entryTypeDesc);
                if (template.getBatchOperationContext().reachedMaxEntries()) {
                    return;
                }
                if (!checkResultSize || this._resultsSizeLimit >= template.getBatchOperationContext().getNumResults()) continue;
                if (0 < this._resultsSizeLimitMemoryCheckBatchSize && this._memoryManager.isEnabled()) {
                    if (resultSizeOverflow % this._resultsSizeLimitMemoryCheckBatchSize == 0) {
                        this._memoryManager.monitorMemoryUsage(false);
                    }
                } else {
                    throw new LimitExceededException("Query max result", this._resultsSizeLimit);
                }
                ++resultSizeOverflow;
            }
        }
        finally {
            toScan.releaseScan();
            if (context.isPendingExpiredEntriesExist() && this._cacheManager.getTemplatesManager().anyNotifyLeaseTemplates()) {
                try {
                    this._leaseManager.forceLeaseReaperCycle(false);
                }
                catch (InterruptedException interruptedException) {}
                context.setPendingExpiredEntriesExist(false);
            }
        }
    }

    void getMatchedEntriesAndOperateSA_Entry(Context context, ITemplateHolder template, boolean needMatch, int skipAlreadyMatchedFixedPropertyIndex, String skipAlreadyMatchedIndexPath, long leaseFilter, IEntryCacheInfo pEntry, boolean makeWaitForInfo, IServerTypeDesc entryTypeDesc) throws TransactionException, TemplateDeletedException, SAException {
        if (pEntry.isBlobStoreEntry() && !pEntry.preMatch(context, template)) {
            return;
        }
        IEntryHolder entry = BlobStoreOperationOptimizations.isConsiderOptimizedForBlobstore(this, context, template, pEntry) ? ((BlobStoreRefEntryCacheInfo)pEntry).getLatestEntryVersion(this._cacheManager, false, null, context, true) : pEntry.getEntryHolder(this._cacheManager, context);
        if ((template.getExpirationTime() == 0L || !template.isInCache()) && template.getBatchOperationContext().isInProcessedUids(entry.getUID())) {
            return;
        }
        if (entry.isExpired(leaseFilter) && this.disqualifyExpiredEntry(entry) && template.isReadOperation()) {
            context.setPendingExpiredEntriesExist(true);
            return;
        }
        if (needMatch && !this._templateScanner.match(context, entry, template, skipAlreadyMatchedFixedPropertyIndex, skipAlreadyMatchedIndexPath, false)) {
            return;
        }
        if (!template.isNonBlockingRead() && entry.isDeleted()) {
            return;
        }
        try {
            this.performTemplate(context, template, entry, makeWaitForInfo);
        }
        catch (EntryDeletedException ex) {
            return;
        }
        catch (NoMatchException ex) {
            return;
        }
        catch (FifoException ex) {
            return;
        }
        catch (TransactionConflictException ex) {
            if (template.isFifoGroupPoll()) {
                context.setFifoGroupScanEncounteredXtnConflict(true);
            }
            return;
        }
        catch (TransactionNotActiveException ex) {
            if (ex.m_Xtn.equals((Object)template.getXidOriginatedTransaction())) {
                throw new TransactionException("Transaction not active : " + template.getXidOriginatedTransaction(), (Throwable)ex);
            }
            return;
        }
    }

    private void getMatchedEntriesAndOperateSA_Type(Context context, ITemplateHolder template, IServerTypeDesc entryTypeDesc, boolean makeWaitForInfo) throws TransactionException, TemplateDeletedException, SAException {
        IServerTypeDesc serverTypeDesc = this._typeManager.getServerTypeDesc(template.getClassName());
        if (template.isChangeById() && !serverTypeDesc.getTypeName().equals(template.getServerTypeDesc().getTypeName())) {
            return;
        }
        IScanListIterator<IEntryCacheInfo> toScan = this._cacheManager.getMatchingMemoryEntriesForScanning(context, entryTypeDesc, template, serverTypeDesc);
        if (toScan == null) {
            return;
        }
        if (!toScan.isIterator()) {
            this.getMatchedEntriesAndOperateSA_Entry(context, template, true, -1, null, SystemTime.timeMillis(), toScan.next(), makeWaitForInfo, entryTypeDesc);
        } else {
            this.getMatchedEntriesAndOperateSA_Scan(context, template, toScan, makeWaitForInfo, entryTypeDesc);
        }
    }

    private void performTemplate(Context context, ITemplateHolder template, IEntryHolder entry, boolean makeWaitForInfo) throws TransactionConflictException, EntryDeletedException, TemplateDeletedException, TransactionNotActiveException, SAException, NoMatchException, FifoException {
        this.performTemplateOnEntrySA(context, template, entry, makeWaitForInfo);
        this.performReplIfChunkReached(context);
    }

    private boolean isMemoryOnlyOperation(ITemplateHolder template) {
        return this._cacheManager.getStorageAdapter().isReadOnly() && !this.hasMirror() && !template.isReadOperation() || template.isInitiatedEvictionOperation();
    }

    public boolean hasMirror() {
        return this.getClusterPolicy() != null && this.getClusterPolicy().getReplicationPolicy() != null && this.getClusterPolicy().getReplicationPolicy().isMirrorServiceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performTemplateOnEntrySA(Context context, ITemplateHolder template, IEntryHolder entry, boolean makeWaitForInfo) throws TransactionConflictException, EntryDeletedException, TemplateDeletedException, TransactionNotActiveException, SAException, NoMatchException, FifoException {
        if (entry.isBlobStoreEntry() && template.getTemplateOperation() == 7) {
            this._cacheManager.getBlobStoreMemoryMonitor().onMemoryAllocation(((IBlobStoreEntryHolder)((Object)entry)).getBlobStoreResidentPart().getStorageKey());
        }
        context.setDisableSyncReplication(true);
        context.setOperationID(template.getOperationID());
        try {
            if (template.getTemplateOperation() == 7 && !template.isChange() && !template.getUpdatedEntry().getClassName().equals(entry.getClassName())) {
                ILockObject templateLock = this.getTemplateLockObject(template);
                try {
                    ILockObject iLockObject = templateLock;
                    synchronized (iLockObject) {
                        if (template.hasAnswer()) throw new TemplateDeletedException(template);
                        RuntimeException rtex = new RuntimeException(" Update: original entry and updated entry not from same class updated=" + template.getUpdatedEntry().getClassName() + " original=" + entry.getClassName());
                        context.setOperationAnswer(template, null, rtex);
                        if (template.isDeleted()) throw new TemplateDeletedException(template);
                        if (!template.isInCache()) throw new TemplateDeletedException(template);
                        this._cacheManager.removeTemplate(context, template, false, true, false);
                        throw new TemplateDeletedException(template);
                    }
                }
                catch (Throwable throwable) {
                    if (templateLock == null) throw throwable;
                    this.freeTemplateLockObject(templateLock);
                    throw throwable;
                }
            }
            ILockObject entryLock = null;
            ILockObject templateLock = null;
            boolean need_xtn_lock = false;
            boolean upgrade_lock = false;
            while (true) {
                block49: {
                    ILockObject iLockObject;
                    block48: {
                        block46: {
                            block47: {
                                context.setNonBlockingReadOp(template.isNonBlockingRead() && !context.isUnstableEntry() && !context.isTransactionalMultipleOperation());
                                need_xtn_lock = !template.isFifoSearch() ? need_xtn_lock || !context.isNonBlockingReadOp() && template.getXidOriginated() != null : need_xtn_lock || !context.isNonBlockingReadOp() && (template.getXidOriginated() != null || entry.isMaybeUnderXtn());
                                if (context.isNonBlockingReadOp()) break block48;
                                if (need_xtn_lock) {
                                    if (!context.isTransactionalMultipleOperation()) {
                                        this.getTransactionHandler().xtnLockEntryOnTemplateOperation(context, entry, template, context.isTransactionalMultipleOperation() ? template.getXidOriginated() : null);
                                    }
                                    if (template.isFifoSearch()) {
                                        this.getTransactionHandler().getTxReadLock().lock();
                                    }
                                }
                                try {
                                    iLockObject = entryLock = this._cacheManager.getLockManager().getLockObject(entry);
                                    synchronized (iLockObject) {
                                        try {
                                            if (makeWaitForInfo || template.isInCache()) {
                                                ILockObject iLockObject2 = templateLock = this.getTemplateLockObject(template);
                                                synchronized (iLockObject2) {
                                                    upgrade_lock = this.performTemplateOnEntryXtnAwareSA(context, template, entry, need_xtn_lock, makeWaitForInfo);
                                                }
                                            } else {
                                                upgrade_lock = this.performTemplateOnEntryXtnAwareSA(context, template, entry, need_xtn_lock, makeWaitForInfo);
                                            }
                                        }
                                        finally {
                                            if (this.getCacheManager().mayNeedEntriesUnpinning()) {
                                                this._cacheManager.unpinIfNeeded(context, entry, template, null);
                                            }
                                        }
                                        if (!need_xtn_lock) break block46;
                                    }
                                    if (context.isTransactionalMultipleOperation()) break block47;
                                    this.getTransactionHandler().xtnUnlockEntryOnTemplateOperation(template, context.isTransactionalMultipleOperation() ? template.getXidOriginated() : null);
                                }
                                catch (Throwable throwable) {
                                    if (!need_xtn_lock) throw throwable;
                                    if (!context.isTransactionalMultipleOperation()) {
                                        this.getTransactionHandler().xtnUnlockEntryOnTemplateOperation(template, context.isTransactionalMultipleOperation() ? template.getXidOriginated() : null);
                                    }
                                    if (!template.isFifoSearch()) throw throwable;
                                    this.getTransactionHandler().getTxReadLock().unlock();
                                    throw throwable;
                                }
                            }
                            if (template.isFifoSearch()) {
                                this.getTransactionHandler().getTxReadLock().unlock();
                            }
                        }
                        if (upgrade_lock && !need_xtn_lock) {
                            need_xtn_lock = true;
                        }
                        if (!upgrade_lock) {
                            if (templateLock != null) {
                                this.freeTemplateLockObject(templateLock);
                                templateLock = null;
                            }
                            if (entryLock == null) return;
                            this._cacheManager.getLockManager().freeLockObject(entryLock);
                            entryLock = null;
                            return;
                        }
                        break block49;
                    }
                    if (makeWaitForInfo || template.isInCache()) {
                        iLockObject = templateLock = this.getTemplateLockObject(template);
                        synchronized (iLockObject) {
                            upgrade_lock = this.performTemplateOnEntryXtnAwareSA(context, template, entry, false, makeWaitForInfo);
                        }
                    } else {
                        upgrade_lock = this.performTemplateOnEntryXtnAwareSA(context, template, entry, false, makeWaitForInfo);
                    }
                    if (upgrade_lock) {
                        if (templateLock != null) {
                            this.freeTemplateLockObject(templateLock);
                            templateLock = null;
                        }
                        if (entryLock == null) continue;
                        this._cacheManager.getLockManager().freeLockObject(entryLock);
                        entryLock = null;
                        continue;
                    }
                    if (templateLock != null) {
                        this.freeTemplateLockObject(templateLock);
                        templateLock = null;
                    }
                    if (entryLock == null) return;
                    this._cacheManager.getLockManager().freeLockObject(entryLock);
                    entryLock = null;
                    return;
                }
                if (templateLock != null) {
                    this.freeTemplateLockObject(templateLock);
                    templateLock = null;
                }
                if (entryLock == null) continue;
                this._cacheManager.getLockManager().freeLockObject(entryLock);
                entryLock = null;
                continue;
                break;
            }
            catch (Throwable throwable) {
                if (templateLock != null) {
                    this.freeTemplateLockObject(templateLock);
                    templateLock = null;
                }
                if (entryLock == null) throw throwable;
                this._cacheManager.getLockManager().freeLockObject(entryLock);
                entryLock = null;
                throw throwable;
            }
        }
        finally {
            context.setDisableSyncReplication(false);
            context.setLastRawMatchSnapshot(null);
            if (template.getXidOriginatedTransaction() == null) {
                if (context.isSyncReplFromMultipleOperation()) {
                    this.performReplIfChunkReached(context);
                } else {
                    this.performReplication(context);
                }
            }
        }
    }

    private boolean performTemplateOnEntryXtnAwareSA(Context context, ITemplateHolder tmpl, IEntryHolder ent, boolean needXtnLocked, boolean makeWaitForInfo) throws TransactionConflictException, EntryDeletedException, TemplateDeletedException, TransactionNotActiveException, SAException, NoMatchException, FifoException {
        if (ent.isBlobStoreEntry()) {
            BlobStoreRefEntryCacheInfo blobStoreRefEntryCacheInfo = ((BlobStoreEntryHolder)ent).getBlobStoreResidentPart();
            BlobStoreOperationOptimizations.isConsiderOptimizedForBlobstore(this, context, tmpl, blobStoreRefEntryCacheInfo);
        }
        boolean needRematch = false;
        if (needXtnLocked) {
            XtnEntry xtnEntry;
            if (ent.isDeleted()) {
                throw ENTRY_DELETED_EXCEPTION;
            }
            IEntryHolder entry = ent;
            if (this.getCacheManager().needReReadAfterEntryLock()) {
                boolean replicatedFromCentralDB = this.isReplicatedFromCentralDB(context);
                entry = replicatedFromCentralDB && (tmpl.getTemplateOperation() == 7 || tmpl.getTemplateOperation() == 5 || tmpl.getTemplateOperation() == 4) ? this._cacheManager.getEntry(context, ent, true, true, true) : this._cacheManager.getEntry(context, ent, true, true, tmpl.isMemoryOnlySearch());
                if (entry == null) {
                    throw ENTRY_DELETED_EXCEPTION;
                }
                if (entry.isDeleted()) {
                    throw ENTRY_DELETED_EXCEPTION;
                }
                if (entry.isBlobStoreEntry() && !entry.isSameEntryInstance(ent)) {
                    throw ENTRY_DELETED_EXCEPTION;
                }
                if (ent != entry) {
                    needRematch = true;
                }
            }
            if (entry.getWriteLockOwner() != null && entry.getWriteLockOperation() == 1 && (xtnEntry = entry.getWriteLockOwner()) != null && (xtnEntry.getStatus() == XtnStatus.ROLLED || xtnEntry.getStatus() == XtnStatus.ROLLING)) {
                throw ENTRY_DELETED_EXCEPTION;
            }
            if (!(entry.getWriteLockTransaction() == null || entry.getWriteLockOperation() != 4 && entry.getWriteLockOperation() != 5 || (xtnEntry = entry.getWriteLockOwner()) == null || xtnEntry.getStatus() != XtnStatus.COMMITED && xtnEntry.getStatus() != XtnStatus.COMMITING)) {
                throw ENTRY_DELETED_EXCEPTION;
            }
            if (entry.isExpired() && !this.isExpiredEntryStayInSpace(entry)) {
                boolean continueOp;
                boolean bl = continueOp = tmpl.getXidOriginated() != null && tmpl.getXidOriginated() == entry.getWriteLockOwner();
                if (!continueOp && entry.isExpired(this._leaseManager.getEffectiveEntryLeaseTime(SystemTime.timeMillis()))) {
                    if (!(this._leaseManager.replicateLeaseExpirationEventsForEntries() || this._leaseManager.isNoReapUnderXtnLeases() && entry.isEntryUnderWriteLockXtn())) {
                        IServerTypeDesc typeDesc = this._typeManager.getServerTypeDesc(entry.getClassName());
                        this.removeEntrySA(context, entry, typeDesc, false, true, EntryRemoveReasonCodes.LEASE_EXPIRED);
                    }
                    throw ENTRY_DELETED_EXCEPTION;
                }
            }
            if (!(needRematch || tmpl.isMatchByID() || context.getLastRawMatchSnapshot() != null && context.getLastRawmatchTemplate() == tmpl && context.getLastRawmatchEntry() == entry && context.getLastRawMatchSnapshot() == entry.getTxnEntryData() && context.getLastRawMatchSnapshot().getVersion() == entry.getTxnEntryData().getVersion() && context.getLastRawMatchSnapshot().getOtherUpdateUnderXtnEntry() == null)) {
                needRematch = true;
            }
            if (tmpl.isInCache()) {
                ITemplateHolder template = tmpl;
                if (template.isDeleted()) {
                    throw new TemplateDeletedException(template);
                }
                if (template.isExpired()) {
                    boolean cancelPendingOp;
                    boolean bl = cancelPendingOp = !template.isInitialIfExistSearchActive() || template.getEntriesWaitingForTemplate() != null && !template.getEntriesWaitingForTemplate().isEmpty();
                    if (cancelPendingOp) {
                        if (!template.hasAnswer()) {
                            context.setOperationAnswer(template, null, null);
                        }
                        this._cacheManager.removeTemplate(context, template, false, true, false);
                        throw new TemplateDeletedException(template);
                    }
                }
                this.performTemplateOnEntryCoreSA(context, template, entry, makeWaitForInfo, needRematch);
            } else {
                this.performTemplateOnEntryCoreSA(context, tmpl, entry, makeWaitForInfo, needRematch);
            }
        } else {
            if (ent.isDeleted()) {
                throw ENTRY_DELETED_EXCEPTION;
            }
            if (context.isNonBlockingReadOp() && this._cacheManager.isDummyEntry(ent)) {
                throw ENTRY_DELETED_EXCEPTION;
            }
            IEntryHolder entry = ent;
            if (!(!this.getCacheManager().needReReadAfterEntryLock() || context.isNonBlockingReadOp() && context.isMainThread())) {
                entry = this._cacheManager.getEntry(context, ent, true, !context.isNonBlockingReadOp(), tmpl.isInitiatedEvictionOperation() || tmpl.isMemoryOnlySearch());
                if (entry == null && tmpl.isInitiatedEvictionOperation()) {
                    throw NO_MATCH_EXCEPTION;
                }
                if (entry == null) {
                    throw ENTRY_DELETED_EXCEPTION;
                }
                if (!context.isNonBlockingReadOp() && entry.isDeleted()) {
                    throw ENTRY_DELETED_EXCEPTION;
                }
                if (entry.isBlobStoreEntry() && !context.isNonBlockingReadOp() && !entry.isSameEntryInstance(ent)) {
                    throw ENTRY_DELETED_EXCEPTION;
                }
                if (ent != entry) {
                    needRematch = true;
                }
            }
            if (tmpl.isFifoSearch() && !context.isNonBlockingReadOp() && entry.isMaybeUnderXtn()) {
                return true;
            }
            if (!needRematch && !tmpl.isMatchByID()) {
                if (context.getLastRawMatchSnapshot() == null || context.getLastRawmatchTemplate() != tmpl || context.getLastRawmatchEntry() != entry) {
                    needRematch = true;
                }
                if (!(needRematch || context.getLastRawMatchSnapshot() == entry.getTxnEntryData() && context.getLastRawMatchSnapshot().getVersion() == entry.getTxnEntryData().getVersion() && context.getLastRawMatchSnapshot().getOtherUpdateUnderXtnEntry() == null)) {
                    needRematch = true;
                }
            }
            if (context.isNonBlockingReadOp() && needRematch) {
                if (!this._templateScanner.match(context, entry, tmpl)) {
                    throw NO_MATCH_EXCEPTION;
                }
                if (entry.isDeleted()) {
                    throw ENTRY_DELETED_EXCEPTION;
                }
                needRematch = false;
                if (context.isUnstableEntry()) {
                    return true;
                }
            }
            boolean expired = context.isNonBlockingReadOp() ? context.getLastRawMatchSnapshot().isExpired() : entry.isExpired();
            boolean bl = expired = expired && !this.isExpiredEntryStayInSpace(entry);
            if (expired && !context.isNonBlockingReadOp() && !entry.isExpired(this._leaseManager.getEffectiveEntryLeaseTime(SystemTime.timeMillis()))) {
                expired = false;
            }
            if (expired) {
                if (!context.isNonBlockingReadOp()) {
                    if (!(this._leaseManager.isNoReapUnderXtnLeases() && entry.isEntryUnderWriteLockXtn() || tmpl.isInitiatedEvictionOperation() || this._leaseManager.replicateLeaseExpirationEventsForEntries())) {
                        IServerTypeDesc typeDesc = this._typeManager.getServerTypeDesc(entry.getClassName());
                        this.removeEntrySA(context, entry, typeDesc, false, true, EntryRemoveReasonCodes.LEASE_EXPIRED);
                    }
                } else {
                    context.setUnstableEntry(true);
                    return true;
                }
                throw ENTRY_DELETED_EXCEPTION;
            }
            if (tmpl.isInCache()) {
                ITemplateHolder template = tmpl;
                if (template.isDeleted()) {
                    throw new TemplateDeletedException(template);
                }
                if (template.isExpired()) {
                    boolean cancelPendingOp;
                    boolean bl2 = cancelPendingOp = !template.isInitialIfExistSearchActive() || template.getEntriesWaitingForTemplate() != null && !template.getEntriesWaitingForTemplate().isEmpty();
                    if (cancelPendingOp) {
                        if (!template.hasAnswer()) {
                            context.setOperationAnswer(template, null, null);
                        }
                        this._cacheManager.removeTemplate(context, template, false, true, false);
                        throw new TemplateDeletedException(template);
                    }
                }
                this.performTemplateOnEntryCoreSA(context, template, entry, makeWaitForInfo, needRematch);
            } else {
                this.performTemplateOnEntryCoreSA(context, tmpl, entry, makeWaitForInfo, needRematch);
            }
        }
        return false;
    }

    private void performTemplateOnEntryCoreSA(Context context, ITemplateHolder template, IEntryHolder entry, boolean makeWaitForInfo, boolean needRematch) throws TransactionConflictException, EntryDeletedException, TemplateDeletedException, TransactionNotActiveException, SAException, NoMatchException, FifoException {
        if (!context.isNonBlockingReadOp() && !needRematch) {
            needRematch = !template.isMatchByID() && entry.hasShadow(true);
        }
        boolean tryMaster = true;
        boolean tryShadow = false;
        if (!context.isNonBlockingReadOp()) {
            if (template.isMatchByID()) {
                tryShadow = entry.hasShadow(true);
            } else if (needRematch) {
                MatchResult mr = template.match(this._cacheManager, entry, -1, null, true, context, this._templateScanner.getRegexCache());
                tryMaster = mr == MatchResult.MASTER || mr == MatchResult.MASTER_AND_SHADOW;
                tryShadow = mr == MatchResult.SHADOW || mr == MatchResult.MASTER_AND_SHADOW;
            }
        } else {
            tryMaster = context.getLastMatchResult() == MatchResult.MASTER || context.getLastMatchResult() == MatchResult.MASTER_AND_SHADOW;
            boolean bl = tryShadow = context.getLastMatchResult() == MatchResult.SHADOW || context.getLastMatchResult() == MatchResult.MASTER_AND_SHADOW;
        }
        if (!tryMaster && !tryShadow) {
            throw NO_MATCH_EXCEPTION;
        }
        if (template.isInitiatedEvictionOperation()) {
            if (!tryMaster) {
                throw NO_MATCH_EXCEPTION;
            }
            tryShadow = false;
        }
        if (tryMaster) {
            try {
                this.performTemplateOnEntryCoreSA_impl(context, template, entry, makeWaitForInfo, false, tryShadow);
                return;
            }
            catch (TransactionConflictException ex) {
                if (!template.isReadOperation()) {
                    tryShadow = false;
                }
                if (!tryShadow) {
                    throw ex;
                }
                try {
                    this.performTemplateOnEntryCoreSA_impl(context, template, entry, makeWaitForInfo, true, true);
                    return;
                }
                catch (Exception exception) {
                    throw ex;
                }
            }
        }
        this.performTemplateOnEntryCoreSA_impl(context, template, entry, makeWaitForInfo, true, true);
    }

    private void performTemplateOnEntryCoreSA_impl(Context context, ITemplateHolder template, IEntryHolder entry, boolean makeWaitForInfo, boolean isShadow, boolean shadowMatches) throws TransactionConflictException, EntryDeletedException, TemplateDeletedException, TransactionNotActiveException, SAException, FifoException, NoMatchException {
        XtnEntry templateTransactionEntry = null;
        if (!(template.getXidOriginatedTransaction() == null || (templateTransactionEntry = this.getTransaction(template.getXidOriginatedTransaction())) != null && templateTransactionEntry.m_Active)) {
            throw new TransactionNotActiveException(template.getXidOriginatedTransaction());
        }
        if (isShadow && template.getXidOriginatedTransaction() != null && template.getXidOriginatedTransaction().equals((Object)entry.getWriteLockTransaction())) {
            throw ENTRY_DELETED_EXCEPTION;
        }
        if (template.isFifoSearch()) {
            this.checkValidityOfFifoTemplateOnEntry(context, entry, template);
            if (context.isNonBlockingReadOp() && entry.isDeleted()) {
                throw ENTRY_DELETED_EXCEPTION;
            }
        }
        boolean isReadCommitted = template.isReadOperation() && this.indicateReadCommitted(context.isNonBlockingReadOp() ? context.getLastRawMatchSnapshot() : entry.getTxnEntryData(), template);
        XtnConfilctCheckIndicators cres = this.checkTransactionConflict(context, entry, template, isShadow);
        if (cres != XtnConfilctCheckIndicators.NO_CONFLICT) {
            boolean skipWFenlist;
            if (cres == XtnConfilctCheckIndicators.ENTRY_DELETED || cres == XtnConfilctCheckIndicators.DELETED_BY_OWN_XTN) {
                throw ENTRY_DELETED_EXCEPTION;
            }
            boolean bl = skipWFenlist = isReadCommitted && !isShadow && shadowMatches;
            if (makeWaitForInfo && !skipWFenlist && !template.isDeleted()) {
                if (!template.isInCache()) {
                    if (template.isMultipleIdsOperation()) {
                        template.getMultipleIdsContext().setNonMainThreadUsed();
                    }
                    this._cacheManager.insertTemplate(context, template, false);
                }
                this._cacheManager.makeWaitForInfo(context, entry, template);
            }
            if (!skipWFenlist && template.isChange() && !template.isInCache()) {
                if (template.isChangeMultiple()) {
                    ((ExtendedAnswerHolder)template.getAnswerHolder()).addRejectedEntriesInfo(Context._operationTimeoutExecption, entry.getEntryData(), entry.getUID());
                } else {
                    template.setRejectedOpOriginalExceptionAndEntry(new OperationTimeoutException(), entry.getEntryData());
                }
            }
            if (!makeWaitForInfo && template.isIfExist()) {
                context.setPossibleIEBlockingMatch(true);
            }
            throw TX_CONFLICT_EXCEPTION;
        }
        if (template.isFifoTemplate() && !this._isLocalCache && context.isNonBlockingReadOp()) {
            this.checkValidityOfFifoTemplateOnEntry(context, entry, template);
        }
        IServerTypeDesc tte = this._typeManager.getServerTypeDesc(entry.getClassName());
        if (template.isFifoGroupPoll()) {
            this._fifoGroupsHandler.fifoGroupsOnOperationAction(context, entry, template, tte);
        }
        if (template.isBatchOperation() && template.getBatchOperationContext().isInProcessedUids(entry.getUID())) {
            throw NO_MATCH_EXCEPTION;
        }
        switch (template.getTemplateOperation()) {
            case 2: 
            case 3: {
                this.performReadTemplateOnEntryCoreSA(context, template, entry, isShadow, isReadCommitted);
                break;
            }
            case 4: 
            case 5: {
                if (template.isInitiatedEvictionOperation()) {
                    this.performInitiatedEvictionTemplateOnEntryCoreSA(context, template, entry, tte);
                    break;
                }
                this.performTakeTemplateOnEntryCoreSA(context, template, entry, tte);
                break;
            }
            case 7: {
                try {
                    this.performUpdateTemplateOnEntryCoreSA(context, template, entry, templateTransactionEntry, tte);
                    break;
                }
                catch (ChangeInternalException ex) {
                    if (template.isBatchOperation()) {
                        template.getBatchOperationContext().addToProcessedUidsIfNeeded(entry.getUID());
                    }
                    throw NO_MATCH_EXCEPTION;
                }
            }
            default: {
                if (!this._logger.isLoggable(Level.SEVERE)) break;
                this._logger.severe("Unknown operation in template.");
            }
        }
    }

    private void performReadTemplateOnEntryCoreSA(Context context, ITemplateHolder template, IEntryHolder entry, boolean isShadow, boolean isReadCommitted) throws SAException {
        boolean useReadCommittedOfUpdatedEntry;
        IEntryHolder shadowEntryToUse = null;
        boolean bl = useReadCommittedOfUpdatedEntry = isShadow && isReadCommitted;
        if (useReadCommittedOfUpdatedEntry) {
            shadowEntryToUse = context.isNonBlockingReadOp() ? context.getLastRawMatchSnapshot().getOtherUpdateUnderXtnEntry() : entry.getShadow();
        }
        boolean isDirtyRead = this.indicateDirtyRead(template);
        if (template.getXidOriginated() != null && !isReadCommitted && !isDirtyRead) {
            this._cacheManager.associateEntryWithXtn(context, entry, template, template.getXidOriginated(), null);
        }
        if (template.isIfExist() && template.isInCache()) {
            this._cacheManager.removeWaitingForInfo(context, entry, template, false);
        }
        IEntryPacket entryPacket = null;
        EntryHolderAggregatorContext aggregatorContext = template.getAggregatorContext();
        if (shadowEntryToUse != null) {
            if (aggregatorContext != null) {
                aggregatorContext.scan(shadowEntryToUse.getEntryData(), entry.getUID(), entry.isTransient());
            } else {
                entryPacket = EntryPacketFactory.createFullPacket(shadowEntryToUse, template, entry.getUID());
            }
        } else {
            IEntryData entryData;
            IEntryData iEntryData = entryData = context.isNonBlockingReadOp() ? context.getLastRawMatchSnapshot() : entry.getEntryData();
            if (aggregatorContext != null) {
                aggregatorContext.scan(entryData, entry.getUID(), entry.isTransient());
            } else {
                entryPacket = EntryPacketFactory.createFullPacket(entry, template, entryData);
            }
        }
        if (!template.isBatchOperation()) {
            context.setOperationAnswer(template, entryPacket, null);
            if (template.isInCache()) {
                this._cacheManager.removeTemplate(context, template, false, true, false);
            }
        } else {
            template.getBatchOperationContext().addResult(entryPacket);
            template.getBatchOperationContext().addToProcessedUidsIfNeeded(entry.getUID());
            if (template.canFinishBatchOperation()) {
                context.setOperationAnswer(template, null, null);
                if (template.isInCache()) {
                    this._cacheManager.removeTemplate(context, template, false, true, false);
                }
            }
        }
        if (this.getCacheManager().isEvictableCachePolicy() || entry.isBlobStoreEntry()) {
            this._cacheManager.touchByEntry(context, entry, false, template, CacheOperationReason.ON_READ);
        }
    }

    private void performTakeTemplateOnEntryCoreSA(Context context, ITemplateHolder template, IEntryHolder entry, IServerTypeDesc typeDesc) throws SAException, TemplateDeletedException {
        boolean anyNotityTakeTemplates;
        int templateVersion;
        boolean called_remove = false;
        if (!(this._isLocalCache || (templateVersion = template.getEntryData().getVersion()) <= 0 || template.getUidToOperateBy() == null && template.getID() == null)) {
            int entryVersion = entry.getEntryData().getVersion();
            if (context.isFromReplication()) {
                if (templateVersion < entryVersion) {
                    EntryVersionConflictException exv = new EntryVersionConflictException(template.getUidToOperateBy(), entryVersion, templateVersion, "Take");
                    context.setOperationAnswer(template, null, (Exception)((Object)exv));
                    return;
                }
            } else if (templateVersion != entryVersion) {
                EntryVersionConflictException exv = new EntryVersionConflictException(template.getUidToOperateBy(), entryVersion, templateVersion, "Take/TakeIE");
                context.setOperationAnswer(template, null, (Exception)((Object)exv));
                if (template.isInCache()) {
                    this._cacheManager.removeTemplate(context, template, false, true, false);
                }
                throw TEMPLATE_DELETED_EXCEPTION;
            }
        }
        IEntryPacket ep = EntryPacketFactory.createFullPacket(entry, template);
        if (!(template.getXidOriginatedTransaction() == null || entry.getXidOriginatedTransaction() != null && template.getXidOriginatedTransaction().equals((Object)entry.getXidOriginatedTransaction()))) {
            this._cacheManager.associateEntryWithXtn(context, entry, template, template.getXidOriginated(), null);
        }
        if (template.isIfExist() && template.isInCache()) {
            this._cacheManager.removeWaitingForInfo(context, entry, template, false);
        }
        boolean fromReplication = context.isFromReplication();
        boolean origin = context.isOrigin();
        context.set_take_template(template);
        context.set_take_typeDesc(typeDesc);
        if (template.getXidOriginatedTransaction() == null || entry.getXidOriginatedTransaction() != null && template.getXidOriginatedTransaction().equals((Object)entry.getXidOriginatedTransaction())) {
            this.removeEntrySA(context, entry, typeDesc, fromReplication, origin, EntryRemoveReasonCodes.TAKE);
            called_remove = true;
        }
        if (!template.isBatchOperation()) {
            context.setOperationAnswer(template, ep, null);
            if (template.isInCache()) {
                this._cacheManager.removeTemplate(context, template, false, true, false);
            }
        } else {
            template.getBatchOperationContext().addResult(ep);
            template.getBatchOperationContext().addToProcessedUidsIfNeeded(entry.getUID());
            if (template.canFinishBatchOperation()) {
                context.setOperationAnswer(template, null, null);
                if (template.isInCache()) {
                    this._cacheManager.removeTemplate(context, template, false, true, false);
                }
            }
        }
        if (anyNotityTakeTemplates = this._cacheManager.getTemplatesManager().anyNotifyTakeTemplates()) {
            boolean fifoNotify;
            IEntryHolder notifytake_eh = template.getXidOriginatedTransaction() != null ? entry.createCopy() : entry;
            boolean bl = fifoNotify = !called_remove && (context.get_take_typeDesc().isFifoSupported() && this._cacheManager.getTemplatesManager().anyNotifyFifoTakeTemplates() || !context.get_take_typeDesc().isFifoSupported() && this._cacheManager.getTemplatesManager().anyNotifyFifoForNonFifoTypePerOperation(context.get_take_typeDesc(), 4));
            if (fifoNotify) {
                FifoBackgroundRequest red = new FifoBackgroundRequest(context.getOperationID(), true, false, entry, null, context.isFromReplication(), 4, context.get_take_template().getXidOriginatedTransaction(), notifytake_eh);
                this._cacheManager.getFifoBackgroundDispatcher().positionAndActivateRequest(red);
            }
            if (template.getXidOriginatedTransaction() == null) {
                EntryTakenPacket etp = new EntryTakenPacket(context.getOperationID(), entry, null, notifytake_eh, context.isFromReplication());
                this._processorWG.enqueueBlocked(etp);
            }
        }
        if ((this.getCacheManager().isEvictableCachePolicy() || entry.isBlobStoreEntry()) && template.getXidOriginatedTransaction() != null) {
            this._cacheManager.touchByEntry(context, entry, true, template, CacheOperationReason.ON_TAKE);
        }
    }

    private void performUpdateTemplateOnEntryCoreSA(Context context, ITemplateHolder template, IEntryHolder entry, XtnEntry templateTransactionEntry, IServerTypeDesc typeDesc) throws SAException, TemplateDeletedException {
        IEntryHolder originalEntryHolder;
        int operation;
        IEntryHolder newEntry;
        int newVersionID;
        IEntryData edata;
        int templateVersion = template.getEntryData().getVersion();
        int previousTemplateVersion = template.getPreviousVersion();
        boolean overrideVersion = Modifiers.contains(template.getOperationModifiers(), 524288);
        context.setReRegisterLeaseOnUpdate(template.isReRegisterLeaseOnUpdate());
        if (templateVersion > 0) {
            if (template.isChangeMultiple()) {
                throw new RuntimeException(" change multiple: version-id not allowed!");
            }
            boolean versionIdConfilct = false;
            int entryVersion = entry.getEntryData().getVersion();
            if (context.isFromReplication()) {
                if (templateVersion <= entryVersion && !overrideVersion) {
                    EntryVersionConflictException exv = new EntryVersionConflictException(template.getUidToOperateBy(), entryVersion, templateVersion, "Update");
                    context.setOperationAnswer(template, null, (Exception)((Object)exv));
                    return;
                }
            } else if (context.isFromGateway()) {
                if (entryVersion != previousTemplateVersion && !overrideVersion) {
                    versionIdConfilct = true;
                }
            } else if (this._isLocalCache) {
                if (templateVersion < entryVersion || templateVersion != entryVersion && UpdateModifiers.isPartialUpdate(template.getOperationModifiers())) {
                    versionIdConfilct = true;
                }
            } else if (templateVersion != entryVersion && !overrideVersion) {
                versionIdConfilct = true;
            }
            if (versionIdConfilct) {
                EntryVersionConflictException exv = new EntryVersionConflictException(template.getUidToOperateBy(), entryVersion, templateVersion, "Update");
                if (template.isSetSingleOperationExtendedErrorInfo()) {
                    template.setRejectedOpOriginalExceptionAndEntry((Throwable)((Object)exv), entry.getEntryData());
                    context.setOperationAnswer(template, null, null);
                } else {
                    if (template.isChangeMultiple()) {
                        ((ExtendedAnswerHolder)template.getAnswerHolder()).addRejectedEntriesInfo((Throwable)((Object)exv), entry.getEntryData(), entry.getUID());
                    }
                    context.setOperationAnswer(template, null, (Exception)((Object)exv));
                }
                if (template.isInCache()) {
                    this._cacheManager.removeTemplate(context, template, context.isFromReplication(), true, false);
                }
                throw TEMPLATE_DELETED_EXCEPTION;
            }
        }
        boolean reWrittenUnderXtn = false;
        boolean needVerifyWF = entry.isHasWaitingFor();
        boolean fromReplication = false;
        try {
            if (template.isChange()) {
                ProtectiveModeException exception;
                IEntryHolder updateEntry = this._cacheManager.makeChangeOpEntry(context, template, entry);
                if (!context.isFromReplication() && this.isPartitionedSpace() && updateEntry.getRoutingValue() != entry.getRoutingValue() && ProtectiveMode.isWrongRoutingUsageProtectionEnabled() && (exception = this.createExceptionIfRoutingValueDoesntMatchesCurrentPartition(updateEntry.getRoutingValue(), typeDesc, "change")) != null) {
                    throw exception;
                }
                template.setUpdatedEntry(updateEntry);
            }
            boolean renewLease = false;
            IEntryData udata = template.getUpdatedEntry().getEntryData();
            edata = entry.getEntryData();
            if (udata.getExpirationTime() != 0L) {
                renewLease = true;
            }
            if ((newVersionID = this._isLocalCache || context.isFromReplication() || context.isFromGateway() || overrideVersion ? template.getEntryData().getVersion() : edata.getVersion() + 1) != udata.getVersion() || udata.getExpirationTime() == 0L) {
                template.getUpdatedEntry().updateVersionAndExpiration(newVersionID, renewLease ? udata.getExpirationTime() : edata.getExpirationTime());
                udata = template.getUpdatedEntry().getEntryData();
            }
            if (template.getXidOriginatedTransaction() != null) {
                if (entry.getWriteLockTransaction() != null && (entry.getWriteLockOperation() == 4 || entry.getWriteLockOperation() == 5) && template.getXidOriginatedTransaction().equals((Object)entry.getWriteLockTransaction())) {
                    reWrittenUnderXtn = true;
                }
                templateTransactionEntry.m_AnyUpdates = true;
                newEntry = this._cacheManager.associateEntryWithXtn(context, entry, template, template.getXidOriginated(), template.getUpdatedEntry());
            } else {
                fromReplication = context.isFromReplication();
                boolean origin = context.isOrigin();
                newEntry = this.updateEntrySA(context, entry, template, fromReplication, origin, typeDesc);
            }
        }
        catch (RuntimeException e) {
            if (template.isInCache()) {
                this._cacheManager.removeWaitingForInfo(context, entry, template, false);
            }
            if (template.isSetSingleOperationExtendedErrorInfo() || template.isChangeMultiple()) {
                RuntimeException exception;
                RuntimeException runtimeException = exception = e instanceof ChangeInternalException ? ((ChangeInternalException)e).getInternalException() : e;
                if (template.isSetSingleOperationExtendedErrorInfo()) {
                    template.setRejectedOpOriginalExceptionAndEntry(exception, entry.getEntryData());
                } else {
                    ((ExtendedAnswerHolder)template.getAnswerHolder()).addRejectedEntriesInfo(exception, entry.getEntryData(), entry.getUID());
                }
                boolean removeTemplateIfNeeded = false;
                if (template.isChangeById()) {
                    if (!template.isInitialIfExistSearchActive()) {
                        context.setOperationAnswer(template, null, exception);
                        removeTemplateIfNeeded = true;
                    }
                } else if (template.isChangeMultiple() && template.canFinishBatchOperation()) {
                    context.setOperationAnswer(template, null, null);
                    removeTemplateIfNeeded = true;
                }
                if (removeTemplateIfNeeded && template.isInCache()) {
                    this._cacheManager.removeTemplate(context, template, false, true, false);
                }
            } else {
                context.setOperationAnswer(template, null, e);
                if (template.isInCache()) {
                    this._cacheManager.removeTemplate(context, template, context.isFromReplication(), true, false);
                }
            }
            throw e;
        }
        if (template.isChangeMultiple()) {
            ((ExtendedAnswerHolder)template.getAnswerHolder()).addModifiedEntriesData(newEntry.getEntryData(), entry.getUID(), context.getChangeResultsForCurrentEntry());
        } else {
            ((ExtendedAnswerHolder)template.getAnswerHolder()).setModifiedEntryData(newEntry.getEntryData());
            ((ExtendedAnswerHolder)template.getAnswerHolder()).setPreviousEntryData(edata);
            if (template.isChange()) {
                ((ExtendedAnswerHolder)template.getAnswerHolder()).setSingleChangeResults(context.getChangeResultsForCurrentEntry());
            }
        }
        IEntryPacket ep = EntryPacketFactory.createFullPacket(entry, template, edata);
        if (template.isUpdateOperation() && (context.getWriteResult() == null || !entry.getUID().equals(context.getWriteResult().getUid()))) {
            context.setWriteResult(new WriteEntryResult(entry.getUID(), newVersionID, newEntry.getEntryData().getExpirationTime()));
        }
        if (template.isIfExist() && template.isInCache()) {
            this._cacheManager.removeWaitingForInfo(context, entry, template, false);
        }
        if (!template.isBatchOperation()) {
            context.setOperationAnswer(template, ep, null);
            if (template.isInCache()) {
                this._cacheManager.removeTemplate(context, template, false, true, false);
            }
        } else {
            template.getBatchOperationContext().addResult(ep);
            template.getBatchOperationContext().addToProcessedUidsIfNeeded(entry.getUID());
            if (template.canFinishBatchOperation()) {
                context.setOperationAnswer(template, null, null);
                if (template.isInCache()) {
                    this._cacheManager.removeTemplate(context, template, false, true, false);
                }
            }
        }
        IEntryHolder notify_eh = newEntry.createCopy();
        boolean fifoNotify = false;
        fifoNotify = typeDesc.isFifoSupported() ? !reWrittenUnderXtn && this._cacheManager.getTemplatesManager().anyNotifyFifoUpdateTemplates() || reWrittenUnderXtn && this._cacheManager.getTemplatesManager().anyNotifyFifoWriteTemplates() : !reWrittenUnderXtn && this._cacheManager.getTemplatesManager().anyNotifyFifoForNonFifoTypePerOperation(typeDesc, 7) || reWrittenUnderXtn && this._cacheManager.getTemplatesManager().anyNotifyFifoForNonFifoTypePerOperation(typeDesc, 1);
        FifoBackgroundRequest red = null;
        int n = operation = !reWrittenUnderXtn ? 7 : 1;
        if (fifoNotify) {
            IEntryHolder originalEntryHolder2 = EntryHolderFactory.createEntryHolder(typeDesc, ep, this._entryDataType);
            red = new FifoBackgroundRequest(context.getOperationID(), true, typeDesc.isFifoSupported() && this._cacheManager.getTemplatesManager().anyNonNotifyFifoTemplates(), newEntry, originalEntryHolder2, context.isFromReplication(), operation, template.getXidOriginatedTransaction(), notify_eh);
        } else if (typeDesc.isFifoSupported() && this._cacheManager.getTemplatesManager().anyNonNotifyFifoTemplates()) {
            red = new FifoBackgroundRequest(context.getOperationID(), false, true, newEntry, null, context.isFromReplication(), operation, template.getXidOriginatedTransaction(), null);
        }
        long curTime = SystemTime.timeMillis();
        if (red != null) {
            red.setTime(curTime);
            this._cacheManager.getFifoBackgroundDispatcher().positionAndActivateRequest(red);
        }
        this.setLastEntryTimestamp(curTime);
        boolean isNotifyMatched = this._cacheManager.getTemplatesManager().anyNotifyMatchedTemplates();
        boolean isNotifyRematched = this._cacheManager.getTemplatesManager().anyNotifyRematchedTemplates();
        if (this._cacheManager.getTemplatesManager().anyNonNotifyTemplates() || this._cacheManager.getTemplatesManager().anyNotifyUpdateTemplates() || isNotifyMatched || isNotifyRematched) {
            if (reWrittenUnderXtn) {
                EntryArrivedPacket ea = this._entryArrivedFactory.getPacket(context.getOperationID(), newEntry, template.getXidOriginatedTransaction(), true, notify_eh, fromReplication);
                this._processorWG.enqueueBlocked(ea);
            } else {
                originalEntryHolder = EntryHolderFactory.createEntryHolder(typeDesc, ep, this._entryDataType);
                EntryUpdatedPacket entryUpdatedPacket = new EntryUpdatedPacket(context.getOperationID(), originalEntryHolder, newEntry, notify_eh, template.getXidOriginatedTransaction(), fromReplication, isNotifyMatched, isNotifyRematched);
                this._processorWG.enqueueBlocked(entryUpdatedPacket);
            }
        }
        if (this._cacheManager.getTemplatesManager().anyNotifyUnmatchedTemplates() && template.getXidOriginatedTransaction() == null) {
            originalEntryHolder = EntryHolderFactory.createEntryHolder(typeDesc, ep, this._entryDataType);
            EntryUnmatchedPacket ea = new EntryUnmatchedPacket(context.getOperationID(), originalEntryHolder, notify_eh, null, fromReplication);
            this._processorWG.enqueueBlocked(ea);
        }
        if (needVerifyWF) {
            this.checkWFValidityAfterUpdate(context, entry);
        }
        if (this.getCacheManager().isEvictableCachePolicy() || entry.isBlobStoreEntry()) {
            this._cacheManager.touchByEntry(context, entry, true, template, CacheOperationReason.ON_UPDATE);
        }
    }

    private void performInitiatedEvictionTemplateOnEntryCoreSA(Context context, ITemplateHolder template, IEntryHolder entry, IServerTypeDesc typeDesc) throws SAException, NoMatchException {
        IEntryPacket ep = EntryPacketFactory.createFullPacket(entry, template);
        boolean fromReplication = context.isFromReplication();
        boolean shouldReplicate = false;
        if (this.isReplicated()) {
            shouldReplicate = this.shouldReplicate(ReplicationOperationType.EVICT, typeDesc, false, fromReplication);
        }
        if (!this._cacheManager.initiatedEviction(context, entry, shouldReplicate)) {
            throw NO_MATCH_EXCEPTION;
        }
        if (!template.isBatchOperation()) {
            context.setOperationAnswer(template, ep, null);
            if (template.isInCache()) {
                this._cacheManager.removeTemplate(context, template, false, true, false);
            }
        } else {
            template.getBatchOperationContext().addResult(ep);
            template.getBatchOperationContext().addToProcessedUidsIfNeeded(entry.getUID());
            if (template.canFinishBatchOperation()) {
                context.setOperationAnswer(template, null, null);
                if (template.isInCache()) {
                    this._cacheManager.removeTemplate(context, template, false, true, false);
                }
            }
        }
    }

    private boolean indicateReadCommitted(ITransactionalEntryData entry, ITemplateHolder template) {
        if (this.indicateDirtyRead(template) || !template.isReadCommittedRequested()) {
            return false;
        }
        ServerTransaction est = entry.getWriteLockTransaction();
        return template.getXidOriginatedTransaction() == null || est == null || !template.getXidOriginatedTransaction().equals((Object)est);
    }

    public boolean indicateDirtyRead(ITemplateHolder template) {
        return template.isReadOperation() && this._useDirtyRead || template.isDirtyReadRequested();
    }

    private void checkValidityOfFifoTemplateOnEntry(Context context, IEntryHolder entry, ITemplateHolder template) throws FifoException {
        TerminatingFifoXtnsInfo.FifoXtnEntryInfo eti = null;
        boolean isDirtyRead = false;
        boolean isReadCommitted = false;
        if (context.isTemplateInitialSearch() && template.isInitialFifoSearchActive() && (eti = this._cacheManager.getFifoEntryXtnInfo(entry)) != null) {
            long xtnEntry;
            if (TerminatingFifoXtnsInfo.isSeqTransactionGT(eti.getCreatingXtn(), template.getFifoXtnNumberOnSearchStart())) {
                throw this._fifoException;
            }
            if (template.isReadOperation()) {
                isDirtyRead = this.indicateDirtyRead(template);
                if (isDirtyRead) {
                    return;
                }
                isReadCommitted = this.indicateReadCommitted(context.isNonBlockingReadOp() ? context.getLastRawMatchSnapshot() : entry.getTxnEntryData(), template);
                if (isReadCommitted) {
                    long xtnEntry2 = eti.getEntryWriteXtnNumber();
                    if (TerminatingFifoXtnsInfo.isSeqTransactionGT(xtnEntry2, template.getFifoXtnNumberOnSearchStart())) {
                        throw this._fifoException;
                    }
                    return;
                }
            }
            if (TerminatingFifoXtnsInfo.isSeqTransactionGT(xtnEntry = eti.getTerminatingXtnWriteLock(), template.getFifoXtnNumberOnSearchStart())) {
                throw this._fifoException;
            }
            if (template.isWriteLockOperation() && TerminatingFifoXtnsInfo.isSeqTransactionGT(xtnEntry = eti.getTerminatingXtnReadLock(), template.getFifoXtnNumberOnSearchStart())) {
                throw this._fifoException;
            }
        }
        if (!context.isTemplateInitialSearch() && template.isInitialFifoSearchActive() && template.getPendingFifoSearchObject() != null) {
            template.getPendingFifoSearchObject().addRejectedEntry(entry, context.getRecentFifoObject());
            throw this._fifoException;
        }
        if (context.isFifoThread()) {
            long fifoThreadXtn = context.getRecentFifoObject().getFifoXtnNumber();
            if (TerminatingFifoXtnsInfo.isSeqTransactionGT(template.getFifoXtnNumberOnSearchStart(), fifoThreadXtn)) {
                throw this._fifoException;
            }
            eti = this._cacheManager.getFifoEntryXtnInfo(entry);
            if (eti != null) {
                long xtnEntry;
                if (template.isReadOperation()) {
                    isDirtyRead = this.indicateDirtyRead(template);
                    if (isDirtyRead) {
                        return;
                    }
                    isReadCommitted = this.indicateReadCommitted(context.isNonBlockingReadOp() ? context.getLastRawMatchSnapshot() : entry.getTxnEntryData(), template);
                    if (isReadCommitted) {
                        long xtnEntry3 = eti.getEntryWriteXtnNumber();
                        if (TerminatingFifoXtnsInfo.isSeqTransactionGT(xtnEntry3, fifoThreadXtn)) {
                            throw this._fifoException;
                        }
                        return;
                    }
                }
                if (TerminatingFifoXtnsInfo.isSeqTransactionGT(xtnEntry = eti.getTerminatingXtnWriteLock(), fifoThreadXtn)) {
                    throw this._fifoException;
                }
                if (template.isWriteLockOperation() && TerminatingFifoXtnsInfo.isSeqTransactionGT(xtnEntry = eti.getTerminatingXtnReadLock(), fifoThreadXtn)) {
                    throw this._fifoException;
                }
            }
        }
    }

    public void checkWFValidityAfterUpdate(Context context, IEntryHolder entry) throws SAException {
        if (!entry.isHasWaitingFor() || entry.isDeleted()) {
            return;
        }
        Collection<ITemplateHolder> wf = entry.getTemplatesWaitingForEntry();
        for (ITemplateHolder template : wf) {
            boolean match;
            if (template.isDeleted() || (match = this._templateScanner.match(context, entry, template, -1, null, true))) continue;
            RemoveWaitingForInfoSABusPacket wfpacket = new RemoveWaitingForInfoSABusPacket(context.getOperationID(), entry, template);
            this._processorWG.enqueueBlocked(wfpacket);
        }
    }

    public XtnEntry attachToXtn(ServerTransaction txn, boolean fromReplication) throws TransactionException, RemoteException {
        return this._transactionHandler.attachToXtnGranular(txn, fromReplication);
    }

    public void removeEntrySA(Context context, IEntryHolder entry, IServerTypeDesc typeDesc, boolean fromReplication, boolean origin, EntryRemoveReasonCodes removeReason) throws SAException {
        this.removeEntrySA(context, entry, typeDesc, fromReplication, origin, removeReason, false, false, false);
    }

    public void removeEntrySA(Context context, IEntryHolder entry, IServerTypeDesc typeDesc, boolean fromReplication, boolean origin, EntryRemoveReasonCodes removeReason, boolean disableReplication, boolean disableProcessorCall, boolean disableSADelete) throws SAException {
        this.removeEntrySA(context, entry, fromReplication, origin, typeDesc.getTypeDesc().isReplicable(), removeReason, disableReplication, disableProcessorCall, disableSADelete);
    }

    public void removeEntrySA(Context context, IEntryHolder entry, boolean fromReplication, boolean origin, boolean ofReplicatableClass, EntryRemoveReasonCodes removeReason, boolean disableReplication, boolean disableProcessorCall, boolean disableSADelete) throws SAException {
        boolean fromLeaseExpiration;
        block27: {
            ShadowEntryHolder shadoweh;
            boolean bl = fromLeaseExpiration = removeReason == EntryRemoveReasonCodes.LEASE_CANCEL || removeReason == EntryRemoveReasonCodes.LEASE_EXPIRED;
            if ((fromLeaseExpiration || this._general_purpose_remove_filters) && this._filterManager._isFilter[52]) {
                this._filterManager.invokeFilters(52, null, entry);
            }
            boolean noRealRemoveFromSpace = fromLeaseExpiration && this.isExpiredEntryStayInSpace(entry);
            boolean bl2 = disableReplication = disableReplication || removeReason == EntryRemoveReasonCodes.LEASE_EXPIRED && !this._leaseManager.replicateLeaseExpirationEventsForEntries();
            if (!noRealRemoveFromSpace) {
                entry.setDeleted(true);
            }
            if (entry.hasShadow(true) && (shadoweh = entry.getShadow()) != null) {
                shadoweh.setDeleted(true);
            }
            boolean originalWF = false;
            if (entry.isHasWaitingFor()) {
                originalWF = true;
                RemoveWaitingForInfoSABusPacket packet = new RemoveWaitingForInfoSABusPacket(context.getOperationID(), entry, null);
                this._processorWG.enqueueBlocked(packet);
            }
            boolean shouldReplicate = false;
            if (this.isReplicated()) {
                ReplicationOperationType operType = removeReason == EntryRemoveReasonCodes.TAKE ? ReplicationOperationType.TAKE : ReplicationOperationType.LEASE_EXPIRATION;
                shouldReplicate = this.shouldReplicate(operType, ofReplicatableClass, disableReplication, fromReplication);
            }
            FifoBackgroundRequest red = null;
            if (context.get_take_template() != null || fromLeaseExpiration) {
                boolean fifoNotifyLeaseExpiration;
                boolean fifoNotifyTake = context.get_take_template() != null && this._cacheManager.getTemplatesManager().anyNotifyTakeTemplates() && (context.get_take_typeDesc().isFifoSupported() && this._cacheManager.getTemplatesManager().anyNotifyFifoTakeTemplates() || !context.get_take_typeDesc().isFifoSupported() && this._cacheManager.getTemplatesManager().anyNotifyFifoForNonFifoTypePerOperation(context.get_take_typeDesc(), 4));
                boolean bl3 = fifoNotifyLeaseExpiration = !fifoNotifyTake && fromLeaseExpiration && this._cacheManager.getTemplatesManager().anyNotifyLeaseTemplates();
                if (fifoNotifyLeaseExpiration) {
                    IServerTypeDesc tte = this._typeManager.getServerTypeDesc(entry.getClassName());
                    boolean bl4 = fifoNotifyLeaseExpiration = tte.isFifoSupported() && this._cacheManager.getTemplatesManager().anyNotifyFifoLeaseExpirationTemplates() || !tte.isFifoSupported() && this._cacheManager.getTemplatesManager().anyNotifyFifoForNonFifoTypePerOperation(tte, 8);
                }
                if (fifoNotifyTake || fifoNotifyLeaseExpiration) {
                    int spaceOperation = fifoNotifyTake ? 4 : 8;
                    red = fifoNotifyTake ? new FifoBackgroundRequest(context.getOperationID(), true, false, entry, null, context.isFromReplication(), spaceOperation, context.get_take_template().getXidOriginatedTransaction(), entry) : new FifoBackgroundRequest(context.getOperationID(), true, false, entry, null, context.isFromReplication(), spaceOperation, null, entry);
                    red.setAllowFifoNotificationsForNonFifoEvents(new FifoBackgroundRequest.AllowFifoNotificationsForNonFifoType());
                    this._cacheManager.getFifoBackgroundDispatcher().positionAndActivateRequest(red);
                }
            }
            try {
                IEntryCacheInfo pEntry = null;
                if (noRealRemoveFromSpace) {
                    pEntry = this._cacheManager.getEntryCacheInfo(entry);
                    pEntry.setRemoving(true);
                }
                this._cacheManager.removeEntry(context, entry, pEntry, shouldReplicate, origin, removeReason, disableSADelete);
            }
            catch (SAException e) {
                if (this._cacheManager.getEntryByUidFromPureCache(entry.getUID()) == entry) {
                    if (red != null) {
                        red.setCancelled();
                        red.getAllowFifoNotificationsForNonFifoEvents().allow();
                    }
                    entry.setDeleted(false);
                }
                throw e;
            }
            catch (RuntimeException re) {
                if (red != null) {
                    red.setCancelled();
                    red.getAllowFifoNotificationsForNonFifoEvents().allow();
                }
                throw re;
            }
            if (red != null) {
                red.getAllowFifoNotificationsForNonFifoEvents().allow();
            }
            this._cacheManager.removeFromRecentUpdatesIfNeeded(entry);
            if (((ITransactionalEntryData)entry.getEntryData()).getEntryXtnInfo() != null) {
                if (originalWF) {
                    if (entry.getXidOriginated() != null) {
                        entry.resetXidOriginated();
                    }
                    if (entry.getWriteLockOwner() != null) {
                        entry.resetWriteLockOwner();
                    }
                    if (entry.getReadLockOwners() != null && entry.getReadLockOwners().size() > 0) {
                        entry.getReadLockOwners().clear();
                    }
                } else {
                    entry.resetEntryXtnInfo();
                }
            }
            if (this._cacheManager.isFromFifoClass(entry.getServerTypeDesc())) {
                this._cacheManager.removeFifoXtnInfoForEntry(entry);
            }
            try {
                if ((fromLeaseExpiration || this._general_purpose_remove_filters) && this._filterManager._isFilter[53]) {
                    this._filterManager.invokeFilters(53, null, entry);
                }
            }
            catch (RuntimeException ex) {
                if (!this._logger.isLoggable(Level.SEVERE)) break block27;
                this._logger.log(Level.SEVERE, "Failed AFTER_REMOVE filter.", ex);
            }
        }
        if (fromLeaseExpiration && !disableProcessorCall && this._cacheManager.getTemplatesManager().anyNotifyLeaseTemplates() && entry.getWriteLockTransaction() == null) {
            this._processorWG.enqueueBlocked(new EntryExpiredBusPacket(entry, null, fromReplication));
        }
    }

    private IEntryHolder updateEntrySA(Context context, IEntryHolder entry, ITemplateHolder template, boolean fromReplication, boolean origin, IServerTypeDesc typeDesc) throws SAException {
        this._cacheManager.insertToRecentUpdatesIfNeeded(entry, this._cacheManager.requiresEvictionReplicationProtection() ? Long.MAX_VALUE : 0L, null);
        boolean shouldReplicate = false;
        if (this.isReplicated()) {
            shouldReplicate = this.shouldReplicate(ReplicationOperationType.UPDATE, typeDesc, false, fromReplication);
        }
        return this._cacheManager.updateEntry(context, entry, template, shouldReplicate, origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commitSA(TransactionManager mgr, ServerTransaction st, boolean supportsTwoPhaseReplication, OperationID operationID, boolean mayBeFromReplication) throws UnknownTransactionException, RemoteException {
        Context context = null;
        XtnInfo xtnEntry = null;
        try {
            XtnInfo xtnEntryLocked;
            context = this._cacheManager.getCacheContext();
            this.getTransactionHandler().getTimedXtns().remove(st);
            boolean lockedXtnTable = false;
            while (true) {
                boolean relock = false;
                xtnEntryLocked = xtnEntry = this.getTransaction(st);
                if (xtnEntry == null) {
                    if (!(mgr instanceof LocalTransactionManager)) throw new UnknownTransactionException("Unknown Transaction [memberName=" + this._spaceImpl.getServiceName() + "] transaction: " + st);
                    return;
                }
                try {
                    lockedXtnTable = this.getTransactionHandler().lockXtnOnXtnEnd((XtnEntry)xtnEntryLocked);
                    xtnEntry = this.getTransaction(st);
                    if (xtnEntry == xtnEntryLocked) continue;
                    relock = true;
                    continue;
                }
                finally {
                    if (!relock) break;
                    this.getTransactionHandler().unlockXtnOnXtnEnd((XtnEntry)xtnEntryLocked, lockedXtnTable);
                    continue;
                }
                break;
            }
            try {
                boolean fifoEntries;
                if (xtnEntry != null && !xtnEntry.addUsedIfPossible()) {
                    xtnEntry = null;
                }
                if (xtnEntry == null) {
                    if (!(mgr instanceof LocalTransactionManager)) throw new UnknownTransactionException("Unknown Transaction " + st);
                    return;
                }
                if (xtnEntry.getStatus() == XtnStatus.ROLLED) throw new UnknownTransactionException("Commit failed, transaction : " + st + " already rolled.");
                if (xtnEntry.getStatus() == XtnStatus.ROLLING) {
                    throw new UnknownTransactionException("Commit failed, transaction : " + st + " already rolled.");
                }
                if (xtnEntry.getStatus() == XtnStatus.COMMITING) return;
                if (xtnEntry.getStatus() == XtnStatus.COMMITED) {
                    return;
                }
                boolean bl = fifoEntries = !((XtnEntry)xtnEntry).m_SingleParticipant && ((XtnEntry)xtnEntry).anyFifoEntriesUnderXtn();
                if (!((XtnEntry)xtnEntry).m_SingleParticipant) {
                    context.setCommittingXtn(((XtnEntry)xtnEntry).m_Transaction);
                    this.getTransactionHandler().removeFromPrepared2PCXtns(xtnEntry.getServerTransaction());
                }
                if (!mayBeFromReplication) {
                    xtnEntry.setFromReplication(false);
                }
                context.setFromGateway(xtnEntry.isFromGateway());
                if (!((XtnEntry)xtnEntry).m_SingleParticipant) {
                    ((XtnEntry)xtnEntry).m_CommitRollbackTimeStamp = SystemTime.timeMillis();
                }
                this._cacheManager.prepare(context, (XtnEntry)xtnEntry, supportsTwoPhaseReplication, false, !((XtnEntry)xtnEntry).m_SingleParticipant);
                this._cacheManager.preCommit(context, (XtnEntry)xtnEntry, supportsTwoPhaseReplication);
                if (((XtnEntry)xtnEntry).m_AnyUpdates && !((XtnEntry)xtnEntry).m_SingleParticipant) {
                    this.handleUnderXtnUpdates(context, (XtnEntry)xtnEntry, true);
                }
                long currentFifoXtn = -1L;
                if (fifoEntries) {
                    currentFifoXtn = this._cacheManager.getLatestTTransactionTerminationNum();
                    if (++currentFifoXtn < 0L) {
                        currentFifoXtn = 1L;
                    }
                    this._cacheManager.setFifoXtnNumber((XtnEntry)xtnEntry, currentFifoXtn);
                    this._coreProcessor.handleLockedFifoEntriesBeforeXtnEnd(context, (XtnEntry)xtnEntry, false);
                }
                boolean considerNotifyFifoForNonFifoEvents = false;
                if (!((XtnEntry)xtnEntry).m_SingleParticipant) {
                    considerNotifyFifoForNonFifoEvents = this._coreProcessor.handleNotifyFifoInCommit(context, (XtnEntry)xtnEntry, true);
                }
                if (!((XtnEntry)xtnEntry).m_SingleParticipant) {
                    this._fifoGroupsHandler.prepareForFifoGroupsAfterXtnScans(context, (XtnEntry)xtnEntry);
                }
                context.setOperationID(operationID);
                this._cacheManager.commit(context, (XtnEntry)xtnEntry, ((XtnEntry)xtnEntry).m_SingleParticipant, ((XtnEntry)xtnEntry).m_AnyUpdates, supportsTwoPhaseReplication);
                xtnEntry.setStatus(XtnStatus.COMMITING);
                if (!((XtnEntry)xtnEntry).m_SingleParticipant && ((XtnEntry)xtnEntry).getXtnData().anyFifoGroupOperations()) {
                    this._cacheManager.handleFifoGroupsCacheOnXtnEnd(context, (XtnEntry)xtnEntry);
                }
                if (!((XtnEntry)xtnEntry).m_SingleParticipant) {
                    this._coreProcessor.handleCommittedTakenEntries(context, (XtnEntry)xtnEntry);
                }
                if (considerNotifyFifoForNonFifoEvents) {
                    ((XtnEntry)xtnEntry).getAllowFifoNotificationsForNonFifoEntries().allow();
                }
                xtnEntry.setStatus(XtnStatus.COMMITED);
                if (fifoEntries && currentFifoXtn != -1L) {
                    this._cacheManager.setLatestTransactionTerminationNum(currentFifoXtn);
                }
                if (fifoEntries) {
                    this._coreProcessor.handleLockedFifoEntriesOnXtnEnd(context, (XtnEntry)xtnEntry, false);
                }
                if (fifoEntries) {
                    this._coreProcessor.handleNotifyFifoInCommit(context, (XtnEntry)xtnEntry, false);
                }
            }
            finally {
                this.getTransactionHandler().unlockXtnOnXtnEnd((XtnEntry)xtnEntryLocked, lockedXtnTable);
            }
            if (this.getTransactionHandler().isLightTransaction((XtnEntry)xtnEntry)) {
                try {
                    this._coreProcessor.handleCommitSA(new CommitBusPacket((XtnEntry)xtnEntry));
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            this._processorWG.enqueueBlocked(new CommitBusPacket((XtnEntry)xtnEntry));
            return;
        }
        catch (SAException ex) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, ex.toString(), ex);
            }
            if (this._spaceImpl.isAborted()) {
                throw new RemoteException("Can not commit transaction - space is aborting", ex);
            }
            if (xtnEntry != null && xtnEntry.getStatus() == XtnStatus.PREPARED) {
                xtnEntry.setStatus(XtnStatus.ERROR);
                this.abort(mgr, st, supportsTwoPhaseReplication, null);
            }
            JSpaceUtilities.throwEngineInternalSpaceException(ex.getMessage() + " aborting transaction", ex);
            return;
        }
        finally {
            this.replicateAndfreeCacheContextTxn(context, st);
        }
    }

    public boolean isReplicated() {
        return this._isReplicated;
    }

    public boolean isReplicatedPersistentBlobstore() {
        return this._isReplicatedPersistentBlobstore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void abortSA(TransactionManager mgr, ServerTransaction st, boolean fromLeaseExpiration, boolean verifyExpiredXtn, boolean supportsTwoPhaseReplication, OperationID operationID) throws UnknownTransactionException {
        Context context = null;
        XtnEntry xtnEntry = null;
        try {
            XtnEntry xtnEntryLocked;
            context = this._cacheManager.getCacheContext();
            boolean lockedXtnTable = false;
            while (true) {
                boolean relock = false;
                xtnEntryLocked = xtnEntry = this.getTransaction(st);
                if (xtnEntry == null) {
                    if (mgr instanceof LocalTransactionManager && !fromLeaseExpiration) {
                        return;
                    }
                    this.getTransactionHandler().addToPhantomGlobalXtns(st);
                    throw new UnknownTransactionException();
                }
                try {
                    lockedXtnTable = this.getTransactionHandler().lockXtnOnXtnEnd(xtnEntryLocked);
                    xtnEntry = this.getTransaction(st);
                    if (xtnEntry == xtnEntryLocked) continue;
                    relock = true;
                    continue;
                }
                finally {
                    if (!relock) break;
                    this.getTransactionHandler().unlockXtnOnXtnEnd(xtnEntryLocked, lockedXtnTable);
                    continue;
                }
                break;
            }
            try {
                if (xtnEntry != null && !xtnEntry.addUsedIfPossible()) {
                    xtnEntry = null;
                }
                if (xtnEntry == null) {
                    if (!(mgr instanceof LocalTransactionManager)) throw new UnknownTransactionException();
                    if (fromLeaseExpiration) throw new UnknownTransactionException();
                    return;
                }
                if (verifyExpiredXtn) {
                    Long Llimit = this.getTransactionHandler().getTimedXtns().get(st);
                    if (Llimit == null) {
                        return;
                    }
                    long limit = Llimit;
                    if (SystemTime.timeMillis() <= limit) {
                        return;
                    }
                    if (!xtnEntry.m_Active && !xtnEntry.isFromGateway()) {
                        return;
                    }
                }
                boolean fifoEntries = xtnEntry.anyFifoEntriesUnderXtn();
                this.getTransactionHandler().getTimedXtns().remove(st);
                XtnStatus status = xtnEntry.checkAndGetState_Granular();
                if (status == XtnStatus.COMMITING) return;
                if (status == XtnStatus.COMMITED) return;
                if (status == XtnStatus.ROLLING) return;
                if (status == XtnStatus.ROLLED) return;
                if (xtnEntry.m_SingleParticipant) {
                    if (status == XtnStatus.PREPARED) return;
                    if (status == XtnStatus.PREPARING) {
                        return;
                    }
                }
                if (!xtnEntry.m_SingleParticipant && xtnEntry.m_AlreadyPrepared) {
                    this.getTransactionHandler().removeFromPrepared2PCXtns(xtnEntry.getServerTransaction());
                }
                context.setOperationID(operationID);
                context.setFromGateway(xtnEntry.isFromGateway());
                this._cacheManager.rollback(context, xtnEntry, xtnEntry.m_AlreadyPrepared, xtnEntry.m_AnyUpdates, supportsTwoPhaseReplication);
                xtnEntry.m_Active = false;
                if (xtnEntry.m_AnyUpdates) {
                    this.handleUnderXtnUpdates(context, xtnEntry, false);
                }
                xtnEntry.m_CommitRollbackTimeStamp = SystemTime.timeMillis();
                long currentFifoXtn = -1L;
                if (fifoEntries) {
                    currentFifoXtn = this._cacheManager.getLatestTTransactionTerminationNum();
                    if (++currentFifoXtn < 0L) {
                        currentFifoXtn = 1L;
                    }
                    this._cacheManager.setFifoXtnNumber(xtnEntry, currentFifoXtn);
                    this._coreProcessor.handleLockedFifoEntriesBeforeXtnEnd(context, xtnEntry, true);
                }
                xtnEntry.setStatus(XtnStatus.ROLLING);
                if (xtnEntry.getXtnData().anyFifoGroupOperations()) {
                    this._cacheManager.handleFifoGroupsCacheOnXtnEnd(context, xtnEntry);
                }
                this._fifoGroupsHandler.prepareForFifoGroupsAfterXtnScans(context, xtnEntry);
                boolean new_entries_deleted = false;
                if (!xtnEntry.m_AlreadyPrepared) {
                    this._coreProcessor.handleNewRolledbackEntries(context, xtnEntry);
                    new_entries_deleted = true;
                }
                xtnEntry.setStatus(XtnStatus.ROLLED);
                if (fifoEntries && currentFifoXtn != -1L) {
                    this._cacheManager.setLatestTransactionTerminationNum(currentFifoXtn);
                }
                if (fifoEntries) {
                    this._coreProcessor.handleLockedFifoEntriesOnXtnEnd(context, xtnEntry, true);
                }
                if (!new_entries_deleted) {
                    this._coreProcessor.handleNewRolledbackEntries(context, xtnEntry);
                }
            }
            finally {
                this.getTransactionHandler().unlockXtnOnXtnEnd(xtnEntryLocked, lockedXtnTable);
            }
            if (this.getTransactionHandler().isLightTransaction(xtnEntry)) {
                try {
                    this._coreProcessor.handleRollbackSA(new RollbackBusPacket(xtnEntry));
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            this._processorWG.enqueueBlocked(new RollbackBusPacket(xtnEntry));
            return;
        }
        catch (SAException ex) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, ex.toString(), ex);
            }
            JSpaceUtilities.throwEngineInternalSpaceException(ex.getMessage(), ex);
            return;
        }
        finally {
            this._cacheManager.freeCacheContext(context);
        }
    }

    public XtnEntry getTransaction(ServerTransaction st) {
        ServerTransaction internalTx;
        XtnEntry xtnEntry = this.getTransactionHandler().getXtnTable().get(st);
        if (xtnEntry != null && (internalTx = xtnEntry.getXtnData().getXtn()) != null) {
            internalTx.setMetaData(st.getMetaData());
        }
        return xtnEntry;
    }

    void cancelLocalXtn(TransactionManager mgr, ServerTransaction st) throws UnknownLeaseException {
        if (!(mgr instanceof LocalTransactionManagerImpl)) {
            throw new RuntimeException("cancel local xtn lease: invalid transaction manager");
        }
        LocalTransactionManagerImpl ltx = (LocalTransactionManagerImpl)mgr;
        try {
            this.abortSA(mgr, st, true, false, false, null);
        }
        catch (UnknownTransactionException ex) {
            throw new UnknownLeaseException("cancel:unknown transaction at space-server transaction-id= " + st + " manager=" + ltx.getManagerID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renewXtn(ServerTransaction st, long time) throws LeaseDeniedException, UnknownLeaseException {
        XtnEntry xtnEntry = this.getTransaction(st);
        if (xtnEntry == null) {
            if (time <= 0L || time == Long.MAX_VALUE || time == -1L) {
                this.getTransactionHandler().getTimedXtns().remove(st);
            } else {
                this.getTransactionHandler().renewTransactionLease(st, time);
            }
            return;
        }
        xtnEntry.lock();
        boolean decrementUsed = true;
        try {
            if (!xtnEntry.m_Active) {
                decrementUsed = false;
                throw new LeaseDeniedException("renew:transaction not active any more at space-server transaction= " + st);
            }
            if (!xtnEntry.addUsedIfPossible()) {
                decrementUsed = false;
            }
            if (time <= 0L || time == Long.MAX_VALUE || time == -1L) {
                this.getTransactionHandler().getTimedXtns().remove(st);
            } else {
                this.getTransactionHandler().renewTransactionLease(st, time);
            }
        }
        finally {
            if (decrementUsed) {
                xtnEntry.decrementUsed();
            }
            xtnEntry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void handleUnderXtnUpdates(Context context, XtnEntry xtnEntry, boolean isCommitting) throws SAException {
        iter = null;
        entryLock = null;
        pXtn = xtnEntry.getXtnData();
        iter = this._cacheManager.makeUnderXtnEntriesIter(context, xtnEntry, 2);
        if (iter == null) {
            return;
        }
        while (true) lbl-1000:
        // 16 sources

        {
            block27: {
                if ((eh = (IEntryHolder)iter.next()) == null) {
                    return;
                }
                var8_8 = entryLock = this._cacheManager.getLockManager().getLockObject(eh);
                // MONITORENTER : var8_8
                if (eh.isDeleted()) {
                    // MONITOREXIT : var8_8
                    if (entryLock == null) continue;
                    this._cacheManager.getLockManager().freeLockObject(entryLock);
                    entryLock = null;
                    continue;
                }
                if (this._leaseManager.isNoReapUnderXtnLeases() || !eh.isExpired() || this._leaseManager.isSlaveLeaseManagerForEntries() || this.isExpiredEntryStayInSpace(eh)) break block27;
                if (entryLock == null) continue;
                this._cacheManager.getLockManager().freeLockObject(entryLock);
                entryLock = null;
                continue;
            }
            if (eh.getWriteLockOwner() == null || eh.getWriteLockOwner() != xtnEntry) {
                // MONITOREXIT : var8_8
                if (entryLock == null) continue;
                this._cacheManager.getLockManager().freeLockObject(entryLock);
                entryLock = null;
                continue;
            }
            if (eh.getWriteLockOperation() == 2 || eh.getWriteLockOperation() == 3) {
                // MONITOREXIT : var8_8
                if (entryLock == null) continue;
                this._cacheManager.getLockManager().freeLockObject(entryLock);
                entryLock = null;
                continue;
            }
            context.setOperationID(pXtn.getOperationID(eh.getUID()));
            if (isCommitting) ** GOTO lbl59
            if (eh.getWriteLockOperation() != 7 && eh.getWriteLockOperation() != 4 && eh.getWriteLockOperation() != 5) {
                // MONITOREXIT : var8_8
                if (entryLock == null) continue;
                this._cacheManager.getLockManager().freeLockObject(entryLock);
                entryLock = null;
                continue;
            }
            if (eh.getXidOriginated() == xtnEntry) {
                // MONITOREXIT : var8_8
                if (entryLock == null) continue;
                this._cacheManager.getLockManager().freeLockObject(entryLock);
                entryLock = null;
                continue;
            }
            try {
                block28: {
                    if (eh.hasShadow(true)) {
                        this._cacheManager.handleUnderXtnUpdate(context, xtnEntry.m_Transaction, eh, isCommitting, pXtn);
                    }
                    break block28;
lbl59:
                    // 1 sources

                    if (eh.getWriteLockOperation() != 1 && eh.hasShadow(true)) {
                        this._cacheManager.handleUnderXtnUpdate(context, xtnEntry.m_Transaction, eh, isCommitting, pXtn);
                    }
                }
                // MONITOREXIT : var8_8
            }
            finally {
                if (entryLock == null) ** GOTO lbl-1000
                this._cacheManager.getLockManager().freeLockObject(entryLock);
                entryLock = null;
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    private XtnConfilctCheckIndicators checkTransactionConflict(Context context, IEntryHolder entry, ITemplateHolder template, boolean isShadow) {
        if (!(template.getTemplateOperation() != 2 && template.getTemplateOperation() != 3 || template.isExclusiveReadLockOperation())) {
            ITransactionalEntryData edata = context.isNonBlockingReadOp() ? context.getLastRawMatchSnapshot() : entry.getTxnEntryData();
            XtnEntry xtnEntry = edata.getWriteLockOwner();
            if (xtnEntry == null) {
                return XtnConfilctCheckIndicators.NO_CONFLICT;
            }
            XtnStatus entryWriteLockStatus = xtnEntry.getStatus();
            int entryWriteLockOperation = edata.getWriteLockOperation();
            boolean isDirtyRead = this.indicateDirtyRead(template);
            boolean isReadCommitted = this.indicateReadCommitted(edata, template);
            if (template.getXidOriginatedTransaction() == null || !edata.getWriteLockTransaction().equals((Object)template.getXidOriginatedTransaction())) {
                if (isDirtyRead) {
                    return this.checkTransactionConflictDirtyRead(context, xtnEntry, entryWriteLockStatus, entryWriteLockOperation, entry, edata, isShadow);
                }
                if (isReadCommitted) {
                    return this.checkTransactionConflictReadCommitted(context, xtnEntry, entryWriteLockStatus, entryWriteLockOperation, entry, edata, isShadow);
                }
                return this.checkTransactionConflict(xtnEntry, entryWriteLockStatus, entryWriteLockOperation);
            }
            if (entryWriteLockOperation == 4 || entryWriteLockOperation == 5) {
                return XtnConfilctCheckIndicators.DELETED_BY_OWN_XTN;
            }
            if (isReadCommitted && isShadow) {
                return XtnConfilctCheckIndicators.XTN_CONFLICT;
            }
            return XtnConfilctCheckIndicators.NO_CONFLICT;
        }
        if (template.getTemplateOperation() == 5 || template.getTemplateOperation() == 4) {
            XtnEntry xtnEntry;
            List<XtnEntry> readWriteLock = entry.getReadLockOwners();
            if (entry.getWriteLockTransaction() == null && (readWriteLock == null || readWriteLock.isEmpty())) {
                return XtnConfilctCheckIndicators.NO_CONFLICT;
            }
            if (readWriteLock != null && !readWriteLock.isEmpty()) {
                for (XtnEntry readLockOwner : readWriteLock) {
                    XtnStatus entryReadLockStatus;
                    xtnEntry = readLockOwner;
                    if (xtnEntry == null || (entryReadLockStatus = xtnEntry.getStatus()) == XtnStatus.COMMITED || entryReadLockStatus == XtnStatus.COMMITING || entryReadLockStatus == XtnStatus.PREPARED && xtnEntry.m_SingleParticipant || entryReadLockStatus == XtnStatus.ROLLED || entryReadLockStatus == XtnStatus.ROLLING && !xtnEntry.m_AlreadyPrepared || template.getXidOriginatedTransaction() != null && readLockOwner.m_Transaction.equals((Object)template.getXidOriginatedTransaction())) continue;
                    return XtnConfilctCheckIndicators.XTN_CONFLICT;
                }
            }
            if ((xtnEntry = entry.getWriteLockOwner()) == null) {
                return XtnConfilctCheckIndicators.NO_CONFLICT;
            }
            XtnStatus entryWriteLockStatus = xtnEntry.getStatus();
            int entryWriteLockOperation = entry.getWriteLockOperation();
            if (template.getXidOriginatedTransaction() == null || !entry.getWriteLockTransaction().equals((Object)template.getXidOriginatedTransaction())) {
                return this.checkTransactionConflict(xtnEntry, entryWriteLockStatus, entryWriteLockOperation);
            }
            if (entryWriteLockOperation == 4 || entryWriteLockOperation == 5) {
                return XtnConfilctCheckIndicators.DELETED_BY_OWN_XTN;
            }
            return XtnConfilctCheckIndicators.NO_CONFLICT;
        }
        if (template.getTemplateOperation() == 7 || template.isExclusiveReadLockOperation()) {
            XtnEntry xtnEntry;
            List<XtnEntry> rwLock = entry.getReadLockOwners();
            if (entry.getWriteLockTransaction() == null && (rwLock == null || rwLock.isEmpty())) {
                return XtnConfilctCheckIndicators.NO_CONFLICT;
            }
            if (rwLock != null && !rwLock.isEmpty()) {
                for (XtnEntry readLockOwner : rwLock) {
                    XtnStatus entryReadLockStatus;
                    xtnEntry = readLockOwner;
                    if (xtnEntry == null || (entryReadLockStatus = xtnEntry.getStatus()) == XtnStatus.COMMITED || entryReadLockStatus == XtnStatus.COMMITING || entryReadLockStatus == XtnStatus.PREPARED && xtnEntry.m_SingleParticipant || entryReadLockStatus == XtnStatus.ROLLED || entryReadLockStatus == XtnStatus.ROLLING && !xtnEntry.m_AlreadyPrepared || template.getXidOriginatedTransaction() != null && readLockOwner.m_Transaction.equals((Object)template.getXidOriginatedTransaction())) continue;
                    return XtnConfilctCheckIndicators.XTN_CONFLICT;
                }
            }
            if ((xtnEntry = entry.getWriteLockOwner()) == null) {
                return XtnConfilctCheckIndicators.NO_CONFLICT;
            }
            XtnStatus entryWriteLockStatus = xtnEntry.getStatus();
            int entryWriteLockOperation = entry.getWriteLockOperation();
            if (template.getXidOriginatedTransaction() == null || !entry.getWriteLockTransaction().equals((Object)template.getXidOriginatedTransaction())) {
                return this.checkTransactionConflict(xtnEntry, entryWriteLockStatus, entryWriteLockOperation);
            }
            if (entryWriteLockOperation == 4 || entryWriteLockOperation == 5) {
                return UpdateModifiers.isUpdateOrWrite(template.getOperationModifiers()) ? XtnConfilctCheckIndicators.NO_CONFLICT : XtnConfilctCheckIndicators.DELETED_BY_OWN_XTN;
            }
            if (template.isFifoGroupPoll() && xtnEntry == template.getXidOriginated() && template.isExclusiveReadLockOperation()) {
                return XtnConfilctCheckIndicators.DELETED_BY_OWN_XTN;
            }
            return XtnConfilctCheckIndicators.NO_CONFLICT;
        }
        return XtnConfilctCheckIndicators.NO_CONFLICT;
    }

    private XtnConfilctCheckIndicators checkTransactionConflict(XtnEntry xtnEntry, XtnStatus entryWriteLockStatus, int entryWriteLockOperation) {
        if (!(entryWriteLockOperation != 4 && entryWriteLockOperation != 5 || entryWriteLockStatus != XtnStatus.ROLLED && (entryWriteLockStatus != XtnStatus.ROLLING || xtnEntry.m_AlreadyPrepared))) {
            return XtnConfilctCheckIndicators.NO_CONFLICT;
        }
        if ((entryWriteLockOperation == 4 || entryWriteLockOperation == 5) && (entryWriteLockStatus == XtnStatus.COMMITED || entryWriteLockStatus == XtnStatus.COMMITING || entryWriteLockStatus == XtnStatus.PREPARED && xtnEntry.m_SingleParticipant)) {
            return XtnConfilctCheckIndicators.ENTRY_DELETED;
        }
        if (entryWriteLockOperation == 1 && (entryWriteLockStatus == XtnStatus.COMMITED || entryWriteLockStatus == XtnStatus.COMMITING || entryWriteLockStatus == XtnStatus.PREPARED && xtnEntry.m_SingleParticipant)) {
            return XtnConfilctCheckIndicators.NO_CONFLICT;
        }
        if ((entryWriteLockOperation == 7 || entryWriteLockOperation == 2 || entryWriteLockOperation == 3) && (entryWriteLockStatus == XtnStatus.COMMITED || entryWriteLockStatus == XtnStatus.COMMITING || entryWriteLockStatus == XtnStatus.PREPARED && xtnEntry.m_SingleParticipant)) {
            return XtnConfilctCheckIndicators.NO_CONFLICT;
        }
        if (!(entryWriteLockOperation != 7 && entryWriteLockOperation != 2 && entryWriteLockOperation != 3 || entryWriteLockStatus != XtnStatus.ROLLED && (entryWriteLockStatus != XtnStatus.ROLLING || xtnEntry.m_AlreadyPrepared))) {
            return XtnConfilctCheckIndicators.NO_CONFLICT;
        }
        return XtnConfilctCheckIndicators.XTN_CONFLICT;
    }

    private XtnConfilctCheckIndicators checkTransactionConflictReadCommitted(Context context, XtnEntry xtnEntry, XtnStatus entryWriteLockStatus, int entryWriteLockOperation, IEntryHolder entry, ITransactionalEntryData edata, boolean isShadow) {
        if (isShadow) {
            return XtnConfilctCheckIndicators.NO_CONFLICT;
        }
        if (!context.isNonBlockingReadOp() ? entry.hasShadow(true) : edata.getOtherUpdateUnderXtnEntry() != null) {
            return XtnConfilctCheckIndicators.XTN_CONFLICT;
        }
        if ((entryWriteLockOperation == 4 || entryWriteLockOperation == 5) && (entryWriteLockStatus == XtnStatus.COMMITED || entryWriteLockStatus == XtnStatus.COMMITING || entryWriteLockStatus == XtnStatus.PREPARED && xtnEntry.m_SingleParticipant)) {
            if (context.isNonBlockingReadOp()) {
                ITransactionalEntryData curedata = entry.getTxnEntryData();
                if (curedata.getWriteLockOwner() == null && !entry.isDeleted()) {
                    return XtnConfilctCheckIndicators.NO_CONFLICT;
                }
                if (curedata.getWriteLockOwner() != null && (curedata.getWriteLockOwner() != edata.getWriteLockOwner() || curedata.getWriteLockOperation() != entryWriteLockOperation)) {
                    return XtnConfilctCheckIndicators.NO_CONFLICT;
                }
            }
            return XtnConfilctCheckIndicators.ENTRY_DELETED;
        }
        if (entryWriteLockOperation == 1 && (xtnEntry.m_Active || xtnEntry.getStatus() == XtnStatus.PREPARING || xtnEntry.getStatus() == XtnStatus.PREPARED && !xtnEntry.m_SingleParticipant)) {
            return XtnConfilctCheckIndicators.XTN_CONFLICT;
        }
        if (entryWriteLockOperation == 1 && (entryWriteLockStatus == XtnStatus.ROLLED || entryWriteLockStatus == XtnStatus.ROLLING && !xtnEntry.m_AlreadyPrepared)) {
            return XtnConfilctCheckIndicators.ENTRY_DELETED;
        }
        return XtnConfilctCheckIndicators.NO_CONFLICT;
    }

    private XtnConfilctCheckIndicators checkTransactionConflictDirtyRead(Context context, XtnEntry xtnEntry, XtnStatus entryWriteLockStatus, int entryWriteLockOperation, IEntryHolder entry, ITransactionalEntryData edata, boolean isShadow) {
        if (isShadow) {
            return XtnConfilctCheckIndicators.XTN_CONFLICT;
        }
        if (!(entryWriteLockOperation != 4 && entryWriteLockOperation != 5 || entryWriteLockStatus != XtnStatus.ROLLED && (entryWriteLockStatus != XtnStatus.ROLLING || xtnEntry.m_AlreadyPrepared))) {
            return XtnConfilctCheckIndicators.NO_CONFLICT;
        }
        if (entryWriteLockOperation == 4 || entryWriteLockOperation == 5) {
            return XtnConfilctCheckIndicators.XTN_CONFLICT;
        }
        return XtnConfilctCheckIndicators.NO_CONFLICT;
    }

    public void aggregate(ITemplatePacket queryPacket, List<SpaceEntriesAggregator> aggregators, int readModifiers, SpaceContext sc) throws Exception {
        if (Modifiers.contains(readModifiers, 0x10000000)) {
            throw new UnsupportedOperationException("Sql explain plan is not supported for aggregation");
        }
        AggregateOperationContext batchContext = new AggregateOperationContext(queryPacket, Integer.MAX_VALUE, 1);
        AnswerHolder ah = this.readMultiple(queryPacket, null, 0L, false, false, sc, false, readModifiers, batchContext, aggregators);
        if (ah != null && ah.getException() != null) {
            throw ah.getException();
        }
    }

    public int countIncomingConnections() throws RemoteException {
        if (this.isLocalCache()) {
            return 0;
        }
        IRemoteSpace dynamicProxy = (IRemoteSpace)((LRMISpaceImpl)this._spaceImpl.getSpaceStub()).getDynamicProxy();
        long remoteObjID = TransportProtocolHelper.getRemoteObjID(dynamicProxy);
        return remoteObjID != 0L ? LRMIRuntime.getRuntime().countRemoteObjectConnections(remoteObjID) : 0;
    }

    public void getAdmin(SpaceContext sc) throws RemoteException {
        try {
            this._filterManager.invokeFilters(5, sc, null);
        }
        catch (RuntimeException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new RemoteException(e2.getMessage(), e2);
        }
    }

    public ClusterPolicy getClusterPolicy() {
        return this._clusterPolicy;
    }

    Object[] getReplicationStatus() {
        this.monitorMemoryUsage(false);
        if (this._clusterPolicy == null) {
            throw new RuntimeException("changeReplicationState- space is not clustered.");
        }
        if (!this.isReplicated()) {
            throw new RuntimeException("changeReplicationState- space is not a member of any replication group.");
        }
        return this.getReplicationNode().getAdmin().getStatus();
    }

    public void beforeAuthentication(SecurityContext securityContext) throws RemoteException {
        try {
            if (this._filterManager._isFilter[6]) {
                SpaceContext sc = new SpaceContext(securityContext);
                this._filterManager.invokeFilters(6, sc, null);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RemoteException("Exception occurred invoking before-authentication filter", e);
        }
    }

    public ISpaceCopyReplicaState spaceCopyReplica(SpaceURL sourceRemoteUrl, String sourceMemberName, IRemoteSpace remoteJSpace, ITemplatePacket templPacket, boolean includeNotifyTemplates, int chunkSize, SpaceContext sc, SpaceContext remoteSpaceContext) {
        if (remoteJSpace == null) {
            throw new EngineInternalSpaceException("Remote space for : " + sourceRemoteUrl + " can not be null!");
        }
        if (this._filterManager._isFilter[0]) {
            this._filterManager.invokeFilters(0, sc, templPacket);
        }
        int concurrentConsumers = 1;
        if (this.getClusterPolicy() != null && this.getClusterPolicy().getReplicationPolicy() != null) {
            concurrentConsumers = this.getClusterPolicy().getReplicationPolicy().getRecoveryThreadPoolSize();
        }
        long recoveryStartTime = SystemTime.timeMillis();
        ISpaceSynchronizeReplicaRequestContext context = this.createReplicateSpaceContext(sourceRemoteUrl, chunkSize, concurrentConsumers, templPacket, includeNotifyTemplates, false, remoteSpaceContext, SpaceCopyReplicaParameters.ReplicaType.COPY);
        ISpaceCopyReplicaState spaceCopyReplica = this.getReplicationNode().spaceCopyReplicaRequest(context);
        try {
            this.waitForCopyResultAndLogStatus(sourceRemoteUrl, recoveryStartTime, spaceCopyReplica, false);
        }
        catch (InterruptedException ex) {
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.log(Level.WARNING, "", ex);
            }
            return FailedSyncSpaceReplicateState.createFailedSyncState(ex);
        }
        return spaceCopyReplica;
    }

    private void waitForCopyResultAndLogStatus(SpaceURL sourceRemoteUrl, long recoveryStartTime, ISpaceCopyReplicaState spaceCopyReplica, boolean spaceSyncOperation) throws InterruptedException {
        Exception error;
        ISpaceCopyResult result = spaceCopyReplica.waitForCopyResult();
        if (!this._spaceImpl.isPrimary()) {
            ((ReplicationNode)this._replicationManager.getReplicationNode()).getReplicaHandler().clearFifoBatchesHandler();
        }
        Level level = result.isSuccessful() ? Level.INFO : Level.WARNING;
        Exception exception = error = result.isSuccessful() ? null : result.getFailureReason();
        if (this._logger.isLoggable(level)) {
            this._logger.log(level, result.getStringDescription(sourceRemoteUrl.getMemberName(), sourceRemoteUrl.toString(), this._fullSpaceName, spaceSyncOperation, SystemTime.timeMillis() - recoveryStartTime), error);
        }
    }

    public String generateGroupName() {
        if (!this.isReplicated()) {
            return null;
        }
        int staticPartitionNumber = this.getPartitionIdOneBased();
        if (staticPartitionNumber == 0) {
            staticPartitionNumber = 1;
        }
        return ReplicationNodeConfigBuilder.getInstance().getSynchronizeGroupName(this._clusterInfo, staticPartitionNumber, this._fullSpaceName);
    }

    public ISpaceSynchronizeReplicaState spaceSynchronizeReplica(SpaceURL sourceRemoteUrl, int chunkSize, boolean transientOnly, boolean memoryOnly) {
        long recoveryStartTime = SystemTime.timeMillis();
        String groupName = this.generateGroupName();
        long findTimeout = 0L;
        int concurrentConsumers = 1;
        if (this.getClusterPolicy().getReplicationPolicy() != null) {
            findTimeout = this.getClusterPolicy().getReplicationPolicy().m_SpaceFinderTimeout;
            concurrentConsumers = this.getClusterPolicy().getReplicationPolicy().getRecoveryThreadPoolSize();
        } else if (this.getClusterPolicy().m_FailOverPolicy != null) {
            findTimeout = this.getClusterPolicy().m_FailOverPolicy.spaceFinderTimeout;
        }
        sourceRemoteUrl.setProperty("timeout", String.valueOf(findTimeout));
        if (this.getCacheManager().isEmptyAfterInitialLoadStage() && this.getSpaceImpl().isBackup() && this.getSpaceImpl().getDirectPersistencyRecoveryHelper() != null) {
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("[" + this.getFullSpaceName() + "] setting storage state of backup to Inconsistent before recovery from primary");
            }
            this.getSpaceImpl().getDirectPersistencyRecoveryHelper().setStorageState(StorageConsistencyModes.Inconsistent);
        }
        boolean directPersistencySyncListRecovery = this.getReplicationNode().getDirectPesistencySyncHandler() != null && !this.getCacheManager().isEmptyAfterInitialLoadStage();
        DirectPersistencySyncListFetcher directPersistencySyncListFetcher = null;
        if (directPersistencySyncListRecovery) {
            try {
                directPersistencySyncListFetcher = new DirectPersistencySyncListFetcher(this._spaceImpl.getSpaceStub());
                Iterator<String> entriesForRecovery = this.getReplicationNode().getDirectPesistencySyncHandler().getEntriesForRecovery();
                DirectPersistencyBackupSyncIteratorHandler directPersistencyBackupSyncIteratorHandler = new DirectPersistencyBackupSyncIteratorHandler(entriesForRecovery);
                this.getReplicationNode().setDirectPersistencyBackupSyncIteratorHandler(new DirectPersistencyBackupSyncIteratorHandler(entriesForRecovery));
                if (this._logger.isLoggable(Level.INFO)) {
                    this._logger.info(this.getSpaceName() + " performing direct persistency sync list recovery, batch size is: " + directPersistencyBackupSyncIteratorHandler.getBatchSize());
                }
            }
            catch (RemoteException e) {
                return FailedSyncSpaceReplicateState.createFailedSyncState(e);
            }
        }
        ISpaceSynchronizeReplicaRequestContext context = this.createReplicateSpaceContext(sourceRemoteUrl, null, true, transientOnly, memoryOnly, null, SpaceCopyReplicaParameters.ReplicaType.SYNCRONIZE, groupName, chunkSize, concurrentConsumers, this.getCacheManager().isBlobStoreCachePolicy(), directPersistencySyncListRecovery ? directPersistencySyncListFetcher : null);
        ISpaceSynchronizeReplicaState spaceSynchronizeReplicaRequest = this.getReplicationNode().spaceSynchronizeReplicaRequest(context);
        try {
            this.waitForCopyResultAndLogStatus(sourceRemoteUrl, recoveryStartTime, spaceSynchronizeReplicaRequest, true);
            return spaceSynchronizeReplicaRequest;
        }
        catch (InterruptedException ex) {
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.log(Level.WARNING, "", ex);
            }
            return FailedSyncSpaceReplicateState.createFailedSyncState(ex);
        }
    }

    public ISpaceCopyReplicaState spaceBroadcastNotifyTemplatesReplica(SpaceURL sourceRemoteUrl, int chunkSize, boolean transientOnly) throws InterruptedException {
        long recoveryStartTime = SystemTime.timeMillis();
        ISpaceSynchronizeReplicaRequestContext context = this.createReplicateSpaceContext(sourceRemoteUrl, chunkSize, 1, null, true, transientOnly, null, SpaceCopyReplicaParameters.ReplicaType.BROADCAST_NOTIFY_TEMPLATES_COPY);
        ISpaceCopyReplicaState spaceCopyReplicaRequest = this.getReplicationNode().spaceCopyReplicaRequest(context);
        this.waitForCopyResultAndLogStatus(sourceRemoteUrl, recoveryStartTime, spaceCopyReplicaRequest, true);
        return spaceCopyReplicaRequest;
    }

    public void rollbackCopyReplica(ISpaceCopyResult replicaResult) {
        this.getReplicationNode().rollbackCopyReplica(replicaResult);
    }

    private ISpaceSynchronizeReplicaRequestContext createReplicateSpaceContext(SpaceURL sourceRemoteUrl, int chunkSize, int concurrentConsumers, ITemplatePacket template, boolean includeNotifyTemplate, boolean transientOnly, SpaceContext remoteSpaceContent, SpaceCopyReplicaParameters.ReplicaType replicaType) {
        return this.createReplicateSpaceContext(sourceRemoteUrl, template, includeNotifyTemplate, transientOnly, transientOnly, remoteSpaceContent, replicaType, null, chunkSize, concurrentConsumers);
    }

    private ISpaceSynchronizeReplicaRequestContext createReplicateSpaceContext(SpaceURL sourceRemoteUrl, ITemplatePacket template, boolean includeNotifyTemplate, boolean transientOnly, boolean memoryOnly, SpaceContext remoteSpaceContent, SpaceCopyReplicaParameters.ReplicaType replicaType, String synchronizeGroupName, int fetchBatchSize, int concurrentConsumers) {
        return this.createReplicateSpaceContext(sourceRemoteUrl, template, includeNotifyTemplate, transientOnly, memoryOnly, remoteSpaceContent, replicaType, synchronizeGroupName, fetchBatchSize, concurrentConsumers, false);
    }

    private ISpaceSynchronizeReplicaRequestContext createReplicateSpaceContext(SpaceURL sourceRemoteUrl, ITemplatePacket template, boolean includeNotifyTemplate, boolean transientOnly, boolean memoryOnly, SpaceContext remoteSpaceContent, SpaceCopyReplicaParameters.ReplicaType replicaType, String synchronizeGroupName, int fetchBatchSize, int concurrentConsumers, boolean isBlobstore) {
        return this.createReplicateSpaceContext(sourceRemoteUrl, template, includeNotifyTemplate, transientOnly, memoryOnly, remoteSpaceContent, replicaType, synchronizeGroupName, fetchBatchSize, concurrentConsumers, isBlobstore, null);
    }

    private ISpaceSynchronizeReplicaRequestContext createReplicateSpaceContext(SpaceURL sourceRemoteUrl, ITemplatePacket template, boolean includeNotifyTemplate, boolean transientOnly, boolean memoryOnly, SpaceContext remoteSpaceContent, SpaceCopyReplicaParameters.ReplicaType replicaType, String synchronizeGroupName, int fetchBatchSize, int concurrentConsumers, boolean isBlobstore, DirectPersistencySyncListFetcher fetcher) {
        SpaceSynchronizeReplicaRequestContext context = new SpaceSynchronizeReplicaRequestContext();
        context.setOriginUrl(sourceRemoteUrl);
        context.setFetchBatchSize(fetchBatchSize);
        context.setConcurrentConsumers(concurrentConsumers);
        if (isBlobstore && Long.getLong("com.gs.replication.replicaProgressTimeout") == null) {
            context.setProgressTimeout(context.getProgressTimeout() * 3L);
        }
        SpaceCopyReplicaParameters parameters = new SpaceCopyReplicaParameters();
        parameters.setCopyNotifyTemplates(includeNotifyTemplate);
        parameters.addTemplatePacket(template);
        parameters.setTransient(transientOnly);
        parameters.setMemoryOnly(memoryOnly);
        parameters.setIncludeEvictionReplicationMarkers(this._cacheManager.requiresEvictionReplicationProtection());
        parameters.setReplicaType(replicaType);
        parameters.setSpaceContext(remoteSpaceContent);
        if (fetcher != null) {
            parameters.setSynchronizationListFetcher(fetcher);
        }
        context.setParameters(parameters);
        context.setSynchronizeGroupName(synchronizeGroupName);
        return context;
    }

    public ITypeDesc getClassTypeInfo(String className) {
        if (className == null) {
            throw new RuntimeException("getClassTypeInfo : invalid class name (null)");
        }
        IServerTypeDesc severTTE = this._typeManager.getServerTypeDesc(className);
        if (severTTE != null) {
            return severTTE.getTypeDesc();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmptyPersistent() throws SAException {
        ISAdapterIterator<IEntryHolder> entriesIterSA;
        Context context;
        block5: {
            block4: {
                boolean bl;
                context = null;
                try {
                    if (this._cacheManager.getTemplatesManager().isEmpty()) break block4;
                    bl = false;
                    this._cacheManager.freeCacheContext(context);
                }
                catch (Throwable throwable) {
                    this._cacheManager.freeCacheContext(context);
                    throw throwable;
                }
                return bl;
            }
            ITemplateHolder tHolder = TemplateHolderFactory.createEmptyTemplateHolder(this, this._uidFactory.createUIDFromCounter(), Long.MAX_VALUE, false);
            IServerTypeDesc templateType = this._typeManager.getServerTypeDesc(IServerTypeDesc.ROOT_TYPE_NAME);
            context = this._cacheManager.getCacheContext();
            entriesIterSA = this._cacheManager.makeEntriesIter(context, tHolder, templateType, 0L, SystemTime.timeMillis(), false);
            if (entriesIterSA != null) break block5;
            boolean bl = true;
            this._cacheManager.freeCacheContext(context);
            return bl;
        }
        IEntryHolder eh = entriesIterSA.next();
        entriesIterSA.close();
        boolean bl = eh == null;
        this._cacheManager.freeCacheContext(context);
        return bl;
    }

    public final boolean isSyncReplicationEnabled() {
        return this._isSyncReplication;
    }

    public final boolean isMirrorService() {
        return this._replicationManager.isMirrorService();
    }

    public boolean isTransactionalSA() {
        return false;
    }

    private void performReplIfChunkReached(Context context) {
        if (this.isReplicated()) {
            int maxMultipleOperChunkSize = this._clusterPolicy.m_ReplicationPolicy.m_SyncReplPolicy.getMultipleOperationChunkSize();
            IReplicationOutContext replicationContext = context.getReplicationContext();
            if (maxMultipleOperChunkSize > 0 && replicationContext != null && replicationContext.pendingSize() >= maxMultipleOperChunkSize) {
                this.performReplication(context);
            }
        }
    }

    public int performReplication(Context context) {
        IReplicationOutContext replicationContext;
        if (context.isActiveBlobStoreBulk() && this._cacheManager.isDirectPersistencyEmbeddedtHandlerUsed() && !context.isFromReplication()) {
            context.getBlobStoreBulkInfo().bulk_flush(context, false, false);
        }
        if ((replicationContext = context.getReplicationContext()) != null) {
            return context.getReplicationContext().setCompleted(this.getReplicationNode().execute(replicationContext));
        }
        return 0;
    }

    public boolean isEntryFromPartition(IEntryHolder entryHolder) {
        Object routingValue = entryHolder.getRoutingValue();
        if (routingValue == null) {
            return false;
        }
        if (!this._clusterInfo.isPartitioned()) {
            return true;
        }
        int partitionId = PartitionedClusterUtils.getPartitionId(routingValue, this._clusterInfo.getNumberOfPartitions());
        return partitionId == this._partitionId;
    }

    public boolean isPartitionedSpace() {
        return this._clusterInfo.isPartitioned();
    }

    private void replicateAndfreeCacheContextTxn(Context context, ServerTransaction transaction) {
        block2: {
            try {
                this.replicateAndfreeCache(context);
            }
            catch (RuntimeException ex) {
                if (!this._logger.isLoggable(Level.SEVERE)) break block2;
                this._logger.log(Level.SEVERE, "Failed to perform sync-replication on transactionId: " + transaction, ex);
            }
        }
    }

    private int replicateAndfreeCache(Context context) {
        if (context != null) {
            try {
                int n = this.performReplication(context);
                return n;
            }
            finally {
                this._cacheManager.freeCacheContext(context);
            }
        }
        return 0;
    }

    private boolean isReplicatedFromCentralDB(Context ctx) {
        return this._cacheManager.isCacheExternalDB() && this._cacheManager.isCentralDB() && ctx.isFromReplication();
    }

    public CacheManager getCacheManager() {
        return this._cacheManager;
    }

    public final MemoryManager getMemoryManager() {
        return this._memoryManager;
    }

    public List<ISpaceComponentsHandler> getComponentsHandlers() {
        LinkedList<ISpaceComponentsHandler> handlers = new LinkedList<ISpaceComponentsHandler>();
        if (this._filterManager != null) {
            handlers.add(this._filterManager);
        }
        if (this.isReplicated()) {
            handlers.add(this._replicationManager.getReplicationFilterManager());
        }
        return handlers;
    }

    public int getNumberOfPartitions() {
        return this._numberOfPartitions;
    }

    public int getPartitionIdOneBased() {
        return this._partitionId + 1;
    }

    public int getPartitionIdZeroBased() {
        return this._partitionId;
    }

    public String getSpaceName() {
        return this._spaceName;
    }

    public String getFullSpaceName() {
        return this._fullSpaceName;
    }

    public long getLastEntryTimestamp() {
        return this._lastEntryTimestamp;
    }

    public void setLastEntryTimestamp(long timestamp) {
        this._lastEntryTimestamp = timestamp;
    }

    public void touchLastEntryTimestamp() {
        this._lastEntryTimestamp = SystemTime.timeMillis();
    }

    public boolean isColdStart() {
        return this._coldStart;
    }

    public boolean isMemoryRecoveryEnabled() {
        return this._memoryRecoveryEnabled;
    }

    public TransactionHandler getTransactionHandler() {
        return this._transactionHandler;
    }

    private ILockObject getTemplateLockObject(ITemplateHolder template) {
        return this._cacheManager.getLockManager().getLockObject(template, false);
    }

    private void freeTemplateLockObject(ILockObject lockObject) {
        this._cacheManager.getLockManager().freeLockObject(lockObject);
    }

    public List<FilterProvider> getInternalFilters() {
        LinkedList<FilterProvider> filters = new LinkedList<FilterProvider>();
        if (this.supportsGuaranteedNotifications()) {
            filters.add(new NotifyAcknowledgeFilter(this));
        }
        return filters;
    }

    public boolean supportsGuaranteedNotifications() {
        return this._clusterPolicy != null && this._clusterPolicy.isPrimaryElectionAvailable() && EventSessionConfig.USE_OLD_GUARANTEED_NOTIFICATIONS;
    }

    public Object directLocalReadById(Object id, String typeName, QueryResultTypeInternal queryResultType) {
        if (!this._isLocalCache) {
            throw new EngineInternalSpaceException("Supported only in local cache");
        }
        IServerTypeDesc serverTypeDesc = this._typeManager.getServerTypeDesc(typeName);
        if (serverTypeDesc == null) {
            return null;
        }
        Object res = null;
        boolean noUid = true;
        if (serverTypeDesc.isActive()) {
            if (serverTypeDesc.getTypeDesc().getIdPropertyName() == null) {
                return null;
            }
            if (serverTypeDesc.getTypeDesc().isAutoGenerateId()) {
                noUid = false;
            }
            IEntryHolder entryHolder = noUid ? this._cacheManager.getEntryByIdFromPureCache(id, serverTypeDesc) : this.directLocalReadByUidForClass((String)id, typeName);
            res = this.getUserObjectFromEntryHolder(entryHolder, queryResultType);
        }
        if (res != null || !noUid) {
            return res;
        }
        IServerTypeDesc[] subTypes = serverTypeDesc.getAssignableTypes();
        for (int i = 1; i < subTypes.length; ++i) {
            IServerTypeDesc subType = this._typeManager.getServerTypeDesc(subTypes[i].getTypeName());
            if (subType == null || subType.isInactive()) continue;
            if (subType.getTypeDesc().getIdPropertyName() == null) {
                return null;
            }
            IEntryHolder entryHolder = this._cacheManager.getEntryByIdFromPureCache(id, subType);
            res = this.getUserObjectFromEntryHolder(entryHolder, queryResultType);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private IEntryHolder directLocalReadByUidForClass(String uid, String className) {
        try {
            return this._cacheManager.getEntry(null, uid, className, null, false, false, true);
        }
        catch (Exception ex) {
            throw new EngineInternalSpaceException(ex.toString(), ex);
        }
    }

    private Object getUserObjectFromEntryHolder(IEntryHolder entryHolder, QueryResultTypeInternal expectedResultType) {
        if (entryHolder == null) {
            return null;
        }
        ITransactionalEntryData entryData = entryHolder.getTxnEntryData();
        if (entryData.getEntryDataType() != EntryDataType.USER_TYPE) {
            return null;
        }
        EntryType entryType = expectedResultType.getEntryType();
        if (entryType == null) {
            entryType = entryData.getEntryTypeDesc().getTypeDesc().getObjectType();
        }
        if (entryType != entryData.getEntryTypeDesc().getEntryType()) {
            return null;
        }
        return ((UserTypeEntryData)entryData).getUserObject();
    }

    private boolean canReplicate(boolean disableReplication, boolean fromReplication) {
        return !fromReplication && !disableReplication;
    }

    public boolean shouldReplicate(ReplicationOperationType operType, IServerTypeDesc serverTypeDesc, boolean disableReplication, boolean fromReplication) {
        return this.shouldReplicate(operType, serverTypeDesc.getTypeDesc().isReplicable(), disableReplication, fromReplication);
    }

    public boolean shouldReplicate(ReplicationOperationType operType, boolean ofReplicatableClass, boolean disableReplication, boolean fromReplication) {
        if (!this.canReplicate(disableReplication, fromReplication)) {
            return false;
        }
        boolean replicableOper = this._clusterPolicy.m_ReplicationPolicy.shouldReplicate(operType);
        return replicableOper && (this._clusterPolicy.m_ReplicationPolicy.isFullReplication() || ofReplicatableClass);
    }

    public IReplicationNode getReplicationNode() {
        return this._replicationManager.getReplicationNode();
    }

    public boolean isCleanUnusedEmbeddedGlobalXtns() {
        return this._spaceImpl._cleanUnusedEmbeddedGlobalXtns;
    }

    @Override
    public void afterSpaceModeChange(SpaceMode newMode) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("afterSpaceModeChange(newMode=" + (Object)((Object)newMode) + ")");
        }
        if (newMode == SpaceMode.PRIMARY) {
            if (this._spaceImpl.isRecovering()) {
                this._failOverDuringRecovery = true;
            }
            if (this._memoryManager != null && this._memoryManager.isRestartOnFailover()) {
                this._memoryManager.close();
                this._memoryManager = new MemoryManager(this._spaceName, this._containerName, this._cacheManager, this._leaseManager, this._spaceImpl.isPrimary());
            }
        }
    }

    @Override
    public void beforeSpaceModeChange(SpaceMode newMode) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("beforeSpaceModeChange(newMode=" + (Object)((Object)newMode) + ")");
        }
        switch (newMode) {
            case PRIMARY: {
                this._duplicateOperationIDFilter.onBecomePrimary();
                this.getReplicationNode().getAdmin().setActive();
                break;
            }
            case BACKUP: {
                this._duplicateOperationIDFilter.onBecomeBackup();
                this.getReplicationNode().getAdmin().setPassive(true);
            }
        }
    }

    public boolean isClusteredExternalDBEnabled(IStorageAdapter storageAdapter) {
        return storageAdapter.supportsExternalDB() && this._clusterPolicy.m_CacheLoaderConfig.externalDataSource && !this._clusterPolicy.m_CacheLoaderConfig.centralDataSource || this.hasMirror();
    }

    public List<Throwable> getUnhealthyReasons() {
        LinkedList<Throwable> errors = new LinkedList<Throwable>();
        if (this._spaceImpl.getSpaceMode() == SpaceMode.BACKUP && this._replicationUnhealthyReason != null) {
            errors.add(this._replicationUnhealthyReason);
        }
        if (this._unhealthyReason != null) {
            errors.add(this._unhealthyReason);
        }
        return errors;
    }

    public SpaceReplicationManager getReplicationManager() {
        return this._replicationManager;
    }

    public int getProcessorQueueSize() {
        return this._processorWG.getQueue().size();
    }

    public int getNotifierQueueSize() {
        return this._dataEventManager.getQueueSize();
    }

    private String getOrCreateUid(IEntryPacket entryPacket) {
        String uid = entryPacket.getUID();
        if (uid == null) {
            ITypeDesc typeDesc = entryPacket.getTypeDescriptor();
            String idPropertyName = typeDesc.getIdPropertyName();
            if (idPropertyName == null || idPropertyName.length() == 0) {
                uid = this.generateUid();
            } else {
                int identifierPos = typeDesc.getIdentifierPropertyId();
                Object idValue = entryPacket.getFieldValue(identifierPos);
                if (typeDesc.isAutoGenerateId()) {
                    uid = (String)idValue;
                    if (uid == null || uid.length() == 0) {
                        uid = this.generateUid();
                    }
                } else if (idValue != null) {
                    uid = ClientUIDHandler.createUIDFromName(idValue.toString(), typeDesc.getTypeName());
                } else {
                    throw new ConversionException("SpaceId(autogenerate=false) field value can't be null.");
                }
            }
        }
        return uid;
    }

    private static String extractMemberIdFromContainer(SpaceImpl spaceImpl) {
        if (spaceImpl.getClusterPolicy() == null) {
            return null;
        }
        String container = spaceImpl.getContainerName();
        if (container == null || container.length() == 0) {
            return null;
        }
        String partitionPrefix = "_container";
        int pos = container.indexOf("_container");
        return pos == -1 ? null : container.substring(pos + "_container".length());
    }

    public String generateUid() {
        return this._uidFactory.generateUid();
    }

    public void setReplicationUnhealthyReason(Exception cause) {
        this._replicationUnhealthyReason = cause;
    }

    public ConflictingOperationPolicy getConflictingOperationPolicy() {
        if (this._conflictingOperationPolicy == null) {
            this._conflictingOperationPolicy = this._clusterPolicy != null && this._clusterPolicy.getReplicationPolicy().getConflictingOperationPolicy() != null ? this._clusterPolicy.getReplicationPolicy().getConflictingOperationPolicy() : ConflictingOperationPolicy.DEFAULT;
        }
        return this._conflictingOperationPolicy;
    }

    public FifoGroupsHandler getFifoGroupsHandler() {
        return this._fifoGroupsHandler;
    }

    public void enableDuplicateExecutionProtection(OperationID operationID) {
        if (operationID != null) {
            this._duplicateOperationIDFilter.add(operationID);
        }
    }

    private boolean disqualifyExpiredEntry(IEntryHolder entry) {
        return !entry.isEntryUnderWriteLockXtn() && !this._leaseManager.isSlaveLeaseManagerForEntries() && !this.isExpiredEntryStayInSpace(entry);
    }

    public boolean isExpiredEntryStayInSpace(IEntryHolder entry) {
        return this._cacheManager.isEvictableCachePolicy() && !entry.isTransient() && !this._cacheManager.isMemorySpace();
    }

    public boolean isFailOverDuringRecovery() {
        return this._failOverDuringRecovery;
    }

    public boolean isLocalCache() {
        return this._isLocalCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTypeDesc(ITypeDesc typeDesc, boolean fromGateway) throws DetailedUnusableEntryException {
        AddTypeDescResult result = this.getTypeManager().addTypeDesc(typeDesc);
        if (result.getResultType() == AddTypeDescResultType.NONE) {
            return;
        }
        IReplicationOutContext context = this.getReplicationNode().createContext();
        if (fromGateway) {
            ((ReplicationOutContext)context).setFromGateway(true);
        }
        try {
            this.getCacheManager().getStorageAdapter().introduceDataType(typeDesc);
            this.getReplicationNode().outDataTypeIntroduce(context, typeDesc);
            this.getReplicationNode().execute(context);
        }
        finally {
            context.release();
        }
    }

    public LocalViewRegistrations getLocalViewRegistrations() {
        return this._localViewRegistrations;
    }

    public MetricRegistrator getMetricRegistrator() {
        return this._metricRegistrator;
    }

    public void registerLocalView(ITemplatePacket[] queryPackets, Collection<SpaceQueryDetails> queryDescriptions, RouterStubHolder viewStub, int batchSize, long batchTimeout, SpaceContext spaceContext) throws UnusableEntryException, UnknownTypeException {
        IReplicationNodeAdmin replicationNodeAdmin = this.getReplicationNode().getAdmin();
        replicationNodeAdmin.getRouterAdmin().addRemoteRouterStub(viewStub);
        String groupName = this.generateGroupName();
        DynamicSourceGroupConfigHolder groupConfig = replicationNodeAdmin.getSourceGroupConfigHolder(groupName);
        for (ITemplatePacket template : queryPackets) {
            this.getTypeManager().loadServerTypeDesc(template);
            this.getSpaceImpl().assertAuthorizedForType(template.getTypeName(), SpaceAuthority.SpacePrivilege.READ, spaceContext);
        }
        String uniqueName = viewStub.getMyEndpointDetails().getLookupName();
        groupConfig.removeMember(uniqueName);
        ViewReplicationChannelDataFilter viewFilter = new ViewReplicationChannelDataFilter(this._cacheManager, groupName, queryPackets, this.getTemplateScanner().getRegexCache(), this.getTypeManager());
        BacklogMemberLimitationConfig memberBacklogLimitations = new BacklogMemberLimitationConfig();
        ReplicationPolicy replicationPolicy = this.getClusterPolicy().getReplicationPolicy();
        long limit = replicationPolicy.getLocalViewMaxRedologCapacity();
        memberBacklogLimitations.setLimit(limit, BacklogConfig.LimitReachedPolicy.DROP_MEMBER);
        long localViewMaxDisconnectionTime = replicationPolicy.getLocalViewMaxDisconnectionTime();
        long localViewMaxRedologRecoveryCapacity = replicationPolicy.getLocalViewMaxRedologRecoveryCapacity();
        memberBacklogLimitations.setLimitDuringSynchronization(localViewMaxRedologRecoveryCapacity, BacklogConfig.LimitReachedPolicy.DROP_MEMBER);
        AsyncChannelConfig config = new AsyncChannelConfig(batchSize, batchTimeout, batchSize, ReplicationStatistics.ReplicationMode.LOCAL_VIEW, localViewMaxDisconnectionTime);
        ViewDynamicSourceGroupMemberLifeCycle lifecycle = new ViewDynamicSourceGroupMemberLifeCycle(this._localViewRegistrations, queryDescriptions, viewStub.getMyEndpointDetails().getConnectionDetails());
        groupConfig.addMember(uniqueName, viewFilter, memberBacklogLimitations, config, lifecycle);
    }

    public void unregisterLocalView(String viewStubHolderName) {
        IReplicationNodeAdmin replicationNodeAdmin = this.getReplicationNode().getAdmin();
        String groupName = this.generateGroupName();
        DynamicSourceGroupConfigHolder groupConfig = replicationNodeAdmin.getSourceGroupConfigHolder(groupName);
        groupConfig.removeMember(viewStubHolderName);
        replicationNodeAdmin.getRouterAdmin().removeRemoteStubHolder(viewStubHolderName);
        this._localViewRegistrations.remove(viewStubHolderName);
    }

    private boolean isBlobStoreCachePolicy() {
        return this._configReader.getIntSpaceProperty("engine.cache_policy", "-1") == 3;
    }

    public boolean isBlobStorePersistent() {
        return this.isBlobStoreCachePolicy() && Boolean.parseBoolean(this._spaceImpl.getCustomProperties().getProperty("space-config.engine.blobstore_persistent"));
    }

    public SpaceClusterInfo getClusterInfo() {
        return this._clusterInfo;
    }

    private void monitorMemoryUsage(boolean isWriteTypeOperation) {
        if (this._memoryManager != null) {
            this._memoryManager.monitorMemoryUsage(isWriteTypeOperation);
        }
    }

    public Logger getLogger() {
        return this._logger;
    }

    static {
        TEMPLATE_DELETED_EXCEPTION = new TemplateDeletedException(null);
        ENTRY_DELETED_EXCEPTION = new EntryDeletedException();
        NO_MATCH_EXCEPTION = new NoMatchException(null);
        TX_CONFLICT_EXCEPTION = new TransactionConflictException(null, null);
        EMPTY_ENTRYPACKET = new EntryPacket();
        EMPTY_ENTRYPACKET.setFieldsValues(new Object[0]);
    }

    public static enum TemplateRemoveReasonCodes {
        OPERATED_OR_TIMEDOUT,
        LEASE_CANCEL,
        LEASE_EXPIRED;

    }

    public static enum EntryRemoveReasonCodes {
        TAKE,
        EVICT,
        LEASE_CANCEL,
        LEASE_EXPIRED;

    }

    private static enum XtnConfilctCheckIndicators {
        NO_CONFLICT,
        XTN_CONFLICT,
        ENTRY_DELETED,
        DELETED_BY_OWN_XTN;

    }
}

