/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaConsumeFacade;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SpaceEngineReplicaConsumerFacade
implements ISpaceReplicaConsumeFacade {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.replica");
    private final SpaceEngine _spaceEngine;

    public SpaceEngineReplicaConsumerFacade(SpaceEngine spaceEngine) {
        this._spaceEngine = spaceEngine;
    }

    @Override
    public void addTypeDesc(ITypeDesc typeDescriptor) throws Exception {
        this._spaceEngine.getTypeManager().addTypeDesc(typeDescriptor);
        if (this._spaceEngine.getCacheManager().isBlobStoreCachePolicy()) {
            this._spaceEngine.getCacheManager().getStorageAdapter().introduceDataType(typeDescriptor);
        }
    }

    @Override
    public void write(IEntryPacket entryPacket, IMarker evictionMarker, SpaceCopyReplicaParameters.ReplicaType replicaType) throws Exception {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this._spaceEngine.getReplicationNode() + " inserting entry " + entryPacket);
        }
        if (evictionMarker != null && this._spaceEngine.getCacheManager().requiresEvictionReplicationProtection()) {
            this._spaceEngine.getCacheManager().getEvictionReplicationsMarkersRepository().insert(entryPacket.getUID(), evictionMarker, false);
        }
        this._spaceEngine.write(entryPacket, null, entryPacket.getTTL(), 0, this._spaceEngine.isReplicated(), replicaType == SpaceCopyReplicaParameters.ReplicaType.COPY, null);
    }

    @Override
    public void remove(String uidToRemove, IMarker evictionMarker, SpaceCopyReplicaParameters.ReplicaType replicaType) throws Exception {
        throw new UnsupportedOperationException("remove operation is not supported in SpaceEngineReplicaConsumerFacade");
    }

    @Override
    public GSEventRegistration insertNotifyTemplate(ITemplatePacket templatePacket, String templateUid, NotifyInfo notifyInfo) throws Exception {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this._spaceEngine.getReplicationNode() + " inserting notify template " + templatePacket);
        }
        return this._spaceEngine.notify(templatePacket, templatePacket.getTTL(), this._spaceEngine.isReplicated(), templateUid, null, notifyInfo);
    }
}

