/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaConsumeFacade;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.j_spaces.core.UpdateOrWriteContext;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SpaceEngineReplicaDirectPersistencySyncConsumerFacade
implements ISpaceReplicaConsumeFacade {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.replica");
    private final SpaceEngine _spaceEngine;

    public SpaceEngineReplicaDirectPersistencySyncConsumerFacade(SpaceEngine spaceEngine) {
        this._spaceEngine = spaceEngine;
    }

    @Override
    public void remove(String uidToRemove, IMarker evictionMarker, SpaceCopyReplicaParameters.ReplicaType replicaType) throws Exception {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this._spaceEngine.getReplicationNode() + " removing entry with uid: " + uidToRemove);
        }
        if (!this._spaceEngine.getCacheManager().isEntryInPureCache(uidToRemove)) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this._spaceEngine.getReplicationNode() + " the entry with uid: " + uidToRemove + " does not exists, will not be deleted");
            }
            return;
        }
        ITemplatePacket template = TemplatePacketFactory.createUidPacket(uidToRemove, 0, true);
        this._spaceEngine.read(template, null, 0L, true, true, null, true, true, replicaType == SpaceCopyReplicaParameters.ReplicaType.COPY, 16384);
    }

    @Override
    public GSEventRegistration insertNotifyTemplate(ITemplatePacket templatePacket, String templateUid, NotifyInfo notifyInfo) throws Exception {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this._spaceEngine.getReplicationNode() + " inserting notify template " + templatePacket);
        }
        return this._spaceEngine.notify(templatePacket, templatePacket.getTTL(), true, templateUid, null, notifyInfo);
    }

    @Override
    public void addTypeDesc(ITypeDesc typeDescriptor) throws Exception {
        this._spaceEngine.getTypeManager().addTypeDesc(typeDescriptor);
        if (this._spaceEngine.getCacheManager().isBlobStoreCachePolicy()) {
            this._spaceEngine.getCacheManager().getStorageAdapter().introduceDataType(typeDescriptor);
        }
    }

    @Override
    public void write(IEntryPacket entryPacket, IMarker evictionMarker, SpaceCopyReplicaParameters.ReplicaType replicaType) throws Exception {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this._spaceEngine.getReplicationNode() + " inserting entry " + entryPacket);
        }
        boolean exists = this._spaceEngine.getCacheManager().isEntryInPureCache(entryPacket.getUID());
        if (_logger.isLoggable(Level.FINER)) {
            String opStr = exists ? "UPDATE" : "WRITE";
            _logger.finer(this._spaceEngine.getReplicationNode() + " [" + this._spaceEngine.getFullSpaceName() + "] performing " + opStr + " operation, uid= " + entryPacket.getUID() + " ,version before operation: " + entryPacket.getVersion());
        }
        if (exists) {
            UpdateOrWriteContext ctx = new UpdateOrWriteContext(entryPacket, entryPacket.getTTL(), 0L, null, null, 528384, false, true, false);
            this._spaceEngine.updateOrWrite(ctx, true, false, false);
        } else {
            this._spaceEngine.write(entryPacket, null, entryPacket.getTTL(), 0, true, false, null);
        }
    }
}

