/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.admin.demote.DemoteFailedException;
import com.gigaspaces.admin.quiesce.DefaultQuiesceToken;
import com.gigaspaces.admin.quiesce.QuiesceException;
import com.gigaspaces.admin.quiesce.QuiesceState;
import com.gigaspaces.admin.quiesce.QuiesceStateChangedEvent;
import com.gigaspaces.annotation.SupportCodeChange;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ReadTakeByIdResult;
import com.gigaspaces.client.ReadTakeByIdsException;
import com.gigaspaces.client.WriteMultipleException;
import com.gigaspaces.client.protective.ProtectiveModeException;
import com.gigaspaces.client.transaction.xa.GSServerTransaction;
import com.gigaspaces.cluster.ClusterFailureDetector;
import com.gigaspaces.cluster.activeelection.ElectionInProcessException;
import com.gigaspaces.cluster.activeelection.ISpaceComponentsHandler;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.InactiveSpaceException;
import com.gigaspaces.cluster.activeelection.LeaderSelector;
import com.gigaspaces.cluster.activeelection.LeaderSelectorHandler;
import com.gigaspaces.cluster.activeelection.LeaderSelectorHandlerConfig;
import com.gigaspaces.cluster.activeelection.LusBasedSelectorHandler;
import com.gigaspaces.cluster.activeelection.PrimarySpaceModeListeners;
import com.gigaspaces.cluster.activeelection.SpaceComponentManager;
import com.gigaspaces.cluster.activeelection.SpaceComponentsInitializeException;
import com.gigaspaces.cluster.activeelection.SpaceInitializationIndicator;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionException;
import com.gigaspaces.cluster.replication.ConsistencyLevelViolationException;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.executor.SpaceTask;
import com.gigaspaces.executor.SpaceTaskWrapper;
import com.gigaspaces.grid.zone.ZoneHelper;
import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.gigaspaces.internal.client.spaceproxy.DirectSpaceProxyFactoryImpl;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.client.spaceproxy.executors.SystemTask;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceConnectRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceConnectResult;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyBackupSyncIteratorHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySyncListBatch;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyReplicaState;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeResult;
import com.gigaspaces.internal.document.DocumentObjectConverterInternal;
import com.gigaspaces.internal.exceptions.BatchQueryException;
import com.gigaspaces.internal.exceptions.WriteResultImpl;
import com.gigaspaces.internal.extension.XapExtensions;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMHelper;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.lrmi.stubs.LRMISpaceImpl;
import com.gigaspaces.internal.lrmi.stubs.LRMIStubHandlerImpl;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.naming.LookupNamingService;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSHelper;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.query.explainplan.SingleExplainPlan;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.RemoteOperationResult;
import com.gigaspaces.internal.server.space.BatchQueryOperationContext;
import com.gigaspaces.internal.server.space.CompositeSpaceModeListener;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.server.space.ReadByIdsContext;
import com.gigaspaces.internal.server.space.ReadMultipleContext;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.TakeMultipleContext;
import com.gigaspaces.internal.server.space.ZookeeperLastPrimaryHandler;
import com.gigaspaces.internal.server.space.demote.DemoteHandler;
import com.gigaspaces.internal.server.space.executors.SpaceActionExecutor;
import com.gigaspaces.internal.server.space.operations.SpaceOperationsExecutor;
import com.gigaspaces.internal.server.space.operations.WriteEntriesResult;
import com.gigaspaces.internal.server.space.operations.WriteEntryResult;
import com.gigaspaces.internal.server.space.quiesce.QuiesceHandler;
import com.gigaspaces.internal.server.space.recovery.RecoveryManager;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DirectPersistencyRecoveryHelper;
import com.gigaspaces.internal.server.space.recovery.strategy.SpaceRecoverStrategy;
import com.gigaspaces.internal.server.space.suspend.SuspendTypeChangedInternalListener;
import com.gigaspaces.internal.service.ServiceRegistrationException;
import com.gigaspaces.internal.space.responses.SpaceResponseInfo;
import com.gigaspaces.internal.transaction.DefaultTransactionUniqueId;
import com.gigaspaces.internal.transaction.XATransactionUniqueId;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.ITransportPacket;
import com.gigaspaces.internal.utils.ReplaceInFileUtils;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.lrmi.ILRMIProxy;
import com.gigaspaces.lrmi.LRMIMethodMetadata;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.OperationPriority;
import com.gigaspaces.lrmi.TransportProtocolHelper;
import com.gigaspaces.lrmi.classloading.LRMIClassLoadersHolder;
import com.gigaspaces.lrmi.nio.AbstractResponseContext;
import com.gigaspaces.lrmi.nio.DefaultResponseHandler;
import com.gigaspaces.lrmi.nio.IResponseContext;
import com.gigaspaces.lrmi.nio.IResponseHandler;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.ResponseContext;
import com.gigaspaces.lrmi.nio.async.IFuture;
import com.gigaspaces.lrmi.nio.async.LRMIFuture;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoHelper;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.management.space.LocalCacheDetails;
import com.gigaspaces.management.space.LocalViewDetails;
import com.gigaspaces.management.transport.ITransportConnection;
import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.gigaspaces.security.service.SecurityContext;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.gigaspaces.server.space.suspend.SuspendType;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.time.SystemTime;
import com.gigaspaces.transaction.TransactionUniqueId;
import com.gigaspaces.utils.Pair;
import com.j_spaces.core.AbstractIdsQueryPacket;
import com.j_spaces.core.AnswerHolder;
import com.j_spaces.core.AnswerPacket;
import com.j_spaces.core.Constants;
import com.j_spaces.core.CreateException;
import com.j_spaces.core.DropClassException;
import com.j_spaces.core.ExtendedAnswerHolder;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.IStubHandler;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.JSpaceContainerImpl;
import com.j_spaces.core.JSpaceState;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.LeaseInitializer;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.SpaceConfigFactory;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceContextHelper;
import com.j_spaces.core.SpaceCopyStatus;
import com.j_spaces.core.SpaceCopyStatusImpl;
import com.j_spaces.core.SpaceHealthStatus;
import com.j_spaces.core.SpaceRecoveryException;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.UnknownTypesException;
import com.j_spaces.core.UpdateOrWriteContext;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.JSpaceAdminImpl;
import com.j_spaces.core.admin.RuntimeHolder;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.admin.TemplateInfo;
import com.j_spaces.core.client.BasicTypeInfo;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.IJSpaceProxyListener;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceSettings;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.client.TransactionInfo;
import com.j_spaces.core.client.UnderTxnLockedObject;
import com.j_spaces.core.client.UpdateModifiers;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.core.cluster.startup.ReplicationStartupManager;
import com.j_spaces.core.exception.SpaceAlreadyStartedException;
import com.j_spaces.core.exception.SpaceAlreadyStoppedException;
import com.j_spaces.core.exception.SpaceCleanedException;
import com.j_spaces.core.exception.SpaceStoppedException;
import com.j_spaces.core.exception.SpaceUnavailableException;
import com.j_spaces.core.exception.StatisticsNotAvailable;
import com.j_spaces.core.filters.FiltersInfo;
import com.j_spaces.core.filters.ISpaceFilter;
import com.j_spaces.core.filters.JSpaceStatistics;
import com.j_spaces.core.filters.RuntimeStatisticsHolder;
import com.j_spaces.core.filters.StatisticsContext;
import com.j_spaces.core.filters.StatisticsHolder;
import com.j_spaces.core.server.processor.UpdateOrWriteBusPacket;
import com.j_spaces.core.service.AbstractService;
import com.j_spaces.core.service.Service;
import com.j_spaces.jdbc.IQueryProcessor;
import com.j_spaces.jdbc.QueryProcessor;
import com.j_spaces.jdbc.QueryProcessorFactory;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.kernel.weaklistener.WeakDiscoveryListener;
import com.j_spaces.lookup.entry.ClusterGroup;
import com.j_spaces.lookup.entry.ClusterName;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.lookup.entry.HostName;
import com.j_spaces.lookup.entry.State;
import com.j_spaces.sadapter.datasource.DataAdaptorIterator;
import com.j_spaces.worker.WorkerManager;
import com.sun.jini.mahalo.ExtendedPrepareResult;
import com.sun.jini.start.LifeCycle;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.core.transaction.server.TransactionParticipantDataImpl;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.id.Uuid;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.entry.Name;
import net.jini.lookup.entry.ServiceInfo;
import org.jini.rio.boot.CodeChangeClassLoadersManager;
import org.jini.rio.boot.ServiceClassLoader;
import org.jini.rio.boot.SpaceInstanceRemoteClassLoaderInfo;
import org.jini.rio.boot.SupportCodeChangeAnnotationContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@InternalApi
public class SpaceImpl
extends AbstractService
implements IRemoteSpace,
IInternalRemoteJSpaceAdmin,
DiscoveryListener,
TransactionParticipant,
StatisticsAdmin {
    protected static final String COMPONENT = "com.gigaspaces.javaspace";
    private final String _spaceName;
    private final String _containerName;
    private final JSpaceContainerImpl _container;
    private final SpaceURL _url;
    private final JSpaceAttributes _jspaceAttr;
    private final Properties _customProperties;
    private final ClusterPolicy _clusterPolicy;
    private final SpaceClusterInfo _clusterInfo;
    private final boolean _secondary;
    private final String _instanceId;
    private final String _nodeName;
    private final Logger _logger;
    private final Logger _operationLogger;
    private final String _spaceMemberName;
    private final String _deployPath;
    private final SpaceConfigReader _configReader;
    private final boolean _isLusRegEnabled;
    private final JSpaceState _spaceState;
    private final int _serializationType;
    public final boolean _cleanUnusedEmbeddedGlobalXtns;
    private final SpaceOperationsExecutor _operationsExecutor;
    private final IJSpaceContainer _containerProxyRemote;
    private final SecurityInterceptor _securityInterceptor;
    private final CredentialsProvider _embeddedCredentialsProvider;
    private final QuiesceHandler _quiesceHandler;
    private final Object _cleanedLock = new Object();
    private final PrimarySpaceModeListeners primarySpaceModeListeners = new PrimarySpaceModeListeners();
    private final CompositeSpaceModeListener _internalSpaceModesListeners = new CompositeSpaceModeListener();
    private final IStubHandler _stubHandler;
    private final DemoteHandler _demoteHandler;
    private final HttpServer _httpServer;
    private SpaceConfig _spaceConfig;
    private SpaceEngine _engine;
    private SpaceProxyImpl _embeddedProxy;
    private SpaceProxyImpl _clusteredProxy;
    private SpaceProxyImpl _taskProxy;
    private IRemoteSpace _spaceStub;
    private boolean _isCleaned;
    private JSpaceStatistics _statistics;
    private AtomicBoolean _recovering = new AtomicBoolean();
    private WorkerManager _workerManager;
    private LeaderSelectorHandler _leaderSelector;
    private ReplicationStartupManager _startupManager;
    private SpaceComponentManager _componentManager;
    private RecoveryManager _recoveryManager;
    private QueryProcessor _qp;
    private volatile ClusterFailureDetector _clusterFailureDetector;
    private volatile DirectPersistencyRecoveryHelper _directPersistencyRecoveryHelper;
    private final ZookeeperLastPrimaryHandler zookeeperLastPrimaryHandler;
    private final Map<Class<? extends SystemTask>, SpaceActionExecutor> executorMap = XapExtensions.getInstance().getActionExecutors();
    private final StatisticsNotAvailable _statNotAvailableEx = new StatisticsNotAvailable("Statistics are not available, because a space statistics filter is disabled");

    public SpaceImpl(String spaceName, String containerName, JSpaceContainerImpl container, SpaceURL url, JSpaceAttributes spaceConfig, Properties customProperties, boolean isSecondary, boolean securityEnabled, LifeCycle lifeCycle) throws CreateException, RemoteException {
        super(lifeCycle);
        boolean useZooKeeper;
        this._spaceName = spaceName;
        this._containerName = containerName;
        this._spaceMemberName = JSpaceUtilities.createFullSpaceName(containerName, spaceName);
        this._container = container;
        this._url = url;
        this._jspaceAttr = spaceConfig != null ? spaceConfig : new JSpaceAttributes();
        this._customProperties = new Properties();
        this._customProperties.putAll((Map<?, ?>)customProperties);
        this._clusterPolicy = this._jspaceAttr.getClusterPolicy();
        this._clusterInfo = new SpaceClusterInfo(this._jspaceAttr, this._spaceMemberName);
        this._secondary = isSecondary;
        this._deployPath = this._customProperties.getProperty("deployPath");
        this._configReader = new SpaceConfigReader(this._spaceMemberName);
        this._instanceId = SpaceImpl.extractInstanceIdFromContainerName(containerName);
        this._nodeName = this._instanceId == "0" ? spaceName : spaceName + "." + this._instanceId;
        this._logger = Logger.getLogger("com.gigaspaces.space." + this._nodeName);
        this._operationLogger = Logger.getLogger("com.gigaspaces.space.operations." + this._nodeName);
        this._isLusRegEnabled = Boolean.valueOf(JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jini_lus.enabled", "true"));
        this._spaceState = new JSpaceState();
        this._serializationType = this.loadSerializationType();
        this._cleanUnusedEmbeddedGlobalXtns = this._configReader.getBooleanSpaceProperty("engine.clean_unused_embedded_global_xtns", "true");
        this._httpServer = this.initWebServerIfNeeded();
        this._operationsExecutor = new SpaceOperationsExecutor();
        this._containerProxyRemote = container != null ? container.getContainerProxy() : null;
        this._securityInterceptor = securityEnabled ? new SecurityInterceptor(spaceName, customProperties, true) : null;
        this._embeddedCredentialsProvider = securityEnabled ? this.extractCredentials(customProperties, spaceConfig) : null;
        this._quiesceHandler = new QuiesceHandler(this, this.getQuiesceStateChangedEvent(customProperties));
        this._demoteHandler = new DemoteHandler(this);
        this._stubHandler = new LRMIStubHandlerImpl();
        if (spaceConfig != null) {
            this.initClassLoadersManager(spaceConfig.getSupportCodeChange(), spaceConfig.getMaxClassLoaders());
        }
        this.zookeeperLastPrimaryHandler = (useZooKeeper = this.useZooKeeper()) ? new ZookeeperLastPrimaryHandler(this, this._logger) : null;
        this.startInternal();
        if (this._clusterPolicy != null && this._clusterPolicy.isPersistentStartupEnabled()) {
            this.initSpaceStartupStateManager();
        }
    }

    private HttpServer initWebServerIfNeeded() throws CreateException {
        String prefix = "com.gs.space.rest";
        boolean enabled = Boolean.getBoolean("com.gs.space.rest.enabled");
        if (!enabled) {
            return null;
        }
        int port = Integer.getInteger("com.gs.space.rest.port", 8089);
        int socketBacklog = Integer.getInteger("com.gs.space.rest.socket-backlog", 0);
        final Logger restLogger = Logger.getLogger("com.gs.space.rest");
        try {
            HttpServer server = HttpServer.create(new InetSocketAddress(port), socketBacklog);
            server.createContext("/probes/alive", new HttpHandler(){

                @Override
                public void handle(HttpExchange context) throws IOException {
                    try {
                        SpaceImpl.this.assertAvailable();
                        SpaceImpl.httpResponse(context, 200, "OK");
                        if (restLogger.isLoggable(Level.FINE)) {
                            restLogger.fine("/probes/alive result: 200 (OK)");
                        }
                    }
                    catch (SpaceUnavailableException e) {
                        SpaceImpl.httpResponse(context, 503, e.getMessage());
                        restLogger.warning("/probes/alive result: 503 (" + e.getMessage() + ")");
                    }
                }
            });
            server.setExecutor(Executors.newSingleThreadExecutor((ThreadFactory)new GSThreadFactory("WEB", true)));
            server.start();
            restLogger.info("Started rest server at " + server.getAddress());
            return server;
        }
        catch (IOException e) {
            throw new CreateException("Failed to start web server", e);
        }
    }

    private static void httpResponse(HttpExchange context, int responseCode, String response) throws IOException {
        OutputStream os = context.getResponseBody();
        if (response == null) {
            context.sendResponseHeaders(responseCode, -1L);
        } else {
            byte[] data = response.getBytes("UTF-8");
            context.sendResponseHeaders(responseCode, data.length);
            os.write(data);
        }
        os.close();
    }

    public ZookeeperLastPrimaryHandler getZookeeperLastPrimaryHandler() {
        return this.zookeeperLastPrimaryHandler;
    }

    private void initClassLoadersManager(String enableTaskReloadingStr, String maxClassLoadersStr) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader instanceof ServiceClassLoader) {
            ((ServiceClassLoader)contextClassLoader).initCodeChangeClassLoadersManager(Boolean.parseBoolean(enableTaskReloadingStr), Integer.parseInt(maxClassLoadersStr));
        } else {
            CodeChangeClassLoadersManager.initInstance((ClassLoader)contextClassLoader, (boolean)Boolean.parseBoolean(enableTaskReloadingStr), (int)Integer.parseInt(maxClassLoadersStr));
        }
    }

    @Override
    public String getContainerName() {
        return this._containerName;
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public SpaceURL getURL() {
        return this._url;
    }

    public Properties getCustomProperties() {
        return this._customProperties;
    }

    public JSpaceAttributes getJspaceAttr() {
        return this._jspaceAttr;
    }

    public JSpaceContainerImpl getContainer() {
        return this._container;
    }

    public Logger getOperationLogger() {
        return this._operationLogger;
    }

    public boolean isPrivate() {
        return this._jspaceAttr != null ? this._jspaceAttr.isPrivate() : false;
    }

    @Override
    public String getServiceName() {
        return this._spaceMemberName;
    }

    @Override
    protected String getServiceTypeDescription() {
        return "Space";
    }

    @Override
    public synchronized Object getAdmin() {
        try {
            if (this.m_adminImpl == null) {
                this.m_adminImpl = new JSpaceAdminImpl(this, this.m_adminExporter);
            }
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "Fail to create admin object", ex);
        }
        return this.m_adminImpl != null ? this.m_adminImpl.getProxy() : null;
    }

    private QuiesceStateChangedEvent getQuiesceStateChangedEvent(Properties customProperties) {
        QuiesceStateChangedEvent result = null;
        if (customProperties.containsKey("quiesce.token")) {
            String token = customProperties.getProperty("quiesce.token");
            String description = customProperties.getProperty("quiesce.description");
            result = new QuiesceStateChangedEvent(QuiesceState.QUIESCED, new DefaultQuiesceToken(token), description);
        }
        return result;
    }

    public static String extractInstanceIdFromContainerName(String containerName) {
        String containerSuffix = "_container";
        int pos = containerName.lastIndexOf("_container");
        String suffix = pos != -1 ? containerName.substring(pos + "_container".length()) : containerName;
        return suffix.length() == 0 ? "0" : suffix;
    }

    public static String extractContainerName(String fullName) {
        int pos = fullName.indexOf(":");
        return pos != -1 ? fullName.substring(0, pos) : fullName;
    }

    public static String extractInstanceId(String fullName) {
        return SpaceImpl.extractInstanceIdFromContainerName(SpaceImpl.extractContainerName(fullName));
    }

    private CredentialsProvider extractCredentials(Properties properties, JSpaceAttributes spaceAttr) {
        CredentialsProvider credentialsProvider = CredentialsProviderHelper.extractCredentials(properties);
        if (credentialsProvider != null) {
            CredentialsProviderHelper.clearCredentialsProperties(spaceAttr);
        }
        return credentialsProvider;
    }

    public boolean isSecuredSpace() {
        return this._securityInterceptor != null;
    }

    private void initSpaceStartupStateManager() throws CreateException {
        List<String> targetNames = this._clusterPolicy.m_ReplicationPolicy.m_ReplicationGroupMembersNames;
        String spaceName = this._clusterPolicy.m_ReplicationPolicy.m_OwnMemberName;
        this._startupManager = new ReplicationStartupManager(spaceName);
        for (String name : targetNames) {
            if (!name.equals(spaceName)) continue;
        }
        try {
            if (this._startupManager.shouldWait(targetNames)) {
                this._logger.info("Waiting for the first space in cluster to start");
                this._startupManager.waitForLastSpace();
            }
        }
        catch (InterruptedException e) {
            throw new CreateException("ReplicationStartupManager was interrupted", e);
        }
    }

    public SpaceEngine getEngine() {
        return this._engine;
    }

    public QuiesceHandler getQuiesceHandler() {
        return this._quiesceHandler;
    }

    public DirectPersistencyRecoveryHelper getDirectPersistencyRecoveryHelper() {
        return this._directPersistencyRecoveryHelper;
    }

    public void beforeOperation(boolean isCheckForStandBy, boolean checkQuiesceMode, SpaceContext sc) throws RemoteException {
        if (isCheckForStandBy && this._leaderSelector != null && !this._leaderSelector.isPrimary() && !SpaceInitializationIndicator.isInitializer()) {
            this.throwInactiveSpaceException();
        }
        this.assertAvailable();
        if (this._spaceState.getState() == 0 && this._leaderSelector != null && !SpaceInitializationIndicator.isInitializer()) {
            this.throwInactiveSpaceException();
        }
        try {
            this.blockIfNecessaryUntilCleaned();
        }
        catch (InterruptedException e) {
            throw new RemoteException("interrupted.", e);
        }
        try {
            if (checkQuiesceMode && this.getQuiesceHandler() != null) {
                this.getQuiesceHandler().checkAllowedOp(sc != null ? sc.getQuiesceToken() : null);
            }
        }
        catch (RuntimeException ex) {
            throw this.logException(ex);
        }
    }

    private void assertAvailable() throws SpaceUnavailableException {
        if (this._spaceState.isAborted()) {
            throw new SpaceUnavailableException(this.getServiceName(), "Space [" + this.getServiceName() + "] is not available. Shutdown or other abort operation in process.");
        }
        if (this._spaceState.isStopped() || this._engine == null) {
            throw new SpaceStoppedException(this.getServiceName(), "Space [" + this.getServiceName() + "] is in stopped state.");
        }
    }

    public void beforeTypeOperation(boolean isCheckForStandBy, SpaceContext sc, Privilege privilege, String className) throws RemoteException {
        this.beforeOperation(isCheckForStandBy, true, sc);
        if (this._securityInterceptor != null && privilege != SpaceAuthority.SpacePrivilege.NOT_SET) {
            this._securityInterceptor.intercept(SpaceContextHelper.getSecurityContext(sc), privilege, className);
        }
    }

    public void beginPacketOperation(boolean isCheckForStandBy, SpaceContext sc, Privilege privilege, ITransportPacket packet) throws RemoteException {
        this.beforeOperation(isCheckForStandBy, true, sc);
        if (this._securityInterceptor != null) {
            this._securityInterceptor.intercept(SpaceContextHelper.getSecurityContext(sc), privilege, packet != null ? packet.getTypeName() : null);
        }
    }

    private void beginBatchOperation(SpaceContext sc, Privilege privilege, ITransportPacket[] packets) throws RemoteException {
        this.beforeOperation(true, true, sc);
        if (this._securityInterceptor != null) {
            SecurityContext securityContext = SpaceContextHelper.getSecurityContext(sc);
            for (ITransportPacket packet : packets) {
                this._securityInterceptor.intercept(securityContext, privilege, packet != null ? packet.getTypeName() : null);
            }
        }
    }

    private void endPacketOperation() {
    }

    public void checkPacketAccessPrivileges(SpaceContext sc, Privilege privilege, ITransportPacket packet) {
        if (this._securityInterceptor != null) {
            this._securityInterceptor.intercept(SpaceContextHelper.getSecurityContext(sc), privilege, packet != null ? packet.getTypeName() : null);
        }
    }

    private void close() {
        if (this._workerManager != null) {
            this._workerManager.shutdown();
            this._workerManager = null;
        }
        if (this._engine != null) {
            this._engine.close();
        }
        if (this._componentManager != null) {
            this._componentManager.clear();
        }
        if (this._leaderSelector != null) {
            this._leaderSelector.removeListener(this._engine);
        }
    }

    private void destroy() {
        try {
            if (this._leaderSelector != null) {
                this._leaderSelector.terminate();
            }
            if (this.zookeeperLastPrimaryHandler != null) {
                this.zookeeperLastPrimaryHandler.closeZooKeeperAttributeStore();
            }
            if (this._qp != null) {
                this._qp.close();
            }
            this.cleanOnDestroy();
            if (this._clusterFailureDetector != null) {
                this._clusterFailureDetector.terminate();
            }
        }
        catch (Exception ex) {
            JSpaceUtilities.throwInternalSpaceException(ex.toString(), ex);
        }
        this._engine = null;
        Runtime.getRuntime().gc();
    }

    private void throwInactiveSpaceException() throws InactiveSpaceException {
        String primaryMemberName = this._leaderSelector.getPrimaryMemberName();
        if (primaryMemberName == null) {
            throw new ElectionInProcessException(this.getServiceName());
        }
        throw new InactiveSpaceException(this.getServiceName(), primaryMemberName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockIfNecessaryUntilCleaned() throws SpaceCleanedException, InterruptedException {
        if (this._isCleaned) {
            if (Thread.holdsLock(this._cleanedLock)) {
                return;
            }
            Object object = this._cleanedLock;
            synchronized (object) {
                long CLEAN_TIMEOUT = 10000L;
                while (this._isCleaned) {
                    this._cleanedLock.wait(CLEAN_TIMEOUT);
                    if (!this._isCleaned) continue;
                    throw new SpaceCleanedException(this.getServiceName(), "Clean operation timed out after " + CLEAN_TIMEOUT + " ms. for space: " + this.getServiceName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalClean(boolean isInternalUse, boolean isRestart, boolean isWarmInit) {
        if (this._isCleaned) {
            return;
        }
        if (!isInternalUse) {
            this._engine.getFilterManager().invokeFilters(8, null, null);
        }
        Object object = this._cleanedLock;
        synchronized (object) {
            try {
                this._isCleaned = true;
                this.close();
                if (this._embeddedProxy != null) {
                    this._embeddedProxy.directClean();
                }
                if (this._clusteredProxy != null) {
                    this._clusteredProxy.directClean();
                }
                if (this._engine == null) {
                    return;
                }
                this._engine = new SpaceEngine(this);
                this.initReplicationStateBasedOnActiveElection();
                this._engine.init(isWarmInit, isRestart);
                this._statistics = (JSpaceStatistics)this.getFilterObject("Statistics");
                if (!isInternalUse) {
                    try {
                        this._workerManager = this.createWorkerManager();
                    }
                    catch (RemoteException ex) {
                        JSpaceUtilities.throwInternalSpaceException("Failed to get embedded space-proxy for worker manager.", ex);
                    }
                    if (this._qp != null) {
                        this._qp.clean();
                    }
                    try {
                        this._componentManager.restartSpaceComponents();
                    }
                    catch (SpaceComponentsInitializeException e) {
                        JSpaceUtilities.throwInternalSpaceException("Failed to restart space components.", e);
                    }
                }
                LRMIClassLoadersHolder.dropAllClasses();
            }
            catch (Exception ex) {
                if (this._logger.isLoggable(Level.SEVERE)) {
                    this._logger.log(Level.SEVERE, ex.toString(), ex);
                }
                JSpaceUtilities.throwInternalSpaceException("internal error upon clean operation", ex);
            }
            finally {
                this._isCleaned = false;
                this._cleanedLock.notifyAll();
            }
        }
        Runtime.getRuntime().gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanOnDestroy() {
        if (this._isCleaned) {
            return;
        }
        Object object = this._cleanedLock;
        synchronized (object) {
            try {
                this._isCleaned = true;
                this.close();
                if (this._embeddedProxy != null) {
                    this._embeddedProxy.directClean();
                }
                if (this._clusteredProxy != null) {
                    this._clusteredProxy.directClean();
                }
                if (this._taskProxy != null) {
                    this._taskProxy.directClean();
                }
                LRMIClassLoadersHolder.dropAllClasses();
            }
            catch (Exception ex) {
                if (this._logger.isLoggable(Level.SEVERE)) {
                    this._logger.log(Level.SEVERE, ex.toString(), ex);
                }
                JSpaceUtilities.throwInternalSpaceException("internal error upon clean operation", ex);
            }
            finally {
                this._isCleaned = false;
                this._cleanedLock.notifyAll();
            }
        }
    }

    AnswerPacket updateOrWrite(UpdateOrWriteContext ctx, boolean newRouter) throws RemoteException, UnusableEntryException, UnknownTypeException, TransactionException, InterruptedException {
        ExtendedAnswerHolder holder;
        this._engine.getTypeManager().loadServerTypeDesc(ctx.packet);
        ctx.isUpdateOperation = this.isPurePojo(ctx.packet) ? false : ctx.packet.getVersion() > 0 || this._engine.getCacheManager().isEntryInPureCache(ctx.packet.getUID());
        IResponseContext responseContext = ResponseContext.getResponseContext();
        if (responseContext != null && !ctx.hasConcentratingTemplate()) {
            responseContext.setResponseHandler(new UpdateOrWriteResponseHandler(this._engine, ctx));
        }
        if (ctx.fromUpdateMultiple) {
            ctx.operationModifiers |= 0x40000;
        }
        return (holder = this._engine.updateOrWrite(ctx, newRouter)) != null ? holder.m_AnswerPacket : null;
    }

    private boolean isPurePojo(IEntryPacket packet) {
        return packet.getUID() == null;
    }

    public PrimarySpaceModeListeners getPrimarySpaceModeListeners() {
        return this.primarySpaceModeListeners;
    }

    public int getPartitionIdOneBased() {
        return this._clusterInfo.getPartitionOfMember(this.getServiceName()) + 1;
    }

    public IJSpace getSpaceProxy() throws RemoteException {
        return this.isClusteredSpace() ? this.getClusteredProxy() : this.getSingleProxy();
    }

    public IDirectSpaceProxy getSingleProxy() throws RemoteException {
        if (this._embeddedProxy == null) {
            this._embeddedProxy = this.createProxy(false, true);
        }
        return this._embeddedProxy;
    }

    private IJSpace getClusteredProxy() throws RemoteException {
        if (this._clusteredProxy == null) {
            this._clusteredProxy = this.createProxy(true, true);
        }
        return this._clusteredProxy;
    }

    protected IJSpace getTaskProxy() throws RemoteException {
        if (this._taskProxy == null) {
            this._taskProxy = (SpaceProxyImpl)this.createProxy(true, true).getNonClusteredProxy();
        }
        return this._taskProxy;
    }

    private SpaceProxyImpl createProxy(boolean isClustered) throws RemoteException {
        return this.createProxy(isClustered, false);
    }

    protected SpaceProxyImpl createProxy(boolean isClustered, boolean useEmbeddedCredentials) throws RemoteException {
        DirectSpaceProxyFactoryImpl factory = new DirectSpaceProxyFactoryImpl(this.getSpaceStub(), this.createSpaceSettings(isClustered), isClustered);
        SpaceProxyImpl spaceProxy = factory.createSpaceProxy();
        spaceProxy.setFinderURL(this.getURL());
        if (useEmbeddedCredentials && this._embeddedCredentialsProvider != null) {
            spaceProxy.login(this._embeddedCredentialsProvider);
        }
        return spaceProxy;
    }

    private SpaceSettings createSpaceSettings(boolean isClustered) {
        SpaceConfig spaceConfig = this.getConfig();
        if (!isClustered) {
            spaceConfig = spaceConfig.clone();
            spaceConfig.setClusterPolicy(null);
        }
        return new SpaceSettings(this._containerName, this._containerProxyRemote, this.getSpaceUuid(), this._secondary, this._serializationType, spaceConfig, this._spaceName, this._url, this._stubHandler, this.isSecuredSpace(), this._stubHandler.getTransportConfig(), this._cleanUnusedEmbeddedGlobalXtns);
    }

    private SpaceProxyImpl createSecuredProxy() throws RemoteException {
        SpaceProxyImpl proxy = this.createProxy(false);
        this.secureProxy(proxy);
        return proxy;
    }

    private void secureProxy(IJSpace spaceProxy) throws RemoteException {
        if (this.isSecuredSpace()) {
            this._securityInterceptor.trustProxy(spaceProxy);
        }
    }

    public boolean isClusteredSpace() {
        return this._clusterPolicy != null && (this._clusterPolicy.m_FailOverPolicy != null || this._clusterPolicy.m_LoadBalancingPolicy != null);
    }

    public IRemoteSpace getSpaceStub() throws RemoteException {
        if (this._spaceStub == null) {
            this._spaceStub = new LRMISpaceImpl(this, (IRemoteSpace)this._stubHandler.exportObject(this));
        }
        return this._spaceStub;
    }

    public String toString() {
        return this.getName();
    }

    public static void setConfig(String spaceName, String containerName, JSpaceAttributes config, String spaceFileURL) throws RemoteException {
        if (config == null) {
            return;
        }
        try {
            ReplaceInFileUtils updateFile = new ReplaceInFileUtils(spaceFileURL);
            for (Map.Entry<Object, Object> entry : config.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ((key = key.substring(key.indexOf(46) + 1)).equals("space-config.cluster.enabled")) continue;
                updateFile.xmlReplace(key, value);
            }
            if (!config.isClustered() && config.getDCacheConfigName() != null) {
                updateFile.xmlReplace("dist-cache.config-name", config.getDCacheConfigName());
                if (config.getDCacheProperties() != null) {
                    String spDir = null;
                    spDir = !JSpaceUtilities.isEmpty(config.getSchemaName()) ? new File(spaceFileURL).getParentFile().getParent() : new File(spaceFileURL).getParent();
                    String dCacheConfigFileName = spDir + File.separator + config.getDCacheConfigName() + "_DCache.xml";
                    String fullSpaceName = JSpaceUtilities.createFullSpaceName(containerName, spaceName);
                    String oldDCacheConfigName = JProperties.getSpaceProperty(fullSpaceName, "dist-cache.config-name", "DefaultConfig");
                    String oldDCacheConfigFileName = spDir + File.separator + oldDCacheConfigName + "_DCache.xml";
                    if (new File(oldDCacheConfigFileName).exists()) {
                        new File(oldDCacheConfigFileName).renameTo(new File(dCacheConfigFileName));
                    } else {
                        InputStream dcacheConfigInputStream = ResourceLoader.findConfigDCache("DefaultConfig");
                        if (dcacheConfigInputStream != null) {
                            SpaceConfigFactory.writeDOMToFile(dcacheConfigInputStream, new File(dCacheConfigFileName));
                        }
                    }
                    ReplaceInFileUtils dcacheFile = new ReplaceInFileUtils(dCacheConfigFileName);
                    Enumeration<Object> enum_ = config.getDCacheProperties().keys();
                    while (enum_.hasMoreElements()) {
                        String key = (String)enum_.nextElement();
                        dcacheFile.xmlReplace(key, config.getDCacheProperties().getProperty(key));
                    }
                    dcacheFile.close();
                }
            }
            updateFile.close();
            if (config.getFiltersInfo() != null && config.getFiltersInfo().length > 0) {
                SpaceImpl.updateFilterXMLNodes(spaceFileURL, config.getFiltersInfo());
            }
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger("com.gigaspaces.core.common");
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, ex.toString(), ex);
            }
            throw new RemoteException(ex.getMessage(), ex.getCause());
        }
    }

    static void updateFilterXMLNodes(String spaceConfigFile, FiltersInfo[] filtersInfo) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(spaceConfigFile);
        NodeList nodeList = doc.getElementsByTagName("filters");
        if (nodeList.getLength() <= 0) {
            return;
        }
        Element filterElem = (Element)nodeList.item(0);
        Node filterNamesNode = filterElem.getElementsByTagName("filter-names").item(0);
        String fnames = filterNamesNode.getFirstChild().getNodeValue();
        StringTokenizer st = new StringTokenizer(fnames, ",");
        while (st.hasMoreElements()) {
            String filterName = st.nextToken().trim();
            NodeList filNL = filterElem.getElementsByTagName(filterName);
            for (int c = 0; c < filNL.getLength(); ++c) {
                filterElem.removeChild(filNL.item(c));
            }
        }
        String filterNames = "";
        for (int i = 0; i < filtersInfo.length; ++i) {
            filterNames = filterNames + filtersInfo[i].filterName + ", ";
            Element filElem = doc.createElement(filtersInfo[i].filterName);
            filElem.appendChild(SpaceImpl.createXMLTextNode(doc, "enabled", String.valueOf(filtersInfo[i].enabled)));
            filElem.appendChild(SpaceImpl.createXMLTextNode(doc, "class", filtersInfo[i].filterClassName));
            filElem.appendChild(SpaceImpl.createXMLTextNode(doc, "url", filtersInfo[i].paramURL));
            filElem.appendChild(SpaceImpl.createXMLTextNode(doc, "priority", String.valueOf(i)));
            String operCode = "";
            if (filtersInfo[i].beforeAuthentication) {
                operCode = operCode + String.valueOf(6) + ", ";
            }
            if (filtersInfo[i].afterRemove) {
                operCode = operCode + String.valueOf(53) + ", ";
            }
            if (filtersInfo[i].afterWrite) {
                operCode = operCode + String.valueOf(1) + ", ";
            }
            if (filtersInfo[i].beforeClean) {
                operCode = operCode + String.valueOf(8) + ", ";
            }
            if (filtersInfo[i].beforeNotify) {
                operCode = operCode + String.valueOf(4) + ", ";
            }
            if (filtersInfo[i].beforeRead) {
                operCode = operCode + String.valueOf(2) + ", ";
            }
            if (filtersInfo[i].afterRead) {
                operCode = operCode + String.valueOf(22) + ", ";
            }
            if (filtersInfo[i].beforeTake) {
                operCode = operCode + String.valueOf(3) + ", ";
            }
            if (filtersInfo[i].afterTake) {
                operCode = operCode + String.valueOf(23) + ", ";
            }
            if (filtersInfo[i].beforeWrite) {
                operCode = operCode + String.valueOf(0) + ", ";
            }
            if (filtersInfo[i].beforeGetAdmin) {
                operCode = operCode + String.valueOf(5) + ", ";
            }
            if (filtersInfo[i].beforeUpdate) {
                operCode = operCode + String.valueOf(9) + ", ";
            }
            if (filtersInfo[i].afterUpdate) {
                operCode = operCode + String.valueOf(10) + ", ";
            }
            if (!operCode.equals("")) {
                operCode = operCode.substring(0, operCode.lastIndexOf(44));
            }
            filElem.appendChild(SpaceImpl.createXMLTextNode(doc, "operation-code", operCode));
            filterElem.appendChild(filElem);
        }
        Node filterNameNode = filterElem.getElementsByTagName("filter-names").item(0);
        filterNameNode.getFirstChild().setNodeValue(filterNames.substring(0, filterNames.lastIndexOf(44)));
        JSpaceUtilities.domWriter(doc.getDocumentElement(), new PrintStream(new FileOutputStream(spaceConfigFile)), " ");
    }

    private static Node createXMLTextNode(Document rootDoc, String tagName, String tagValue) {
        Element tag = rootDoc.createElement(tagName);
        Text tagText = rootDoc.createTextNode(tagValue);
        tag.appendChild(tagText);
        return tag;
    }

    public SpaceConfigReader getConfigReader() {
        return this._configReader;
    }

    @Override
    public Uuid getSpaceUuid() {
        return this.getUuid();
    }

    private ISpaceFilter getFilterObject(String filterId) {
        return this._engine != null ? this._engine.getFilterManager().getFilterObject(filterId) : null;
    }

    @Override
    public void shutdown() throws RemoteException {
        this.shutdown(false, true);
    }

    public void shutdown(boolean isDestroy, boolean shutdowContainer) throws RemoteException {
        if (this._spaceState.isAborted()) {
            this._logger.fine("Shutdown already in progress...");
            return;
        }
        int previousState = this._spaceState.getState();
        this._spaceState.setState(5);
        Level logLevel = this.isPrivate() ? Level.FINE : Level.INFO;
        this._logger.log(logLevel, "Beginning shutdown...");
        this.beforeShutdown();
        if (isDestroy) {
            this.destroy();
        } else if (previousState != 2) {
            this.stopInternal();
        }
        this._spaceState.setState(3);
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("Life cycle is " + this.getLifeCycle());
        }
        if (this.getLifeCycle() != null) {
            this.getLifeCycle().unregister((Object)this);
        }
        if (shutdowContainer && this._container != null) {
            this._container.shutdownInternal();
        }
        this.unregister();
        if (this._qp != null) {
            this._qp.close();
        }
        if (this._embeddedProxy != null) {
            this._embeddedProxy.close();
        }
        if (this._clusteredProxy != null) {
            this._clusteredProxy.close();
        }
        if (this._taskProxy != null) {
            this._taskProxy.close();
        }
        if (this._customProperties != null) {
            this._customProperties.clear();
        }
        if (this._jspaceAttr != null) {
            this._jspaceAttr.clear();
        }
        if (this._httpServer != null) {
            this._httpServer.stop(1);
        }
        this._logger.log(logLevel, "Shutdown complete");
    }

    private void beforeShutdown() {
        SpaceEngine engine = this._engine;
        if (engine != null) {
            engine.waitForConsistentState();
        }
    }

    public void unregister() throws RemoteException {
        this.unregisterFromLookupService();
        if (this.m_adminImpl != null) {
            this.m_adminImpl.unexport(true);
        }
        this.disableStub();
    }

    private void initReplicationStateBasedOnActiveElection() throws RemoteException {
        if (this._clusterPolicy != null) {
            if (this._clusterPolicy.isPrimaryElectionAvailable()) {
                this._leaderSelector.addListenerAndNotify(this._engine);
            } else {
                this._engine.getReplicationNode().getAdmin().setActive();
            }
        } else if (this._engine.isMirrorService()) {
            this._engine.getReplicationNode().getAdmin().setActive();
        }
    }

    private QueryProcessor createQueryProcessor() throws Exception {
        IJSpace clusterProxy;
        SpaceProxyImpl singleProxy = this.createProxy(false);
        this.secureProxy(singleProxy);
        if (this.isClusteredSpace()) {
            if (this.isActive()) {
                clusterProxy = this.createProxy(true);
            } else {
                SpaceURL remoteUrl = this.getURL().clone();
                remoteUrl.setProperty("protocol", "jini:");
                remoteUrl.setProperty("host", "*");
                Long queryProcessorSpaceLookupTimeout = Long.getLong("com.gs.queryProcessor.cluster-lookup-timeout", 15000L);
                remoteUrl.setProperty("timeout", String.valueOf(queryProcessorSpaceLookupTimeout));
                remoteUrl.refreshUrlString();
                clusterProxy = (IJSpace)SpaceFinder.find(remoteUrl);
            }
            this.secureProxy(clusterProxy);
        } else {
            clusterProxy = singleProxy;
        }
        QueryProcessor qp = (QueryProcessor)QueryProcessorFactory.newLocalInstance(clusterProxy, singleProxy, null, this._securityInterceptor);
        qp.initStub();
        return qp;
    }

    private void postRecoveryActions(ISpaceSynchronizeReplicaState recoveryState) throws Exception {
        this.changeSpaceState(0, true, true);
        if (recoveryState != null) {
            int replicationSynchronizationTimeout = 300;
            try {
                long syncStartTime = SystemTime.timeMillis();
                ISpaceSynchronizeResult synchronizeResult = recoveryState.waitForSynchronizeCompletion(replicationSynchronizationTimeout, TimeUnit.SECONDS);
                if (synchronizeResult != null) {
                    if (synchronizeResult.isFailed()) {
                        if (this._logger.isLoggable(Level.WARNING)) {
                            this._logger.warning("Synchronization failed: " + synchronizeResult.getFailureReason());
                        }
                        throw synchronizeResult.getFailureReason();
                    }
                    if (this.getEngine().getReplicationNode() != null && this.getEngine().getReplicationNode().getDirectPesistencySyncHandler() != null) {
                        this.getEngine().getReplicationNode().getDirectPesistencySyncHandler().afterRecovery();
                        this.getEngine().getReplicationNode().setDirectPersistencyBackupSyncIteratorHandler(null);
                    }
                    if (this.getDirectPersistencyRecoveryHelper() != null && this.isBackup()) {
                        this.getDirectPersistencyRecoveryHelper().setPendingBackupRecovery(false);
                    }
                    if (this._logger.isLoggable(Level.INFO)) {
                        long duration = SystemTime.timeMillis() - syncStartTime;
                        this._logger.info("Synchronization completed [duration=" + JSpaceUtilities.formatMillis(duration) + "]");
                    }
                }
            }
            catch (TimeoutException e) {
                if (this.getEngine().getCacheManager().isBlobStoreCachePolicy()) {
                    if (this._logger.isLoggable(Level.SEVERE)) {
                        this._logger.severe("Timeout occurred [" + replicationSynchronizationTimeout + " seconds] while waiting for replication to synchronize. Will shut down space since blobstore inconsistent space can't be started.");
                    }
                    throw e;
                }
                if (this._logger.isLoggable(Level.WARNING)) {
                    this._logger.warning("Timeout occurred [" + replicationSynchronizationTimeout + " seconds] while waiting for replication to synchronize. Starting the space without complete synchronization.");
                }
            }
            catch (Exception e) {
                this.changeSpaceState(0, true, false);
                throw e;
            }
        }
    }

    private void initAndStartPrimaryBackupSpace() throws Exception {
        for (int retries = 1; retries <= 3; ++retries) {
            try {
                SpaceMode spaceMode = this._leaderSelector.getSpaceMode();
                SpaceRecoverStrategy strategy = this._recoveryManager.getRecoveryStrategy(spaceMode);
                ISpaceSynchronizeReplicaState recoveryState = strategy.recover();
                this.postRecoveryActions(recoveryState);
                this._internalSpaceModesListeners.beforeSpaceModeChange(spaceMode);
                if (!this._leaderSelector.compareAndRegister(spaceMode, this._internalSpaceModesListeners)) {
                    throw new SpaceRecoveryException("Space state changed during recovery");
                }
                this.changeSpaceState(1, true, true);
                this._internalSpaceModesListeners.afterSpaceModeChange(spaceMode);
                return;
            }
            catch (Exception e) {
                this.handleRecoveryFailure(e, retries);
                continue;
            }
        }
    }

    private void handleRecoveryFailure(Exception e, int retries) throws Exception {
        if (this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, "Space recovery failure.", e);
        }
        if (retries == 3 || this.getEngine().getCacheManager().isBlobStoreCachePolicy() || this._spaceState.getState() == 2) {
            throw e;
        }
        this.close();
        this._engine = new SpaceEngine(this);
        if (this._leaderSelector != null) {
            this._logger.info("Space recovery failed - selecting primary");
            this._leaderSelector.select();
        }
        this.initReplicationStateBasedOnActiveElection();
    }

    private void initAndStartRegularSpace() throws Exception, RemoteException {
        this.changeSpaceState(0, true, false);
        for (int retries = 1; retries <= 3; ++retries) {
            try {
                SpaceRecoverStrategy strategy = this._recoveryManager.getRecoveryStrategy(SpaceMode.NONE);
                ISpaceSynchronizeReplicaState recoveryState = strategy.recover();
                this.postRecoveryActions(recoveryState);
                this._componentManager.initComponents();
                this.changeSpaceState(1, true, true);
                this._componentManager.startComponents();
                break;
            }
            catch (Exception e) {
                this.handleRecoveryFailure(e, retries);
                continue;
            }
        }
    }

    public void initAndRecoverFromDataStorage(boolean isWarm) throws RemoteException, CreateException, SpaceComponentsInitializeException {
        this._engine.init(isWarm, true);
        this._statistics = (JSpaceStatistics)this.getFilterObject("Statistics");
        this._workerManager = this.createWorkerManager();
        this._componentManager = new SpaceComponentManager(this);
    }

    public boolean useZooKeeper() {
        return !SystemInfo.singleton().getManagerClusterInfo().isEmpty();
    }

    private boolean isLookupServiceEnabled() {
        return this._isLusRegEnabled && !this.isPrivate();
    }

    public boolean restartLeaderSelectorHandler() {
        try {
            this._leaderSelector.terminate();
            this._leaderSelector = this.initLeaderSelectorHandler(this.isLookupServiceEnabled());
        }
        catch (RemoteException e) {
            this._logger.log(Level.SEVERE, "Unable to reinitialize leader selector ", e);
            return false;
        }
        catch (ActiveElectionException e) {
            this._logger.log(Level.SEVERE, "Unable to reinitialize leader selector ", e);
            return false;
        }
        return true;
    }

    public LeaderSelectorHandler getLeaderSelector() {
        return this._leaderSelector;
    }

    private LeaderSelectorHandler initLeaderSelectorHandler(boolean isLookupServiceEnabled) throws RemoteException, ActiveElectionException {
        LeaderSelector leaderSelectorHandler = null;
        if (this._clusterPolicy != null && this._clusterPolicy.isPrimaryElectionAvailable()) {
            if (!isLookupServiceEnabled) {
                throw new ActiveElectionException("This cluster configuration requires a running Jini Lookup Service.  Make sure this space is registering/joining a running Jini Lookup Service (i.e. verify the <jini_lus><enabled>true<enabled> element in the relevant container schema).");
            }
            if (this._spaceState.getState() != 1) {
                this.changeSpaceState(0, true, false);
            }
            boolean useZooKeeper = this.useZooKeeper();
            try {
                ServiceTemplate participantSrvTemplate;
                CountDownLatch latch;
                LeaderSelectorHandlerConfig leaderSelectorHandlerConfig = new LeaderSelectorHandlerConfig();
                leaderSelectorHandlerConfig.setSpace(this);
                if (!useZooKeeper) {
                    leaderSelectorHandler = new LusBasedSelectorHandler(this.createSecuredProxy());
                    ((LeaderSelectorHandler)leaderSelectorHandler).initialize(leaderSelectorHandlerConfig);
                } else {
                    leaderSelectorHandler = this.createZooKeeperLeaderSelector();
                    ((LeaderSelectorHandler)leaderSelectorHandler).initialize(leaderSelectorHandlerConfig);
                }
                leaderSelectorHandler.select();
                if (((LeaderSelectorHandler)leaderSelectorHandler).isPrimary()) {
                    latch = new CountDownLatch(1);
                    participantSrvTemplate = this.buildServiceTemplate(this._clusterPolicy, true);
                } else {
                    latch = new CountDownLatch(2);
                    participantSrvTemplate = this.buildServiceTemplate(this._clusterPolicy, false);
                }
                LookupNamingService namingService = new LookupNamingService((LookupDiscoveryManager)this.getJoinManager().getDiscoveryManager(), this.getJoinManager().getLeaseRenewalManager());
                LookupCache lookupCache = namingService.notify(participantSrvTemplate, null, new LeaderSelectorServiceDiscoveryListener(latch));
                latch.await();
                lookupCache.terminate();
            }
            catch (Exception e) {
                if (leaderSelectorHandler != null) {
                    leaderSelectorHandler.terminate();
                }
                throw new ActiveElectionException("Failed to initialize Leader Selector handler", e);
            }
        }
        return leaderSelectorHandler;
    }

    public ClusterFailureDetector getClusterFailureDetector() {
        return this._clusterFailureDetector;
    }

    public void updateXmlConfigEntry(String configEntry, String configValue) throws IOException {
        String spaceConfigURL = JProperties.getURL(this.getServiceName());
        ReplaceInFileUtils updateFile = new ReplaceInFileUtils(spaceConfigURL);
        updateFile.xmlReplace(configEntry, configValue);
        updateFile.close();
    }

    public ServerTransaction createServerTransaction(TransactionManager mgr, Object id, int numOfParticipants) {
        try {
            if (id instanceof Long) {
                long txId = (Long)id;
                TransactionParticipantDataImpl serverTransactionMetaData = new TransactionParticipantDataImpl((TransactionUniqueId)new DefaultTransactionUniqueId(mgr.getTransactionManagerId(), txId), this._engine.getPartitionIdOneBased(), numOfParticipants);
                return new ServerTransaction(mgr, txId, serverTransactionMetaData);
            }
            TransactionParticipantDataImpl serverTransactionMetaData = new TransactionParticipantDataImpl((TransactionUniqueId)new XATransactionUniqueId(mgr.getTransactionManagerId(), id), this._engine.getPartitionIdOneBased(), numOfParticipants);
            return new GSServerTransaction(mgr, id, serverTransactionMetaData);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private ServerTransaction createServerTransaction(TransactionManager mgr, Object id) {
        return this.createServerTransaction(mgr, id, 1);
    }

    public void changeSpaceState(int state, boolean electable, boolean replicable) {
        this._spaceState.setState(state);
        this.modifyLookupAttributes(new Entry[]{new State()}, new Entry[]{new State(state, electable, replicable)});
    }

    public LinkedList<ISpaceComponentsHandler> getSpaceComponentHandlers() {
        LinkedList<ISpaceComponentsHandler> componentsHandlers = new LinkedList<ISpaceComponentsHandler>();
        componentsHandlers.clear();
        componentsHandlers.addAll(this._engine.getComponentsHandlers());
        if (this._workerManager != null) {
            componentsHandlers.add(this._workerManager);
        }
        return componentsHandlers;
    }

    private int loadSerializationType() {
        String propertyValue = this._configReader.getSpaceProperty("serialization-type", Constants.Engine.ENGINE_SERIALIZATION_TYPE_DEFAULT).trim();
        try {
            int result = Integer.parseInt(propertyValue);
            StorageType storageType = StorageType.fromCode(result);
            if (storageType != StorageType.OBJECT && this._logger.isLoggable(Level.WARNING)) {
                this._logger.log(Level.WARNING, "space-config.serialization-type=" + propertyValue + " is deprecated - use POJO annotations or gs.xml instead.");
            }
            return result;
        }
        catch (NumberFormatException e) {
            String msg = "Invalid serialization-type specified " + propertyValue;
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, e);
            }
            throw new RuntimeException(msg, e);
        }
        catch (IllegalArgumentException e) {
            String msg = e.getMessage().replace("StorageType", "serialization-type");
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg);
            }
            throw new RuntimeException(msg);
        }
    }

    public SpaceHealthStatus getLocalSpaceHealthStatus() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        return this.getSpaceHealthStatusHelper(errors);
    }

    private SpaceHealthStatus getSpaceHealthStatusHelper(ArrayList<Throwable> errors) {
        LeaderSelectorHandler leaderElector;
        SpaceMode spaceMode = this.getSpaceMode();
        SpaceEngine engine = this._engine;
        if (engine != null) {
            if (spaceMode == SpaceMode.BACKUP) {
                try {
                    engine.getMemoryManager().monitorMemoryUsage(true);
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            errors.addAll(engine.getUnhealthyReasons());
        }
        if ((leaderElector = this._leaderSelector) != null && leaderElector.getLastError() != null) {
            errors.add(leaderElector.getLastError());
        }
        return new SpaceHealthStatus(errors.toArray(new Throwable[errors.size()]));
    }

    @Override
    public SecurityContext login(SecurityContext securityContext) throws RemoteException {
        if (!this.isSecuredSpace()) {
            throw new SecurityException("Trying to login to a non-secured space [" + this.getServiceName() + "]");
        }
        if (this._engine != null && !this._securityInterceptor.shouldBypassFilter(securityContext)) {
            this._engine.beforeAuthentication(securityContext);
        }
        return this._securityInterceptor.authenticate(securityContext);
    }

    public void addInternalSpaceModeListener(ISpaceModeListener listener) {
        this._internalSpaceModesListeners.addListener(listener);
    }

    public void removeInternalSpaceModeListener(ISpaceModeListener listener) {
        this._internalSpaceModesListeners.removeListener(listener);
    }

    public SpaceProxyImpl getServiceProxy() throws RemoteException {
        return this.createProxy(this.isClusteredSpace(), false);
    }

    @Override
    public SpaceConnectResult connect(SpaceConnectRequest request) throws RemoteException {
        this.assertAvailable();
        SpaceConnectResult result = new SpaceConnectResult();
        boolean serializeClusterPolicy = request.getVersion().lessThan(PlatformLogicalVersion.v11_0_0);
        result.setSpaceSettings(this.createSpaceSettings(serializeClusterPolicy));
        result.setClustered(this._clusterInfo.isClustered());
        return result;
    }

    public boolean isAborted() {
        return this._spaceState.isAborted();
    }

    private <T extends Throwable> T logException(T e) {
        if (!(e instanceof ProtectiveModeException) && !(e instanceof ConsistencyLevelViolationException) && !(e instanceof QuiesceException) && this._logger.isLoggable(Level.SEVERE)) {
            this._logger.log(Level.SEVERE, e.toString(), e);
        }
        return e;
    }

    @Override
    public DirectPersistencySyncListBatch getSynchronizationListBatch() throws RemoteException {
        DirectPersistencyBackupSyncIteratorHandler directPersistencyBackupSyncIteratorHandler = this.getEngine().getReplicationManager().getReplicationNode().getDirectPersistencyBackupSyncIteratorHandler();
        return directPersistencyBackupSyncIteratorHandler.getNextBatch();
    }

    @Override
    public String getName() {
        return this._spaceName;
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public void ping() throws RemoteException {
        if (this._spaceState.isTerminated()) {
            throw new SpaceUnavailableException(this.getServiceName(), "Space [" + this.getServiceName() + "] is not available. Shutdown or other abort operation in process.");
        }
        if (this._spaceState.isStopped() || this._engine == null) {
            throw new SpaceStoppedException(this.getServiceName(), "Space [" + this.getServiceName() + "] is in stopped state.");
        }
    }

    @Override
    public SpaceHealthStatus getSpaceHealthStatus() throws RemoteException {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.ping();
        }
        catch (Exception e) {
            errors.add(e);
        }
        return this.getSpaceHealthStatusHelper(errors);
    }

    @Override
    public IQueryProcessor getQueryProcessor() {
        return this._qp.getStub();
    }

    public IStubHandler getStubHandler() {
        return this._stubHandler;
    }

    @Override
    public String getUniqueID() throws RemoteException {
        this.beforeOperation(false, false, null);
        return this._engine.generateUid();
    }

    @Override
    public Class<?> loadRemoteClass(String className) throws ClassNotFoundException {
        return ClassLoaderHelper.loadClass(className, true);
    }

    public SpaceResponseInfo executeAction(SystemTask systemTask) {
        SpaceActionExecutor executor = this.getActionExecutor(systemTask);
        return executor.execute(this, systemTask.getSpaceRequestInfo());
    }

    private SpaceActionExecutor getActionExecutor(SystemTask<?> systemTask) {
        SpaceActionExecutor result = this.executorMap.get(systemTask.getClass());
        if (result == null) {
            throw new UnsupportedOperationException("Could not find executor for request of type " + systemTask.getClass().getName());
        }
        return result;
    }

    @Override
    public boolean isActive() throws RemoteException {
        this.assertAvailable();
        return this.isPrimary();
    }

    @Override
    public boolean isActiveAndNotSuspended() throws RemoteException {
        return this.isActive() && !this._quiesceHandler.isOn();
    }

    @Override
    public Boolean isActiveAsync() throws RemoteException {
        return this.isActive() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public <T extends RemoteOperationResult> T executeOperation(RemoteOperationRequest<T> request) throws RemoteException {
        return this._operationsExecutor.executeOperation(request, this, false);
    }

    @Override
    public <T extends RemoteOperationResult> T executeOperationAsync(RemoteOperationRequest<T> request) throws RemoteException {
        return this.executeOperation(request);
    }

    @Override
    public void executeOperationOneway(RemoteOperationRequest<?> request) throws RemoteException {
        this._operationsExecutor.executeOperation(request, this, true);
    }

    public WriteEntryResult write(IEntryPacket entry, Transaction txn, long lease, int modifiers, boolean fromReplication, SpaceContext sc) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException {
        if (UpdateModifiers.isPotentialUpdate(modifiers)) {
            this.beginPacketOperation(true, sc, SpaceAuthority.SpacePrivilege.WRITE, entry);
        } else {
            this.beginPacketOperation(true, sc, SpaceAuthority.SpacePrivilege.CREATE, entry);
        }
        try {
            if (txn != null && !this._engine.isLocalCache() && !fromReplication) {
                this._engine.getTransactionHandler().checkTransactionDisconnection(entry.getOperationID(), (ServerTransaction)txn);
            }
            WriteEntryResult writeEntryResult = this._engine.write(entry, txn, lease, modifiers, fromReplication, true, sc);
            return writeEntryResult;
        }
        catch (EntryAlreadyInSpaceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
        finally {
            this.endPacketOperation();
        }
    }

    public LeaseContext<?>[] writeOld(IEntryPacket[] entries, Transaction txn, long lease, long[] leases, SpaceContext sc, int modifiers) throws TransactionException, UnknownTypesException, RemoteException {
        if (UpdateModifiers.isPotentialUpdate(modifiers)) {
            this.beginBatchOperation(sc, SpaceAuthority.SpacePrivilege.WRITE, entries);
        } else {
            this.beginBatchOperation(sc, SpaceAuthority.SpacePrivilege.CREATE, entries);
        }
        try {
            WriteEntriesResult result = this.write(entries, txn, lease, leases, sc, 0L, modifiers, false);
            LeaseContext<?>[] leaseContextArray = this.convertWriteMultipleResult(result, entries, modifiers);
            return leaseContextArray;
        }
        catch (WriteMultipleException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
        finally {
            this.endPacketOperation();
        }
    }

    public WriteEntriesResult write(IEntryPacket[] entries, Transaction txn, long lease, long[] leases, SpaceContext sc, long timeout, int modifiers, boolean newRouter) throws TransactionException, UnknownTypesException, RemoteException {
        if (UpdateModifiers.isPotentialUpdate(modifiers)) {
            this.beginBatchOperation(sc, SpaceAuthority.SpacePrivilege.WRITE, entries);
        } else {
            this.beginBatchOperation(sc, SpaceAuthority.SpacePrivilege.CREATE, entries);
        }
        try {
            if (txn != null && !this._engine.isLocalCache() && entries.length > 0) {
                this._engine.getTransactionHandler().checkTransactionDisconnection(entries[0].getOperationID(), (ServerTransaction)txn);
            }
            WriteEntriesResult writeEntriesResult = this._engine.write(entries, txn, lease, leases, modifiers, sc, timeout, newRouter);
            return writeEntriesResult;
        }
        catch (WriteMultipleException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
        finally {
            this.endPacketOperation();
        }
    }

    private LeaseContext<?>[] convertWriteMultipleResult(WriteEntriesResult result, IEntryPacket[] entries, int modifiers) throws WriteMultipleException {
        WriteEntryResult[] results = result.getResults();
        Exception[] errors = result.getErrors();
        if (errors != null) {
            WriteMultipleException.IWriteResult[] partialFailureResults = new WriteResultImpl[errors.length];
            for (int i = 0; i < results.length; ++i) {
                if (errors[i] != null) {
                    partialFailureResults[i] = WriteResultImpl.createErrorResult(errors[i]);
                    continue;
                }
                boolean noWriteLease = this._engine.isNoWriteLease(entries[i], modifiers, false);
                LeaseContext<?> lease = results[i] == null ? null : results[i].createLease(entries[i].getTypeName(), this, noWriteLease);
                partialFailureResults[i] = WriteResultImpl.createLeaseResult(lease);
            }
            throw new WriteMultipleException(partialFailureResults);
        }
        LeaseContext[] leases = new LeaseContext[entries.length];
        boolean noReturnValue = UpdateModifiers.isNoReturnValue(modifiers);
        for (int i = 0; i < leases.length; ++i) {
            boolean noWriteLease = this._engine.isNoWriteLease(entries[i], modifiers, false);
            if (results[i] == null) continue;
            if (!noReturnValue) {
                leases[i] = results[i].createLease(entries[i].getTypeName(), this, noWriteLease);
                continue;
            }
            if (entries[i].getUID() != null) continue;
            leases[i] = LeaseInitializer.createDummyLease(results[i].getUid(), results[i].getVersion());
        }
        return leases;
    }

    private AnswerPacket update(IEntryPacket entry, Transaction txn, long lease, long timeout, IJSpaceProxyListener listener, SpaceContext sc, int modifiers) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        return this.update(entry, txn, lease, timeout, sc, modifiers, false);
    }

    public AnswerPacket update(IEntryPacket entry, Transaction txn, long lease, long timeout, SpaceContext sc, int modifiers, boolean newRouter) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        if (UpdateModifiers.isPotentialUpdate(modifiers)) {
            this.beginPacketOperation(true, sc, SpaceAuthority.SpacePrivilege.WRITE, entry);
        } else {
            this.beginPacketOperation(true, sc, SpaceAuthority.SpacePrivilege.CREATE, entry);
        }
        try {
            AnswerPacket answerPacket;
            AnswerPacket result;
            if (txn != null && !this._engine.isLocalCache()) {
                this._engine.getTransactionHandler().checkTransactionDisconnection(entry.getOperationID(), (ServerTransaction)txn);
            }
            if (UpdateModifiers.isUpdateOrWrite(modifiers)) {
                UpdateOrWriteContext ctx = new UpdateOrWriteContext(entry, lease, timeout, txn, sc, modifiers, false, true, false);
                result = this.updateOrWrite(ctx, newRouter);
            } else if (UpdateModifiers.isWriteOnly(modifiers)) {
                boolean fromReplication = false;
                WriteEntryResult writeResult = this.write(entry, txn, lease, modifiers, fromReplication, sc);
                if (UpdateModifiers.isNoReturnValue(modifiers)) {
                    result = null;
                } else if (newRouter) {
                    result = new AnswerPacket(writeResult);
                } else {
                    LeaseContext<?> leaseResult = writeResult.createLease(entry.getTypeName(), this, this._engine.isNoWriteLease(entry, modifiers, fromReplication));
                    result = new AnswerPacket(leaseResult);
                }
            } else {
                ExtendedAnswerHolder aHolder = this._engine.update(entry, txn, lease, timeout, sc, false, true, newRouter, modifiers);
                AnswerPacket answerPacket2 = result = aHolder != null ? aHolder.m_AnswerPacket : null;
            }
            if (newRouter) {
                answerPacket = result;
                return answerPacket;
            }
            answerPacket = UpdateModifiers.isNoReturnValue(modifiers) ? null : result;
            return answerPacket;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
        finally {
            this.endPacketOperation();
        }
    }

    private Object[] updateMultiple(IEntryPacket[] entries, Transaction txn, long[] leases, SpaceContext sc, int modifiers) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException {
        if (UpdateModifiers.isPotentialUpdate(modifiers)) {
            this.beginBatchOperation(sc, SpaceAuthority.SpacePrivilege.WRITE, entries);
        } else {
            this.beginBatchOperation(sc, SpaceAuthority.SpacePrivilege.CREATE, entries);
        }
        if (UpdateModifiers.isUpdateOrWrite(modifiers)) {
            return this._engine.updateOrWrite(entries, txn, leases, sc, modifiers, false, false);
        }
        if (UpdateModifiers.isWriteOnly(modifiers)) {
            Object[] res = new Object[entries.length];
            boolean fromReplication = false;
            for (int i = 0; i < entries.length; ++i) {
                WriteEntryResult writeResult = this._engine.write(entries[i], txn, leases[i], modifiers, fromReplication, true, sc);
                LeaseContext<?> lease = writeResult.createLease(entries[i].getTypeName(), this, this._engine.isNoWriteLease(entries[i], modifiers, fromReplication));
                res[i] = lease.getUID();
            }
            return res;
        }
        try {
            Object[] res = this._engine.updateMultiple(entries, txn, leases, sc, modifiers, false);
            return res;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
        finally {
            this.endPacketOperation();
        }
    }

    public Pair<Integer, SingleExplainPlan> count(ITemplatePacket template, Transaction txn, SpaceContext sc, int modifiers) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException {
        this.beginPacketOperation(true, sc, SpaceAuthority.SpacePrivilege.READ, template);
        try {
            Pair<Integer, SingleExplainPlan> pair = this._engine.count(template, txn, sc, modifiers);
            return pair;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
        finally {
            this.endPacketOperation();
        }
    }

    public Pair<Integer, SingleExplainPlan> clear(ITemplatePacket template, Transaction txn, int modifiers, SpaceContext sc) throws UnusableEntryException, UnknownTypeException, TransactionException, RemoteException {
        this.beginPacketOperation(true, sc, SpaceAuthority.SpacePrivilege.TAKE, template);
        try {
            if (txn != null && !this._engine.isLocalCache()) {
                this._engine.getTransactionHandler().checkTransactionDisconnection(template.getOperationID(), (ServerTransaction)txn);
            }
            Pair<Integer, SingleExplainPlan> pair = this._engine.clear(template, txn, sc, modifiers);
            return pair;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
        finally {
            this.endPacketOperation();
        }
    }

    public AnswerHolder readNew(ITemplatePacket template, Transaction txn, long timeout, boolean ifExists, boolean take, IJSpaceProxyListener listener, SpaceContext sc, boolean returnOnlyUid, int modifiers) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        this.beginPacketOperation(true, sc, take ? SpaceAuthority.SpacePrivilege.TAKE : SpaceAuthority.SpacePrivilege.READ, template);
        try {
            AnswerHolder answerHolder;
            AnswerPacket answerPacket;
            if (txn != null && take && !this._engine.isLocalCache()) {
                this._engine.getTransactionHandler().checkTransactionDisconnection(template.getOperationID(), (ServerTransaction)txn);
            }
            AnswerPacket answerPacket2 = answerPacket = (answerHolder = this._engine.read(template, txn, timeout, ifExists, take, sc, returnOnlyUid, false, true, modifiers)) != null ? answerHolder.getAnswerPacket() : null;
            if (answerPacket != null && answerPacket.m_EntryPacket != null) {
                SpaceImpl.applyEntryPacketOutFilter(answerPacket.m_EntryPacket, modifiers, template.getProjectionTemplate());
            }
            AnswerHolder answerHolder2 = answerHolder;
            return answerHolder2;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
        finally {
            this.endPacketOperation();
        }
    }

    public AnswerPacket read(ITemplatePacket template, Transaction txn, long timeout, boolean ifExists, boolean take, IJSpaceProxyListener listener, SpaceContext sc, boolean returnOnlyUid, int modifiers) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        AnswerHolder answerHolder = this.readNew(template, txn, timeout, ifExists, take, listener, sc, returnOnlyUid, modifiers);
        return answerHolder != null ? answerHolder.getAnswerPacket() : null;
    }

    public Object asyncRead(ITemplatePacket template, Transaction txn, long timeout, boolean ifExists, boolean take, IJSpaceProxyListener listener, SpaceContext sc, boolean returnOnlyUid, int modifiers, final IFuture result) throws UnusableEntryException, TransactionException, UnknownTypeException, RemoteException, InterruptedException {
        boolean isEmbedded;
        boolean bl = isEmbedded = result != null;
        if (isEmbedded) {
            AbstractResponseContext respContext = new AbstractResponseContext(null, OperationPriority.REGULAR, null, null){

                @Override
                public void sendResponseToClient(ReplyPacket<?> respPacket) {
                }
            };
            respContext.setResponseHandler(new IResponseHandler(){

                @Override
                public void handleResponse(IResponseContext responseContext, ReplyPacket<?> respPacket) {
                    ((LRMIFuture)result).setResultPacket(respPacket);
                }
            });
        }
        AnswerPacket res = this.read(template, txn, timeout, ifExists, take, listener, sc, returnOnlyUid, modifiers);
        if (isEmbedded) {
            if (res != null) {
                result.setResult(res);
            }
            ResponseContext.clearResponseContext();
        }
        return res;
    }

    public IEntryPacket[] readMultiple(ITemplatePacket template, Transaction txn, boolean take, int maxEntries, SpaceContext sc, boolean returnOnlyUid, int modifiers) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException {
        AnswerHolder answerHolder = this.readMultiple(template, txn, take, maxEntries, sc, returnOnlyUid, modifiers, maxEntries, 0L, false);
        return answerHolder != null ? answerHolder.getEntryPackets() : null;
    }

    /*
     * WARNING - void declaration
     */
    public AnswerHolder readMultiple(ITemplatePacket template, Transaction txn, boolean take, int maxEntries, SpaceContext sc, boolean returnOnlyUid, int modifiers, int minEntries, long timeout, boolean isIfExist) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException {
        this.beginPacketOperation(true, sc, take ? SpaceAuthority.SpacePrivilege.TAKE : SpaceAuthority.SpacePrivilege.READ, template);
        try {
            IEntryPacket[] results;
            Exception retex;
            BatchQueryOperationContext operationContext = take ? new TakeMultipleContext(template, maxEntries, minEntries) : new ReadMultipleContext(template, maxEntries, minEntries);
            AnswerHolder ah = null;
            if (take && txn != null && !this._engine.isLocalCache()) {
                this._engine.getTransactionHandler().checkTransactionDisconnection(template.getOperationID(), (ServerTransaction)txn);
            }
            if ((ah = this._engine.readMultiple(template, txn, timeout, isIfExist, take, sc, returnOnlyUid, modifiers, operationContext, null)) == null) {
                AnswerHolder answerHolder = null;
                return answerHolder;
            }
            if (ah.getException() != null) {
                retex = ah.getException();
                if (retex instanceof RuntimeException) {
                    throw (RuntimeException)retex;
                }
                if (retex instanceof InterruptedException) {
                    throw (InterruptedException)retex;
                }
                if (retex instanceof TransactionException) {
                    throw (TransactionException)((Object)retex);
                }
                if (retex instanceof UnusableEntryException) {
                    throw (UnusableEntryException)((Object)retex);
                }
                if (retex instanceof UnknownTypeException) {
                    throw (UnknownTypeException)retex;
                }
                if (retex instanceof RemoteException) {
                    throw (RemoteException)retex;
                }
            }
            if (ah.getEntryPackets() == null) {
                retex = null;
                return retex;
            }
            for (IEntryPacket packet : results = ah.getEntryPackets()) {
                SpaceImpl.applyEntryPacketOutFilter(packet, modifiers, template.getProjectionTemplate());
            }
            AnswerHolder answerHolder = ah;
            return answerHolder;
        }
        catch (BatchQueryException batchEx) {
            if (batchEx.getResults() != null) {
                void var15_22;
                Object[] objectArray = batchEx.getResults();
                int n = objectArray.length;
                boolean bl = false;
                while (var15_22 < n) {
                    Object result = objectArray[var15_22];
                    if (result != null && result instanceof IEntryPacket) {
                        SpaceImpl.applyEntryPacketOutFilter((IEntryPacket)result, modifiers, template.getProjectionTemplate());
                    }
                    ++var15_22;
                }
            }
            throw batchEx;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(this.logException(e));
        }
        finally {
            this.endPacketOperation();
        }
    }

    public static void applyEntryPacketOutFilter(IEntryPacket entryPacket, int modifiers, AbstractProjectionTemplate projectionTemplate) {
        if (projectionTemplate != null) {
            projectionTemplate.filterOutNonProjectionProperties(entryPacket);
        }
        if (Modifiers.contains(modifiers, 0x200000)) {
            DocumentObjectConverterInternal.instance().convertNonPrimitivePropertiesToStrings(entryPacket);
        } else if (Modifiers.contains(modifiers, 0x400000)) {
            DocumentObjectConverterInternal.instance().convertNonPrimitivePropertiesToDocuments(entryPacket);
        }
    }

    public IEntryPacket[] readByIds(ITemplatePacket template, Transaction txn, boolean take, SpaceContext spaceContext, int modifiers) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException, InterruptedException {
        try {
            this.beginPacketOperation(true, spaceContext, take ? SpaceAuthority.SpacePrivilege.TAKE : SpaceAuthority.SpacePrivilege.READ, template);
            ReadByIdsContext readByIdsContext = new ReadByIdsContext(template, true);
            if (take && txn != null && !this._engine.isLocalCache()) {
                this._engine.getTransactionHandler().checkTransactionDisconnection(template.getOperationID(), (ServerTransaction)txn);
            }
            this._engine.readByIds((AbstractIdsQueryPacket)template, txn, take, spaceContext, modifiers, readByIdsContext);
            for (IEntryPacket packet : readByIdsContext.getResults()) {
                if (packet == null) continue;
                SpaceImpl.applyEntryPacketOutFilter(packet, modifiers, template.getProjectionTemplate());
            }
            IEntryPacket[] iEntryPacketArray = readByIdsContext.getResults();
            return iEntryPacketArray;
        }
        catch (ReadTakeByIdsException e) {
            for (ReadTakeByIdResult result : e.getResults()) {
                Object entry;
                if (result.isError() || !((entry = result.getObject()) instanceof IEntryPacket)) continue;
                SpaceImpl.applyEntryPacketOutFilter((IEntryPacket)entry, modifiers, template.getProjectionTemplate());
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
        finally {
            this.endPacketOperation();
        }
    }

    public GSEventRegistration notify(ITemplatePacket template, Transaction txn, long lease, SpaceContext sc, NotifyInfo info) throws TransactionException, UnusableEntryException, UnknownTypeException, RemoteException {
        this.beginPacketOperation(true, sc, SpaceAuthority.SpacePrivilege.READ, template);
        try {
            Object listener;
            if (txn != null) {
                throw new UnsupportedOperationException("Notification registration with transactions is no longer supported.");
            }
            info.applyDefaults(this._clusterPolicy);
            if (info.isGuaranteedNotifications()) {
                if (!this.getEngine().supportsGuaranteedNotifications()) {
                    throw new IllegalArgumentException("Guaranteed notifications are supported only on primary-backup topology.");
                }
                listener = (ILRMIProxy)info.getListener();
                HashMap<String, LRMIMethodMetadata> methodsMetadata = null;
                boolean oneWay = false;
                methodsMetadata = new HashMap<String, LRMIMethodMetadata>();
                methodsMetadata.put("notifyBatch(Lcom/gigaspaces/events/batching/BatchRemoteEvent;)V", new LRMIMethodMetadata(false));
                methodsMetadata.put("notify(Lnet/jini/core/event/RemoteEvent;)V", new LRMIMethodMetadata(false));
                listener.overrideMethodsMetadata(methodsMetadata);
            }
            listener = this._engine.notify(template, lease, false, info.getTemplateUID(), sc, info);
            return listener;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
        finally {
            this.endPacketOperation();
        }
    }

    @Override
    public void snapshot(ITemplatePacket template) throws UnusableEntryException, RemoteException {
        this.beforeOperation(false, true, null);
        try {
            this._engine.snapshot(template);
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
    }

    public void cancel(String entryUID, String classname, int objectType, boolean isFromGateway) throws UnknownLeaseException, RemoteException {
        this.beforeOperation(true, true, null);
        try {
            this._engine.getLeaseManager().cancel(entryUID, classname, objectType, false, true, isFromGateway);
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
    }

    @Override
    public void cancel(String entryUID, String classname, int objectType) throws UnknownLeaseException, RemoteException {
        this.cancel(entryUID, classname, objectType, false);
    }

    public long renew(String entryUID, String classname, int objectType, long duration, boolean isFromGateway) throws UnknownLeaseException, RemoteException {
        this.beforeOperation(true, true, null);
        try {
            return this._engine.getLeaseManager().renew(entryUID, classname, objectType, duration, false, true, isFromGateway);
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
    }

    @Override
    public long renew(String entryUID, String classname, int objectType, long duration) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        return this.renew(entryUID, classname, objectType, duration, false);
    }

    @Override
    public Exception[] cancelAll(String[] entryUIDs, String[] classnames, int[] objectTypes) throws RemoteException {
        this.beforeOperation(true, true, null);
        try {
            return this._engine.getLeaseManager().cancelAll(entryUIDs, classnames, objectTypes);
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
    }

    @Override
    public Object[] renewAll(String[] entryUIDs, String[] classnames, int[] objectTypes, long[] durations) throws RemoteException {
        this.beforeOperation(true, false, null);
        try {
            return this._engine.getLeaseManager().renewAll(entryUIDs, classnames, objectTypes, durations);
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
    }

    public void abort(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        this.abort(mgr, (Object)id);
    }

    @Override
    public void abort(TransactionManager mgr, Object id) throws UnknownTransactionException, RemoteException {
        this.abortImpl(mgr, id, false, null);
    }

    public void abortImpl(TransactionManager mgr, Object id, boolean supportsTwoPhaseReplication, OperationID operationID) throws RemoteException, UnknownTransactionException {
        this.beforeOperation(true, false, null);
        try {
            this._engine.abort(mgr, this.createServerTransaction(mgr, id), supportsTwoPhaseReplication, operationID);
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
    }

    public void commit(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        this.commit(mgr, (Object)id, 1);
    }

    @Override
    public void commit(TransactionManager mgr, Object id) throws UnknownTransactionException, RemoteException {
        this.commit(mgr, id, 1);
    }

    public void commit(TransactionManager mgr, long id, int numOfParticipants) throws UnknownTransactionException, RemoteException {
        this.commit(mgr, (Object)id, numOfParticipants);
    }

    @Override
    public void commit(TransactionManager mgr, Object id, int numOfParticipants) throws UnknownTransactionException, RemoteException {
        this.commitImpl(mgr, id, numOfParticipants, false, null, true);
    }

    public void commitImpl(TransactionManager mgr, Object id, int numOfParticipants, boolean supportsTwoPhaseReplication, OperationID operationID, boolean mayBeFromReplication) throws RemoteException, UnknownTransactionException {
        this.beforeOperation(true, false, null);
        try {
            this._engine.commit(mgr, this.createServerTransaction(mgr, id, numOfParticipants), supportsTwoPhaseReplication, operationID, mayBeFromReplication);
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
    }

    public int prepare(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        return this.prepare(mgr, (Object)id, 1);
    }

    @Override
    public int prepare(TransactionManager mgr, Object id) throws UnknownTransactionException, RemoteException {
        return this.prepare(mgr, id, 1);
    }

    @Override
    public int prepare(TransactionManager mgr, Object id, int numOfParticipants) throws UnknownTransactionException, RemoteException {
        return this.prepareImpl(mgr, id, numOfParticipants, false);
    }

    private int prepareImpl(TransactionManager mgr, Object id, int numOfParticipants, boolean supportsTwoPhaseReplication) throws RemoteException, UnknownTransactionException {
        this.beforeOperation(true, true, null);
        try {
            ServerTransaction transaction = this.createServerTransaction(mgr, id, numOfParticipants);
            if (supportsTwoPhaseReplication && this._operationLogger.isLoggable(Level.FINEST)) {
                this._operationLogger.finest("preparing transaction [" + this._engine.createTransactionDetailsString(transaction, null) + "]");
            }
            int prepareResult = this._engine.prepare(mgr, transaction, false, supportsTwoPhaseReplication, null);
            if (supportsTwoPhaseReplication && this._operationLogger.isLoggable(Level.FINEST)) {
                this._operationLogger.finest("prepared transaction [" + this._engine.createTransactionDetailsString(transaction, null) + "] result=" + prepareResult);
            }
            return prepareResult;
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
    }

    @Override
    public Object prepare(TransactionManager mgr, long id, boolean needClusteredProxy) throws UnknownTransactionException, RemoteException {
        int vote = this.prepareImpl(mgr, id, 1, true);
        return needClusteredProxy ? new ExtendedPrepareResult(vote, (IDirectSpaceProxy)this.getSpaceProxy()) : new ExtendedPrepareResult(vote, null);
    }

    @Override
    public Object prepare(TransactionManager mgr, Object parm2, boolean needClusteredProxy) throws UnknownTransactionException, RemoteException {
        int vote = this.prepareImpl(mgr, parm2, 1, true);
        return needClusteredProxy ? new ExtendedPrepareResult(vote, (IDirectSpaceProxy)this.getSpaceProxy()) : new ExtendedPrepareResult(vote, null);
    }

    @Override
    public Object prepare(TransactionManager mgr, Object parm2, int numOfParticipants, boolean needClusteredProxy) throws UnknownTransactionException, RemoteException {
        int vote = this.prepareImpl(mgr, parm2, numOfParticipants, true);
        return needClusteredProxy ? new ExtendedPrepareResult(vote, (IDirectSpaceProxy)this.getSpaceProxy()) : new ExtendedPrepareResult(vote, null);
    }

    public int prepareAndCommit(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        return this.prepareAndCommit(mgr, (Object)id);
    }

    @Override
    public int prepareAndCommit(TransactionManager mgr, Object id) throws UnknownTransactionException, RemoteException {
        return this.prepareAndCommitImpl(mgr, id, null);
    }

    public int prepareAndCommitImpl(TransactionManager mgr, Object id, OperationID operationID) throws RemoteException, UnknownTransactionException {
        this.beforeOperation(true, true, null);
        ServerTransaction st = this.createServerTransaction(mgr, id);
        try {
            return this._engine.prepareAndCommit(mgr, st, operationID);
        }
        catch (RuntimeException e) {
            this.logException(e);
            throw e;
        }
    }

    private void renewLocalXtn(TransactionManager mgr, Object id, long time) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        this.beforeOperation(true, true, null);
        try {
            this._engine.renewXtn(this.createServerTransaction(mgr, id), time);
        }
        catch (RuntimeException e) {
            throw this.logException(e);
        }
    }

    public void renewLease(TransactionManager mgr, long id, long time) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        this.renewLocalXtn(mgr, id, time);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeTask(SpaceTask task, Transaction tx, SpaceContext sc, boolean newRouter) throws RemoteException, ExecutionException {
        Object t;
        String typeName = task instanceof SpaceTaskWrapper ? ((SpaceTaskWrapper)((Object)task)).getWrappedTask().getClass().getName() : task.getClass().getName();
        boolean isSystemTask = task instanceof SystemTask;
        boolean supportsBackup = false;
        SpaceAuthority.SpacePrivilege privilege = SpaceAuthority.SpacePrivilege.EXECUTE;
        if (isSystemTask) {
            SystemTask systemTask = (SystemTask)task;
            SpaceActionExecutor executor = this.getActionExecutor(systemTask);
            supportsBackup = executor.supportsBackup();
            privilege = executor.getPrivilege();
            systemTask.getSpaceRequestInfo().setSpaceContext(sc);
        }
        this.beforeTypeOperation(!supportsBackup, sc, privilege, typeName);
        this._engine.getMemoryManager().monitorMemoryUsage(true);
        if (!isSystemTask) {
            this._engine.invokeFilters(sc, 20, task);
        }
        IDirectSpaceProxy spaceProxy = this.getTaskProxy().getDirectProxy();
        SpaceContext prevContext = null;
        try {
            if (tx != null && newRouter) {
                XtnEntry xtnEntry = this._engine.getTransactionHandler().attachToXtnGranular((ServerTransaction)tx, false);
                xtnEntry.setOperatedUpon();
            }
            if (this.isSecuredSpace()) {
                prevContext = spaceProxy.getSecurityManager().setThreadSpaceContext(this._securityInterceptor.trustContext(sc));
            }
            Object result = task.execute(spaceProxy, tx);
            if (!isSystemTask && this._engine.getFilterManager()._isFilter[21]) {
                this._engine.invokeFilters(sc, 21, result);
            }
            t = result;
            if (this.isSecuredSpace()) {
                spaceProxy.getSecurityManager().setThreadSpaceContext(prevContext);
            }
        }
        catch (RemoteException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new ExecutionException(e2);
                }
            }
            catch (Throwable throwable) {
                Class<?> oneTimeClass2;
                if (this.isSecuredSpace()) {
                    spaceProxy.getSecurityManager().setThreadSpaceContext(prevContext);
                }
                if ((oneTimeClass2 = this.getOneTimeClassIfExists(task)) != null) {
                    if (this._logger.isLoggable(Level.FINEST)) {
                        this._logger.finest("Dropping class of OneTime task " + oneTimeClass2.getName());
                    }
                    ClassLoaderCache.getCache().removeClassLoader(oneTimeClass2.getClassLoader());
                }
                throw throwable;
            }
        }
        Class<?> oneTimeClass = this.getOneTimeClassIfExists(task);
        if (oneTimeClass != null) {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest("Dropping class of OneTime task " + oneTimeClass.getName());
            }
            ClassLoaderCache.getCache().removeClassLoader(oneTimeClass.getClassLoader());
        }
        return t;
    }

    private Class<?> getOneTimeClassIfExists(SpaceTask task) {
        SupportCodeChange annotation;
        if (task instanceof SpaceTaskWrapper) {
            SpaceTaskWrapper wrapper = (SpaceTaskWrapper)((Object)task);
            SupportCodeChangeAnnotationContainer supportCodeChange = wrapper.getSupportCodeChangeAnnotationContainer();
            return supportCodeChange != null && supportCodeChange.getVersion().isEmpty() ? wrapper.getWrappedTask().getClass() : null;
        }
        boolean isOneTime = false;
        if (task.getClass().isAnnotationPresent(SupportCodeChange.class) && (annotation = task.getClass().getAnnotation(SupportCodeChange.class)).id().isEmpty()) {
            isOneTime = true;
        }
        return isOneTime ? task.getClass() : null;
    }

    @Override
    public IReplicationConnectionProxy getReplicationRouterConnectionProxy() throws RemoteException {
        SpaceEngine engine = this._engine;
        if (engine == null) {
            throw new RemoteException("engine is being created");
        }
        return (IReplicationConnectionProxy)engine.getReplicationManager().getReplicationRouter().getMyStubHolder().getStub();
    }

    @Override
    public NIODetails getNIODetails() {
        return NIOInfoHelper.getDetails();
    }

    @Override
    public NIOStatistics getNIOStatistics() {
        return NIOInfoHelper.getNIOStatistics();
    }

    @Override
    public void enableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.enableMonitoring();
    }

    @Override
    public void disableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.disableMonitoring();
    }

    @Override
    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return NIOInfoHelper.fetchMonitoringDetails();
    }

    @Override
    public long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    @Override
    public OSDetails getOSDetails() {
        return OSHelper.getDetails();
    }

    @Override
    public OSStatistics getOSStatistics() {
        return OSHelper.getStatistics();
    }

    @Override
    public JVMDetails getJVMDetails() {
        return JVMHelper.getDetails();
    }

    @Override
    public JVMStatistics getJVMStatistics() {
        return JVMHelper.getStatistics();
    }

    @Override
    public void runGc() {
        System.gc();
    }

    @Override
    public String[] getZones() {
        return ZoneHelper.getSystemZones();
    }

    @Override
    public boolean isStatisticsAvailable() {
        return this._statistics != null;
    }

    @Override
    public String[] getStatisticsStringArray() throws StatisticsNotAvailable {
        this.assertStatisticsAvailable();
        return this._statistics.toStringArray();
    }

    @Override
    public long getStatisticsSamplingRate() throws StatisticsNotAvailable {
        this.assertStatisticsAvailable();
        return this._statistics.getPeriod();
    }

    @Override
    public void setStatisticsSamplingRate(long rate) throws StatisticsNotAvailable {
        this.assertStatisticsAvailable();
        this._statistics.setPeriod(rate);
    }

    @Override
    public Map<Integer, StatisticsContext> getStatistics() throws StatisticsNotAvailable {
        this.assertStatisticsAvailable();
        return this._statistics.getStatistics();
    }

    @Override
    public StatisticsContext getStatistics(int operationCode) throws StatisticsNotAvailable {
        this.assertStatisticsAvailable();
        return this._statistics.getStatistics(operationCode);
    }

    @Override
    public Map<Integer, StatisticsContext> getStatistics(Integer[] operationCodes) throws StatisticsNotAvailable {
        this.assertStatisticsAvailable();
        HashMap<Integer, StatisticsContext> result = new HashMap<Integer, StatisticsContext>(operationCodes.length);
        for (Integer code : operationCodes) {
            result.put(code, this._statistics.getStatistics().get(code));
        }
        return result;
    }

    @Override
    public StatisticsHolder getHolder() {
        SpaceEngine engine = this._engine;
        if (engine == null) {
            return new StatisticsHolder(new long[]{-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L});
        }
        if (engine.isMirrorService()) {
            StatisticsHolder mirrorStat = new StatisticsHolder(new long[]{-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L});
            mirrorStat.setMirrorStatistics(this._engine.getReplicationManager().getMirrorService().getMirrorStatistics());
            return mirrorStat;
        }
        if (!this.isStatisticsAvailable()) {
            return new StatisticsHolder(new long[]{-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L});
        }
        long[] totalCounts = new long[StatisticsHolder.getOperationCodes().length];
        for (int i = 0; i < totalCounts.length; ++i) {
            totalCounts[i] = this._statistics.getStatistics(StatisticsHolder.getOperationCodes()[i]).getCurrentCount();
        }
        StatisticsHolder stat = new StatisticsHolder(totalCounts);
        if (engine.isReplicated()) {
            stat.setReplicationStatistics(engine.getReplicationNode().getAdmin().getStatistics());
        }
        stat.setProcessorQueueSize(engine.getProcessorQueueSize());
        stat.setNotifierQueueSize(engine.getNotifierQueueSize());
        try {
            long numOfEntries = engine.getCacheManager().getNumberOfEntries();
            long numOTemplates = engine.getCacheManager().getNumberOfNotifyTemplates();
            int numOfConnections = this.countIncomingConnections();
            int transactions = this.countTransactions(0, 1);
            stat.setRuntimeStatisticsHolder(new RuntimeStatisticsHolder(numOfEntries, numOTemplates, numOfConnections, transactions));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        stat.setBlobStoreStatistics(engine.getCacheManager().getBlobStoreStatistics());
        return stat;
    }

    @Override
    public Map<String, Object> getMetricSnapshots(Collection<String> prefixes) throws RemoteException {
        if (this._engine == null) {
            return new HashMap<String, Object>(0);
        }
        Map<String, Object> metricsSnapshotByPrefix = this._engine.getMetricsSnapshotByPrefix(prefixes);
        return metricsSnapshotByPrefix;
    }

    private void assertStatisticsAvailable() throws StatisticsNotAvailable {
        if (this._statistics == null) {
            throw this._statNotAvailableEx;
        }
    }

    @Override
    public SpaceRuntimeInfo getRuntimeInfo() throws RemoteException {
        this.beforeOperation(false, false, null);
        return this._engine.getRuntimeInfo();
    }

    @Override
    public SpaceRuntimeInfo getRuntimeInfo(String className) throws RemoteException {
        this.beforeOperation(false, false, null);
        return this._engine.getRuntimeInfo(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpaceConfig getConfig() {
        SpaceImpl spaceImpl = this;
        synchronized (spaceImpl) {
            if (this._spaceConfig != null && this._spaceConfig.getCachePolicy().equals(3) && this._spaceConfig.getBlobStoreDevices() == null) {
                this._spaceConfig = null;
            }
            if (this._spaceConfig != null) {
                return this._spaceConfig;
            }
            Properties spaceProps = JProperties.getSpaceProperties(this._configReader.getFullSpaceName());
            this._spaceConfig = new SpaceConfig(this._spaceName, spaceProps, this._containerName, "");
            this._spaceConfig.setClusterPolicy(this._clusterPolicy);
            this._spaceConfig.setClusterInfo(this._clusterInfo);
            this._spaceConfig.setLoadOnStartup(this._jspaceAttr.isLoadOnStartup());
            this._spaceConfig.setSpaceState(String.valueOf(this._spaceState.getState()));
            String schemaFilePath = spaceProps.getProperty("schemaFilePath");
            if (schemaFilePath != null) {
                this._spaceConfig.setSchemaPath(schemaFilePath);
            }
            this.initSpaceConfig(this._spaceConfig, this._configReader, schemaFilePath);
        }
        return this._spaceConfig;
    }

    private void initSpaceConfig(SpaceConfig spaceConfig, SpaceConfigReader configReader, String schemaFilePath) {
        String schemaName = configReader.getSpaceProperty("schema", null);
        spaceConfig.setPrivate(configReader.getBooleanSpaceProperty("isPrivate", Boolean.FALSE.toString()));
        if (schemaName != null) {
            spaceConfig.setSchemaName(schemaName);
        }
        spaceConfig.setConnectionRetries(configReader.getSpaceProperty("retries", "10"));
        spaceConfig.setNotifyRetries(configReader.getSpaceProperty("notifier-retries", "3"));
        spaceConfig.setExpirationTimeInterval(configReader.getSpaceProperty("lease_manager.expiration_time_interval", String.valueOf(10000L)));
        spaceConfig.setExpirationTimeRecentDeletes(configReader.getSpaceProperty("lease_manager.expiration_time_recent_deletes", String.valueOf(180000L)));
        spaceConfig.setExpirationTimeRecentUpdate(configReader.getSpaceProperty("lease_manager.expiration_time_recent_updates", String.valueOf(180000L)));
        spaceConfig.setExpirationStaleReplicas(configReader.getSpaceProperty("lease_manager.expiration_stale_replicas", String.valueOf(300000L)));
        spaceConfig.setEngineMemoryUsageEnabled(configReader.getSpaceProperty("engine.memory_usage.enabled", "true"));
        spaceConfig.setEngineMemoryUsageHighPercentageRatio(configReader.getSpaceProperty("engine.memory_usage.high_watermark_percentage", "95"));
        spaceConfig.setEngineMemoryUsageLowPercentageRatio(configReader.getSpaceProperty("engine.memory_usage.low_watermark_percentage", "75"));
        spaceConfig.setEngineMemoryUsageWriteOnlyBlockPercentageRatio(configReader.getSpaceProperty("engine.memory_usage.write_only_block_percentage", "85"));
        spaceConfig.setEngineMemoryWriteOnlyCheckPercentageRatio(configReader.getSpaceProperty("engine.memory_usage.write_only_check_percentage", "76"));
        spaceConfig.setEngineMemoryUsageEvictionBatchSize(configReader.getSpaceProperty("engine.memory_usage.eviction_batch_size", "500"));
        spaceConfig.setEngineMemoryUsageRetryCount(configReader.getSpaceProperty("engine.memory_usage.retry_count", "5"));
        spaceConfig.setEngineMemoryExplicitGSEnabled(configReader.getSpaceProperty("engine.memory_usage.explicit-gc", "false"));
        spaceConfig.setEngineMemoryGCBeforeShortageEnabled(configReader.getSpaceProperty("engine.memory_usage.gc-before-shortage", "true"));
        String serilType = configReader.getSpaceProperty("serialization-type", Constants.Engine.ENGINE_SERIALIZATION_TYPE_DEFAULT);
        if (serilType != null) {
            spaceConfig.setSerializationType(Integer.parseInt(serilType));
        }
        spaceConfig.setEngineMinThreads(configReader.getSpaceProperty("engine.min_threads", "1"));
        spaceConfig.setEngineMaxThreads(configReader.getSpaceProperty("engine.max_threads", "64"));
        boolean isPersitent = configReader.getBooleanSpaceProperty("persistent.enabled", Constants.StorageAdapter.PERSISTENT_ENABLED_DEFAULT);
        spaceConfig.setPersistent(isPersitent);
        spaceConfig.setMirrorServiceEnabled(configReader.getBooleanSpaceProperty("mirror-service.enabled", "false"));
        spaceConfig.setDataSourceClass(configReader.getSpaceProperty("external-data-source.data-source-class", "org.openspaces.persistency.hibernate.DefaultHibernateExternalDataSource"));
        spaceConfig.setDataClass(configReader.getSpaceProperty("external-data-source.data-class", Constants.DataAdapter.DATA_CLASS_DEFAULT));
        spaceConfig.setQueryBuilderClass(configReader.getSpaceProperty("external-data-source.query-builder-class", Constants.DataAdapter.QUERY_BUILDER_PROP_DEFAULT));
        spaceConfig.setDataPropertiesFile(configReader.getSpaceProperty("external-data-source.init-properties-file", ""));
        spaceConfig.setUsage(configReader.getSpaceProperty("external-data-source.usage", "read-write"));
        spaceConfig.setSupportsInheritanceEnabled(configReader.getBooleanSpaceProperty("external-data-source.supports-inheritance", "true"));
        spaceConfig.setSupportsVersionEnabled(configReader.getBooleanSpaceProperty("external-data-source.supports-version", "false"));
        spaceConfig.setSupportsPartialUpdateEnabled(configReader.getBooleanSpaceProperty("external-data-source.supports-partial-update", "false"));
        spaceConfig.setSupportsRemoveByIdEnabled(configReader.getBooleanSpaceProperty("external-data-source.supports-remove-by-id", "false"));
        spaceConfig.setDataSourceSharedIteratorMode(configReader.getBooleanSpaceProperty("external-data-source.shared-iterator.enabled", "true"));
        String dataSourceShareIteratorTTLDefault = DataAdaptorIterator.getDataSourceShareIteratorTTLDefault(Long.parseLong(spaceConfig.getExpirationTimeRecentDeletes()), Long.parseLong(spaceConfig.getExpirationTimeRecentUpdates()));
        spaceConfig.setDataSourceSharedIteratorTimeToLive(configReader.getLongSpaceProperty("external-data-source.shared-iterator.time-to-live", dataSourceShareIteratorTTLDefault));
        spaceConfig.setQPAutoCommit(configReader.getBooleanSpaceProperty("QueryProcessor.auto_commit", Constants.QueryProcessorInfo.QP_AUTO_COMMIT_DEFAULT));
        spaceConfig.setQPParserCaseSensetivity(configReader.getBooleanSpaceProperty("QueryProcessor.parser_case_sensetivity", Constants.QueryProcessorInfo.QP_PARSER_CASE_SENSETIVITY_DEFAULT));
        spaceConfig.setQPTraceExecTime(configReader.getBooleanSpaceProperty("QueryProcessor.trace_exec_time", Constants.QueryProcessorInfo.QP_TRACE_EXEC_TIME_DEFAULT));
        spaceConfig.setQpTransactionTimeout(configReader.getIntSpaceProperty("QueryProcessor.transaction_timeout", Constants.QueryProcessorInfo.QP_TRANSACTION_TIMEOUT_DEFAULT));
        spaceConfig.setQpSpaceReadLeaseTime(configReader.getIntSpaceProperty("QueryProcessor.space_read_lease_time", Constants.QueryProcessorInfo.QP_SPACE_READ_LEASE_TIME_DEFAULT));
        spaceConfig.setQpSpaceWriteLeaseTime(configReader.getLongSpaceProperty("QueryProcessor.space_write_lease", Constants.QueryProcessorInfo.QP_SPACE_WRITE_LEASE_DEFAULT));
        spaceConfig.setQpDateFormat(configReader.getSpaceProperty("QueryProcessor.date_format", "yyyy-MM-dd"));
        spaceConfig.setQpDateTimeFormat(configReader.getSpaceProperty("QueryProcessor.datetime_format", "yyyy-MM-dd HH:mm:ss"));
        spaceConfig.setQpTimeFormat(configReader.getSpaceProperty("QueryProcessor.time_format", "HH:mm:ss"));
        spaceConfig.setCacheManagerSize(configReader.getSpaceProperty("engine.cache_size", "100000"));
        String defaultCachePolicyValue = isPersitent ? String.valueOf(0) : String.valueOf(1);
        spaceConfig.setCachePolicy(configReader.getSpaceProperty("engine.cache_policy", defaultCachePolicyValue));
        spaceConfig.setClusterConfigURL(configReader.getSpaceProperty("cluster.config-url", "none", false));
        spaceConfig.setClustered(configReader.getBooleanSpaceProperty("cluster.enabled", Constants.Cluster.IS_CLUSTER_SPACE_DEFAULT));
        JSpaceAttributes spaceAttr = (JSpaceAttributes)JProperties.getSpaceProperties(configReader.getFullSpaceName());
        if (spaceAttr != null) {
            spaceConfig.setDCacheConfigName(spaceAttr.getDCacheConfigName());
            spaceConfig.setDCacheProperties(spaceAttr.getDCacheProperties());
        }
        int filterCounter = 0;
        String fnames = configReader.getSpaceProperty("filters.filter-names", "");
        StringTokenizer st = new StringTokenizer(fnames, ",");
        spaceConfig.setFiltersInfo(new FiltersInfo[st.countTokens()]);
        while (st.hasMoreElements()) {
            String filterName = st.nextToken().trim();
            FiltersInfo info = new FiltersInfo();
            spaceConfig.setFilterInfoAt(info, filterCounter++);
            info.filterName = filterName;
            info.enabled = configReader.getBooleanSpaceProperty("filters." + filterName + "." + "enabled", Constants.Filter.DEFAULT_FILTER_ENABLE_VALUE);
            info.filterClassName = configReader.getSpaceProperty("filters." + filterName + "." + "class", "");
            info.paramURL = configReader.getSpaceProperty("filters." + filterName + "." + "url", "");
            String operationsCode = configReader.getSpaceProperty("filters." + filterName + "." + "operation-code", "");
            StringTokenizer operStrToken = new StringTokenizer(operationsCode, ",");
            while (operStrToken.hasMoreTokens()) {
                int operCode = Integer.parseInt(operStrToken.nextToken().trim());
                switch (operCode) {
                    case 53: {
                        info.afterRemove = true;
                        break;
                    }
                    case 1: {
                        info.afterWrite = true;
                        break;
                    }
                    case 8: {
                        info.beforeClean = true;
                        break;
                    }
                    case 4: {
                        info.beforeNotify = true;
                        break;
                    }
                    case 2: {
                        info.beforeRead = true;
                        break;
                    }
                    case 3: {
                        info.beforeTake = true;
                        break;
                    }
                    case 0: {
                        info.beforeWrite = true;
                        break;
                    }
                    case 22: {
                        info.afterRead = true;
                        break;
                    }
                    case 23: {
                        info.afterTake = true;
                        break;
                    }
                    case 5: {
                        info.beforeGetAdmin = true;
                        break;
                    }
                    case 6: {
                        info.beforeAuthentication = true;
                        break;
                    }
                    case 9: {
                        info.beforeUpdate = true;
                        break;
                    }
                    case 10: {
                        info.afterUpdate = true;
                    }
                }
            }
            if (!filterName.equalsIgnoreCase("DefaultSecurityFilter")) continue;
            String schemaRef = schemaFilePath != null ? " [" + schemaFilePath + "] " : " ";
            this._logger.warning("The filter [DefaultSecurityFilter] defined in the space schema file" + schemaRef + "is no longer in use since 7.0.1; Please remove it.");
        }
        spaceConfig.setProxyConnectionMode(configReader.getSpaceProperty("proxy-settings.connection-monitor", "all"));
        spaceConfig.setProxyMonitorFrequency(configReader.getLongSpaceProperty("proxy-settings.ping-frequency", Constants.SpaceProxy.OldRouter.MONITOR_FREQUENCY_DEFAULT));
        spaceConfig.setProxyDetectorFrequency(configReader.getLongSpaceProperty("proxy-settings.lookup-frequency", Constants.SpaceProxy.OldRouter.DETECTOR_FREQUENCY_DEFAULT));
        spaceConfig.setProxyConnectionRetries(configReader.getIntSpaceProperty("proxy-settings.connection-retries", "10"));
    }

    @Override
    public void start() throws RemoteException {
        if (!Boolean.getBoolean("com.gs.enabled-backward-space-lifecycle-admin")) {
            throw new UnsupportedOperationException("Invoking start on a space has reached end of life and it is no longer supported");
        }
        this.startInternal();
    }

    public void startInternal() throws RemoteException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("Starting space [url=" + this.getURL() + "]...");
        }
        if (this._spaceState.getState() == 1) {
            throw new SpaceAlreadyStartedException("Space [" + this.getServiceName() + "] already started");
        }
        boolean isLookupServiceEnabled = this.isLookupServiceEnabled();
        try {
            this._clusterFailureDetector = SpaceImpl.initClusterFailureDetector(this._clusterPolicy);
            this._engine = new SpaceEngine(this);
            if (isLookupServiceEnabled) {
                this.registerLookupService();
            }
            this._directPersistencyRecoveryHelper = this.initDirectPersistencyRecoveryHelper(this._clusterPolicy);
            this._leaderSelector = this.initLeaderSelectorHandler(isLookupServiceEnabled);
            this.initReplicationStateBasedOnActiveElection();
            this.recover();
            this._qp = this.createQueryProcessor();
            if (this._logger.isLoggable(Level.INFO) && !this.isPrivate()) {
                long duration = System.currentTimeMillis() - this._container.getStartTime();
                this._logger.log(Level.FINE, "Space started [duration=" + (double)duration / 1000.0 + "s, url=" + this.getURL() + ", " + this._engine.getCacheManager().getConfigInfo() + "]");
            }
        }
        catch (Throwable ex) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, "Failed to start space with url [" + this.getURL() + "]", ex);
            }
            this.shutdown(false, true);
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    private ServiceTemplate buildServiceTemplate(ClusterPolicy clusterPolicy, boolean isPrimary) {
        ClusterName clusterName = new ClusterName(clusterPolicy.m_ClusterName);
        ClusterGroup clusterGroup = new ClusterGroup(clusterPolicy.m_FailOverPolicy.getElectionGroupName(), null, null);
        State state = new State();
        state.setElectable(Boolean.TRUE);
        ContainerName containerName = new ContainerName(this._containerName);
        Entry[] spaceTemplAttr = isPrimary ? new Entry[]{clusterName, clusterGroup, state, containerName} : new Entry[]{clusterName, clusterGroup, state};
        Class[] serviceTypes = new Class[]{Service.class};
        return new ServiceTemplate(null, serviceTypes, spaceTemplAttr);
    }

    private void registerLookupService() throws CreateException {
        try {
            this.registerLookupService(new WeakDiscoveryListener(this), false);
        }
        catch (Throwable e) {
            throw new CreateException("Failed to create Join Manager for [" + this.getServiceName() + "]", e);
        }
    }

    private DirectPersistencyRecoveryHelper initDirectPersistencyRecoveryHelper(ClusterPolicy clusterPolicy) {
        boolean isBlobStore;
        DirectPersistencyRecoveryHelper result = null;
        boolean bl = isBlobStore = this._configReader.getIntSpaceProperty("engine.cache_policy", "-1") == 3;
        if (clusterPolicy != null && clusterPolicy.isPrimaryElectionAvailable() && isBlobStore && this._engine.getCacheManager().isPersistentBlobStore()) {
            this._spaceState.setState(0);
            result = new DirectPersistencyRecoveryHelper(this, this._logger);
            result.beforePrimaryElectionProcess();
        }
        return result;
    }

    private void recover() throws Exception {
        this._recovering.set(true);
        this._recoveryManager = new RecoveryManager(this);
        if (this._leaderSelector != null) {
            this.initAndStartPrimaryBackupSpace();
        } else {
            this.initAndStartRegularSpace();
        }
        this._recovering.set(false);
    }

    private static ClusterFailureDetector initClusterFailureDetector(ClusterPolicy clusterPolicy) {
        ClusterFailureDetector result = null;
        if (clusterPolicy != null) {
            if (clusterPolicy.isPrimaryElectionAvailable()) {
                result = new ClusterFailureDetector(clusterPolicy.m_FailOverPolicy.getActiveElectionConfig().getFDHConfig());
            } else if (clusterPolicy.m_ReplicationPolicy != null) {
                result = new ClusterFailureDetector();
            }
        }
        return result;
    }

    @Override
    public void stop() throws RemoteException {
        if (!Boolean.getBoolean("com.gs.enabled-backward-space-lifecycle-admin")) {
            throw new UnsupportedOperationException("Invoking stop on a space has reached end of life and it is no longer supported");
        }
        this.stopInternal();
    }

    public void stopInternal() throws RemoteException {
        if (!this._spaceState.isAborted() && this._spaceState.isStopped()) {
            throw new SpaceAlreadyStoppedException(this.getServiceName(), "Space [" + this.getServiceName() + "] already stopped");
        }
        int previousState = this._spaceState.getState();
        if (!this._spaceState.isAborted()) {
            this._spaceState.setState(2);
        }
        try {
            if (this._leaderSelector != null) {
                this._leaderSelector.terminate();
            }
            try {
                this.close();
            }
            catch (Exception e) {
                this._logger.info("Ignoring caught exception: " + e + " while stopping Space");
            }
            if (this._qp != null) {
                try {
                    this._qp.close();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            this.modifyLookupAttributes(new Entry[]{new State()}, new Entry[]{new State(2, Boolean.FALSE, Boolean.FALSE)});
            this._logger.info("Space Stopped successfully");
        }
        catch (Exception ex) {
            this._logger.log(Level.WARNING, "Failed to stop space", ex);
            if (!this._spaceState.isAborted()) {
                this._spaceState.setState(previousState);
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void restart() throws RemoteException {
        if (!Boolean.getBoolean("com.gs.enabled-backward-space-lifecycle-admin")) {
            throw new UnsupportedOperationException("Invoking restart on a space has reached end of life and it is no longer supported");
        }
        this.beforeOperation(false, false, null);
        try {
            String spaceConfigFileURL = JProperties.getURL(this.getServiceName());
            if (spaceConfigFileURL != null) {
                JProperties.setUrlWithoutSchema(this.getServiceName(), null, spaceConfigFileURL);
            } else {
                String schemaName = this._jspaceAttr.getSchemaName();
                InputStream inputStream = ResourceLoader.findSpaceSchema(schemaName).getInputStream();
                JProperties.setUrlWithSchema(this.getServiceName(), this._customProperties, inputStream);
            }
            this._spaceConfig = null;
            this._spaceConfig = this.getConfig();
            System.setProperty("com.gs.container.name", this._containerName);
            System.setProperty("com.gs.space.name", this._spaceName);
            Properties spaceProperties = JProperties.getSpaceProperties(this.getServiceName());
            if (this._url != null && this._url.getClusterSchema() != null) {
                spaceProperties.setProperty(this.getServiceName() + "." + "space-config." + "." + "cluster.enabled", Boolean.TRUE.toString());
                this._spaceConfig.setClustered(true);
            }
        }
        catch (Exception ex) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, ex.toString(), ex);
            }
            throw new RemoteException(ex.getMessage(), ex.getCause());
        }
        this.internalClean(false, true, true);
        String clusterName = "NONE";
        if (this.getClusterPolicy() != null) {
            clusterName = this.getClusterPolicy().m_ClusterName;
        }
        this.modifyLookupAttributes(new Entry[]{new ClusterName(), new State()}, new Entry[]{new ClusterName(clusterName), new State(this.getState(), Boolean.TRUE, Boolean.TRUE)});
    }

    @Override
    public SpaceInstanceRemoteClassLoaderInfo getSpaceInstanceRemoteClassLoaderInfo() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader instanceof ServiceClassLoader) {
            CodeChangeClassLoadersManager codeChangeClassLoadersManager = ((ServiceClassLoader)contextClassLoader).getCodeChangeClassLoadersManager();
            return codeChangeClassLoadersManager.createSpaceInstanceRemoteClassLoaderInfo();
        }
        throw new UnsupportedOperationException("not ServiceClassLoader");
    }

    @Override
    public Object[] getReplicationStatus() throws RemoteException {
        this.beforeOperation(false, false, null);
        return this._engine.getReplicationStatus();
    }

    @Override
    public ClusterPolicy getClusterPolicy() {
        return this._clusterPolicy;
    }

    public SpaceClusterInfo getClusterInfo() {
        return this._clusterInfo;
    }

    @Override
    public BasicTypeInfo getClassTypeInfo(String className) throws RemoteException {
        ITypeDesc typeDesc = this.getClassDescriptor(className);
        if (typeDesc.isInactive()) {
            return null;
        }
        return new BasicTypeInfo(typeDesc);
    }

    @Override
    public void dropClass(String className, SpaceContext sc) throws RemoteException, DropClassException {
        this.beforeTypeOperation(false, sc, SpaceAuthority.SpacePrivilege.ALTER, className);
        this._engine.dropClass(className);
        if (this._embeddedProxy != null) {
            this._embeddedProxy.directDropClass(className);
        }
        if (this._clusteredProxy != null) {
            this._clusteredProxy.directDropClass(className);
        }
        if (this._taskProxy != null) {
            this._taskProxy.directDropClass(className);
        }
        LRMIClassLoadersHolder.dropClass(className);
    }

    @Override
    public int getState() {
        return this._spaceState.getState();
    }

    @Override
    public void disableStub() throws RemoteException {
        try {
            if (this._spaceStub != null) {
                this._stubHandler.unexportObject(this);
                this._spaceStub = null;
            }
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public RuntimeHolder getRuntimeHolder() throws RemoteException {
        this.beforeOperation(false, false, null);
        Object[] replicationStatus = null;
        if (this._engine.isReplicated()) {
            replicationStatus = this._engine.getReplicationNode().getAdmin().getStatus();
        }
        return new RuntimeHolder(this.getSpaceMode(), replicationStatus, this.getState(), this.getQuiesceHandler().getSuspendInfo());
    }

    @Override
    public boolean isStartedWithinGSC() {
        return System.getProperty("com.gigaspaces.gsc.running", "false").equals("true");
    }

    public String getDeployPath() {
        return this._deployPath;
    }

    @Override
    public SpaceCopyStatus spaceCopy(String remoteUrl, ITemplatePacket template, boolean includeNotifyTemplates, int chunkSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SpaceCopyStatus spaceCopy(String remoteUrl, ITemplatePacket template, boolean includeNotifyTemplates, int chunkSize, SpaceContext sc) throws RemoteException {
        this.beginPacketOperation(false, sc, SpaceAuthority.SpacePrivilege.WRITE, template);
        try {
            IDirectSpaceProxy abstractSpaceProxy;
            int findTimeout = 3000;
            SpaceURL remoteSpaceUrl = SpaceURLParser.parseURL(remoteUrl);
            remoteSpaceUrl.setProperty("timeout", String.valueOf(3000));
            try {
                abstractSpaceProxy = (IDirectSpaceProxy)SpaceFinder.find(remoteSpaceUrl);
            }
            catch (FinderException ex) {
                SpaceCopyStatusImpl copyStatus = new SpaceCopyStatusImpl(2, this.getServiceName());
                copyStatus.setCauseException(ex);
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, ex.toString(), ex);
                }
                SpaceCopyStatusImpl spaceCopyStatusImpl = copyStatus;
                this.endPacketOperation();
                return spaceCopyStatusImpl;
            }
            String sourceMemberName = abstractSpaceProxy.getRemoteMemberName();
            IRemoteSpace remoteJSpace = abstractSpaceProxy.getRemoteJSpace();
            SpaceCopyStatus spaceCopyStatus = this.spaceCopy(remoteJSpace, remoteUrl, sourceMemberName, template, includeNotifyTemplates, chunkSize, sc, sc);
            return spaceCopyStatus;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
        finally {
            this.endPacketOperation();
        }
    }

    @Override
    public SpaceCopyStatus spaceCopy(IRemoteSpace remoteProxy, String remoteSpaceUrl, String remoteSpaceName, ITemplatePacket template, boolean includeNotifyTemplates, int chunkSize, SpaceContext sc, SpaceContext remoteSpaceContext) throws RemoteException {
        this.checkPacketAccessPrivileges(sc, SpaceAuthority.SpacePrivilege.WRITE, template);
        try {
            SpaceURL url = SpaceURLParser.parseURL(remoteSpaceUrl);
            ISpaceCopyReplicaState spaceCopyReplica = this._engine.spaceCopyReplica(url, remoteSpaceName, remoteProxy, template, includeNotifyTemplates, chunkSize, sc, remoteSpaceContext);
            return spaceCopyReplica.getCopyResult().toOldResult((short)2, remoteSpaceName);
        }
        catch (MalformedURLException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public TransactionInfo[] getTransactionsInfo(int type, int status) throws RemoteException {
        return this._engine.getTransactionsInfo(type, status);
    }

    @Override
    public int countTransactions(int type, int status) throws RemoteException {
        return this._engine.countTransactions(type, status);
    }

    @Override
    public List<TemplateInfo> getTemplatesInfo(String className) throws RemoteException {
        return this._engine.getTemplatesInfo(className);
    }

    @Override
    public List<ITransportConnection> getConnectionsInfo() throws RemoteException {
        if (this._engine.isLocalCache()) {
            return Collections.emptyList();
        }
        IRemoteSpace dynamicProxy = (IRemoteSpace)((LRMISpaceImpl)this.getSpaceStub()).getDynamicProxy();
        long remoteObjID = TransportProtocolHelper.getRemoteObjID(dynamicProxy);
        return LRMIRuntime.getRuntime().getRemoteObjectConnectionsList(remoteObjID);
    }

    @Override
    public int countIncomingConnections() throws RemoteException {
        return this._engine.countIncomingConnections();
    }

    @Override
    public List<UnderTxnLockedObject> getLockedObjects(Transaction txn) throws RemoteException {
        return this._engine.getLockedObjects(txn);
    }

    @Override
    public SpaceMode getSpaceMode() {
        return this._leaderSelector != null ? this._leaderSelector.getSpaceMode() : SpaceMode.PRIMARY;
    }

    public boolean isPrimary() {
        return this.getSpaceMode() == SpaceMode.PRIMARY;
    }

    public boolean isBackup() {
        return this.getSpaceMode() == SpaceMode.BACKUP;
    }

    @Override
    public SpaceMode addSpaceModeListener(ISpaceModeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Callback listener supplied for space mode changes is <null>.");
        }
        this.primarySpaceModeListeners.addListener(listener);
        return this.getSpaceMode();
    }

    @Override
    public void removeSpaceModeListener(ISpaceModeListener listener) {
        this.primarySpaceModeListeners.removeListener(listener);
    }

    @Override
    public ITypeDesc getClassDescriptor(String className) throws RemoteException {
        this.beforeOperation(false, true, null);
        try {
            return this._engine.getClassTypeInfo(className);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void forceMoveToPrimary() throws RemoteException {
        if (this._leaderSelector == null) {
            throw new IllegalArgumentException("Space doesn't support primary/backup mode. ");
        }
        this._leaderSelector.forceMoveToPrimary();
    }

    @Override
    public String getReplicationDump() {
        return this._engine.getReplicationNode().getAdmin().dumpState();
    }

    public void assertAuthorizedForType(String typeName, SpaceAuthority.SpacePrivilege privilege, SpaceContext spaceContext) {
        if (this._securityInterceptor != null) {
            this._securityInterceptor.intercept(SpaceContextHelper.getSecurityContext(spaceContext), privilege, typeName);
        }
    }

    public void assertAuthorizedForPrivilege(Privilege privilege, SpaceContext spaceContext) {
        if (this._securityInterceptor != null) {
            this._securityInterceptor.intercept(SpaceContextHelper.getSecurityContext(spaceContext), privilege, null);
        }
    }

    private WorkerManager createWorkerManager() throws RemoteException {
        return new WorkerManager(this.createSecuredProxy(), this.getServiceName());
    }

    public boolean isRecovering() {
        return this._recovering.get();
    }

    public AtomicBoolean getRecoveryIndicator() {
        return this._recovering;
    }

    @Override
    public Map<String, LocalCacheDetails> getLocalCacheDetails() throws RemoteException {
        return this.isActive() ? this._engine.getCacheManager().getLocalCaches() : null;
    }

    @Override
    public Map<String, LocalViewDetails> getLocalViewDetails() throws RemoteException {
        return this.isActive() ? this._engine.getLocalViewRegistrations().get() : null;
    }

    public boolean isLocalCache() {
        return this.getConfigReader().getBooleanSpaceProperty("engine.local_cache_mode", "false");
    }

    @Override
    public SpaceCopyStatus spaceCopy(String remoteUrl, Object template, boolean includeNotifyTemplates, int chunkSize) {
        throw new UnsupportedOperationException("shouldn't of come here ...");
    }

    @Override
    public SpaceCopyStatus spaceCopy(IJSpace remoteSpace, Object template, boolean includeNotifyTemplates, int chunkSize) {
        throw new UnsupportedOperationException("shouldn't of come here ...");
    }

    @Override
    public void discarded(DiscoveryEvent event) {
    }

    @Override
    public void discovered(DiscoveryEvent event) {
        block3: {
            try {
                ServiceRegistrar[] registrars = event.getRegistrars();
                for (int i = 0; i < registrars.length; ++i) {
                    if (!this._logger.isLoggable(Level.FINE)) continue;
                    this._logger.fine("Directory Service (Jini Lookup Service registrar): \n[  Registrar <" + registrars[i].getLocator().getHost() + ':' + registrars[i].getLocator().getPort() + ">  ][  Member of " + Arrays.asList(registrars[i].getGroups()) + " has been discovered by the <" + this.getServiceName() + "> space.  ]");
                }
            }
            catch (Exception ex) {
                if (!this._logger.isLoggable(Level.SEVERE)) break block3;
                this._logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    @Override
    public byte[] getClusterConfigFile() throws RemoteException {
        try {
            String clusterConfigURL = this._configReader.getSpaceProperty("cluster.config-url", null);
            ClusterXML clusterXml = new ClusterXML(this._url, clusterConfigURL, this._spaceName);
            StringBuilder clusterConfigOutput = clusterXml.getClusterConfigDebugOutput();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Cluster Configuration:\n" + clusterConfigOutput);
            }
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            JSpaceUtilities.domWriter(clusterXml.getXMLRootDocument().getDocumentElement(), new PrintStream(byteArray), "");
            byteArray.flush();
            byteArray.close();
            return byteArray.toByteArray();
        }
        catch (Exception ex) {
            throw new RemoteException("Fail to obtain a cluster configuration file", ex);
        }
    }

    @Override
    public void setClusterConfigFile(byte[] config) throws RemoteException {
        throw new UnsupportedOperationException("Currently doesn't implemented");
    }

    @Override
    protected void AppendInitialLookupAttributes(List<Entry> lookupAttributes) throws ServiceRegistrationException {
        super.AppendInitialLookupAttributes(lookupAttributes);
        lookupAttributes.add((Entry)new Name(this.getName()));
        ClusterName clusterName = null;
        ClusterGroup clusterGroup = null;
        ClusterPolicy clusterPolicy = this.getClusterPolicy();
        if (clusterPolicy != null) {
            clusterName = new ClusterName(clusterPolicy.m_ClusterName);
            clusterGroup = new ClusterGroup();
            clusterGroup.electionGroup = "";
            clusterGroup.replicationGroup = "";
            clusterGroup.loadBalancingGroup = "";
            if (clusterPolicy.m_FailOverPolicy != null) {
                clusterGroup.electionGroup = clusterPolicy.m_FailOverPolicy.getElectionGroupName();
            }
            if (clusterPolicy.m_ReplicationPolicy != null) {
                clusterGroup.replicationGroup = clusterPolicy.m_ReplicationPolicy.m_ReplicationGroupName;
            }
            if (clusterPolicy.m_LoadBalancingPolicy != null) {
                clusterGroup.loadBalancingGroup = clusterPolicy.m_LoadBalancingPolicy.m_GroupName;
            }
        } else {
            clusterName = new ClusterName("NONE");
            clusterGroup = new ClusterGroup("NONE");
        }
        lookupAttributes.add((Entry)clusterName);
        lookupAttributes.add((Entry)clusterGroup);
        lookupAttributes.add((Entry)new ContainerName(this._container.getName()));
        lookupAttributes.add((Entry)new ServiceInfo("JavaSpace", "GigaSpaces Technologies Ltd.", "GigaSpaces", PlatformVersion.getOfficialVersion(), "", ""));
        lookupAttributes.add((Entry)new HostName(SystemInfo.singleton().network().getHostId()));
        lookupAttributes.add((Entry)new State(this.getState()));
    }

    private LeaderSelectorHandler createZooKeeperLeaderSelector() throws ActiveElectionException {
        try {
            Class clazz = ClassLoaderHelper.loadLocalClass("org.openspaces.zookeeper.leader_selector.ZooKeeperBasedLeaderSelectorHandler");
            return (LeaderSelectorHandler)clazz.newInstance();
        }
        catch (Exception e) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, "Failed to initialize Leader Selector handler");
            }
            throw new ActiveElectionException("Failed to start [" + this.getEngine().getFullSpaceName() + "] Failed to initialize Leader Selector handler.");
        }
    }

    @Override
    public void demote(long maxSuspendTime, TimeUnit unit, SpaceContext sc) throws DemoteFailedException, RemoteException {
        this.assertAuthorizedForPrivilege(GridAuthority.GridPrivilege.MANAGE_PU, sc);
        this._demoteHandler.demote(maxSuspendTime, unit);
    }

    @Override
    public SuspendType addSpaceSuspendTypeListener(SuspendTypeChangedInternalListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Callback listener supplied for space suspend type changes is <null>.");
        }
        this._quiesceHandler.addSpaceSuspendTypeListener(listener);
        return this._quiesceHandler.getSuspendInfo().getSuspendType();
    }

    @Override
    public void removeSpaceSuspendTypeListener(SuspendTypeChangedInternalListener listener) {
        this._quiesceHandler.removeSpaceSuspendTypeListener(listener);
    }

    private class LeaderSelectorServiceDiscoveryListener
    implements ServiceDiscoveryListener {
        CountDownLatch latch;

        public LeaderSelectorServiceDiscoveryListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void serviceAdded(ServiceDiscoveryEvent event) {
            this.latch.countDown();
        }

        @Override
        public void serviceRemoved(ServiceDiscoveryEvent event) {
        }

        @Override
        public void serviceChanged(ServiceDiscoveryEvent event) {
        }
    }

    private static class UpdateOrWriteResponseHandler
    extends DefaultResponseHandler {
        private final SpaceEngine engine;
        private final UpdateOrWriteContext ctx;

        private UpdateOrWriteResponseHandler(SpaceEngine engine, UpdateOrWriteContext ctx) {
            this.engine = engine;
            this.ctx = ctx;
        }

        @Override
        public void handleResponse(IResponseContext respContext, ReplyPacket respPacket) {
            Exception ex;
            long expTime;
            long current = SystemTime.timeMillis();
            boolean expired = current > (expTime = LeaseManager.toAbsoluteTime(this.ctx.timeout, current));
            Exception exception = ex = respContext.isInvokedFromNewRouter() ? ((RemoteOperationResult)respPacket.getResult()).getExecutionException() : respPacket.getException();
            if (ex != null && ex instanceof EntryNotInSpaceException && !expired) {
                UpdateOrWriteBusPacket packet = new UpdateOrWriteBusPacket(this.ctx.packet.getOperationID(), respContext, this.ctx, respPacket);
                this.engine.getProcessorWG().enqueueBlocked(packet);
            } else {
                super.handleResponse(respContext, respPacket);
            }
        }
    }
}

