/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.SegmentedReentrantReadWriteLock;

@InternalApi
public class SpaceOperationsCoordinator {
    private final SegmentedReentrantReadWriteLock _readWriteLock;

    public SpaceOperationsCoordinator(int numOfSegments) {
        this._readWriteLock = numOfSegments < 1 ? null : new SegmentedReentrantReadWriteLock(numOfSegments, true);
    }

    public void beginConcurrentOperation() {
        if (this._readWriteLock != null) {
            this._readWriteLock.acquireThreadReadLock();
        }
    }

    public void endConcurrentOperation() {
        if (this._readWriteLock != null) {
            this._readWriteLock.releaseThreadReadLock();
        }
    }

    public void beginExclusiveOperation() {
        if (this._readWriteLock != null) {
            this._readWriteLock.acquireWriteLock();
        }
    }

    public void endExclusiveOperation() {
        if (this._readWriteLock != null) {
            this._readWriteLock.releaseWriteLock();
        }
    }
}

