/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.time.SystemTime;
import java.util.concurrent.atomic.AtomicLong;

@InternalApi
public class SpaceUidFactory {
    private static final boolean DISABLE_UID_SUFFIX = Boolean.getBoolean("com.gs.disable-uid-suffix");
    public static final String SUFFIX = DISABLE_UID_SUFFIX ? "" : "^0^0";
    private static final int MAX_NUM_CLASSES_CACHED = 500;
    public static final char SEPARATOR = '^';
    public static final String PREFIX_AUTO = "A";
    public static final String PREFIX_MANUAL = "M";
    private final String _memberId;
    private final AtomicLong _counter;
    private String _timeStamp;
    private String _prefix;
    private final CopyOnUpdateMap<String, String> _typeUidFactoryCache;

    public SpaceUidFactory() {
        this(null);
    }

    public SpaceUidFactory(String memberId) {
        this._memberId = memberId != null ? memberId : "0";
        this._counter = new AtomicLong();
        this._typeUidFactoryCache = new CopyOnUpdateMap();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        SpaceUidFactory spaceUidFactory = this;
        synchronized (spaceUidFactory) {
            if (this._counter.get() > 0L) {
                return;
            }
            this._timeStamp = Long.toString(SystemTime.timeMillis());
            this._prefix = PREFIX_AUTO + this._memberId + '^' + this._timeStamp + '^';
            this._counter.set(0L);
        }
    }

    private long getNextId() {
        long id = this._counter.incrementAndGet();
        if (id > 0L) {
            return id;
        }
        this.reset();
        return this.getNextId();
    }

    public String getTimeStamp() {
        return this._timeStamp;
    }

    public String createUIDFromCounter() {
        return Long.toString(this.getNextId());
    }

    public String generateUid() {
        long id = this.getNextId();
        return this._prefix.concat(Long.toString(id));
    }

    public String createUidFromTypeAndId(String typeName, String id, boolean validate) {
        if (validate && id.indexOf(94) != -1) {
            throw new RuntimeException("Invalid UID creation request: UID can not contains the character '^'.");
        }
        String prefix = this._typeUidFactoryCache.get(typeName);
        if (prefix == null) {
            prefix = SpaceUidFactory.generateTypePrefix(typeName);
            if (this._typeUidFactoryCache.size() > 500) {
                this._typeUidFactoryCache.clear();
            }
            this._typeUidFactoryCache.put(typeName, prefix);
        }
        return SpaceUidFactory.generateUid(prefix, id);
    }

    public static Integer extractPartitionId(String uid) {
        if (uid == null || uid.length() < 2) {
            return null;
        }
        int result = 0;
        int pos = 1;
        char c = uid.charAt(pos++);
        while (c >= '0' && c <= '9') {
            result = result * 10 + c - 48;
            c = uid.charAt(pos++);
        }
        return result == 0 ? null : Integer.valueOf(result - 1);
    }

    public static String generateUid(String typePrefix, String id) {
        return typePrefix.concat(id).concat(SUFFIX);
    }

    public static String generateTypePrefix(String typeName) {
        return "" + typeName.hashCode() + '^' + typeName.length() + '^';
    }
}

