/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.backport.java.util.concurrent.FastConcurrentSkipListMap;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.lrmi.nio.IResponseContext;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.AnswerHolder;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.exception.ClosedResourceException;
import com.j_spaces.kernel.IConsumerObject;
import com.j_spaces.kernel.WorkingGroup;
import com.j_spaces.kernel.locks.ILockObject;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class TemplateExpirationManager
implements IConsumerObject<Object> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.engine");
    private static final int minPoolSize = 1;
    private static final int maxPoolSize = 16;
    private static final int timeout = 300000;
    private static final int bucketTimeSpan = 10;
    private final CacheManager _cacheManager;
    private final FastConcurrentSkipListMap<TemplateKey, ITemplateHolder> _expirationList;
    private final WorkingGroup<Object> _threadPool;
    private final Timer _timer;

    public TemplateExpirationManager(CacheManager cacheManager) {
        this._cacheManager = cacheManager;
        this._expirationList = new FastConcurrentSkipListMap();
        this._threadPool = new WorkingGroup<Object>(this, 5, "TemplateExpirationManager", 1, 16, 300000L);
        this._timer = new Timer("GS-Template-Expiration-Manager-Timer");
    }

    public void start() {
        this._timer.start();
        this._threadPool.start();
    }

    @Override
    public void dispatch(Object req) {
        ITemplateHolder template = null;
        Exception exp = null;
        boolean fromTimerThread = true;
        if (req instanceof ITemplateHolder) {
            template = (ITemplateHolder)req;
        } else {
            template = ((ReturnWithExecption)req).getTemplate();
            exp = ((ReturnWithExecption)req).getException();
            fromTimerThread = false;
        }
        this.cancelTemplateHolder(template, exp, fromTimerThread);
    }

    public void cancelTemplateHolder(ITemplateHolder template, Exception exp) {
        this.cancelTemplateHolder(template, exp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelTemplateHolder(ITemplateHolder template, Exception exp, boolean fromTimerThread) {
        Context context;
        ILockObject templateLock;
        block17: {
            block18: {
                block19: {
                    IResponseContext respContext = template.getResponseContext();
                    if (respContext == null && template.getMultipleIdsContext() == null) {
                        if (exp == null) return;
                    }
                    templateLock = this._cacheManager.getLockManager().getLockObject(template, false);
                    context = null;
                    AnswerHolder aHolder = template.getAnswerHolder();
                    try {
                        ILockObject iLockObject = templateLock;
                        synchronized (iLockObject) {
                            AnswerHolder answerHolder = aHolder;
                            synchronized (answerHolder) {
                                if (!template.isDeleted()) {
                                    if (!fromTimerThread) {
                                        this.removeTemplate(template);
                                    } else {
                                        template.setInExpirationManager(false);
                                    }
                                    context = this._cacheManager.getCacheContext();
                                    context.setOperationAnswer(template, null, exp);
                                    this._cacheManager.removeTemplate(context, template, false, true, false);
                                    // MONITOREXIT @DISABLED, blocks:[0, 16, 7, 8] lbl20 : MonitorExitStatement: MONITOREXIT : var9_10
                                    // MONITOREXIT @DISABLED, blocks:[0, 16, 7] lbl21 : MonitorExitStatement: MONITOREXIT : var8_8
                                    if (templateLock == null) break block17;
                                    break block18;
                                }
                                if (templateLock == null) break block19;
                            }
                        }
                    }
                    catch (ClosedResourceException ex) {
                        _logger.log(Level.FINE, "exception occurred during template removing", ex);
                        return;
                    }
                    this._cacheManager.getLockManager().freeLockObject(templateLock);
                }
                this._cacheManager.freeCacheContext(context);
                return;
            }
            this._cacheManager.getLockManager().freeLockObject(templateLock);
        }
        this._cacheManager.freeCacheContext(context);
        return;
        finally {
            if (templateLock != null) {
                this._cacheManager.getLockManager().freeLockObject(templateLock);
            }
            this._cacheManager.freeCacheContext(context);
        }
    }

    @Override
    public void cleanUp() {
    }

    public void shutDown() {
        this._expirationList.clear();
        this._timer.close();
        this._threadPool.shutdown();
    }

    public void addTemplate(ITemplateHolder template) {
        if (template.getResponseContext() == null && template.getMultipleIdsContext() == null || template.getExpirationTime() == Long.MAX_VALUE || template.isNotifyTemplate()) {
            return;
        }
        template.setInExpirationManager(true);
        TemplateKey mykey = TemplateExpirationManager.createTemplateKey(template);
        this._expirationList.put(mykey, template);
        this._timer.updateTimeIfNeccesary(mykey._timestamp);
        try {
            this._cacheManager.getEngine().getSpaceImpl().getQuiesceHandler().checkAllowedOp(template.getSpaceContext() != null ? template.getSpaceContext().getQuiesceToken() : null);
        }
        catch (Exception ex) {
            this._threadPool.enqueueBlocked(new ReturnWithExecption(template, ex));
        }
    }

    public void returnWithExceptionFromAllPendingTemplates(Exception exp) {
        for (ITemplateHolder template : this._expirationList.values()) {
            if (template.isDeleted()) continue;
            this._threadPool.enqueueBlocked(new ReturnWithExecption(template, exp));
        }
    }

    private static TemplateKey createTemplateKey(ITemplateHolder template) {
        long expTimeStamp = template.getExpirationTime();
        long bucketKey = expTimeStamp + (10L - expTimeStamp % 10L);
        return new TemplateKey(bucketKey, template.getUID(), template);
    }

    public void removeTemplate(ITemplateHolder template) {
        if (!template.isInExpirationManager()) {
            return;
        }
        template.setInExpirationManager(false);
        this._expirationList.remove(TemplateExpirationManager.createTemplateKey(template));
    }

    private class Timer
    extends GSThread {
        private volatile boolean _closed;
        private final Object _timerObj;
        private volatile long _nextAwakening;
        private boolean _scanningTheList;

        public Timer(String threadName) {
            super(threadName);
            this._timerObj = new Object();
            this._nextAwakening = Long.MAX_VALUE;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateTimeIfNeccesary(long timestamp) {
            long nextAwakening = this._nextAwakening;
            if (nextAwakening <= timestamp) {
                return;
            }
            Object object = this._timerObj;
            synchronized (object) {
                if (this._nextAwakening > timestamp) {
                    this._nextAwakening = timestamp;
                    if (!this._scanningTheList) {
                        this._timerObj.notify();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this._closed) {
                boolean hasMoreTemplates = true;
                long currenttime = SystemTime.timeMillis();
                long nextTime = Long.MAX_VALUE;
                while (hasMoreTemplates && !TemplateExpirationManager.this._expirationList.isEmpty()) {
                    try {
                        TemplateKey firstKey = (TemplateKey)TemplateExpirationManager.this._expirationList.firstKey();
                        if (currenttime >= firstKey._timestamp) {
                            Map.Entry entry = TemplateExpirationManager.this._expirationList.pollFirstEntry();
                            if (entry == null) {
                                hasMoreTemplates = false;
                                continue;
                            }
                            firstKey = (TemplateKey)entry.getKey();
                            if (currenttime < firstKey._timestamp && !firstKey._template.isDeleted()) {
                                TemplateExpirationManager.this._expirationList.put(firstKey, firstKey._template);
                                nextTime = firstKey._timestamp;
                                hasMoreTemplates = false;
                                continue;
                            }
                            ITemplateHolder template = (ITemplateHolder)entry.getValue();
                            if (template.isDeleted()) continue;
                            TemplateExpirationManager.this._threadPool.enqueueBlocked(template);
                            continue;
                        }
                        nextTime = firstKey._timestamp;
                        hasMoreTemplates = false;
                    }
                    catch (NoSuchElementException ex) {
                        hasMoreTemplates = false;
                    }
                }
                boolean needsleep = true;
                Object object = this._timerObj;
                synchronized (object) {
                    try {
                        while (needsleep) {
                            this._scanningTheList = false;
                            this._nextAwakening = Math.min(this._nextAwakening, nextTime);
                            long timeToSleep = this._nextAwakening - SystemTime.timeMillis();
                            if (timeToSleep > 0L) {
                                this._timerObj.wait(timeToSleep);
                            } else {
                                needsleep = false;
                            }
                            nextTime = Long.MAX_VALUE;
                        }
                        this._scanningTheList = true;
                        this._nextAwakening = Long.MAX_VALUE;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }

        public void close() {
            this._closed = true;
            this.interrupt();
        }
    }

    private static class ReturnWithExecption {
        private final ITemplateHolder _template;
        private final Exception _exception;

        private ReturnWithExecption(ITemplateHolder template, Exception exception) {
            this._template = template;
            this._exception = exception;
        }

        ITemplateHolder getTemplate() {
            return this._template;
        }

        Exception getException() {
            return this._exception;
        }
    }

    private static class TemplateKey
    implements Comparable {
        private Long _timestamp;
        private String _id;
        private ITemplateHolder _template;

        private TemplateKey(long expirationTime, String templateID, ITemplateHolder template) {
            this._timestamp = expirationTime;
            this._id = templateID;
            this._template = template;
        }

        public int compareTo(Object o) {
            TemplateKey other = (TemplateKey)o;
            int firstRes = this._timestamp.compareTo(other._timestamp);
            if (firstRes != 0) {
                return firstRes;
            }
            return this._id.compareTo(other._id);
        }

        public boolean equals(Object obj) {
            TemplateKey other = (TemplateKey)obj;
            return other._template == this._template;
        }

        public int hashCode() {
            return this._timestamp.hashCode() + 17 * this._id.hashCode();
        }
    }
}

