/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.query.RegexCache;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.FifoGroupsSearch;
import com.gigaspaces.internal.server.space.FifoSearch;
import com.gigaspaces.internal.server.space.MatchResult;
import com.gigaspaces.internal.server.space.MatchTarget;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.events.NotifyContext;
import com.gigaspaces.internal.server.space.events.NotifyContextsHolder;
import com.gigaspaces.internal.server.space.events.SpaceDataEventManager;
import com.gigaspaces.internal.server.space.events.UpdateNotifyContextHolder;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.j_spaces.core.EntryDeletedException;
import com.j_spaces.core.FifoException;
import com.j_spaces.core.NoMatchException;
import com.j_spaces.core.TemplateDeletedException;
import com.j_spaces.core.TransactionConflictException;
import com.j_spaces.core.TransactionNotActiveException;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IExtendedIndexIterator;
import com.j_spaces.core.cache.TemplateCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.ICollection;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import com.j_spaces.kernel.list.ScanSingleListIterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class TemplateScanner {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.templatescanner");
    private final SpaceEngine _engine;
    private final SpaceTypeManager _typeManager;
    private final CacheManager _cacheManager;
    private final SpaceDataEventManager _dataEventManager;
    private final RegexCache _regexCache;

    public TemplateScanner(SpaceTypeManager typeManager, CacheManager cacheManager, SpaceDataEventManager dataEventManager, SpaceEngine engine) {
        this._typeManager = typeManager;
        this._cacheManager = cacheManager;
        this._dataEventManager = dataEventManager;
        this._regexCache = new RegexCache(engine.getConfigReader());
        this._engine = engine;
    }

    public void cancelAllNonNotifyTemplates(Exception ex) {
        Map<String, IServerTypeDesc> safeTypeTable = this._typeManager.getSafeTypeTable();
        if (safeTypeTable == null) {
            return;
        }
        for (IServerTypeDesc serverTypeDesc : safeTypeTable.values()) {
            TypeData typeData = this._cacheManager.getTypeData(serverTypeDesc);
            if (typeData == null) continue;
            this.cancelTemplates(typeData.getReadTakeUidTemplates(), ex);
            this.cancelTemplates(typeData.getReadTakeTemplates(), ex);
            this.cancelTemplates(typeData.getReadTakeExtendedTemplates(), ex);
            if (typeData.getIndexes() == null) continue;
            for (TypeDataIndex typeDataIndex : typeData.getIndexes()) {
                ConcurrentHashMap<Object, IStoredList<TemplateCacheInfo>[]> rtTemplates = typeDataIndex._RTTemplates;
                if (rtTemplates != null) {
                    for (IStoredList<TemplateCacheInfo>[] iStoredLists : rtTemplates.values()) {
                        for (IStoredList<TemplateCacheInfo> iStoredList : iStoredLists) {
                            this.cancelTemplates(iStoredList, ex);
                        }
                    }
                }
                this.cancelTemplates(typeDataIndex._RTNullTemplates, ex);
                if (typeDataIndex.getM_RT_GT_Index() != null) {
                    this.cancelTemplates(typeDataIndex.getM_RT_GT_Index().getOrderedStore(), ex);
                }
                if (typeDataIndex.getM_RT_LT_Index() != null) {
                    this.cancelTemplates(typeDataIndex.getM_RT_LT_Index().getOrderedStore(), ex);
                }
                if (typeDataIndex.getM_RT_NE_Index() == null) continue;
                this.cancelTemplates(typeDataIndex.getM_RT_NE_Index().getOrderedStore(), ex);
            }
        }
    }

    private void cancelTemplates(Map<?, IStoredList<TemplateCacheInfo>> map, Exception ex) {
        if (map == null) {
            return;
        }
        for (IStoredList<TemplateCacheInfo> storedList : map.values()) {
            this.cancelTemplates(storedList, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTemplates(IStoredList<TemplateCacheInfo> templates, Exception ex) {
        if (templates == null) {
            return;
        }
        if (templates.isEmpty()) {
            return;
        }
        ScanSingleListIterator<TemplateCacheInfo> iterator = new ScanSingleListIterator<TemplateCacheInfo>(templates, false);
        try {
            while (iterator.hasNext()) {
                ITemplateHolder templateHolder = iterator.next().getSubject().m_TemplateHolder;
                if (templateHolder.isDeleted()) continue;
                this._cacheManager.getTemplateExpirationManager().cancelTemplateHolder(templateHolder, ex);
            }
        }
        finally {
            iterator.releaseScan();
        }
    }

    public RegexCache getRegexCache() {
        return this._regexCache;
    }

    public void scanNonNotifyTemplates(Context context, IEntryHolder entry, ServerTransaction txn, FifoSearch fifoSearch) throws EntryDeletedException, SAException {
        this.scanNonNotifyTemplates(context, entry, txn, fifoSearch, fifoSearch == FifoSearch.YES ? FifoGroupsSearch.NO : FifoGroupsSearch.INCLUSIVE);
    }

    public void scanNonNotifyTemplates(Context context, IEntryHolder entry, ServerTransaction txn, FifoSearch fifoSearch, FifoGroupsSearch fifoGroupsSearch) throws EntryDeletedException, SAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Starting scan of non-notify templates: EntryUid=" + entry.getUID() + ", fifoSearch=" + (Object)((Object)fifoSearch));
        }
        context.setExhaustedFifoGroupsTemplatesSearch(false);
        this.scanTemplates(context, entry, txn, fifoSearch, null, fifoGroupsSearch);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Finished scan of non-notify templates: EntryUid=" + entry.getUID() + ", fifoSearch=" + (Object)((Object)fifoSearch));
        }
    }

    public void scanNotifyTemplates(NotifyContextsHolder notifyContextsHolder, Context context, ServerTransaction txn, FifoSearch fifoSearch) throws EntryDeletedException, SAException {
        String entryUid = notifyContextsHolder.getNotifyEntry().getUID();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Starting scan of notify templates: EntryUid=" + entryUid + ", fifoSearch=" + (Object)((Object)fifoSearch) + ", notifyTypes=" + notifyContextsHolder.getNotifyTypes());
        }
        this.scanTemplates(context, notifyContextsHolder.getNotifyEntry(), txn, fifoSearch, notifyContextsHolder, FifoGroupsSearch.NO);
        for (NotifyContext notifyContext : notifyContextsHolder.getNotifyContexts()) {
            notifyContext.setFinishedTemplateSearch(true);
            this._dataEventManager.finishTemplatesSearch(notifyContext);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "Finished scan of notify templates: EntryUid=" + entryUid + ", fifoSearch=" + (Object)((Object)fifoSearch) + ", notifyType=" + notifyContext.getNotifyType().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanTemplates(Context context, IEntryHolder entry, ServerTransaction txn, FifoSearch fifoSearch, NotifyContextsHolder notifyContextsHolder, FifoGroupsSearch fifoGroupsSearch) throws EntryDeletedException, SAException {
        EntryDeletedException exp = null;
        MatchTarget matchTarget = notifyContextsHolder != null ? MatchTarget.NOTIFY : MatchTarget.READ_TAKE;
        IServerTypeDesc entryTypeDesc = this._typeManager.getServerTypeDesc(entry.getClassName());
        try {
            for (IServerTypeDesc typeDesc : entryTypeDesc.getSuperTypes()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Scanning templates of type [" + typeDesc.getTypeName() + "]: entryUid=" + entry.getUID() + ", fifoSearch=" + (Object)((Object)fifoSearch));
                }
                if (typeDesc.isInactive()) continue;
                if (context.isExhaustedFifoGroupsTemplatesSearch() && fifoGroupsSearch == FifoGroupsSearch.EXCLUSIVE) {
                    return;
                }
                Object searchResult = this._cacheManager.findTemplatesByIndex(context, typeDesc, entry, matchTarget);
                if (searchResult == null) continue;
                try {
                    this.scanTemplatesByIndexSearchResult(context, entry, txn, fifoSearch, notifyContextsHolder, searchResult, fifoGroupsSearch);
                }
                catch (EntryDeletedException ex) {
                    if (notifyContextsHolder != null || fifoGroupsSearch == FifoGroupsSearch.NO) {
                        throw ex;
                    }
                    exp = ex;
                    fifoGroupsSearch = FifoGroupsSearch.EXCLUSIVE;
                }
            }
        }
        finally {
            if (exp != null) {
                throw exp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanTemplatesByIndexSearchResult(Context context, IEntryHolder entry, ServerTransaction txn, FifoSearch fifoSearch, NotifyContextsHolder notifyContextsHolder, Object searchResult, FifoGroupsSearch fifoGroupsSearch) throws EntryDeletedException, SAException {
        block29: {
            EntryDeletedException exp = null;
            try {
                if (searchResult instanceof IStoredList) {
                    this.scanTemplatesByIndex(context, entry, txn, fifoSearch, notifyContextsHolder, (ICollection)searchResult, fifoGroupsSearch);
                    break block29;
                }
                if (searchResult instanceof IExtendedIndexIterator) {
                    IExtendedIndexIterator ois = (IExtendedIndexIterator)searchResult;
                    try {
                        while (true) {
                            if (ois.hasNext()) {
                                if (fifoGroupsSearch == FifoGroupsSearch.EXCLUSIVE && context.isExhaustedFifoGroupsTemplatesSearch()) {
                                    return;
                                }
                                try {
                                    this.scanTemplatesByIndexSearchResult(context, entry, txn, fifoSearch, notifyContextsHolder, ois.next(), fifoGroupsSearch);
                                }
                                catch (EntryDeletedException ex) {
                                    if (fifoGroupsSearch == FifoGroupsSearch.NO) {
                                        throw ex;
                                    }
                                    exp = ex;
                                    fifoGroupsSearch = FifoGroupsSearch.EXCLUSIVE;
                                }
                                continue;
                            }
                            break block29;
                            break;
                        }
                    }
                    finally {
                        ois.releaseScan();
                    }
                }
                if (searchResult instanceof Object[]) {
                    for (Object result : (Object[])searchResult) {
                        try {
                            this.scanTemplatesByIndexSearchResult(context, entry, txn, fifoSearch, notifyContextsHolder, result, fifoGroupsSearch);
                        }
                        catch (EntryDeletedException ex) {
                            if (fifoGroupsSearch == FifoGroupsSearch.NO) {
                                throw ex;
                            }
                            exp = ex;
                            fifoGroupsSearch = FifoGroupsSearch.EXCLUSIVE;
                        }
                    }
                    break block29;
                }
                if (searchResult instanceof List) {
                    for (Object result : (List)searchResult) {
                        if (fifoGroupsSearch == FifoGroupsSearch.EXCLUSIVE && context.isExhaustedFifoGroupsTemplatesSearch()) {
                            return;
                        }
                        try {
                            this.scanTemplatesByIndexSearchResult(context, entry, txn, fifoSearch, notifyContextsHolder, result, fifoGroupsSearch);
                        }
                        catch (EntryDeletedException ex) {
                            if (fifoGroupsSearch == FifoGroupsSearch.NO) {
                                throw ex;
                            }
                            exp = ex;
                            fifoGroupsSearch = FifoGroupsSearch.EXCLUSIVE;
                        }
                    }
                    break block29;
                }
                throw new IllegalArgumentException("Unsupported search result class: " + searchResult.getClass().getName());
            }
            finally {
                if (exp != null) {
                    throw exp;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanTemplatesByIndex(Context context, IEntryHolder entry, ServerTransaction txn, FifoSearch fifoSearch, NotifyContextsHolder notifyContextsHolder, ICollection<TemplateCacheInfo> sl, FifoGroupsSearch fifoGroupsSearch) throws EntryDeletedException, SAException {
        if (sl.isEmpty()) {
            return;
        }
        EntryDeletedException exp = null;
        IStoredListIterator<TemplateCacheInfo> slh = null;
        try {
            slh = sl.establishListScan(false);
            while (slh != null) {
                block17: {
                    ITemplateHolder template;
                    block18: {
                        TemplateCacheInfo cacheHolder = slh.getSubject();
                        if (cacheHolder == null || (template = cacheHolder.m_TemplateHolder) == null || !template.isFifoGroupPoll() && fifoGroupsSearch == FifoGroupsSearch.EXCLUSIVE || template.isFifoGroupPoll() && fifoGroupsSearch == FifoGroupsSearch.NO) break block17;
                        if (!context.isExhaustedFifoGroupsTemplatesSearch()) break block18;
                        if (fifoGroupsSearch == FifoGroupsSearch.EXCLUSIVE) {
                            return;
                        }
                        if (template.isFifoGroupPoll()) break block17;
                    }
                    if (template.isNotifyTemplate()) {
                        this.notifyIfMatching((NotifyTemplateHolder)template, notifyContextsHolder, context, fifoSearch, txn);
                    } else {
                        try {
                            this.scanNonNotifyTemplate(template, entry, context, fifoSearch);
                        }
                        catch (EntryDeletedException ex) {
                            if (fifoGroupsSearch == FifoGroupsSearch.NO) {
                                throw ex;
                            }
                            exp = ex;
                            fifoGroupsSearch = FifoGroupsSearch.EXCLUSIVE;
                        }
                    }
                }
                slh = sl.isMultiObjectCollection() ? sl.next(slh) : null;
            }
        }
        finally {
            if (slh != null) {
                slh.release();
            }
            if (exp != null) {
                throw exp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIfMatching(NotifyTemplateHolder template, NotifyContextsHolder notifyContextsHolder, Context context, FifoSearch fifoSearch, ServerTransaction txn) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Scanning template #" + template.getEventId() + " (uid=" + template.getUID() + "): entryUid=" + notifyContextsHolder.getNotifyEntry().getUID() + ", fifoSearch=" + (Object)((Object)fifoSearch));
        }
        NotifyTemplateHolder notifyTemplateHolder = template;
        synchronized (notifyTemplateHolder) {
            XtnEntry xtnEntry;
            if (template.quickReject(context, fifoSearch, txn, notifyContextsHolder)) {
                return;
            }
            if (template.isMaybeUnderXtn() && ((xtnEntry = this._engine.getTransaction(template.getXidOriginatedTransaction())) == null || !xtnEntry.m_Active)) {
                return;
            }
            if (!template.isMatchByID() && !this.notifyMatch(context, notifyContextsHolder.getNotifyEntry(), template)) {
                return;
            }
            NotifyContext notifyContext = null;
            NotifyActionType notifyType = notifyContextsHolder.getNotifyType();
            if (notifyType.equals(NotifyActionType.NOTIFY_UNMATCHED)) {
                if (template.isMatchByID() || this.notifyMatch(context, notifyContextsHolder.getNewEntry(), template)) {
                    return;
                }
            } else if (notifyType.equals(NotifyActionType.NOTIFY_UPDATE)) {
                boolean contatinsRematchedNotifyType = template.containsNotifyType(NotifyActionType.NOTIFY_REMATCHED_UPDATE);
                boolean contatinsMatchedNotifyType = template.containsNotifyType(NotifyActionType.NOTIFY_MATCHED_UPDATE);
                if (contatinsRematchedNotifyType || contatinsMatchedNotifyType) {
                    UpdateNotifyContextHolder updateHolder = (UpdateNotifyContextHolder)notifyContextsHolder;
                    if (this.notifyMatch(context, notifyContextsHolder.getOriginalEntry(), template)) {
                        if (contatinsRematchedNotifyType) {
                            notifyContext = updateHolder.getRematchedNotifyContext();
                        }
                    } else if (contatinsMatchedNotifyType) {
                        notifyContext = updateHolder.getMatchedNotifyContext();
                    }
                    if (notifyContext == null && !template.containsNotifyType(NotifyActionType.NOTIFY_UPDATE)) {
                        return;
                    }
                }
            }
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, "Match found: template #" + template.getEventId() + " (uid=" + template.getUID() + "), entryUid=" + notifyContextsHolder.getNotifyEntry().getUID() + ", fifoSearch=" + (Object)((Object)fifoSearch));
            }
            if (notifyContext == null) {
                notifyContext = notifyContextsHolder.getNotifyContext();
            }
            this._dataEventManager.notifyTemplate(template, notifyType.equals(NotifyActionType.NOTIFY_UNMATCHED) ? notifyContext.getReferenceEntry() : notifyContextsHolder.getNotifyEntry(), notifyContextsHolder.getOriginalEntry(), notifyContext, context);
        }
    }

    private void scanNonNotifyTemplate(ITemplateHolder template, IEntryHolder entry, Context context, FifoSearch fifoSearch) throws EntryDeletedException, SAException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Scanning template " + template.getUID() + ": entryUid=" + entry.getUID() + ", fifoSearch=" + (Object)((Object)fifoSearch));
        }
        if (template.quickReject(context, fifoSearch)) {
            return;
        }
        try {
            boolean ifExist;
            if (template.isMatchByID() && template.isNonBlockingRead()) {
                ITransactionalEntryData ed = entry.getTxnEntryData();
                context.setLastRawMatchSnapshot(ed);
                context.setLastMatchResult(ed.getOtherUpdateUnderXtnEntry() != null ? MatchResult.MASTER_AND_SHADOW : MatchResult.MASTER);
                context.setUnstableEntry(entry.isUnstable());
            }
            if (!template.isMatchByID() && !this.match(context, entry, template)) {
                return;
            }
            boolean bl = ifExist = template.getTemplateOperation() == 3 || template.getTemplateOperation() == 5 || template.getTemplateOperation() == 7;
            if (template.isFifoGroupPoll()) {
                if (!context.isExhaustedFifoGroupsTemplatesSearch()) {
                    this._engine.getFifoGroupsHandler().scanNonNotifyTemplate(template, entry, context, ifExist);
                }
                return;
            }
            this._engine.performTemplateOnEntrySA(context, template, entry, ifExist);
        }
        catch (TemplateDeletedException templateDeletedException) {
        }
        catch (NoMatchException noMatchException) {
        }
        catch (FifoException fifoException) {
        }
        catch (TransactionConflictException transactionConflictException) {
        }
        catch (TransactionNotActiveException transactionNotActiveException) {
            // empty catch block
        }
    }

    public boolean match(Context context, IEntryHolder entry, ITemplateHolder template, int skipAlreadyMatchedFixedPropertyIndex, String skipAlreadyMatchedIndexPath, boolean safeEntry) {
        MatchResult res = template.match(this._cacheManager, entry, skipAlreadyMatchedFixedPropertyIndex, skipAlreadyMatchedIndexPath, safeEntry, context, this._regexCache);
        return res != MatchResult.NONE;
    }

    public boolean match(Context context, IEntryHolder entry, ITemplateHolder template) {
        MatchResult res = template.match(this._cacheManager, entry, -1, null, false, context, this._regexCache);
        return res != MatchResult.NONE;
    }

    public boolean notifyMatch(Context context, IEntryHolder entry, ITemplateHolder template) {
        MatchResult res = template.match(this._cacheManager, entry, -1, null, false, context, this._regexCache);
        return res == MatchResult.MASTER || res == MatchResult.MASTER_AND_SHADOW;
    }
}

