/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.TemplateCacheInfo;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class TemplatesManager {
    private final CacheManager _cacheManager;
    private final ConcurrentHashMap<String, TemplateCacheInfo> _allTemplates;
    private final AtomicInteger _numOfNonNotifyTemplates = new AtomicInteger(0);
    private final Object _notifyTemplatesLock = new Object();
    private int _numOfNotifyWriteTemplates;
    private int _numOfNotifyUpdateTemplates;
    private int _numOfNotifyUnmatchedTemplates;
    private int _numOfNotifyMatchedTemplates;
    private int _numOfNotifyRematchedTemplates;
    private int _numOfNotifyTakeTemplates;
    private int _numOfNotifyLeaseTemplates;
    private volatile boolean _anyNotifyWriteTemplates;
    private volatile boolean _anyNotifyUpdateTemplates;
    private volatile boolean _anyNotifyUnmatchedTemplates;
    private volatile boolean _anyNotifyMatchedTemplates;
    private volatile boolean _anyNotifyRematchedTemplates;
    private volatile boolean _anyNotifyTakeTemplates;
    private volatile boolean _anyNotifyLeaseTemplates;
    private int _numOfDurableNotifyTakeTemplates;
    private volatile boolean _anyDurableNotifyTakeTemplates;
    private final int _numNotifyFifoThreads;
    private final int _numNonNotifyFifoThreads;
    private int _currNotifyFifoThreads;
    private int _currNonNotifyFifoThreads;
    private final FifoTemplatesData _notifyFifoWriteTemplatesData;
    private final FifoTemplatesData _notifyFifoTakeTemplatesData;
    private final FifoTemplatesData _notifyFifoUpdateTemplatesData;
    private final FifoTemplatesData _notifyFifoLeaseExpirationTemplatesData;
    private volatile boolean _anyFifoTemplates;
    private volatile boolean _anyNotifyFifoTemplatesForNonFifoType;
    private volatile boolean _anyNonNotifyFifoTemplates;
    private int _numOfFifoTemplates;
    private int _numNonNotifyFifoTemplates;
    private final boolean[] _anyNonNotifyFifoTemplatesTP;
    private final int[] _numNonNotifyFifoTemplatesTP;
    private long _templateBatchOrder;
    private final ConcurrentHashSet<String> _unallowedClearTakeOptimizationsBlobStoreNotify;

    public TemplatesManager(CacheManager cacheManager, int numNotifyFifoThreads, int numNonNotifyFifoThreads) {
        this._cacheManager = cacheManager;
        this._allTemplates = new ConcurrentHashMap();
        this._numNotifyFifoThreads = numNotifyFifoThreads;
        this._numNonNotifyFifoThreads = numNonNotifyFifoThreads;
        this._currNotifyFifoThreads = -1;
        this._currNonNotifyFifoThreads = -1;
        this._notifyFifoWriteTemplatesData = new FifoTemplatesData(numNotifyFifoThreads);
        this._notifyFifoTakeTemplatesData = new FifoTemplatesData(numNotifyFifoThreads);
        this._notifyFifoUpdateTemplatesData = new FifoTemplatesData(numNotifyFifoThreads);
        this._notifyFifoLeaseExpirationTemplatesData = new FifoTemplatesData(numNotifyFifoThreads);
        this._anyNonNotifyFifoTemplatesTP = new boolean[numNonNotifyFifoThreads];
        this._numNonNotifyFifoTemplatesTP = new int[numNonNotifyFifoThreads];
        this._unallowedClearTakeOptimizationsBlobStoreNotify = new ConcurrentHashSet();
    }

    public boolean isEmpty() {
        return this._allTemplates.isEmpty();
    }

    public boolean anyNotifyWriteTemplates() {
        return this._anyNotifyWriteTemplates;
    }

    public boolean anyNotifyUpdateTemplates() {
        return this._anyNotifyUpdateTemplates;
    }

    public boolean anyNotifyUnmatchedTemplates() {
        return this._anyNotifyUnmatchedTemplates;
    }

    public boolean anyNotifyMatchedTemplates() {
        return this._anyNotifyMatchedTemplates;
    }

    public boolean anyNotifyRematchedTemplates() {
        return this._anyNotifyRematchedTemplates;
    }

    public boolean anyNotifyTakeTemplates() {
        return this._anyNotifyTakeTemplates;
    }

    public boolean anyDurableNotifyTakeTemplates() {
        return this._anyDurableNotifyTakeTemplates;
    }

    public boolean anyNotifyLeaseTemplates() {
        return this._anyNotifyLeaseTemplates;
    }

    public boolean anyNonNotifyTemplates() {
        return this._numOfNonNotifyTemplates.get() > 0;
    }

    public boolean anyFifoTemplates() {
        return this._anyFifoTemplates;
    }

    public boolean anyNotifyFifoTemplatesForNonFifoType() {
        return this._anyNotifyFifoTemplatesForNonFifoType;
    }

    public boolean anyNotifyFifoWriteTemplates() {
        return this._notifyFifoWriteTemplatesData.anyNotifyFifoTemplates;
    }

    public boolean anyNotifyFifoWriteTemplates(int tpartition) {
        return this._notifyFifoWriteTemplatesData.anyNotifyFifoTemplatesTP[tpartition];
    }

    public boolean anyNotifyFifoWriteTemplatesForNonFifoType() {
        return this._notifyFifoWriteTemplatesData.anyNotifyFifoTemplatesForNonFifoType;
    }

    public boolean anyNotifyFifoUpdateTemplates() {
        return this._notifyFifoUpdateTemplatesData.anyNotifyFifoTemplates;
    }

    public boolean anyNotifyFifoUpdateTemplates(int tpartition) {
        return this._notifyFifoUpdateTemplatesData.anyNotifyFifoTemplatesTP[tpartition];
    }

    public boolean anyNotifyFifoUpdateTemplatesForNonFifoType() {
        return this._notifyFifoUpdateTemplatesData.anyNotifyFifoTemplatesForNonFifoType;
    }

    public boolean anyNotifyFifoTakeTemplates() {
        return this._notifyFifoTakeTemplatesData.anyNotifyFifoTemplates;
    }

    public boolean anyNotifyFifoTakeTemplates(int tpartition) {
        return this._notifyFifoTakeTemplatesData.anyNotifyFifoTemplatesTP[tpartition];
    }

    public boolean anyNotifyFifoTakeTemplatesForNonFifoType() {
        return this._notifyFifoTakeTemplatesData.anyNotifyFifoTemplatesForNonFifoType;
    }

    public boolean anyNotifyFifoLeaseExpirationTemplates() {
        return this._notifyFifoLeaseExpirationTemplatesData.anyNotifyFifoTemplates;
    }

    public boolean anyNotifyFifoLeaseExpirationTemplates(int tpartition) {
        return this._notifyFifoLeaseExpirationTemplatesData.anyNotifyFifoTemplatesTP[tpartition];
    }

    public boolean anyNotifyFifoLeaseExpirationTemplatesForNonFifoType() {
        return this._notifyFifoLeaseExpirationTemplatesData.anyNotifyFifoTemplatesForNonFifoType;
    }

    public boolean anyNonNotifyFifoTemplates() {
        return this._anyNonNotifyFifoTemplates;
    }

    public boolean anyNonNotifyFifoTemplates(int threadNumber) {
        return this._anyNonNotifyFifoTemplatesTP[threadNumber];
    }

    public boolean anyNotifyFifoForNonFifoTypePerOperation(IServerTypeDesc entryTypeDesc, int operation) {
        HashMap<Integer, Integer> notifyFifoTemplatesPerNonFifoType = null;
        if (operation == 1) {
            notifyFifoTemplatesPerNonFifoType = this._notifyFifoWriteTemplatesData.notifyFifoTemplatesPerNonFifoType;
        } else if (operation == 7) {
            notifyFifoTemplatesPerNonFifoType = this._notifyFifoUpdateTemplatesData.notifyFifoTemplatesPerNonFifoType;
        } else if (operation == 4 || operation == 5) {
            notifyFifoTemplatesPerNonFifoType = this._notifyFifoTakeTemplatesData.notifyFifoTemplatesPerNonFifoType;
        } else if (operation == 8) {
            notifyFifoTemplatesPerNonFifoType = this._notifyFifoLeaseExpirationTemplatesData.notifyFifoTemplatesPerNonFifoType;
        }
        if (notifyFifoTemplatesPerNonFifoType != null && !notifyFifoTemplatesPerNonFifoType.isEmpty()) {
            for (IServerTypeDesc typeDesc : entryTypeDesc.getSuperTypes()) {
                if (!notifyFifoTemplatesPerNonFifoType.containsKey(typeDesc.getTypeName() != null ? typeDesc.getTypeName().hashCode() : 0)) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration<String> getAllTemplatesKeys() {
        return this._allTemplates.keys();
    }

    public TemplateCacheInfo get(String uid) {
        return this._allTemplates.get(uid);
    }

    public TemplateCacheInfo put(TemplateCacheInfo template) {
        TemplateCacheInfo prevTemplate = this._allTemplates.put(template.m_TemplateHolder.getUID(), template);
        if (prevTemplate == null) {
            this.register(template.m_TemplateHolder);
        }
        return prevTemplate;
    }

    public TemplateCacheInfo putIfAbsent(TemplateCacheInfo template) {
        TemplateCacheInfo prevTemplate = this._allTemplates.putIfAbsent(template.m_TemplateHolder.getUID(), template);
        if (prevTemplate == null) {
            this.register(template.m_TemplateHolder);
        }
        return prevTemplate;
    }

    public TemplateCacheInfo remove(String uid) {
        TemplateCacheInfo pTemplate = this._allTemplates.remove(uid);
        if (pTemplate != null) {
            this.unregister(pTemplate.m_TemplateHolder);
        }
        return pTemplate;
    }

    public ITemplateHolder getTemplate(String uid) {
        TemplateCacheInfo pTemplate = this._allTemplates.get(uid);
        return pTemplate == null ? null : pTemplate.m_TemplateHolder;
    }

    private void register(ITemplateHolder template) {
        if (template.isNotifyTemplate()) {
            this.registerNotifyTemplate((NotifyTemplateHolder)template);
        } else {
            this._numOfNonNotifyTemplates.incrementAndGet();
        }
        if (template.isFifoTemplate()) {
            this.registerFifoTemplate(template);
        }
    }

    private void unregister(ITemplateHolder template) {
        if (template.isNotifyTemplate()) {
            this.unregisterNotifyTemplate((NotifyTemplateHolder)template);
        } else {
            this._numOfNonNotifyTemplates.decrementAndGet();
        }
        if (template.isFifoTemplate()) {
            this.unregisterFifoTemplate(template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNotifyTemplate(NotifyTemplateHolder template) {
        boolean ntype = false;
        Object object = this._notifyTemplatesLock;
        synchronized (object) {
            if (template.isBatching()) {
                template.setBatchOrder(this._templateBatchOrder++);
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_UPDATE)) {
                this._anyNotifyUpdateTemplates = true;
                ++this._numOfNotifyUpdateTemplates;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_UNMATCHED)) {
                this._anyNotifyUnmatchedTemplates = true;
                ++this._numOfNotifyUnmatchedTemplates;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_MATCHED_UPDATE)) {
                this._anyNotifyMatchedTemplates = true;
                ++this._numOfNotifyMatchedTemplates;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_REMATCHED_UPDATE)) {
                this._anyNotifyRematchedTemplates = true;
                ++this._numOfNotifyRematchedTemplates;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_TAKE)) {
                this._anyNotifyTakeTemplates = true;
                ++this._numOfNotifyTakeTemplates;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_LEASE_EXPIRATION)) {
                this._anyNotifyLeaseTemplates = true;
                ++this._numOfNotifyLeaseTemplates;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_WRITE) || !ntype) {
                this._anyNotifyWriteTemplates = true;
                ++this._numOfNotifyWriteTemplates;
            }
            this.handleBlobStoreNotifyOptimizations(template, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDurableNotifyTemplate(NotifyTemplateHolder template) {
        Object object = this._notifyTemplatesLock;
        synchronized (object) {
            if (template.containsNotifyType(NotifyActionType.NOTIFY_TAKE)) {
                this._anyDurableNotifyTakeTemplates = true;
                ++this._numOfDurableNotifyTakeTemplates;
            }
            this.handleBlobStoreNotifyOptimizations(template, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDurableNotifyTemplate(NotifyTemplateHolder template) {
        Object object = this._notifyTemplatesLock;
        synchronized (object) {
            if (template.containsNotifyType(NotifyActionType.NOTIFY_TAKE)) {
                --this._numOfDurableNotifyTakeTemplates;
                this._anyDurableNotifyTakeTemplates = this._numOfDurableNotifyTakeTemplates > 0;
            }
            this.handleBlobStoreNotifyOptimizations(template, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterNotifyTemplate(NotifyTemplateHolder template) {
        boolean ntype = false;
        Object object = this._notifyTemplatesLock;
        synchronized (object) {
            if (template.containsNotifyType(NotifyActionType.NOTIFY_UPDATE)) {
                --this._numOfNotifyUpdateTemplates;
                this._anyNotifyUpdateTemplates = this._numOfNotifyUpdateTemplates > 0;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_UNMATCHED)) {
                --this._numOfNotifyUnmatchedTemplates;
                this._anyNotifyUnmatchedTemplates = this._numOfNotifyUnmatchedTemplates > 0;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_MATCHED_UPDATE)) {
                --this._numOfNotifyMatchedTemplates;
                this._anyNotifyMatchedTemplates = this._numOfNotifyMatchedTemplates > 0;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_REMATCHED_UPDATE)) {
                --this._numOfNotifyRematchedTemplates;
                this._anyNotifyRematchedTemplates = this._numOfNotifyRematchedTemplates > 0;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_TAKE)) {
                --this._numOfNotifyTakeTemplates;
                this._anyNotifyTakeTemplates = this._numOfNotifyTakeTemplates > 0;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_LEASE_EXPIRATION)) {
                --this._numOfNotifyLeaseTemplates;
                this._anyNotifyLeaseTemplates = this._numOfNotifyLeaseTemplates > 0;
                ntype = true;
            }
            if (template.containsNotifyType(NotifyActionType.NOTIFY_WRITE) || !ntype) {
                --this._numOfNotifyWriteTemplates;
                this._anyNotifyWriteTemplates = this._numOfNotifyWriteTemplates > 0;
            }
            this.handleBlobStoreNotifyOptimizations(template, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void registerFifoTemplate(ITemplateHolder template) {
        int maxThreads;
        int n = maxThreads = template.isNotifyTemplate() ? this._numNotifyFifoThreads : this._numNonNotifyFifoThreads;
        if (maxThreads != 1) {
            TemplatesManager templatesManager = this;
            synchronized (templatesManager) {
                if (template.isNotifyTemplate()) {
                    this._currNotifyFifoThreads = (this._currNotifyFifoThreads + 1) % maxThreads;
                    template.setFifoThreadPartition(this._currNotifyFifoThreads);
                } else {
                    this._currNonNotifyFifoThreads = (this._currNonNotifyFifoThreads + 1) % maxThreads;
                    template.setFifoThreadPartition(this._currNonNotifyFifoThreads);
                }
            }
        }
        ++this._numOfFifoTemplates;
        this._anyFifoTemplates = true;
        int tpartition = template.getFifoThreadPartition();
        if (template.isNotifyTemplate()) {
            NotifyTemplateHolder notifyTemplate = (NotifyTemplateHolder)template;
            boolean notifyfifoClass = template.getServerTypeDesc().isFifoSupported();
            boolean ntype = false;
            if (notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_UPDATE) || notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_UNMATCHED) || notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_MATCHED_UPDATE) || notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_REMATCHED_UPDATE)) {
                this.incrementNumFifoTemplatesData(this._notifyFifoUpdateTemplatesData, template, notifyfifoClass, tpartition);
                ntype = true;
            }
            if (notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_TAKE)) {
                this.incrementNumFifoTemplatesData(this._notifyFifoTakeTemplatesData, template, notifyfifoClass, tpartition);
                ntype = true;
            }
            if (notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_LEASE_EXPIRATION)) {
                this.incrementNumFifoTemplatesData(this._notifyFifoLeaseExpirationTemplatesData, template, notifyfifoClass, tpartition);
                ntype = true;
            }
            if (notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_WRITE) || !ntype) {
                this.incrementNumFifoTemplatesData(this._notifyFifoWriteTemplatesData, template, notifyfifoClass, tpartition);
            }
        } else {
            ++this._numNonNotifyFifoTemplates;
            this._anyNonNotifyFifoTemplatesTP[tpartition] = true;
            int n2 = tpartition;
            this._numNonNotifyFifoTemplatesTP[n2] = this._numNonNotifyFifoTemplatesTP[n2] + 1;
            this._anyNonNotifyFifoTemplates = true;
        }
    }

    private void incrementNumFifoTemplatesData(FifoTemplatesData fifoTemplatesData, ITemplateHolder templateHolder, boolean notifyfifoClass, int tpartition) {
        ++fifoTemplatesData.numNotifyFifoTemplates;
        fifoTemplatesData.anyNotifyFifoTemplatesTP[tpartition] = true;
        int n = tpartition;
        fifoTemplatesData.numNotifyFifoTemplatesTP[n] = fifoTemplatesData.numNotifyFifoTemplatesTP[n] + 1;
        if (!notifyfifoClass) {
            ++fifoTemplatesData.numNotifyFifoTemplatesForNonFifoType;
            HashMap<Integer, Integer> notifyFifoTemplatesPerNonFifoType = fifoTemplatesData.notifyFifoTemplatesPerNonFifoType == null ? new HashMap<Integer, Integer>() : new HashMap<Integer, Integer>(fifoTemplatesData.notifyFifoTemplatesPerNonFifoType);
            Integer cur = (Integer)notifyFifoTemplatesPerNonFifoType.get(templateHolder.getClassName() != null ? templateHolder.getClassName().hashCode() : 0);
            if (cur != null) {
                notifyFifoTemplatesPerNonFifoType.put(templateHolder.getClassName().hashCode(), cur + 1);
            } else {
                notifyFifoTemplatesPerNonFifoType.put(templateHolder.getClassName().hashCode(), 1);
            }
            fifoTemplatesData.notifyFifoTemplatesPerNonFifoType = notifyFifoTemplatesPerNonFifoType;
            this._anyNotifyFifoTemplatesForNonFifoType = true;
            fifoTemplatesData.anyNotifyFifoTemplatesForNonFifoType = true;
        }
        fifoTemplatesData.anyNotifyFifoTemplates = true;
    }

    private synchronized void unregisterFifoTemplate(ITemplateHolder template) {
        --this._numOfFifoTemplates;
        this._anyFifoTemplates = this._numOfFifoTemplates > 0;
        int tpartition = template.getFifoThreadPartition();
        if (template.isNotifyTemplate()) {
            NotifyTemplateHolder notifyTemplate = (NotifyTemplateHolder)template;
            boolean notifyfifoClass = template.getServerTypeDesc().isFifoSupported();
            boolean ntype = false;
            if (notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_UPDATE) || notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_UNMATCHED) || notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_MATCHED_UPDATE) || notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_REMATCHED_UPDATE)) {
                this.decrementNumFifoTemplatesData(this._notifyFifoUpdateTemplatesData, template, notifyfifoClass, tpartition);
                ntype = true;
            }
            if (notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_TAKE)) {
                this.decrementNumFifoTemplatesData(this._notifyFifoTakeTemplatesData, template, notifyfifoClass, tpartition);
                ntype = true;
            }
            if (notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_LEASE_EXPIRATION)) {
                this.decrementNumFifoTemplatesData(this._notifyFifoLeaseExpirationTemplatesData, template, notifyfifoClass, tpartition);
                ntype = true;
            }
            if (notifyTemplate.containsNotifyType(NotifyActionType.NOTIFY_WRITE) || !ntype) {
                this.decrementNumFifoTemplatesData(this._notifyFifoWriteTemplatesData, template, notifyfifoClass, tpartition);
            }
        } else {
            --this._numNonNotifyFifoTemplates;
            int n = tpartition;
            this._numNonNotifyFifoTemplatesTP[n] = this._numNonNotifyFifoTemplatesTP[n] - 1;
            this._anyNonNotifyFifoTemplatesTP[tpartition] = this._numNonNotifyFifoTemplatesTP[tpartition] > 0;
            this._anyNonNotifyFifoTemplates = this._numNonNotifyFifoTemplates > 0;
        }
    }

    private void decrementNumFifoTemplatesData(FifoTemplatesData fifoTemplatesData, ITemplateHolder templateHolder, boolean notifyfifoClass, int tpartition) {
        --fifoTemplatesData.numNotifyFifoTemplates;
        int n = tpartition;
        fifoTemplatesData.numNotifyFifoTemplatesTP[n] = fifoTemplatesData.numNotifyFifoTemplatesTP[n] - 1;
        boolean bl = fifoTemplatesData.anyNotifyFifoTemplatesTP[tpartition] = fifoTemplatesData.numNotifyFifoTemplatesTP[tpartition] > 0;
        if (!notifyfifoClass) {
            --fifoTemplatesData.numNotifyFifoTemplatesForNonFifoType;
            HashMap<Integer, Integer> notifyFifoTemplatesPerNonFifoType = fifoTemplatesData.notifyFifoTemplatesPerNonFifoType == null ? new HashMap<Integer, Integer>() : new HashMap<Integer, Integer>(fifoTemplatesData.notifyFifoTemplatesPerNonFifoType);
            Integer cur = (Integer)notifyFifoTemplatesPerNonFifoType.get(templateHolder.getClassName() != null ? templateHolder.getClassName().hashCode() : 0);
            if (cur == 1) {
                notifyFifoTemplatesPerNonFifoType.remove(templateHolder.getClassName().hashCode());
            } else {
                notifyFifoTemplatesPerNonFifoType.put(templateHolder.getClassName().hashCode(), cur - 1);
            }
            fifoTemplatesData.notifyFifoTemplatesPerNonFifoType = notifyFifoTemplatesPerNonFifoType;
            fifoTemplatesData.anyNotifyFifoTemplatesForNonFifoType = fifoTemplatesData.numNotifyFifoTemplatesForNonFifoType > 0;
            this._anyNotifyFifoTemplatesForNonFifoType = this._notifyFifoUpdateTemplatesData.anyNotifyFifoTemplatesForNonFifoType || this._notifyFifoTakeTemplatesData.anyNotifyFifoTemplatesForNonFifoType || this._notifyFifoWriteTemplatesData.anyNotifyFifoTemplatesForNonFifoType || this._notifyFifoLeaseExpirationTemplatesData.anyNotifyFifoTemplatesForNonFifoType;
        }
        fifoTemplatesData.anyNotifyFifoTemplates = fifoTemplatesData.numNotifyFifoTemplates > 0;
    }

    private void setBlobStoreClearTakeOptimizationNotAllowed(String typeName) {
        this._unallowedClearTakeOptimizationsBlobStoreNotify.add(typeName);
    }

    public boolean isBlobStoreClearTakeOptimizationAllowedNotify(IServerTypeDesc type, boolean onBackup) {
        if (onBackup && !this.anyDurableNotifyTakeTemplates()) {
            return true;
        }
        if (this._unallowedClearTakeOptimizationsBlobStoreNotify.isEmpty()) {
            return true;
        }
        if (this._unallowedClearTakeOptimizationsBlobStoreNotify.contains(type.getTypeDesc().getTypeName())) {
            return false;
        }
        for (String typeName : this._unallowedClearTakeOptimizationsBlobStoreNotify) {
            for (IServerTypeDesc typeDesc : type.getSuperTypes()) {
                if (!typeDesc.getTypeName().equals(typeName)) continue;
                return false;
            }
        }
        return true;
    }

    private void handleBlobStoreNotifyOptimizations(NotifyTemplateHolder template, boolean register) {
        if (!this._cacheManager.isBlobStoreCachePolicy() || !template.containsNotifyType(NotifyActionType.NOTIFY_TAKE)) {
            return;
        }
        if (!register) {
            if (!this.anyDurableNotifyTakeTemplates() && !this.anyNotifyTakeTemplates()) {
                this._unallowedClearTakeOptimizationsBlobStoreNotify.clear();
            }
        } else {
            this.setBlobStoreClearTakeOptimizationNotAllowed(template.getClassName());
        }
    }

    public static class FifoTemplatesData {
        public volatile boolean anyNotifyFifoTemplates;
        public volatile boolean anyNotifyFifoTemplatesForNonFifoType;
        public volatile HashMap<Integer, Integer> notifyFifoTemplatesPerNonFifoType;
        public int numNotifyFifoTemplates;
        public int numNotifyFifoTemplatesForNonFifoType;
        public final boolean[] anyNotifyFifoTemplatesTP;
        public final int[] numNotifyFifoTemplatesTP;

        public FifoTemplatesData(int notifyFifoThreads) {
            this.anyNotifyFifoTemplatesTP = new boolean[notifyFifoThreads];
            this.numNotifyFifoTemplatesTP = new int[notifyFifoThreads];
        }
    }
}

