/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.UpdateMultipleContext;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.AnswerHolder;
import com.j_spaces.core.AnswerPacket;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.core.UpdateOrWriteContext;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.server.processor.UpdateOrWriteBusPacket;

@InternalApi
public class UpdateOrWriteMultipleContext
extends UpdateMultipleContext {
    public UpdateOrWriteMultipleContext(ITemplateHolder concentratingTemplate, IEntryPacket[] entries, long[] leases, int operationModifiers, long timeout, SpaceEngine engine, XtnEntry xtnEntry) {
        super(concentratingTemplate, entries, leases, operationModifiers, timeout, engine, xtnEntry);
    }

    @Override
    public boolean isUpdateOrWriteMultiple() {
        return true;
    }

    @Override
    boolean isExpired() {
        if (super.getTimeOut() == 0L) {
            return false;
        }
        long current = SystemTime.timeMillis();
        long expTime = LeaseManager.toAbsoluteTime(super.getTimeOut(), super.getStartTime());
        return expTime < current;
    }

    @Override
    public boolean shouldRetryUpdateOrWriteForEntry(Throwable exception, ITemplateHolder entryOpTemplate, UpdateOrWriteContext ctx, boolean spawnThread) {
        if (exception instanceof EntryNotInSpaceException && !this.isExpired()) {
            if (spawnThread) {
                super.setNonMainThreadUsed();
                UpdateOrWriteBusPacket packet = new UpdateOrWriteBusPacket(ctx.packet.getOperationID(), super.getConcentratingTemplate().getResponseContext(), ctx);
                super.getEngine().getProcessorWG().enqueueBlocked(packet);
            }
            return true;
        }
        return false;
    }

    @Override
    void setAnswerByOrdinal(Object res, int ordinal) {
        Object[] answer = super.getAnswer();
        if (res instanceof AnswerHolder) {
            AnswerHolder ah = (AnswerHolder)res;
            AnswerPacket answerPacket = ah.m_AnswerPacket;
            answer[ordinal] = ah.getException() != null ? ah.getException() : (answerPacket.m_leaseProxy != null ? answerPacket.m_leaseProxy : (answerPacket.getWriteEntryResult() != null ? answerPacket.getWriteEntryResult() : answerPacket.m_EntryPacket));
        } else {
            answer[ordinal] = res;
        }
    }
}

