/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space;

import com.gigaspaces.attribute_store.AttributeStore;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DirectPersistencyRecoveryException;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZookeeperLastPrimaryHandler {
    private static final String SEPARATOR = "~";
    private final Logger _logger;
    private final SpaceImpl _spaceImpl;
    private final String _attributeStoreKey;
    private final String attributeStoreValue;
    private final AttributeStore _attributeStore;

    public ZookeeperLastPrimaryHandler(SpaceImpl spaceImpl, Logger logger) {
        this._logger = logger;
        this._spaceImpl = spaceImpl;
        this._attributeStoreKey = ZookeeperLastPrimaryHandler.toPath(spaceImpl.getName(), String.valueOf(spaceImpl.getPartitionIdOneBased()));
        this.attributeStoreValue = ZookeeperLastPrimaryHandler.toId(spaceImpl.getInstanceId(), spaceImpl.getSpaceUuid().toString());
        this._attributeStore = this.createZooKeeperAttributeStore();
    }

    private AttributeStore createZooKeeperAttributeStore() {
        try {
            Constructor constructor = ClassLoaderHelper.loadLocalClass("org.openspaces.zookeeper.attribute_store.ZooKeeperAttributeStore").getConstructor(String.class, SpaceConfig.class);
            return (AttributeStore)constructor.newInstance("", this._spaceImpl.getConfig());
        }
        catch (Exception e) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, "Failed to create attribute store ");
            }
            throw new DirectPersistencyRecoveryException("Failed to start [" + this._spaceImpl.getServiceName() + "] Failed to create attribute store.");
        }
    }

    public void closeZooKeeperAttributeStore() {
        try {
            this._attributeStore.close();
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Failed to close ZooKeeperAttributeStore", e);
        }
    }

    public void removeLastPrimaryRecord() throws IOException {
        this._logger.info("Removing key [" + this._attributeStoreKey + "] from ZK");
        this._attributeStore.remove(this._attributeStoreKey);
    }

    public void setMeAsLastPrimary() throws IOException {
        String previousLastPrimary = this._attributeStore.set(this._attributeStoreKey, this.attributeStoreValue);
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.log(Level.INFO, "Set as last primary [" + this.attributeStoreValue + "] for key [" + this._attributeStoreKey + "] in ZK. Previous last primary is [" + previousLastPrimary + "]");
        }
    }

    public boolean isLastPrimary() {
        try {
            return this.attributeStoreValue.equals(this.getLastPrimaryName());
        }
        catch (IOException e) {
            this._logger.log(Level.WARNING, "Failed to get last primary from ZK", e);
            return false;
        }
    }

    public String getLastPrimaryName() throws IOException {
        return this._attributeStore.get(this._attributeStoreKey);
    }

    public String getLastPrimaryNameMemoryXtend() throws IOException {
        String lastPrimary = this._attributeStore.get(this._attributeStoreKey);
        if (lastPrimary == null) {
            return null;
        }
        String[] tokens = lastPrimary.split(SEPARATOR);
        if (tokens.length == 2) {
            return tokens[0];
        }
        this._logger.log(Level.WARNING, "Invalid last primary value [" + lastPrimary + "] - expected " + ZookeeperLastPrimaryHandler.toId("<instance_id>", "<service_id>"));
        return null;
    }

    public String getAttributeStoreKey() {
        return this._attributeStoreKey;
    }

    public static String getSeparator() {
        return SEPARATOR;
    }

    public static String toPath(String spaceName, String partitionId) {
        return "/xap/spaces/" + spaceName + "/leader-election/" + partitionId + "/leader";
    }

    public static String toId(String instanceId, String uid) {
        return instanceId + SEPARATOR + uid;
    }
}

