/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.backport.java.util.concurrent.FastConcurrentSkipListMap;
import com.gigaspaces.internal.server.space.events.RemoteEventBatchBusPacket;
import com.gigaspaces.internal.server.space.events.RemoteEventBusPacket;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.kernel.WorkingGroup;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;

@InternalApi
public class BatchNotifyExecutor {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.notify");
    private static final long SLEEP_PERIOD = 500L;
    public static final long BATCH_NOTIFY_TIMEKEY_GRANULARITY = 20L;
    private static final int STATUS_OK = 0;
    private static final int STATUS_BUSY = 1;
    private static final int STATUS_EMPTY = 2;
    private final BatchNotifyThread _notifyThread;
    private final FastConcurrentSkipListMap<TimeKey, NotifyTemplateHolder> _pendingTemplates;
    private WorkingGroup<RemoteEventBusPacket> _notifyWorkingGroup;
    private final AtomicInteger _estimatedNumberOfTimeKeys = new AtomicInteger();

    public BatchNotifyExecutor(String fullSpaceName, WorkingGroup<RemoteEventBusPacket> notifyWorkingGroup) {
        this._pendingTemplates = new FastConcurrentSkipListMap();
        this._notifyWorkingGroup = notifyWorkingGroup;
        this._notifyThread = new BatchNotifyThread(fullSpaceName, this);
        this._notifyThread.start();
    }

    public void close() {
        this._notifyThread.shutdown();
    }

    public void execute(RemoteEventBusPacket re) throws RemoteException, UnknownEventException {
        long leftover;
        if (re.isAfterBatching()) {
            re.notifyListener();
            return;
        }
        NotifyTemplateHolder template = (NotifyTemplateHolder)re.getEntryHolder();
        RemoteEvent event = re.getRemoteEvent();
        long time = SystemTime.timeMillis() + template.getBatchTime();
        long l = time = time < 0L ? Long.MAX_VALUE : time;
        if (time != Long.MAX_VALUE && (leftover = time % 20L) > 0L) {
            time += 20L - leftover;
        }
        EventHolder eventHolder = new EventHolder(event, time);
        template.addPendingEvent(eventHolder);
        EventHolder firstEvent = null;
        if (template.getPendingEventsSize() >= template.getBatchSize() && (firstEvent = template.peekPendingEvent()) != null) {
            int status = this.notifyEvent(template, false);
            if (status == 0) {
                NotifyTemplateHolder res = this._pendingTemplates.remove(new TimeKey(firstEvent, template));
                if (_logger.isLoggable(Level.FINEST)) {
                    if (res != null) {
                        this._estimatedNumberOfTimeKeys.decrementAndGet();
                    }
                    _logger.finest("execute: OK from notifyEvent remained timekeys=" + this._estimatedNumberOfTimeKeys.get() + " removed=" + (res != null));
                }
                if ((firstEvent = template.peekPendingEvent()) != null) {
                    TimeKey newTime = new TimeKey(firstEvent, template);
                    this._pendingTemplates.put(newTime, template);
                    this._notifyThread.notifyIfNeedTo(newTime);
                    if (_logger.isLoggable(Level.FINEST)) {
                        this._estimatedNumberOfTimeKeys.incrementAndGet();
                        _logger.finest("execute: added template border=" + template.getBatchOrder() + " seq=" + newTime._holder.getEvent().getSequenceNumber() + " size=" + this._estimatedNumberOfTimeKeys.get());
                    }
                }
            } else {
                this.insertTemplateIfFirst(template, eventHolder);
            }
        } else {
            this.insertTemplateIfFirst(template, eventHolder);
        }
    }

    private void notifyReadyEvents() throws RemoteException, UnknownEventException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("notifyReadyEvents: start scanning size=" + this._estimatedNumberOfTimeKeys);
        }
        Iterator<Map.Entry<TimeKey, NotifyTemplateHolder>> iterator = this._pendingTemplates.entrySet().iterator();
        while (iterator.hasNext()) {
            EventHolder firstEvent;
            Map.Entry<TimeKey, NotifyTemplateHolder> entry = iterator.next();
            NotifyTemplateHolder template = entry.getValue();
            TimeKey templateKey = entry.getKey();
            long time = templateKey._holder.getTime();
            long timeToSleep = time - SystemTime.timeMillis();
            int size = template.getPendingEventsSize();
            if (timeToSleep > 0L) {
                return;
            }
            if (templateKey._holder != template.peekPendingEvent() && size < template.getBatchSize()) {
                iterator.remove();
                if (!_logger.isLoggable(Level.FINEST)) continue;
                this._estimatedNumberOfTimeKeys.decrementAndGet();
                _logger.finest("notifyReadyEvents: timekey to just remove (first NE and size) border=" + template.getBatchOrder() + " seq=" + templateKey._holder.getEvent().getSequenceNumber() + " size=" + this._estimatedNumberOfTimeKeys);
                continue;
            }
            int status = this.notifyEvent(template, true);
            if (status == 1) continue;
            iterator.remove();
            if (_logger.isLoggable(Level.FINEST)) {
                this._estimatedNumberOfTimeKeys.decrementAndGet();
                _logger.finest("notifyReadyEvents: timekey to remove after notify =" + status + " border=" + template.getBatchOrder() + " seq=" + templateKey._holder.getEvent().getSequenceNumber() + " size=" + this._estimatedNumberOfTimeKeys);
            }
            if ((firstEvent = template.peekPendingEvent()) == null) continue;
            TimeKey key = new TimeKey(firstEvent, template);
            this._pendingTemplates.put(key, template);
            if (!_logger.isLoggable(Level.FINEST)) continue;
            this._estimatedNumberOfTimeKeys.incrementAndGet();
            _logger.finest("notifyReadyEvents: added new firstevent after notify status=" + status + " border=" + template.getBatchOrder() + " seq=" + key._holder.getEvent().getSequenceNumber() + " size=" + this._estimatedNumberOfTimeKeys);
        }
    }

    private void insertTemplateIfFirst(NotifyTemplateHolder template, EventHolder eventHolder) {
        EventHolder eh = template.peekPendingEvent();
        if (eh == eventHolder) {
            TimeKey newTime = new TimeKey(eh, template);
            this._pendingTemplates.put(newTime, template);
            if (_logger.isLoggable(Level.FINEST)) {
                this._estimatedNumberOfTimeKeys.incrementAndGet();
                _logger.finest("insertTemplateIfFirst: added new firstevent border=" + template.getBatchOrder() + " seq=" + newTime._holder.getEvent().getSequenceNumber() + " size=" + this._estimatedNumberOfTimeKeys);
            }
            this._notifyThread.notifyIfNeedTo(newTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int notifyEvent(NotifyTemplateHolder template, boolean fromBatchThread) throws RemoteException, UnknownEventException {
        boolean notified = false;
        while (true) {
            block29: {
                if (!template.trySetNotifyInProgress()) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("notifyEvent: busy from batch " + fromBatchThread + " border" + template.getBatchOrder());
                    }
                    return notified ? 0 : 1;
                }
                try {
                    if (template.getPendingEventsSize() == 0) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("notifyEvent: empty from batch " + fromBatchThread + " border" + template.getBatchOrder());
                        }
                        int n = notified ? 0 : 2;
                        return n;
                    }
                    if (!fromBatchThread && template.getPendingEventsSize() < template.getBatchSize()) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("notifyEvent: half-empty from batch " + fromBatchThread + " border" + template.getBatchOrder());
                        }
                        int n = notified ? 0 : 2;
                        return n;
                    }
                    RemoteEventListener reListener = template.getREListener();
                    if (reListener == null || template.isDeleted()) {
                        template.clearPendingEvents();
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("notifyEvent: INVALID from batch " + fromBatchThread + " border" + template.getBatchOrder());
                        }
                        int n = 2;
                        return n;
                    }
                    if (reListener instanceof BatchRemoteEventListener) {
                        BatchRemoteEventListener listener = (BatchRemoteEventListener)reListener;
                        RemoteEvent[] eventsArray = new RemoteEvent[Math.min(template.getPendingEventsSize(), template.getBatchSize())];
                        for (int i = 0; i < eventsArray.length; ++i) {
                            EventHolder res = template.pollPendingEvent();
                            if (res == null) {
                                if (i == 0) {
                                    int n = notified ? 0 : 2;
                                    return n;
                                }
                                RemoteEvent[] tempEventsArray = new RemoteEvent[i];
                                System.arraycopy(eventsArray, 0, tempEventsArray, 0, i);
                                eventsArray = tempEventsArray;
                                break;
                            }
                            if (i == 0) {
                                notified = true;
                            }
                            eventsArray[i] = res.getEvent();
                        }
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("notifyEvent: sent batch " + fromBatchThread + " border" + template.getBatchOrder() + " events=" + eventsArray.length + " left=" + template.getPendingEventsSize());
                        }
                        if (fromBatchThread) {
                            RemoteEventBatchBusPacket packet = new RemoteEventBatchBusPacket(template, eventsArray);
                            packet.afterBatching();
                            this._notifyWorkingGroup.enqueueBlocked(packet);
                        } else {
                            listener.notifyBatch(new BatchRemoteEvent(eventsArray));
                        }
                        break block29;
                    }
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("notifyEvent: sent non-batch listener" + fromBatchThread + " border" + template.getBatchOrder() + " events=" + template.getPendingEventsSize());
                    }
                    notified = true;
                    while (template.getPendingEventsSize() > 0) {
                        EventHolder res = template.pollPendingEvent();
                        if (res == null) {
                            break;
                        }
                        RemoteEvent event = res.getEvent();
                        if (fromBatchThread) {
                            RemoteEventBusPacket packet = new RemoteEventBusPacket(template, event, -1, null, false);
                            packet.afterBatching();
                            this._notifyWorkingGroup.enqueueBlocked(packet);
                            continue;
                        }
                        reListener.notify(event);
                    }
                }
                finally {
                    template.finnishedNotify();
                }
            }
            if (template.getPendingEventsSize() < template.getBatchSize()) {
                return notified ? 0 : 2;
            }
            if (!_logger.isLoggable(Level.FINEST)) continue;
            _logger.finest("notifyEvent: another loop from batch " + fromBatchThread + " border=" + template.getBatchOrder() + " template events =" + template.getPendingEventsSize());
        }
    }

    private static class BatchNotifyThread
    extends GSThread {
        private volatile boolean _active;
        private final BatchNotifyExecutor _notifier;
        private long _wakeUpTime;
        private volatile boolean _waiting;

        public BatchNotifyThread(String fullSpaceName, BatchNotifyExecutor notifier) {
            super("[" + fullSpaceName + "] Batch Notifier");
            this._notifier = notifier;
            this._active = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyIfNeedTo(TimeKey current) {
            if (!this._waiting) {
                return;
            }
            BatchNotifyThread batchNotifyThread = this;
            synchronized (batchNotifyThread) {
                if (!this._waiting) {
                    return;
                }
                if (current._holder.getTime() < this._wakeUpTime) {
                    ((Object)((Object)this)).notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this._active) {
                try {
                    BatchNotifyThread batchNotifyThread = this;
                    synchronized (batchNotifyThread) {
                        TimeKey first = null;
                        this._waiting = true;
                        try {
                            first = (TimeKey)this._notifier._pendingTemplates.firstKey();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                        this._wakeUpTime = first == null ? SystemTime.timeMillis() + 500L : first._holder.getTime();
                        long waitTime = this._wakeUpTime - SystemTime.timeMillis();
                        if (_logger.isLoggable(Level.FINEST)) {
                            if (first != null) {
                                _logger.finest("BatchNotifyThread examine first template border=" + first._templateBatchOrder + " seq=" + first._holder.getEvent().getSequenceNumber() + " timetosleep=" + waitTime);
                            } else {
                                _logger.finest("BatchNotifyThread examine TimeKey first is NULL");
                            }
                        }
                        if (waitTime > 0L) {
                            ((Object)((Object)this)).wait(waitTime);
                        }
                        this._waiting = false;
                    }
                    this._notifier.notifyReadyEvents();
                }
                catch (InterruptedException e) {
                    this._active = false;
                    _logger.log(Level.FINE, "batching thread was interrupted");
                }
                catch (RemoteException e) {
                    _logger.log(Level.FINE, "got remote exception when notifying events", e);
                }
                catch (UnknownEventException e) {
                    _logger.log(Level.FINE, "trying to send a corrupted event", e);
                }
            }
        }

        public void shutdown() {
            this._active = false;
            this.interrupt();
        }
    }

    private static class TimeKey
    implements Comparable<TimeKey> {
        public final EventHolder _holder;
        private final long _templateBatchOrder;

        public TimeKey(EventHolder holder, NotifyTemplateHolder template) {
            this._holder = holder;
            this._templateBatchOrder = template.getBatchOrder();
        }

        @Override
        public int compareTo(TimeKey other) {
            if (this._holder.getTime() != other._holder.getTime()) {
                return (int)(this._holder.getTime() - other._holder.getTime());
            }
            if (this._templateBatchOrder != other._templateBatchOrder) {
                return (int)(this._templateBatchOrder - other._templateBatchOrder);
            }
            return (int)(this._holder.getEvent().getSequenceNumber() - other._holder.getEvent().getSequenceNumber());
        }
    }

    public static class EventHolder {
        private final RemoteEvent _event;
        private final long _time;

        public EventHolder(RemoteEvent event, long time) {
            this._event = event;
            this._time = time;
        }

        public RemoteEvent getEvent() {
            return this._event;
        }

        public long getTime() {
            return this._time;
        }
    }
}

