/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInNotificationSentHandler;
import com.gigaspaces.internal.server.space.events.RemoteEventBusPacket;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.j_spaces.core.OperationID;
import com.j_spaces.kernel.WorkingGroup;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@InternalApi
public class NotifyBackupLog
implements IReplicationInNotificationSentHandler {
    private final WorkingGroup<RemoteEventBusPacket> _dataEventDispatcher;
    private final ConcurrentHashMap<OperationID, ConcurrentHashSet<RemoteEventBusPacket>> _outgoingEvents;
    private final ConcurrentHashSet<OperationID> _alreadyTriggeredEvents;

    public NotifyBackupLog(WorkingGroup<RemoteEventBusPacket> dataEventDispatcher) {
        this._dataEventDispatcher = dataEventDispatcher;
        this._outgoingEvents = new ConcurrentHashMap();
        this._alreadyTriggeredEvents = new ConcurrentHashSet();
    }

    public void add(RemoteEventBusPacket packet) {
        ConcurrentHashSet<RemoteEventBusPacket> previous;
        OperationID id = packet.getStatus().getOperationId();
        ConcurrentHashSet<RemoteEventBusPacket> outgoingEventsForOperation = this._outgoingEvents.get(id);
        if (outgoingEventsForOperation == null && (previous = this._outgoingEvents.putIfAbsent(id, outgoingEventsForOperation = new ConcurrentHashSet())) != null) {
            outgoingEventsForOperation = previous;
        }
        outgoingEventsForOperation.add(packet);
    }

    public void clearTriggered(OperationID operationId) {
        if (operationId != null && this._alreadyTriggeredEvents.contains(operationId)) {
            this._outgoingEvents.remove(operationId);
            this._alreadyTriggeredEvents.remove(operationId);
        }
    }

    public void clear() {
        this._outgoingEvents.clear();
        this._alreadyTriggeredEvents.clear();
    }

    @Override
    public void inNotificationSent(IReplicationInContext context, OperationID operationId) throws RemoteException {
        Iterator iterator;
        this._alreadyTriggeredEvents.add(operationId);
        ConcurrentHashSet<RemoteEventBusPacket> notifications = this._outgoingEvents.get(operationId);
        if (notifications != null && !notifications.isEmpty() && (iterator = notifications.iterator()).hasNext() && ((RemoteEventBusPacket)notifications.iterator().next()).getStatus().isFinishedTemplateSearch()) {
            this._outgoingEvents.remove(operationId);
            this._alreadyTriggeredEvents.remove(operationId);
        }
    }

    public void processOutgoingEvents() {
        for (Set set : this._outgoingEvents.values()) {
            for (RemoteEventBusPacket event : set) {
                this._dataEventDispatcher.enqueueBlocked(event);
            }
        }
    }
}

