/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.OperationID;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class NotifyContext {
    private AtomicInteger _notifyCount;
    private boolean _isFirstTrigger = true;
    private final IEntryHolder _notifyEntry;
    private final IEntryHolder _referenceEntry;
    private final OperationID _operationId;
    private final NotifyActionType _notifyType;
    private boolean _guaranteedNotifications;
    private volatile boolean _finishedTemplateSearch;

    public NotifyContext(IEntryHolder notifyEntry, OperationID operationId, NotifyActionType notifyType) {
        this(notifyEntry, null, operationId, notifyType);
    }

    public NotifyContext(IEntryHolder notifyEntry, IEntryHolder referanceEntry, OperationID operationId, NotifyActionType notifyType) {
        this._notifyEntry = notifyEntry;
        this._referenceEntry = referanceEntry;
        this._operationId = operationId;
        this._notifyType = notifyType;
    }

    public IEntryHolder getEntry() {
        return this._notifyEntry;
    }

    public IEntryHolder getReferenceEntry() {
        return this._referenceEntry;
    }

    public OperationID getOperationId() {
        return this._operationId;
    }

    public NotifyActionType getNotifyType() {
        return this._notifyType;
    }

    public boolean isGuaranteedNotifications() {
        return this._guaranteedNotifications;
    }

    public void setGuaranteedNotifications(boolean guaranteedNotifications) {
        this._guaranteedNotifications = guaranteedNotifications;
    }

    public boolean isFinishedTemplateSearch() {
        return this._finishedTemplateSearch;
    }

    public void setFinishedTemplateSearch(boolean finishedTemplateSearch) {
        this._finishedTemplateSearch = finishedTemplateSearch;
    }

    public boolean countInc(boolean needAfterAll) {
        if (this._notifyCount != null) {
            this._notifyCount.incrementAndGet();
        } else if (needAfterAll) {
            this._notifyCount = new AtomicInteger(2);
        }
        boolean first = this._isFirstTrigger;
        this._isFirstTrigger = false;
        return first;
    }

    public boolean countDec() {
        return this._notifyCount == null ? false : this._notifyCount.decrementAndGet() == 0;
    }
}

