/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.server.space.events.NotifyContext;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.OperationID;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class NotifyContextsHolder {
    protected final IEntryHolder _originalEntry;
    protected final IEntryHolder _newEntry;
    protected final OperationID _operationId;
    protected NotifyContext _notifyContext;
    private final boolean _isNotifyNewEntry;
    private NotifyActionType _notifyType;
    protected List<NotifyContext> _notifyContextsList;
    protected List<NotifyActionType> _notifyTypesList;

    public NotifyContextsHolder(IEntryHolder originalEntry, IEntryHolder newEntry, OperationID operationId, NotifyActionType notifyType) {
        this._originalEntry = originalEntry;
        this._newEntry = newEntry;
        this._operationId = operationId;
        this._isNotifyNewEntry = !notifyType.equals(NotifyActionType.NOTIFY_UNMATCHED) && !notifyType.equals(NotifyActionType.NOTIFY_TAKE);
        this._notifyType = notifyType;
        this._notifyContext = null;
        this._notifyContextsList = Collections.EMPTY_LIST;
        this._notifyTypesList = new LinkedList<NotifyActionType>();
        this._notifyTypesList.add(notifyType);
    }

    public IEntryHolder getNotifyEntry() {
        return this._isNotifyNewEntry ? this._newEntry : this._originalEntry;
    }

    public IEntryHolder getOriginalEntry() {
        return this._originalEntry;
    }

    public IEntryHolder getNewEntry() {
        return this._newEntry;
    }

    public NotifyContext getNotifyContext() {
        if (this._notifyContext == null) {
            IEntryHolder notifyEntry = this._newEntry;
            IEntryHolder referenceEntry = this._originalEntry;
            if (!this._isNotifyNewEntry) {
                notifyEntry = this._originalEntry;
                referenceEntry = this._newEntry;
            }
            this._notifyContext = new NotifyContext(notifyEntry, referenceEntry, this._operationId, this._notifyType);
            if (this._notifyContextsList == Collections.EMPTY_LIST) {
                this._notifyContextsList = new LinkedList<NotifyContext>();
            }
            this._notifyContextsList.add(this._notifyContext);
        }
        return this._notifyContext;
    }

    public List<NotifyContext> getNotifyContexts() {
        return this._notifyContextsList;
    }

    public NotifyActionType getNotifyType() {
        return this._notifyType;
    }

    public List<NotifyActionType> getNotifyTypes() {
        return this._notifyTypesList;
    }
}

