/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.events.NotifyContext;
import com.gigaspaces.internal.server.space.events.SpaceDataEventDispatcher;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.server.processor.BusPacket;
import java.rmi.RemoteException;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;

@InternalApi
public class RemoteEventBusPacket
extends BusPacket<SpaceDataEventDispatcher> {
    private final RemoteEvent _remoteEvent;
    private int _TTL;
    private final NotifyContext _notifyContext;
    private boolean _afterBatching = false;
    private final boolean _fromReplication;

    public RemoteEventBusPacket(ITemplateHolder templateHolder, RemoteEvent re, int TTL, NotifyContext notifyContext, boolean fromReplication) {
        super(null, templateHolder, null, 0L);
        if (re instanceof EntryArrivedRemoteEvent) {
            super.setOperationID(((EntryArrivedRemoteEvent)re).getOperationID());
        }
        this._remoteEvent = re;
        this._TTL = TTL;
        this._notifyContext = notifyContext;
        this._fromReplication = fromReplication;
    }

    public void afterBatching() {
        this._afterBatching = true;
    }

    public boolean isAfterBatching() {
        return this._afterBatching;
    }

    public RemoteEvent getRemoteEvent() {
        return this._remoteEvent;
    }

    public void setTTL(int tTL) {
        this._TTL = tTL;
    }

    public int getTTL() {
        return this._TTL;
    }

    public NotifyContext getStatus() {
        return this._notifyContext;
    }

    @Override
    public void execute(SpaceDataEventDispatcher dispatcher) throws Exception {
        dispatcher.execute(this);
    }

    public void notifyListener() throws RemoteException, UnknownEventException {
        NotifyTemplateHolder template = (NotifyTemplateHolder)this.getEntryHolder();
        RemoteEventListener listener = template.getREListener();
        if (listener != null) {
            if (LRMIUtilities.isRemoteProxy(listener)) {
                LRMIInvocationContext.enableCustomPriorityForNextInvocation();
            }
            listener.notify(this.getRemoteEvent());
        }
    }

    public boolean isFromReplication() {
        return this._fromReplication;
    }
}

