/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.exception.lrmi.SlowConsumerException;
import com.gigaspaces.internal.server.space.events.RemoteEventBusPacket;
import com.gigaspaces.internal.server.space.events.SpaceDataEventManager;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.kernel.IConsumerObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.UnknownLeaseException;

@InternalApi
public class SpaceDataEventDispatcher
implements IConsumerObject<RemoteEventBusPacket> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.notify");
    private final SpaceDataEventManager _dataEventManager;
    private LeaseManager _leaseManager;

    public SpaceDataEventDispatcher(SpaceDataEventManager dataEventManager) {
        this._dataEventManager = dataEventManager;
    }

    public void setLeaseManager(LeaseManager leaseManager) {
        this._leaseManager = leaseManager;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void dispatch(RemoteEventBusPacket packet) {
        try {
            packet.execute(this);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
        finally {
            this._dataEventManager.notifyReturned(packet.getStatus(), (ITemplateHolder)packet.getEntryHolder());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RemoteEventBusPacket re) throws Exception {
        int ttl = re.getTTL();
        NotifyTemplateHolder th = (NotifyTemplateHolder)re.getEntryHolder();
        boolean signaledRemoteException = false;
        while (true) {
            try {
                block31: {
                    while (true) {
                        if (th.getREListener() == null || th.isDeleted()) {
                            return;
                        }
                        NotifyTemplateHolder notifyTemplateHolder = th;
                        synchronized (notifyTemplateHolder) {
                            if (th.getREListener() == null || th.isDeleted()) {
                                return;
                            }
                        }
                        if (!th.hasPendingRemoteException() || signaledRemoteException) break block31;
                        re.setTTL(re.getTTL() - 1);
                        if (re.getTTL() <= 0) break;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("Notification failed (signaled by other thread) \nRetrying: TTL=" + re.getTTL());
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException ie) {
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.log(Level.FINEST, Thread.currentThread().getName() + " interrupted.", ie);
                            }
                            this.cancel(th);
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Notification failed: gave up after " + 2000 * ttl + " milliseconds ; removing notification template.");
                    }
                    this.cancel(th);
                    return;
                }
                this._dataEventManager.executePacket(re, th);
                if (th.hasPendingRemoteException()) {
                    NotifyTemplateHolder ie = th;
                    synchronized (ie) {
                        th.setPendingRemoteException(false);
                    }
                }
                return;
            }
            catch (UnknownEventException ex) {
                this.cancel(th, (Exception)((Object)ex));
                return;
            }
            catch (NoSuchObjectException ex) {
                this.cancel(th, ex);
                return;
            }
            catch (RemoteException rex) {
                re.setTTL(re.getTTL() - 1);
                if (re.getTTL() > 0 && !(rex.getCause() instanceof SlowConsumerException)) {
                    NotifyTemplateHolder notifyTemplateHolder = th;
                    synchronized (notifyTemplateHolder) {
                        if (!th.hasPendingRemoteException()) {
                            signaledRemoteException = true;
                            th.setPendingRemoteException(true);
                        }
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Notification failed.", rex);
                        _logger.fine("Retrying: TTL=" + re.getTTL());
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, Thread.currentThread().getName() + " interrupted.", ie);
                        }
                        this.cancel(th);
                        Thread.currentThread().interrupt();
                        return;
                    }
                    continue;
                }
                this.cancel(th, rex);
                return;
            }
            catch (Exception ex) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Notification failed. ", ex);
                }
                this.cancel(th, ex);
                return;
            }
            break;
        }
    }

    private void cancel(NotifyTemplateHolder template, Exception ex) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Notification failed: " + ex + " ; removing notification template.");
        }
        this.cancel(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(NotifyTemplateHolder template) {
        block6: {
            NotifyTemplateHolder notifyTemplateHolder = template;
            synchronized (notifyTemplateHolder) {
                template.setREListener(null);
            }
            if (!template.isDeleted()) {
                try {
                    this._leaseManager.cancel(template.getUID(), template.getClassName(), template.getSpaceItemType(), false, true, false);
                }
                catch (UnknownLeaseException e) {
                    if (!_logger.isLoggable(Level.FINEST)) break block6;
                    _logger.log(Level.FINEST, Thread.currentThread().getName() + " fail to cancel lease.", e);
                }
            }
        }
    }
}

