/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.cluster.node.IReplicationNode;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.events.BatchNotifyExecutor;
import com.gigaspaces.internal.server.space.events.NotifyBackupLog;
import com.gigaspaces.internal.server.space.events.NotifyContext;
import com.gigaspaces.internal.server.space.events.RemoteEventBusPacket;
import com.gigaspaces.internal.server.space.events.SpaceDataEventDispatcher;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.filters.FilterManager;
import com.j_spaces.kernel.WorkingGroup;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.UnknownEventException;

@InternalApi
public class SpaceDataEventManager
implements ISpaceModeListener {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.filters");
    private final IDirectSpaceProxy _spaceProxy;
    private final SpaceImpl _spaceImpl;
    private final FilterManager _filterManager;
    private final NotifyBackupLog _backupLog;
    private final AtomicLong _eventIdGenerator;
    private final SpaceDataEventDispatcher _dataEventDispatcher;
    private final WorkingGroup<RemoteEventBusPacket> _dataEventDispatcherWorkingGroup;
    private final BatchNotifyExecutor _batchNotifier;
    private final int _notifyTTL;

    public SpaceDataEventManager(IDirectSpaceProxy spaceProxy, FilterManager filterManager, SpaceImpl spaceImpl, SpaceConfigReader configReader) {
        this._spaceProxy = spaceProxy;
        this._filterManager = filterManager;
        this._spaceImpl = spaceImpl;
        this._eventIdGenerator = new AtomicLong(0L);
        int minThreads = configReader.getIntSpaceProperty("engine.notify_min_threads", "1");
        int maxThreads = configReader.getIntSpaceProperty("engine.notify_max_threads", "64");
        this._notifyTTL = configReader.getIntSpaceProperty("notifier-retries", "3");
        this._dataEventDispatcher = new SpaceDataEventDispatcher(this);
        this._dataEventDispatcherWorkingGroup = new WorkingGroup<RemoteEventBusPacket>(this._dataEventDispatcher, 5, "Notifier", minThreads, maxThreads, 60000L);
        this._batchNotifier = new BatchNotifyExecutor(configReader.getFullSpaceName(), this._dataEventDispatcherWorkingGroup);
        this._backupLog = new NotifyBackupLog(this._dataEventDispatcherWorkingGroup);
        this._dataEventDispatcherWorkingGroup.start();
    }

    public void init(boolean isReplicated, IReplicationNode replicationNode) {
        if (this._spaceImpl.isBackup() && isReplicated) {
            this._spaceImpl.addSpaceModeListener(this);
            replicationNode.setInNotificationSentHandler(this._backupLog);
        }
    }

    public void setLeaseManager(LeaseManager leaseManager) {
        this._dataEventDispatcher.setLeaseManager(leaseManager);
    }

    public void close() {
        this._spaceImpl.removeSpaceModeListener(this);
        this._batchNotifier.close();
        this._dataEventDispatcherWorkingGroup.shutdown();
    }

    public void notifyReturned(NotifyContext notifyContext, ITemplateHolder template) {
        block4: {
            if (notifyContext == null) {
                return;
            }
            if (this._filterManager._isFilter[16]) {
                Object[] entries = new Object[]{notifyContext.getEntry(), template};
                try {
                    this._filterManager.invokeFilters(16, null, entries);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINE)) break block4;
                    _logger.log(Level.FINE, "Exception was thrown by filter on AFTER_NOTIFY_TRIGGER.", e);
                }
            }
        }
        this.decreaseCounter(notifyContext);
    }

    public void finishTemplatesSearch(NotifyContext notifyContext) {
        this.decreaseCounter(notifyContext);
        this._backupLog.clearTriggered(notifyContext.getOperationId());
    }

    @Override
    public void afterSpaceModeChange(SpaceMode newMode) throws RemoteException {
        if (newMode == SpaceMode.PRIMARY) {
            this._backupLog.processOutgoingEvents();
        }
        this._backupLog.clear();
    }

    @Override
    public void beforeSpaceModeChange(SpaceMode newMode) throws RemoteException {
    }

    public long generateEventId() {
        return this._eventIdGenerator.incrementAndGet();
    }

    public int getQueueSize() {
        return this._dataEventDispatcherWorkingGroup.getQueue().size();
    }

    public void executePacket(RemoteEventBusPacket re, NotifyTemplateHolder th) throws RemoteException, UnknownEventException {
        if (th.isBatching()) {
            this._batchNotifier.execute(re);
        } else {
            re.notifyListener();
        }
    }

    public void notifyTemplate(NotifyTemplateHolder template, IEntryHolder entry, IEntryHolder oldEntry, NotifyContext notifyContext, Context ctx) {
        if (this.executeBeforeNotifyTriggeredFilters(notifyContext, template)) {
            RemoteEvent event;
            RemoteEvent remoteEvent = event = oldEntry == null ? template.createRemoteEvent(entry, notifyContext.getNotifyType(), ctx.getOperationID(), this._spaceProxy, ctx.isFromReplication()) : template.createRemoteEvent(entry, oldEntry, notifyContext.getNotifyType(), ctx.getOperationID(), this._spaceProxy, ctx.isFromReplication());
            if (event != null) {
                RemoteEventBusPacket packet;
                if (template.isGuaranteedNotification()) {
                    notifyContext.setGuaranteedNotifications(true);
                }
                if ((packet = new RemoteEventBusPacket(template, event, this._notifyTTL, notifyContext, ctx.isFromReplication())).isFromReplication() && !template.isTriggerNotify() && this._spaceImpl.isBackup()) {
                    if (packet.getOperationID() != null) {
                        this._backupLog.add(packet);
                    }
                } else {
                    this._dataEventDispatcherWorkingGroup.enqueueBlocked(packet);
                }
            }
        }
    }

    private boolean executeBeforeNotifyTriggeredFilters(NotifyContext notifyContext, ITemplateHolder template) {
        block7: {
            if (notifyContext.countInc(this._filterManager._isFilter[18]) && this._filterManager._isFilter[17]) {
                try {
                    this._filterManager.invokeFilters(17, null, notifyContext.getEntry());
                }
                catch (RuntimeException e) {
                    if (!_logger.isLoggable(Level.FINE)) break block7;
                    _logger.log(Level.FINE, "Exception was thrown by filter on BEFORE_ALL_NOTIFY_TRIGGER.", e);
                }
            }
        }
        if (this._filterManager._isFilter[15]) {
            IEntryHolder[] arguments = new IEntryHolder[]{notifyContext.getEntry(), template};
            try {
                this._filterManager.invokeFilters(15, null, arguments);
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Exception was thrown by filter on BEFORE_NOTIFY_TRIGGER.", e);
                }
                notifyContext.countDec();
                return false;
            }
        }
        return true;
    }

    private void decreaseCounter(NotifyContext notifyContext) {
        block3: {
            if (notifyContext.countDec()) {
                try {
                    this._filterManager.invokeFilters(18, null, notifyContext);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINE)) break block3;
                    _logger.log(Level.FINE, "Exception was thrown by filter on AFTER_ALL_NOTIFY_TRIGGER.", e);
                }
            }
        }
    }
}

