/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.server.space.events.NotifyContext;
import com.gigaspaces.internal.server.space.events.NotifyContextsHolder;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.OperationID;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class UpdateNotifyContextHolder
extends NotifyContextsHolder {
    private NotifyContext _matchedNotifyContext;
    private NotifyContext _rematchedNotifyContext;

    public UpdateNotifyContextHolder(IEntryHolder originalEntry, IEntryHolder newEntry, OperationID operationId, boolean isMatched, boolean isRematched) {
        super(originalEntry, newEntry, operationId, NotifyActionType.NOTIFY_UPDATE);
        if (isMatched) {
            this._notifyTypesList.add(NotifyActionType.NOTIFY_MATCHED_UPDATE);
        }
        if (isRematched) {
            this._notifyTypesList.add(NotifyActionType.NOTIFY_REMATCHED_UPDATE);
        }
    }

    public NotifyContext getMatchedNotifyContext() {
        if (this._matchedNotifyContext == null) {
            this._matchedNotifyContext = new NotifyContext(this._newEntry, this._originalEntry, this._operationId, NotifyActionType.NOTIFY_MATCHED_UPDATE);
            if (this._notifyContextsList == Collections.EMPTY_LIST) {
                this._notifyContextsList = new LinkedList();
            }
            this._notifyContextsList.add(this._matchedNotifyContext);
        }
        return this._matchedNotifyContext;
    }

    public NotifyContext getRematchedNotifyContext() {
        if (this._rematchedNotifyContext == null) {
            this._rematchedNotifyContext = new NotifyContext(this._newEntry, this._originalEntry, this._operationId, NotifyActionType.NOTIFY_REMATCHED_UPDATE);
            if (this._notifyContextsList == Collections.EMPTY_LIST) {
                this._notifyContextsList = new LinkedList();
            }
            this._notifyContextsList.add(this._rematchedNotifyContext);
        }
        return this._rematchedNotifyContext;
    }

    @Override
    public List<NotifyActionType> getNotifyTypes() {
        return this._notifyTypesList;
    }
}

