/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.eviction;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.eviction.IEvictionChain;
import com.gigaspaces.internal.utils.concurrent.UncheckedAtomicIntegerFieldUpdater;
import com.gigaspaces.internal.utils.concurrent.UncheckedAtomicReferenceFieldUpdater;
import com.gigaspaces.server.eviction.EvictableServerEntry;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

@InternalApi
public class ChainSegment
implements IEvictionChain {
    private boolean _unSafe;
    private final boolean _unsafeTouch = true;
    private final LRUInfo _head;
    private final LRUInfo _tail;
    private final short _segment;

    public ChainSegment(int segment) {
        this(true, segment);
    }

    public ChainSegment(boolean unsafe, int segment) {
        this._segment = (short)segment;
        this._head = new LRUInfo(this._segment, null, null, null);
        this._tail = new LRUInfo(this._segment, null, this._head, null);
        this._head.setBwd(this._tail);
        this._head.nodeInsertionEnded();
        this._tail.nodeInsertionEnded();
        this._unSafe = unsafe;
    }

    @Override
    public void insert(EvictableServerEntry entry) {
        LRUInfo newnode = new LRUInfo(this._segment, entry, this._head, null);
        entry.setEvictionPayLoad(newnode);
        this.insertNode(newnode);
    }

    private void insertNode(LRUInfo newnode) {
        LRUInfo cur_first;
        newnode.setDataWasInserted();
        do {
            cur_first = this._head.getBwd();
            newnode.setBwd(cur_first);
        } while (!this._head.casBwd(cur_first, newnode));
        cur_first.setFwd(newnode);
        if (cur_first.isNodeRemoved()) {
            this.disconnect_node(cur_first);
        }
        newnode.nodeInsertionEnded();
    }

    @Override
    public boolean remove(EvictableServerEntry entry) {
        LRUInfo nodetodelete = (LRUInfo)entry.getEvictionPayLoad();
        if (!nodetodelete.setDataDeleted(this._unSafe)) {
            return false;
        }
        if (this.removeNode(nodetodelete)) {
            nodetodelete.setDataNull();
            return true;
        }
        if ((LRUInfo)entry.getEvictionPayLoad() != nodetodelete) {
            nodetodelete = (LRUInfo)entry.getEvictionPayLoad();
            this.removeNode(nodetodelete);
        }
        nodetodelete.setDataNull();
        return true;
    }

    private boolean removeNode(LRUInfo nodetodelete) {
        if (!this._unSafe) {
            // empty if block
        }
        if (!nodetodelete.setNodeRemoved(true)) {
            return false;
        }
        this.disconnect_node(nodetodelete);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean disconnect_node(LRUInfo nodetodrop) {
        if (nodetodrop.isDisconnected() || nodetodrop.getFwd() == this._head) {
            return true;
        }
        LRUInfo lRUInfo = nodetodrop;
        synchronized (lRUInfo) {
            if (nodetodrop.isDisconnected() || nodetodrop.getFwd() == this._head) {
                return true;
            }
            while (true) {
                LRUInfo prev = nodetodrop.getBwd();
                LRUInfo myfwd = nodetodrop.getFwd();
                LRUInfo lRUInfo2 = prev;
                synchronized (lRUInfo2) {
                    if (prev == nodetodrop.getBwd()) {
                        prev.setFwd(myfwd);
                        myfwd.setBwd(prev);
                        // MONITOREXIT @DISABLED, blocks:[2, 3, 4, 5] lbl16 : MonitorExitStatement: MONITOREXIT : var5_5
                        nodetodrop.setDisconnected();
                        return true;
                    }
                }
            }
        }
    }

    @Override
    public boolean touch(EvictableServerEntry entry) {
        LRUInfo lruInfo = (LRUInfo)entry.getEvictionPayLoad();
        if (lruInfo == null || !lruInfo.dataWasInserted()) {
            return true;
        }
        if (lruInfo.getFwd() == this._head && !lruInfo.isDataDeleted()) {
            return true;
        }
        boolean res = this.removeNode(lruInfo);
        if (res || !this._unSafe) {
            // empty if block
        }
        if (!res) {
            return false;
        }
        if (!this._unSafe) {
            // empty if block
        }
        if (lruInfo.isDataDeleted()) {
            return false;
        }
        LRUInfo newnode = new LRUInfo(lruInfo, this._head, null);
        this.insertNode(newnode);
        entry.setEvictionPayLoad(newnode);
        if (!this._unSafe) {
            // empty if block
        }
        return !newnode.isDataDeleted() || !this.removeNode(lruInfo = (LRUInfo)entry.getEvictionPayLoad());
    }

    @Override
    public boolean isEvictable(EvictableServerEntry entry) {
        LRUInfo lruInfo = (LRUInfo)entry.getEvictionPayLoad();
        return lruInfo.isDataEvictable();
    }

    private boolean isEmpty() {
        LRUInfo bk = this._head.getBwd();
        return bk == this._tail || bk.isDataDeleted() && bk.getBwd() == this._tail;
    }

    @Override
    public Iterator<EvictableServerEntry> evictionCandidates() {
        if (this.isEmpty()) {
            return null;
        }
        return new ChainIter(this);
    }

    public void monitor() {
        LRUInfo myf;
        LRUInfo myback;
        int itersf = 0;
        int itersb = 0;
        int nonbalancedf = 0;
        int nonbalancedb = 0;
        int deletedf = 0;
        int deletedb = 0;
        int deletedInsidef = 0;
        int deletedInsideb = 0;
        for (LRUInfo basef = this._tail; basef != null; basef = basef.getFwd()) {
            ++itersf;
            if (basef.isNodeRemoved()) {
                ++deletedf;
                continue;
            }
            if (basef != this._tail) {
                myback = basef.backRef;
                if (myback.isNodeRemoved() && basef != this._head) {
                    ++deletedInsidef;
                    continue;
                }
                if (myback.fwdRef != basef) {
                    ++nonbalancedf;
                    continue;
                }
            }
            if (basef == this._head) continue;
            myf = basef.fwdRef;
            if (myf.isNodeRemoved() && myf.getFwd() != this._head) {
                ++deletedInsidef;
                continue;
            }
            if (myf.backRef == basef) continue;
            ++nonbalancedf;
        }
        for (LRUInfo baseb = this._head; baseb != null; baseb = baseb.getBwd()) {
            ++itersb;
            if (baseb.isNodeRemoved()) {
                ++deletedb;
                continue;
            }
            if (baseb != this._tail) {
                myback = baseb.backRef;
                if (myback.isNodeRemoved() && baseb != this._head) {
                    ++deletedInsideb;
                    continue;
                }
                if (myback.fwdRef != baseb) {
                    ++nonbalancedb;
                    continue;
                }
            }
            if (baseb == this._head) continue;
            myf = baseb.fwdRef;
            if (myf.isNodeRemoved() && myf.getFwd() != this._head) {
                ++deletedInsidef;
                continue;
            }
            if (myf.backRef == baseb) continue;
            ++nonbalancedb;
        }
        System.out.println("Seg= " + this._segment + " itersf=" + itersf + " itersb=" + itersb + " nonbalancedf=" + nonbalancedf + " nonbalancedb=" + nonbalancedb + " deletedf=" + deletedf + " deletedb=" + deletedb + " deletedInsidef=" + deletedInsidef + " deletedInsideb=" + deletedInsideb);
    }

    static class LRUInfo {
        final short _segment;
        public static final int INSERTING = 0;
        public static final int INSERTED = 1;
        public static final int REMOVED = 2;
        volatile int _infoStatus = 0;
        private static final AtomicIntegerFieldUpdater<LRUInfo> infoStatusUpdater = UncheckedAtomicIntegerFieldUpdater.newUpdater(LRUInfo.class, "_infoStatus");
        private boolean _disconnected;
        private final Data lruData;
        private volatile LRUInfo fwdRef;
        private volatile LRUInfo backRef;
        private static final AtomicReferenceFieldUpdater<LRUInfo, LRUInfo> bwdUpdater = UncheckedAtomicReferenceFieldUpdater.newUpdater(LRUInfo.class, LRUInfo.class, "backRef");

        LRUInfo(short segment, EvictableServerEntry data, LRUInfo fwd, LRUInfo bwd) {
            this.lruData = new Data(data);
            if (fwd != null) {
                this.fwdRef = fwd;
            }
            if (bwd != null) {
                this.backRef = bwd;
            }
            this._segment = segment;
        }

        LRUInfo(LRUInfo other, LRUInfo fwd, LRUInfo bwd) {
            this.lruData = other.lruData;
            if (fwd != null) {
                this.fwdRef = fwd;
            }
            if (bwd != null) {
                this.backRef = bwd;
            }
            this._segment = other.getSegment();
        }

        public short getSegment() {
            return this._segment;
        }

        boolean casBwd(LRUInfo expect, LRUInfo update) {
            return bwdUpdater.compareAndSet(this, expect, update);
        }

        void setFwd(LRUInfo update) {
            this.fwdRef = update;
        }

        void setBwd(LRUInfo update) {
            this.backRef = update;
        }

        LRUInfo getFwd() {
            return this.fwdRef;
        }

        LRUInfo getBwd() {
            return this.backRef;
        }

        boolean setDataDeleted(boolean unsafe) {
            return this.lruData.setDeleted(unsafe);
        }

        boolean isDataDeleted() {
            return this.lruData.isDeleted();
        }

        boolean setNodeRemoved(boolean unsafe) {
            if (unsafe) {
                return infoStatusUpdater.compareAndSet(this, 1, 2);
            }
            this._infoStatus = 2;
            return true;
        }

        boolean isNodeRemoved() {
            return this._infoStatus == 2;
        }

        void setNodeUnremoved() {
            this._infoStatus = 0;
        }

        boolean isNodeInserted() {
            return this._infoStatus == 1;
        }

        boolean isNodeBeingInserted() {
            return this._infoStatus == 0;
        }

        int getDataStatus() {
            return this.lruData.getDataStatus();
        }

        boolean isDataEvictable() {
            return this.lruData.isValid();
        }

        void nodeInsertionEnded() {
            this._infoStatus = 1;
        }

        boolean isDisconnected() {
            return this._disconnected;
        }

        boolean setDisconnected() {
            this._disconnected = true;
            return true;
        }

        boolean isNodeRelevantForEviction() {
            return this._infoStatus == 1 && this.lruData.isValid();
        }

        boolean dataWasInserted() {
            return this.lruData.wasInserted();
        }

        void setDataWasInserted() {
            this.lruData.setWasInserted();
        }

        void setDataNull() {
            this.lruData.setDataNull();
        }

        private static class Data {
            public static final int VALID = 0;
            public static final int DELETED = 1;
            private volatile int _dataStatus = 0;
            private static final AtomicIntegerFieldUpdater<Data> dataStatusUpdater = UncheckedAtomicIntegerFieldUpdater.newUpdater(Data.class, "_dataStatus");
            private boolean _wasInserted;
            private EvictableServerEntry _data;

            Data(EvictableServerEntry data) {
                this._data = data;
            }

            boolean isValid() {
                return this._dataStatus == 0;
            }

            boolean setDeleted(boolean unsafe) {
                if (unsafe) {
                    return dataStatusUpdater.compareAndSet(this, 0, 1);
                }
                this._dataStatus = 1;
                return true;
            }

            boolean isDeleted() {
                return this._dataStatus == 1;
            }

            int getDataStatus() {
                return this._dataStatus;
            }

            void setDataNull() {
                this._data = null;
            }

            boolean wasInserted() {
                return this._wasInserted;
            }

            void setWasInserted() {
                this._wasInserted = true;
            }
        }
    }

    private static class ChainIter
    implements Iterator<EvictableServerEntry> {
        private LRUInfo _cur;
        LRUInfo _upto;
        private LRUInfo _next;
        private final ChainSegment _segment;

        ChainIter(ChainSegment segment) {
            this._cur = segment._tail;
            this._upto = segment._head.getBwd();
            this._segment = segment;
        }

        @Override
        public boolean hasNext() {
            if (this._upto == this._segment._tail) {
                return false;
            }
            LRUInfo nextnd = this._cur.getFwd();
            while (true) {
                if (nextnd == null || nextnd == this._segment._head) {
                    this._next = null;
                    return false;
                }
                if (nextnd != this._segment._tail && nextnd.isNodeRelevantForEviction()) {
                    this._next = nextnd;
                    return true;
                }
                if (nextnd == this._upto) {
                    return false;
                }
                nextnd = nextnd.getFwd();
            }
        }

        @Override
        public EvictableServerEntry next() {
            if (this._next == null && !this.hasNext()) {
                return null;
            }
            this._cur = this._next;
            this._next = null;
            return this._cur.lruData._data;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

