/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.eviction;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.eviction.ChainSegment;
import com.gigaspaces.internal.server.space.eviction.IEvictionChain;
import com.gigaspaces.server.eviction.EvictableServerEntry;
import com.j_spaces.kernel.SystemProperties;
import java.util.Iterator;

@InternalApi
public class ChainsSegments
implements IEvictionChain {
    private final ChainSegment[] _segments;
    private int _addCounter = 0;
    private int _scanCounter = 0;

    public ChainsSegments() {
        this(false, 100);
    }

    public ChainsSegments(boolean unsafe, int evictionThreshold) {
        this(unsafe, evictionThreshold, Integer.getInteger("com.gs.engine.lruSegments", 0));
    }

    public ChainsSegments(boolean unsafe, int evictionThreshold, int numOfSegments) {
        if (numOfSegments == 0) {
            numOfSegments = SystemProperties.ENGINE_LRU_SEGMENTS_DEFAULT;
        }
        this._segments = new ChainSegment[numOfSegments];
        for (int i = 0; i < numOfSegments; ++i) {
            this._segments[i] = new ChainSegment(unsafe, i);
        }
    }

    private int getNumSegments() {
        return this._segments.length;
    }

    ChainSegment getSegment(int num) {
        return this._segments[num];
    }

    @Override
    public void insert(EvictableServerEntry entry) {
        int seg = this.drawSegmentNumber(true);
        this._segments[seg].insert(entry);
    }

    private int drawSegmentNumber(boolean add) {
        int tnum = (int)Thread.currentThread().getId();
        if (tnum % this.getNumSegments() == 0) {
            ++tnum;
        }
        return add ? Math.abs(tnum * this._addCounter++ % this.getNumSegments()) : Math.abs(tnum * this._scanCounter++ % this.getNumSegments());
    }

    @Override
    public boolean remove(EvictableServerEntry entry) {
        return this.getSegment(entry).remove(entry);
    }

    @Override
    public boolean touch(EvictableServerEntry entry) {
        ChainSegment.LRUInfo node = (ChainSegment.LRUInfo)entry.getEvictionPayLoad();
        if (node == null || !node.isNodeInserted()) {
            return false;
        }
        return this._segments[node.getSegment()].touch(entry);
    }

    @Override
    public boolean isEvictable(EvictableServerEntry entry) {
        return this.getSegment(entry).isEvictable(entry);
    }

    private ChainSegment getSegment(EvictableServerEntry entry) {
        ChainSegment.LRUInfo node = (ChainSegment.LRUInfo)entry.getEvictionPayLoad();
        return this._segments[node.getSegment()];
    }

    @Override
    public Iterator<EvictableServerEntry> evictionCandidates() {
        return new ChainIter(this);
    }

    public void monitor() {
        for (int i = 0; i < this._segments.length; ++i) {
            this._segments[i].monitor();
        }
    }

    private static class ChainIter
    implements Iterator<EvictableServerEntry> {
        private static final int UNITITIALIZED = -1;
        private static final int TERMINATED = -2;
        int _next = -1;
        private final ChainsSegments _segments;
        private final Iterator<EvictableServerEntry>[] _iters;

        ChainIter(ChainsSegments segments) {
            this._segments = segments;
            this._iters = new Iterator[this._segments.getNumSegments()];
        }

        @Override
        public boolean hasNext() {
            if (this._next == -2) {
                return false;
            }
            this._next = this._next == -1 ? this._segments.drawSegmentNumber(false) : ++this._next;
            int tries = 0;
            while (true) {
                if (this._next == this._segments.getNumSegments()) {
                    this._next = 0;
                }
                if (this._iters[this._next] == null) {
                    this._iters[this._next] = this._segments.getSegment(this._next).evictionCandidates();
                    if (this._iters[this._next] == null) {
                        this._iters[this._next] = this;
                    }
                }
                if (this._iters[this._next] != this) {
                    if (this._iters[this._next].hasNext()) {
                        return true;
                    }
                    this._iters[this._next] = this;
                }
                if (++tries >= this._segments.getNumSegments()) {
                    this._next = -2;
                    return false;
                }
                ++this._next;
            }
        }

        @Override
        public EvictableServerEntry next() {
            if (this._next == -2 || this._next == -1) {
                throw new RuntimeException("successful hasnext() should be called");
            }
            return this._iters[this._next].next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

