/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.eviction;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.eviction.ChainsSegments;
import com.gigaspaces.internal.server.space.eviction.IEvictionChain;
import com.gigaspaces.server.eviction.EvictableServerEntry;
import com.gigaspaces.server.eviction.SpaceEvictionStrategy;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ConcurrentLruSpaceEvictionStrategy
extends SpaceEvictionStrategy {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");
    private static final int TOUCH_UNSAFE_MARGIN = 500;
    private static final int MIN_TOUCH_THRESHOLD = 0;
    private static final int MAX_TOUCH_THRESHOLD = 100;
    private final int _touchThreshold;
    private final IEvictionChain _chain;
    private final AtomicInteger _estimatedNumCachedEntries;
    private int _estimatedNumCachedEntriesUnsafe;
    private int _touchLimit;

    public ConcurrentLruSpaceEvictionStrategy(int touchThreshold, int maxCacheSize) {
        if (touchThreshold > 100 || touchThreshold < 0) {
            throw new IllegalArgumentException("Illegal LRU touch threshold " + touchThreshold + " - must be between " + 0 + " and " + 100 + " (inclusive).");
        }
        this._touchThreshold = touchThreshold;
        if (this._touchThreshold > 0) {
            this._touchLimit = maxCacheSize == Integer.MAX_VALUE ? Integer.MAX_VALUE : maxCacheSize * this._touchThreshold / 100;
        }
        this._chain = new ChainsSegments(false, touchThreshold);
        this._estimatedNumCachedEntries = new AtomicInteger();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.getClass().getSimpleName() + " started: [max-cache-size= " + maxCacheSize + ", touch-threshold= " + this._touchThreshold + ", touch-limit=" + this._touchLimit + "]");
        }
    }

    @Override
    public boolean requiresConcurrencyProtection() {
        return false;
    }

    @Override
    public void onInsert(EvictableServerEntry entry) {
        this.introduce(entry);
    }

    @Override
    public void onLoad(EvictableServerEntry entry) {
        this.introduce(entry);
    }

    @Override
    public void onRead(EvictableServerEntry entry) {
        this.touch(entry);
    }

    @Override
    public void onUpdate(EvictableServerEntry entry) {
        this.touch(entry);
    }

    @Override
    public void onRemove(EvictableServerEntry entry) {
        if (!this._chain.remove(entry)) {
            throw new IllegalStateException("The removed entry is not registered in the eviction strategy - [type=" + entry.getSpaceTypeDescriptor().getTypeName() + ", uid=" + entry.getUID() + "]");
        }
        this._estimatedNumCachedEntriesUnsafe = this._estimatedNumCachedEntries.decrementAndGet();
    }

    @Override
    public int evict(int numOfEntries) {
        int newMax;
        int newLimit;
        int curSize = this._estimatedNumCachedEntries.get();
        int numToEvict = Math.min(numOfEntries, curSize);
        if (this._touchThreshold != 100 && this._touchThreshold != 0 && this._touchLimit > (newLimit = (newMax = curSize - numToEvict) * this._touchThreshold / 100)) {
            this._touchLimit = newLimit;
        }
        return numToEvict > 0 ? this.evictEntriesFromCache(numToEvict) : 0;
    }

    private void introduce(EvictableServerEntry entry) {
        this._estimatedNumCachedEntriesUnsafe = this._estimatedNumCachedEntries.incrementAndGet();
        this._chain.insert(entry);
    }

    private void touch(EvictableServerEntry entry) {
        if (this._touchThreshold == 100) {
            return;
        }
        if (this._touchThreshold != 0) {
            if (this._touchLimit - this._estimatedNumCachedEntriesUnsafe >= 500) {
                return;
            }
            int curSize = this._estimatedNumCachedEntries.get();
            if (curSize < this._touchLimit) {
                return;
            }
        }
        this._chain.touch(entry);
    }

    private int evictEntriesFromCache(int numToEvict) {
        int evicted = 0;
        Iterator<EvictableServerEntry> iter = this._chain.evictionCandidates();
        while (iter.hasNext()) {
            if (this.isClosed()) {
                return evicted;
            }
            EvictableServerEntry entry = iter.next();
            if (entry == null || !this._chain.isEvictable(entry)) continue;
            if (this.getEvictionManager().tryEvict(entry)) {
                ++evicted;
            }
            if (evicted != numToEvict) continue;
            break;
        }
        return evicted;
    }
}

