/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.eviction;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.server.space.eviction.IEvictionReplicationsMarkersRepository;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class EvictionReplicationsMarkersRepository
implements IEvictionReplicationsMarkersRepository {
    public static final int NUM_OF_IMARKERS_REPOSITORY_SEGMENTS = 2000;
    private final EvictionReplicationsMarkersSegment[] _segments = new EvictionReplicationsMarkersSegment[2000];
    private final AtomicInteger _size;

    public EvictionReplicationsMarkersRepository() {
        for (int i = 0; i < 2000; ++i) {
            this._segments[i] = new EvictionReplicationsMarkersSegment();
        }
        this._size = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(String uid, IMarker marker, boolean alreadyLocked) {
        boolean newUid;
        block8: {
            if (!alreadyLocked) {
                Object lockObject = this.getLockObject(uid);
                try {
                    Object object = lockObject;
                    synchronized (object) {
                        newUid = this.insert(uid, marker);
                        break block8;
                    }
                }
                finally {
                    this.releaseLockObject(lockObject);
                }
            }
            newUid = this.insert(uid, marker);
        }
        if (newUid) {
            this._size.incrementAndGet();
        }
    }

    private boolean insert(String uid, IMarker marker) {
        return this._segments[EvictionReplicationsMarkersRepository.getSegment(uid)].getUidsMap().put(uid, marker) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEntryEvictable(String uid, boolean alreadyLocked) {
        if (!alreadyLocked) {
            Object lockObject = this.getLockObject(uid);
            try {
                Object object = lockObject;
                synchronized (object) {
                    boolean bl = this.isEntryEvictable(uid);
                    return bl;
                }
            }
            finally {
                this.releaseLockObject(lockObject);
            }
        }
        return this.isEntryEvictable(uid);
    }

    private boolean isEntryEvictable(String uid) {
        IMarker marker = this.getMarkerUnsafe(uid);
        return marker == null || marker.isMarkerReached();
    }

    private IMarker getMarkerUnsafe(String uid) {
        return this._segments[EvictionReplicationsMarkersRepository.getSegment(uid)].getUidsMap().get(uid);
    }

    @Override
    public Object getLockObject(String uid) {
        return this._segments[EvictionReplicationsMarkersRepository.getSegment(uid)].getLockObject();
    }

    @Override
    public void releaseLockObject(Object lockObject) {
    }

    @Override
    public int reapUnused() {
        int res = 0;
        for (EvictionReplicationsMarkersSegment segment : this._segments) {
            if (this.size() == 0) {
                return res;
            }
            res += this.reapUnused(segment);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reapUnused(EvictionReplicationsMarkersSegment segment) {
        int res = 0;
        try {
            Object object = segment.getLockObject();
            synchronized (object) {
                block9: {
                    if (!segment.getUidsMap().isEmpty()) break block9;
                    int n = 0;
                    return n;
                }
                Iterator<IMarker> iter = segment.getUidsMap().values().iterator();
                while (iter.hasNext()) {
                    IMarker marker = iter.next();
                    if (!marker.isMarkerReached()) continue;
                    iter.remove();
                    this._size.decrementAndGet();
                    ++res;
                }
            }
        }
        finally {
            this.releaseLockObject(segment.getLockObject());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMarker getMarker(String uid) {
        Object lockObject = this.getLockObject(uid);
        try {
            Object object = lockObject;
            synchronized (object) {
                IMarker iMarker = this.getMarkerUnsafe(uid);
                return iMarker;
            }
        }
        finally {
            this.releaseLockObject(lockObject);
        }
    }

    @Override
    public int size() {
        return this._size.get();
    }

    private static int getSegment(String uid) {
        return Math.abs(uid.hashCode() % 2000);
    }

    public static final class EvictionReplicationsMarkersSegment {
        private final HashMap<String, IMarker> _uidsMap = new HashMap();
        private final Object _lockObject = new Object();

        EvictionReplicationsMarkersSegment() {
        }

        Object getLockObject() {
            return this._lockObject;
        }

        Map<String, IMarker> getUidsMap() {
            return this._uidsMap;
        }
    }
}

