/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.eviction;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.time.SystemTime;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class RecentDeletesRepository {
    private final ConcurrentHashMap<String, RecentDeleteInfo> _recentDeletes = new ConcurrentHashMap();

    public void insertToRecentDeletes(IEntryHolder entry, long duration, ServerTransaction xtn) {
        this._recentDeletes.put(entry.getUID(), new RecentDeleteInfo(entry.getUID(), duration > 0L ? duration : SystemTime.timeMillis(), xtn));
    }

    public boolean removeFromRecentDeletes(IEntryHolder entry) {
        return this._recentDeletes.remove(entry.getUID()) != null;
    }

    public RecentDeleteInfo getRecentDeleteInfo(String uid) {
        return this._recentDeletes.get(uid);
    }

    public Iterator<RecentDeleteInfo> getRecentDeletesIterator() {
        return this._recentDeletes.values().iterator();
    }

    public int size() {
        return this._recentDeletes.size();
    }

    public static final class RecentDeleteInfo {
        private final String _uid;
        private final Long _timeBase;
        private final ServerTransaction _xtn;

        public RecentDeleteInfo(String uid, long timeBase, ServerTransaction xtn) {
            this._uid = uid;
            this._timeBase = timeBase;
            this._xtn = xtn;
        }

        public String getUid() {
            return this._uid;
        }

        public long getTimeBase() {
            return this._timeBase;
        }

        public ServerTransaction getXtn() {
            return this._xtn;
        }
    }
}

