/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.eviction;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.time.SystemTime;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class RecentUpdatesRepository {
    private final ConcurrentHashMap<String, RecentUpdateInfo> _recentUpdates = new ConcurrentHashMap();

    public void insertToRecentUpdates(IEntryHolder entry, long duration, ServerTransaction xtn) {
        this._recentUpdates.put(entry.getUID(), new RecentUpdateInfo(entry.getUID(), duration > 0L ? duration : SystemTime.timeMillis(), xtn));
    }

    public boolean removeFromRecentUpdates(IEntryHolder entry) {
        return this._recentUpdates.remove(entry.getUID()) != null;
    }

    public RecentUpdateInfo getRecentUpdateInfo(String uid) {
        return this._recentUpdates.get(uid);
    }

    public Iterator<RecentUpdateInfo> getRecentUpdatesIterator() {
        return this._recentUpdates.values().iterator();
    }

    public int size() {
        return this._recentUpdates.size();
    }

    public static final class RecentUpdateInfo {
        private final String _uid;
        private final Long _timeBase;
        private final ServerTransaction _xtn;

        public RecentUpdateInfo(String uid, long timeBase, ServerTransaction xtn) {
            this._uid = uid;
            this._timeBase = timeBase;
            this._xtn = xtn;
        }

        public String getUid() {
            return this._uid;
        }

        public long getTimeBase() {
            return this._timeBase;
        }

        public ServerTransaction getXtn() {
            return this._xtn;
        }
    }
}

