/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.eviction;

import com.gigaspaces.internal.backport.java.util.concurrent.FastConcurrentSkipListMap;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.server.eviction.EvictableServerEntry;
import com.gigaspaces.server.eviction.SpaceEvictionManager;
import com.gigaspaces.server.eviction.SpaceEvictionStrategy;
import com.gigaspaces.server.eviction.SpaceEvictionStrategyConfig;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import com.j_spaces.kernel.StoredListFactory;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TimeBasedSpaceEvictionStrategy
extends SpaceEvictionStrategy {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");
    private static final long TIMEBASED_EVICTION_MIN_FORCE_EXPIRATION_INTERVAL = 500L;
    private static final long SHORT_LIVED_ENTRY_INTERVAL_LIMIT = 1L;
    private static final long CELLS_GRANULARITY_INTERVAL = 10000L;
    private final long _inCacheTimeInterval;
    private final long _inCacheReinsertedTimeInterval;
    private final long _harvestMainInterval;
    private final long _harvestShortLivedInterval;
    private final FastConcurrentSkipListMap<Long, Cell> _expirationList;
    private final IStoredList<EvictableServerEntry> _shortLived;
    private TimeBasedEvictionReaper _reaper;

    public TimeBasedSpaceEvictionStrategy(long inCacheTimeInterval, long inCacheReinsertedTimeInterval, long harvestMainInterval, long harvestShortLivedInterval) {
        this._inCacheTimeInterval = inCacheTimeInterval;
        this._inCacheReinsertedTimeInterval = Math.max(inCacheReinsertedTimeInterval, 1L);
        this._harvestMainInterval = harvestMainInterval;
        this._harvestShortLivedInterval = harvestShortLivedInterval;
        this._expirationList = new FastConcurrentSkipListMap();
        this._shortLived = StoredListFactory.createConcurrentList(true);
    }

    @Override
    public void initialize(SpaceEvictionManager evictionManager, SpaceEvictionStrategyConfig config) {
        super.initialize(evictionManager, config);
        String spaceName = ((CacheManager)evictionManager).getEngine().getSpaceName();
        this._reaper = new TimeBasedEvictionReaper("TimeBasedEvictionReaper_" + spaceName);
        this._reaper.start();
    }

    @Override
    public void close() {
        super.close();
        this._reaper.clean();
    }

    @Override
    public void onInsert(EvictableServerEntry entry) {
        this.introduce(entry, true);
    }

    @Override
    public void onLoad(EvictableServerEntry entry) {
        this.introduce(entry, false);
    }

    @Override
    public void onRemove(EvictableServerEntry entry) {
        this.remove(entry, false);
    }

    @Override
    public int evict(int numOfEntries) {
        try {
            return this.forceReaperCycle();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void introduce(EvictableServerEntry entry, boolean newEntry) {
        block5: {
            Object payload;
            long interval = newEntry ? this._inCacheTimeInterval : this._inCacheReinsertedTimeInterval;
            long expiration = 0L;
            expiration = interval + SystemTime.timeMillis();
            long expirationCellTime = this.generateListExpirationUponInsertion(interval, expiration);
            if (interval <= 1L) {
                TimeBasedEvictionPayload payLoad = new TimeBasedEvictionPayload(this._shortLived.add(entry), expiration, true);
                entry.setEvictionPayLoad(payLoad);
                return;
            }
            Cell curCell = this._expirationList.get(expirationCellTime);
            Cell newCell = null;
            while (true) {
                if (curCell != null) {
                    payload = curCell.add(entry, expiration);
                    if (payload != null) {
                        entry.setEvictionPayLoad(payload);
                        break block5;
                    }
                    this._expirationList.remove(expirationCellTime, curCell);
                    curCell = null;
                }
                if (newCell == null) {
                    newCell = new Cell(expirationCellTime);
                }
                if ((curCell = this._expirationList.putIfAbsent(expirationCellTime, newCell)) != null) continue;
                payload = newCell.add(entry, expiration);
                if (payload != null) break;
                this._expirationList.remove(expirationCellTime, newCell);
                newCell = null;
            }
            entry.setEvictionPayLoad(payload);
        }
    }

    private long generateListExpirationUponInsertion(long interval, long expiration) {
        return interval == 0L ? expiration : this.generateListExpiration(expiration);
    }

    private long generateListExpiration(long expiration) {
        return (expiration / 10000L + 1L) * 10000L;
    }

    private void remove(EvictableServerEntry entry, boolean fromReaperThread) {
        TimeBasedEvictionPayload payLoad = (TimeBasedEvictionPayload)entry.getEvictionPayLoad();
        if (payLoad == null) {
            if (fromReaperThread) {
                return;
            }
            throw new IllegalStateException("Payload is null while remove called");
        }
        if (!payLoad.isShortLived()) {
            long expirationTime = this.generateListExpiration(payLoad.getExpirationTime());
            Cell curCell = this._expirationList.get(expirationTime);
            curCell.remove(entry);
            if (curCell.setCleanedIfEmpty()) {
                this._expirationList.remove(expirationTime, curCell);
            }
        } else {
            this._shortLived.remove(payLoad._backref);
        }
    }

    private int forceReaperCycle() throws InterruptedException {
        long currentCycle = this._reaper.getCurrentCycle();
        if (this._reaper.forceCycle()) {
            return this._reaper.waitForCycleCompletion(currentCycle);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reapExpiredEntries(boolean forced, boolean reapMainList) {
        long currentTime;
        int evicted = 0;
        IStoredListIterator slh = null;
        try {
            if (!this._shortLived.isEmpty()) {
                currentTime = SystemTime.timeMillis();
                slh = this._shortLived.establishListScan(false);
                while (slh != null) {
                    if (this._reaper.shouldDie()) {
                        int n = evicted;
                        return n;
                    }
                    EvictableServerEntry entry = (EvictableServerEntry)slh.getSubject();
                    if (entry != null && entry.getEvictionPayLoad() != null && ((TimeBasedEvictionPayload)entry.getEvictionPayLoad())._expirationTime <= currentTime && this.getEvictionManager().tryEvict(entry)) {
                        ++evicted;
                    }
                    slh = this._shortLived.next(slh);
                }
            }
        }
        finally {
            if (slh != null) {
                slh.release();
            }
        }
        if (!forced && !reapMainList) {
            return evicted;
        }
        Iterator<Cell> iter = this._expirationList.values().iterator();
        while (iter.hasNext()) {
            currentTime = SystemTime.timeMillis();
            Cell cell = iter.next();
            long expirationTime = cell.getCellKey();
            if (expirationTime > currentTime && currentTime < expirationTime - 10001L) break;
            if (cell._entriesExpired.isEmpty()) continue;
            try {
                slh = cell._entriesExpired.establishListScan(false);
                while (slh != null) {
                    if (this._reaper.shouldDie()) {
                        int n = evicted;
                        return n;
                    }
                    EvictableServerEntry entry = (EvictableServerEntry)slh.getSubject();
                    if (entry != null && entry.getEvictionPayLoad() != null && ((TimeBasedEvictionPayload)entry.getEvictionPayLoad())._expirationTime <= currentTime && this.getEvictionManager().tryEvict(entry)) {
                        ++evicted;
                    }
                    slh = cell._entriesExpired.next(slh);
                }
            }
            finally {
                if (slh == null) continue;
                slh.release();
            }
        }
        return evicted;
    }

    private final class TimeBasedEvictionReaper
    extends GSThread {
        private boolean _shouldDie;
        private long _nextExpirationTimeInterval;
        private long _nextExpirationMainListTimeInterval;
        private final Object _cycleLock;
        private long _cycleCount;
        private long _lastCycleEnded;
        private boolean _force;
        private int _evicted;

        public TimeBasedEvictionReaper(String threadName) {
            super(threadName);
            this._nextExpirationMainListTimeInterval = this._nextExpirationTimeInterval = SystemTime.timeMillis();
            this._cycleLock = new Object();
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (!this.isInterrupted()) {
                    try {
                        boolean reapMainList = this.fallAsleep();
                        if (this._shouldDie) {
                            break;
                        }
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest(this.getName() + " - woke up for reaping.");
                        }
                        this._evicted = TimeBasedSpaceEvictionStrategy.this.reapExpiredEntries(this._force, reapMainList);
                        this.signalEndCycle();
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.SEVERE)) continue;
                        _logger.log(Level.SEVERE, this.getName() + " - caught Exception", e);
                    }
                }
            }
            finally {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(this.getName() + " terminated.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean fallAsleep() {
            TimeBasedEvictionReaper timeBasedEvictionReaper = this;
            synchronized (timeBasedEvictionReaper) {
                try {
                    if (!this._shouldDie) {
                        this._nextExpirationTimeInterval += TimeBasedSpaceEvictionStrategy.this._harvestShortLivedInterval;
                        long fixedRateDelay = this._nextExpirationTimeInterval - SystemTime.timeMillis();
                        if (fixedRateDelay <= 0L) {
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.finest("Skipped fallAsleep since fixedRateDelay=" + fixedRateDelay);
                            }
                            this._nextExpirationTimeInterval = SystemTime.timeMillis();
                            return this.shouldProcessMainList();
                        }
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("fallAsleep - going to wait fixedRateDelay=" + fixedRateDelay);
                        }
                        ((Object)((Object)this)).wait(fixedRateDelay);
                        if (this._force) {
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.finest("TimeBased Eviction reaper was forcibly waken up");
                            }
                            this._nextExpirationTimeInterval = SystemTime.timeMillis();
                        }
                        return this.shouldProcessMainList();
                    }
                }
                catch (InterruptedException ie) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, this.getName() + " interrupted.", ie);
                    }
                    this._shouldDie = true;
                    this.interrupt();
                }
                return this.shouldProcessMainList();
            }
        }

        private boolean shouldProcessMainList() {
            if (this._nextExpirationMainListTimeInterval <= SystemTime.timeMillis()) {
                this._nextExpirationMainListTimeInterval += TimeBasedSpaceEvictionStrategy.this._harvestMainInterval;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void clean() {
            if (!this.isAlive()) {
                return;
            }
            TimeBasedEvictionReaper timeBasedEvictionReaper = this;
            synchronized (timeBasedEvictionReaper) {
                this._shouldDie = true;
                ((Object)((Object)this)).notify();
            }
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (TimeBasedSpaceEvictionStrategy.this._expirationList != null) {
                TimeBasedSpaceEvictionStrategy.this._expirationList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean forceCycle() {
            Object object = this._cycleLock;
            synchronized (object) {
                if (SystemTime.timeMillis() - this._lastCycleEnded < 500L) {
                    return false;
                }
                this._force = true;
            }
            object = this;
            synchronized (object) {
                ((Object)((Object)this)).notify();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int waitForCycleCompletion(long currentCycle) throws InterruptedException {
            Object object = this._cycleLock;
            synchronized (object) {
                while (this._cycleCount == currentCycle && !this._shouldDie) {
                    this._cycleLock.wait();
                }
                return this._evicted;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalEndCycle() {
            Object object = this._cycleLock;
            synchronized (object) {
                this._force = false;
                ++this._cycleCount;
                this._lastCycleEnded = SystemTime.timeMillis();
                this._cycleLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getCurrentCycle() {
            Object object = this._cycleLock;
            synchronized (object) {
                return this._cycleCount;
            }
        }

        private boolean shouldDie() {
            return this._shouldDie;
        }
    }

    public static class TimeBasedEvictionPayload {
        private final IObjectInfo<EvictableServerEntry> _backref;
        private final long _expirationTime;
        private final boolean _shortLived;

        public TimeBasedEvictionPayload(IObjectInfo<EvictableServerEntry> backref, long expirationTime, boolean shortLived) {
            this._backref = backref;
            this._expirationTime = expirationTime;
            this._shortLived = shortLived;
        }

        private long getExpirationTime() {
            return this._expirationTime;
        }

        private boolean isShortLived() {
            return this._shortLived;
        }
    }

    private static class Cell {
        private final Long _expirationTime;
        private final IStoredList<EvictableServerEntry> _entriesExpired;

        private Cell(long expirationTime) {
            this._expirationTime = expirationTime;
            this._entriesExpired = StoredListFactory.createConcurrentList(true);
        }

        private Long getCellKey() {
            return this._expirationTime;
        }

        private boolean isEmpty() {
            return this._entriesExpired.isEmpty();
        }

        private Object add(EvictableServerEntry entry, long expiration) {
            IObjectInfo<EvictableServerEntry> backref = this._entriesExpired.add(entry);
            return backref != null ? new TimeBasedEvictionPayload(backref, expiration, false) : null;
        }

        private void remove(EvictableServerEntry entry) {
            TimeBasedEvictionPayload payload = (TimeBasedEvictionPayload)entry.getEvictionPayLoad();
            this._entriesExpired.remove(payload._backref);
        }

        private boolean setCleanedIfEmpty() {
            return this.isEmpty() && this._entriesExpired.invalidate();
        }
    }
}

