/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.executors;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.executors.SpaceActionExecutor;
import com.gigaspaces.internal.space.requests.AddTypeIndexesRequestInfo;
import com.gigaspaces.internal.space.requests.SpaceRequestInfo;
import com.gigaspaces.internal.space.responses.AddTypeIndexesResponseInfo;
import com.gigaspaces.internal.space.responses.SpaceResponseInfo;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.security.authorities.SpaceAuthority;

@InternalApi
public class SpaceAddTypeIndexesExecutor
extends SpaceActionExecutor {
    @Override
    public SpaceResponseInfo execute(SpaceImpl space, SpaceRequestInfo spaceRequestInfo) {
        AddTypeIndexesRequestInfo requestInfo = (AddTypeIndexesRequestInfo)spaceRequestInfo;
        AddTypeIndexesResponseInfo responseInfo = new AddTypeIndexesResponseInfo();
        try {
            ITypeDesc[] result = space.getEngine().getTypeManager().addIndexes(requestInfo.getTypeName(), requestInfo.getIndexes());
            responseInfo.setUpdatedTypeDescriptors(result);
            IReplicationOutContext context = space.getEngine().getReplicationNode().createContext();
            if (requestInfo.isFromGateway()) {
                ((ReplicationOutContext)context).setFromGateway(true);
            }
            space.getEngine().getCacheManager().getStorageAdapter().addIndexes(requestInfo.getTypeName(), requestInfo.getIndexes());
            space.getEngine().getReplicationNode().outDataTypeAddIndex(context, requestInfo);
            space.getEngine().getReplicationNode().execute(context);
            context.release();
        }
        catch (SpaceMetadataException e) {
            responseInfo.setMetadataException(e);
        }
        return responseInfo;
    }

    @Override
    public SpaceAuthority.SpacePrivilege getPrivilege() {
        return SpaceAuthority.SpacePrivilege.ALTER;
    }
}

