/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.executors;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationNodeAdmin;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogMemberLimitationConfig;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.notification.NotificationDynamicSourceGroupMemberLifeCycle;
import com.gigaspaces.internal.cluster.node.impl.notification.NotificationReplicationChannelDataFilter;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.executors.SpaceActionExecutor;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.server.storage.TemplateHolderFactory;
import com.gigaspaces.internal.space.requests.RegisterReplicationNotificationRequestInfo;
import com.gigaspaces.internal.space.requests.SpaceRequestInfo;
import com.gigaspaces.internal.space.responses.RegisterReplicationNotificationResponseInfo;
import com.gigaspaces.internal.space.responses.SpaceResponseInfo;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.filters.FilterManager;
import com.j_spaces.core.filters.ReplicationStatistics;
import net.jini.core.entry.UnusableEntryException;

@InternalApi
public class SpaceRegisterReplicationNotificationExecutor
extends SpaceActionExecutor {
    @Override
    public SpaceResponseInfo execute(SpaceImpl space, SpaceRequestInfo spaceRequestInfo) {
        IServerTypeDesc typeDesc;
        RegisterReplicationNotificationRequestInfo requestInfo = (RegisterReplicationNotificationRequestInfo)spaceRequestInfo;
        RegisterReplicationNotificationResponseInfo responseInfo = new RegisterReplicationNotificationResponseInfo();
        IReplicationNodeAdmin replicationNodeAdmin = space.getEngine().getReplicationNode().getAdmin();
        replicationNodeAdmin.getRouterAdmin().addRemoteRouterStub(requestInfo.viewStub);
        String groupName = space.getEngine().generateGroupName();
        DynamicSourceGroupConfigHolder groupConfig = replicationNodeAdmin.getSourceGroupConfigHolder(groupName);
        SpaceContext spaceContext = spaceRequestInfo.getSpaceContext();
        try {
            typeDesc = space.getEngine().getTypeManager().loadServerTypeDesc(requestInfo.template);
            space.assertAuthorizedForType(typeDesc.getTypeName(), SpaceAuthority.SpacePrivilege.READ, spaceContext);
        }
        catch (UnusableEntryException e) {
            responseInfo.exception = e;
            return responseInfo;
        }
        catch (UnknownTypeException e) {
            responseInfo.exception = e;
            return responseInfo;
        }
        catch (SecurityException e) {
            responseInfo.exception = e;
            return responseInfo;
        }
        FilterManager filterManager = space.getEngine().getFilterManager();
        NotifyTemplateHolder tHolder = TemplateHolderFactory.createNotifyTemplateHolder(typeDesc, requestInfo.template, requestInfo.template.getUID(), LeaseManager.toAbsoluteTime(Long.MAX_VALUE), requestInfo.eventId, requestInfo.notifyInfo, false);
        String uniqueName = requestInfo.viewStub.getMyEndpointDetails().getLookupName();
        groupConfig.removeMember(uniqueName);
        NotificationReplicationChannelDataFilter notificationFilter = new NotificationReplicationChannelDataFilter(space.getEngine().getCacheManager(), groupName, space.getEngine().getTemplateScanner().getRegexCache(), space.getEngine().getTypeManager(), filterManager, tHolder);
        NotificationDynamicSourceGroupMemberLifeCycle notificationsLifeCycle = new NotificationDynamicSourceGroupMemberLifeCycle(space, filterManager, spaceContext);
        BacklogMemberLimitationConfig memberBacklogLimitations = new BacklogMemberLimitationConfig();
        long limit = space.getClusterPolicy().getReplicationPolicy().getDurableNotificationMaxRedologCapacity();
        memberBacklogLimitations.setLimit(limit, BacklogConfig.LimitReachedPolicy.DROP_MEMBER);
        long notificationMaxDisconnectionTime = space.getClusterPolicy().getReplicationPolicy().getDurableNotificationMaxDisconnectionTime();
        AsyncChannelConfig config = new AsyncChannelConfig(requestInfo.notifyInfo.getBatchSize(), requestInfo.notifyInfo.getBatchTime(), requestInfo.notifyInfo.getBatchPendingThreshold(), ReplicationStatistics.ReplicationMode.DURABLE_NOTIFICATION, notificationMaxDisconnectionTime);
        groupConfig.addMember(uniqueName, notificationFilter, memberBacklogLimitations, config, notificationsLifeCycle);
        responseInfo.spaceUID = space.getSpaceUuid();
        return responseInfo;
    }
}

