/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.EntryIntrospector;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.metadata.InactiveTypeDesc;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class ServerTypeDesc
implements IServerTypeDesc {
    private static final AtomicInteger _codesGen = new AtomicInteger(-1);
    private static final ConcurrentMap<Short, IServerTypeDesc> _codesRepo = new ConcurrentHashMap<Short, IServerTypeDesc>();
    private final int _typeId;
    private final String _typeName;
    private final boolean _isRootType;
    private final IServerTypeDesc[] _superTypes;
    private final short _serverTypeDescCode;
    private ITypeDesc _typeDesc;
    private boolean _inactive;
    private IServerTypeDesc[] _subTypes;
    private IServerTypeDesc[] _assignableTypes;
    private volatile boolean _maybeOutdated;

    public ServerTypeDesc(int typeId, String typeName) {
        this(typeId, typeName, null, null);
    }

    public ServerTypeDesc(int typeId, String typeName, ITypeDesc typeDesc, IServerTypeDesc superType) {
        this(typeId, typeName, typeDesc, superType, null);
    }

    private ServerTypeDesc(int typeId, String typeName, ITypeDesc typeDesc, IServerTypeDesc superType, Short code) {
        this._typeId = typeId;
        this._typeName = typeName;
        this._isRootType = typeName.equals(ROOT_TYPE_NAME);
        this._superTypes = this.initSuperTypes(superType);
        if (typeDesc == null) {
            typeDesc = ServerTypeDesc.createInactiveTypeDesc(typeName, this._superTypes);
        }
        this.setTypeDesc(typeDesc);
        this._subTypes = new ServerTypeDesc[0];
        this._assignableTypes = new ServerTypeDesc[]{this};
        if (superType != null) {
            superType.addSubType(this);
        }
        if (code == null) {
            Integer c = _codesGen.incrementAndGet();
            if (c > Short.MAX_VALUE) {
                throw new IllegalStateException("type map key has reached Short.MAX_VALUE, cannot create more ServerTypeDec instances");
            }
            code = c.shortValue();
            _codesRepo.put(code, this);
        }
        this._serverTypeDescCode = code;
    }

    public static IServerTypeDesc getByServerTypeDescCode(short code) {
        return (IServerTypeDesc)_codesRepo.get(code);
    }

    public String toString() {
        return "ServerTypeDesc(" + this._typeId + ", " + this._typeName + ")";
    }

    @Override
    public int getTypeId() {
        return this._typeId;
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public boolean isRootType() {
        return this._isRootType;
    }

    @Override
    public ITypeDesc getTypeDesc() {
        return this._typeDesc;
    }

    @Override
    public void setTypeDesc(ITypeDesc typeDesc) {
        if (typeDesc == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'typeDesc'");
        }
        this._typeDesc = typeDesc;
        this._inactive = typeDesc.isInactive();
    }

    @Override
    public boolean isActive() {
        return !this._inactive;
    }

    @Override
    public boolean isInactive() {
        return this._inactive;
    }

    @Override
    public void inactivateType() {
        this._inactive = true;
    }

    @Override
    public boolean isFifoSupported() {
        return this._typeDesc.isFifoSupported();
    }

    @Override
    public IServerTypeDesc[] getSuperTypes() {
        return this._superTypes;
    }

    @Override
    public IServerTypeDesc[] getAssignableTypes() {
        return this._assignableTypes;
    }

    @Override
    public boolean hasSubTypes() {
        return this._subTypes.length != 0;
    }

    @Override
    public IServerTypeDesc createCopy(IServerTypeDesc superType) {
        ServerTypeDesc copy = new ServerTypeDesc(this._typeId, this._typeName, this._typeDesc, superType, this._serverTypeDescCode);
        copy._inactive = this._inactive;
        IServerTypeDesc oldServerTypeDesc = _codesRepo.put(this._serverTypeDescCode, copy);
        if (oldServerTypeDesc != null) {
            oldServerTypeDesc.setMaybeOutdated();
        }
        for (int i = 0; i < this._subTypes.length; ++i) {
            this._subTypes[i].createCopy(copy);
        }
        return copy;
    }

    private IServerTypeDesc[] initSuperTypes(IServerTypeDesc superType) {
        if (superType == null) {
            return new IServerTypeDesc[]{this};
        }
        IServerTypeDesc[] superSuperTypes = superType.getSuperTypes();
        return ServerTypeDesc.prependItemToArray(superSuperTypes, new IServerTypeDesc[superSuperTypes.length + 1], this);
    }

    private static ITypeDesc createInactiveTypeDesc(String typeName, IServerTypeDesc[] superTypes) {
        String[] superTypesNames = new String[superTypes.length];
        for (int i = 0; i < superTypesNames.length; ++i) {
            superTypesNames[i] = superTypes[i].getTypeName();
        }
        return new InactiveTypeDesc(typeName, superTypesNames);
    }

    @Override
    public void addSubType(IServerTypeDesc subType) {
        if (subType.getSuperTypes()[1] == this) {
            this._subTypes = ServerTypeDesc.appendItemToArray(this._subTypes, subType);
        }
        this._assignableTypes = ServerTypeDesc.appendItemToArray(this._assignableTypes, subType);
        if (this._superTypes.length > 1) {
            this._superTypes[1].addSubType(subType);
        }
    }

    private static <T> T[] prependItemToArray(T[] source, T[] target, T newFirstItem) {
        target[0] = newFirstItem;
        System.arraycopy(source, 0, target, 1, source.length);
        return target;
    }

    private static IServerTypeDesc[] appendItemToArray(IServerTypeDesc[] source, IServerTypeDesc newLastItem) {
        IServerTypeDesc[] target = new IServerTypeDesc[source.length + 1];
        target[source.length] = newLastItem;
        System.arraycopy(source, 0, target, 0, source.length);
        return target;
    }

    public static boolean isEntry(IServerTypeDesc typeDesc) {
        return typeDesc.getTypeDesc().getIntrospector(null) instanceof EntryIntrospector;
    }

    @Override
    public short getServerTypeDescCode() {
        return this._serverTypeDescCode;
    }

    @Override
    public boolean isMaybeOutdated() {
        return this._maybeOutdated;
    }

    @Override
    public void setMaybeOutdated() {
        this._maybeOutdated = true;
    }
}

