/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.client.spaceproxy.metadata.ClientTypeDescRepository;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.client.spaceproxy.metadata.TypeDescFactory;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.server.metadata.AddTypeDescResult;
import com.gigaspaces.internal.server.metadata.AddTypeDescResultType;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceInstanceConfig;
import com.gigaspaces.internal.server.space.metadata.IServerTypeDescListener;
import com.gigaspaces.internal.server.space.metadata.ServerTypeDesc;
import com.gigaspaces.internal.transport.ITransportPacket;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.j_spaces.core.DetailedUnusableEntryException;
import com.j_spaces.core.DropClassException;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.exception.internal.DirectoryInternalSpaceException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;

@InternalApi
public class SpaceTypeManager {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.typemanager");
    private static final boolean SUPPORT_CHECKSUM = Boolean.parseBoolean(System.getProperty("com.gs.type.checksum-validation", "true"));
    private final TypeDescFactory _typeDescFactory;
    private volatile Map<String, IServerTypeDesc> _typeMap;
    private final Object _typeDescLock = new Object();
    private final AtomicInteger _typeIdGenerator;
    private final Set<IServerTypeDescListener> _typeDescListeners;

    public SpaceTypeManager(SpaceConfigReader configReader) {
        this(new TypeDescFactory(), configReader);
    }

    public SpaceTypeManager(TypeDescFactory typeDescFactory, SpaceConfigReader configReader) {
        SpaceTypeManager.logEnter("SpaceTypeManager.ctor", "spaceName", configReader.getFullSpaceName());
        this._typeDescFactory = typeDescFactory;
        this._typeMap = new HashMap<String, IServerTypeDesc>();
        this._typeIdGenerator = new AtomicInteger();
        this._typeDescListeners = new HashSet<IServerTypeDescListener>();
        ITypeDesc objectTypeDesc = this._typeDescFactory.createPojoTypeDesc(Object.class, null, null);
        IServerTypeDesc rootTypeDesc = this.createServerTypeDescInstance(IServerTypeDesc.ROOT_TYPE_NAME, objectTypeDesc, null, this._typeMap);
        this._typeMap.put(null, rootTypeDesc);
        this.createServerTypeDescInstance("com.gigaspaces.SystemType", null, null, this._typeMap);
        SpaceTypeManager.logExit("SpaceTypeManager.ctor", "spaceName", configReader.getFullSpaceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTypeDescListener(IServerTypeDescListener listener) {
        Object object = this._typeDescLock;
        synchronized (object) {
            this._typeDescListeners.add(listener);
            for (IServerTypeDesc typeDesc : this._typeMap.values()) {
                listener.onTypeAdded(typeDesc);
            }
        }
    }

    public Object getTypeDescLock() {
        return this._typeDescLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITypeDesc[] addIndexes(String typeName, SpaceIndex[] newIndexes) {
        Object object = this._typeDescLock;
        synchronized (object) {
            IServerTypeDesc typeDesc = this._typeMap.get(typeName);
            if (typeDesc == null) {
                throw new SpaceMetadataException("Cannot add indexes to type '" + typeName + "' because it is not registered in the server.");
            }
            ITypeDesc[] updatedTypeDescriptors = SpaceTypeManager.generateUpdatedTypeDescriptors(typeDesc.getAssignableTypes(), newIndexes);
            if (updatedTypeDescriptors.length == 0) {
                return updatedTypeDescriptors;
            }
            Map<String, IServerTypeDesc> localTypeMap = this.cloneTypeMap(this._typeMap, typeDesc.getTypeDesc().isSystemType());
            for (ITypeDesc updatedTypeDesc : updatedTypeDescriptors) {
                IServerTypeDesc updatedServerTypeDesc = localTypeMap.get(updatedTypeDesc.getTypeName());
                updatedServerTypeDesc.setTypeDesc(updatedTypeDesc);
                for (IServerTypeDescListener listener : this._typeDescListeners) {
                    listener.onTypeIndexAdded(updatedServerTypeDesc);
                }
            }
            this._typeMap = localTypeMap;
            return updatedTypeDescriptors;
        }
    }

    private static ITypeDesc[] generateUpdatedTypeDescriptors(IServerTypeDesc[] serverTypes, SpaceIndex[] newIndexes) throws SpaceMetadataException {
        ArrayList<ITypeDesc> result = new ArrayList<ITypeDesc>();
        for (IServerTypeDesc serverType : serverTypes) {
            if (serverType.isInactive()) {
                throw new SpaceMetadataException("Cannot add indexes to type '" + serverType.getTypeName() + "' because it is inactive in the server.");
            }
            ArrayList<SpaceIndex> newIndexesList = new ArrayList<SpaceIndex>(newIndexes.length);
            for (int i = 0; i < newIndexes.length; ++i) {
                SpaceIndex currIndex = serverType.getTypeDesc().getIndexes().get(newIndexes[i].getName());
                if (currIndex == null) {
                    newIndexesList.add(newIndexes[i]);
                    continue;
                }
                SpaceTypeManager.validateIndexIsEquivalent(newIndexes[i], currIndex, serverType.getTypeName());
            }
            if (newIndexesList.isEmpty()) continue;
            result.add(SpaceTypeManager.generateUpdatedTypeDescriptor(serverType.getTypeDesc(), newIndexesList));
        }
        return result.toArray(new ITypeDesc[result.size()]);
    }

    private static ITypeDesc generateUpdatedTypeDescriptor(ITypeDesc currTypeDesc, List<SpaceIndex> newIndexesList) {
        ITypeDesc newTypeDesc = currTypeDesc.clone();
        for (SpaceIndex newIndex : newIndexesList) {
            newTypeDesc.getIndexes().put(newIndex.getName(), newIndex);
        }
        return newTypeDesc;
    }

    private static void validateIndexIsEquivalent(SpaceIndex newIndex, SpaceIndex currIndex, String typeName) throws SpaceMetadataException {
        if (newIndex.getIndexType() != currIndex.getIndexType()) {
            throw new SpaceMetadataException("Cannot add index '" + newIndex.getName() + "' of type " + (Object)((Object)newIndex.getIndexType()) + " to space type '" + typeName + "' because it already contains an index with the same name of type " + (Object)((Object)currIndex.getIndexType()) + ".");
        }
    }

    public IServerTypeDesc getServerTypeDesc(String typeName) {
        return this._typeMap.get(typeName);
    }

    public ITypeDesc getTypeDesc(String typeName) {
        IServerTypeDesc serverTypeDesc = this._typeMap.get(typeName);
        return serverTypeDesc == null ? null : serverTypeDesc.getTypeDesc();
    }

    public Map<String, IServerTypeDesc> getSafeTypeTable() {
        return this._typeMap;
    }

    public IServerTypeDesc loadServerTypeDesc(ITransportPacket packet) throws UnusableEntryException, UnknownTypeException {
        String typeName = packet.getTypeName();
        SpaceTypeManager.logEnter("loadServerTypeDesc", "typeName", typeName);
        IServerTypeDesc serverTypeDesc = this._typeMap.get(typeName);
        if (SpaceTypeManager.requiresRegistration(serverTypeDesc, packet.getEntryType())) {
            ITypeDesc typeDesc = packet.getTypeDescriptor();
            if (typeDesc == null) {
                if (typeName != null) {
                    throw new UnknownTypeException("Insufficient Data In Class : " + typeName, typeName);
                }
                serverTypeDesc = this.getTypeDescriptorByObject(new Object(), ObjectType.POJO);
            } else {
                AddTypeDescResult result = this.createOrUpdateServerTypeDesc(typeName, typeDesc, packet.getEntryType());
                serverTypeDesc = result.getServerTypeDesc();
            }
        }
        SpaceTypeManager.validateChecksum(typeName, packet, serverTypeDesc.getTypeDesc());
        packet.setTypeDesc(serverTypeDesc.getTypeDesc(), false);
        SpaceTypeManager.logExit("loadServerTypeDesc", "typeName", typeName);
        return serverTypeDesc;
    }

    public AddTypeDescResult addTypeDesc(ITypeDesc typeDesc) throws DetailedUnusableEntryException {
        String typeName = typeDesc.getTypeName();
        SpaceTypeManager.logEnter("addTypeDesc", "typeName", typeName);
        IServerTypeDesc serverTypeDesc = this._typeMap.get(typeName);
        AddTypeDescResult result = null;
        AddTypeDescResultType action = SpaceTypeManager.getAddTypeDescAction(serverTypeDesc, typeDesc.getObjectType());
        result = action != AddTypeDescResultType.NONE ? this.createOrUpdateServerTypeDesc(typeName, typeDesc, typeDesc.getObjectType()) : new AddTypeDescResult(serverTypeDesc, action);
        SpaceTypeManager.validateChecksum(typeName, typeDesc, result.getServerTypeDesc().getTypeDesc());
        SpaceTypeManager.logExit("addTypeDesc", "typeName", typeName);
        return result;
    }

    private static boolean requiresRegistration(IServerTypeDesc serverTypeDesc, EntryType entryType) {
        return SpaceTypeManager.getAddTypeDescAction(serverTypeDesc, entryType) != AddTypeDescResultType.NONE;
    }

    private static AddTypeDescResultType getAddTypeDescAction(IServerTypeDesc serverTypeDesc, EntryType entryType) {
        if (serverTypeDesc == null) {
            return AddTypeDescResultType.CREATED;
        }
        if (serverTypeDesc.isInactive()) {
            return AddTypeDescResultType.ACTIVATED;
        }
        if (!serverTypeDesc.getTypeDesc().supports(entryType)) {
            return AddTypeDescResultType.UPDATED;
        }
        return AddTypeDescResultType.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddTypeDescResult createOrUpdateServerTypeDesc(String typeName, ITypeDesc typeDesc, EntryType requestType) {
        Object object = this._typeDescLock;
        synchronized (object) {
            SpaceTypeManager.logEnter("createOrUpdateServerTypeDesc", "typeName", typeName);
            IServerTypeDesc serverTypeDesc = this._typeMap.get(typeName);
            AddTypeDescResultType action = SpaceTypeManager.getAddTypeDescAction(serverTypeDesc, requestType);
            if (action != AddTypeDescResultType.NONE) {
                Map<String, IServerTypeDesc> localTypeMap = this.cloneTypeMap(this._typeMap, typeDesc.isSystemType());
                serverTypeDesc = localTypeMap.get(typeName);
                if (action == AddTypeDescResultType.CREATED) {
                    serverTypeDesc = this.createServerTypeDesc(typeDesc, localTypeMap);
                } else if (action == AddTypeDescResultType.ACTIVATED) {
                    this.activateServerTypeDesc(serverTypeDesc, typeDesc, localTypeMap);
                } else if (action == AddTypeDescResultType.UPDATED) {
                    serverTypeDesc = this.updateServerTypeDesc(serverTypeDesc, typeDesc);
                }
                this._typeMap = localTypeMap;
            }
            SpaceTypeManager.logExit("createOrUpdateServerTypeDesc", "typeName", typeName);
            return new AddTypeDescResult(serverTypeDesc, action);
        }
    }

    private IServerTypeDesc createServerTypeDesc(ITypeDesc typeDesc, Map<String, IServerTypeDesc> localTypeMap) {
        String typeName = typeDesc.getTypeName();
        SpaceTypeManager.logEnter("createServerTypeDesc", "typeName", typeName);
        String[] superClasses = typeDesc.getRestrictSuperClassesNames();
        String rootTypeName = typeDesc.isSystemType() ? "com.gigaspaces.SystemType" : IServerTypeDesc.ROOT_TYPE_NAME;
        for (int i = superClasses.length - 1; i >= 0; --i) {
            String currTypeName = superClasses[i];
            if (localTypeMap.containsKey(currTypeName)) continue;
            String superTypeName = i != superClasses.length - 1 ? superClasses[i + 1] : rootTypeName;
            this.createServerTypeDescInstance(currTypeName, null, superTypeName, localTypeMap);
        }
        String superTypeName = superClasses.length != 0 ? superClasses[0] : rootTypeName;
        IServerTypeDesc serverTypeDesc = this.createServerTypeDescInstance(typeName, typeDesc, superTypeName, localTypeMap);
        SpaceTypeManager.logExit("createServerTypeDesc", "typeName", typeName);
        return serverTypeDesc;
    }

    private IServerTypeDesc createServerTypeDescInstance(String typeName, ITypeDesc typeDesc, String superTypeName, Map<String, IServerTypeDesc> localTypeMap) {
        SpaceTypeManager.logEnter("createServerTypeDescInstance", "typeName", typeName);
        IServerTypeDesc superTypeDesc = superTypeName != null ? localTypeMap.get(superTypeName) : null;
        ServerTypeDesc serverTypeDesc = new ServerTypeDesc(this._typeIdGenerator.incrementAndGet(), typeName, typeDesc, superTypeDesc);
        localTypeMap.put(typeName, serverTypeDesc);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Created ServerTypeDesc for type [" + typeName + "]." + SpaceTypeManager.getClientAddressAddition());
            if (_logger.isLoggable(Level.FINEST)) {
                SpaceTypeManager.logTypeMap(localTypeMap, Level.FINEST);
            } else if (_logger.isLoggable(Level.FINER)) {
                SpaceTypeManager.logServerTypeDesc(serverTypeDesc, Level.FINER);
            }
        }
        for (IServerTypeDescListener listener : this._typeDescListeners) {
            listener.onTypeAdded(serverTypeDesc);
        }
        SpaceTypeManager.logExit("createServerTypeDescInstance", "typeName", typeName);
        return serverTypeDesc;
    }

    private void activateServerTypeDesc(IServerTypeDesc serverTypeDesc, ITypeDesc typeDesc, Map<String, IServerTypeDesc> localTypeMap) {
        String typeName = serverTypeDesc.getTypeName();
        SpaceTypeManager.logEnter("activateServerTypeDesc", "typeName", typeName);
        serverTypeDesc.setTypeDesc(typeDesc);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Activated ServerTypeDesc [" + typeName + "]." + SpaceTypeManager.getClientAddressAddition());
            if (_logger.isLoggable(Level.FINEST)) {
                SpaceTypeManager.logTypeMap(localTypeMap, Level.FINEST);
            } else if (_logger.isLoggable(Level.FINER)) {
                SpaceTypeManager.logServerTypeDesc(serverTypeDesc, Level.FINER);
            }
        }
        for (IServerTypeDescListener listener : this._typeDescListeners) {
            listener.onTypeActivated(serverTypeDesc);
        }
        SpaceTypeManager.logExit("activateServerTypeDesc", "typeName", typeName);
    }

    private static String getClientAddressAddition() {
        InetSocketAddress clientEndPointAddress = LRMIInvocationContext.getEndpointAddress();
        return " [clientAddress=" + (clientEndPointAddress != null ? clientEndPointAddress : "colocated") + "]";
    }

    private IServerTypeDesc updateServerTypeDesc(IServerTypeDesc serverTypeDesc, ITypeDesc typeDesc) {
        SpaceTypeManager.logEnter("updateServerTypeDesc", "typeName", serverTypeDesc.getTypeName());
        serverTypeDesc.setTypeDesc(typeDesc);
        SpaceTypeManager.logExit("updateServerTypeDesc", "typeName", serverTypeDesc.getTypeName());
        return serverTypeDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropClass(String typeName) throws DropClassException {
        if (typeName == null || typeName.equals(IServerTypeDesc.ROOT_TYPE_NAME)) {
            throw new DropClassException("Invalid class name specified", typeName);
        }
        Object object = this._typeDescLock;
        synchronized (object) {
            IServerTypeDesc typeDesc = this._typeMap.get(typeName);
            if (typeDesc == null || typeDesc.isInactive()) {
                return;
            }
            for (IServerTypeDesc subTypeDesc : typeDesc.getAssignableTypes()) {
                if (subTypeDesc.getTypeName().equals(typeName) || !subTypeDesc.isActive()) continue;
                throw new DropClassException("Drop class failed. " + typeName + " class has an active subclass = " + subTypeDesc.getTypeName(), typeName);
            }
            Map<String, IServerTypeDesc> typeMapCopy = this.cloneTypeMap(this._typeMap, typeDesc.getTypeDesc().isSystemType());
            if ((typeDesc = typeMapCopy.get(typeName)) == null) {
                throw new DirectoryInternalSpaceException("internal error - dropClass " + typeName + " class does not exist");
            }
            if (typeDesc.isInactive()) {
                throw new DirectoryInternalSpaceException("internal error - dropClass " + typeName + " class not active");
            }
            typeDesc.inactivateType();
            for (IServerTypeDescListener listener : this._typeDescListeners) {
                listener.onTypeDeactivated(typeDesc);
            }
            this._typeMap = typeMapCopy;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "setting " + typeDesc.getTypeName() + " to inActive");
            }
        }
    }

    private static void validateChecksum(String typeName, ITransportPacket packet, ITypeDesc serverTypeDesc) throws DetailedUnusableEntryException, UnknownTypeException {
        if (typeName == null || !SUPPORT_CHECKSUM || !packet.supportsTypeDescChecksum()) {
            return;
        }
        if (serverTypeDesc.getChecksum() == packet.getTypeDescChecksum()) {
            return;
        }
        ITypeDesc clientTypeDesc = packet.getTypeDescriptor();
        if (clientTypeDesc == null) {
            throw new UnknownTypeException("Client checksum " + packet.getTypeDescChecksum() + " for type [" + typeName + "] does not match server checksum " + serverTypeDesc.getChecksum(), typeName);
        }
        SpaceTypeManager.validateChecksum(typeName, clientTypeDesc, serverTypeDesc);
    }

    private static void validateChecksum(String typeName, ITypeDesc clientTypeDesc, ITypeDesc serverTypeDesc) throws DetailedUnusableEntryException {
        if (serverTypeDesc.getChecksum() == clientTypeDesc.getChecksum() || !SUPPORT_CHECKSUM) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("The operation's type description is incompatible with the type description stored in the space.\n");
        sb.append(String.format("Type=[%s], Server checksum=[%d], Operation checksum=[%d].%n", typeName, serverTypeDesc.getChecksum(), clientTypeDesc.getChecksum()));
        SpaceTypeManager.printTypeDesc(sb, serverTypeDesc, "Server type description:\n");
        sb.append("\n");
        SpaceTypeManager.printTypeDesc(sb, clientTypeDesc, "Operation type description:\n");
        String message = sb.toString();
        if (_logger.isLoggable(Level.SEVERE)) {
            _logger.log(Level.SEVERE, message);
        }
        throw new DetailedUnusableEntryException(message);
    }

    private static void printTypeDesc(StringBuilder sb, ITypeDesc typeDesc, String header) {
        int i;
        String[] superClasses = typeDesc.getSuperClassesNames();
        PropertyInfo[] properties = typeDesc.getProperties();
        sb.append(header);
        sb.append(String.format("Super classes: %d%n", superClasses.length));
        for (i = 0; i < superClasses.length; ++i) {
            sb.append(String.format("%4d: Type=[%s]%n", i + 1, superClasses[i]));
        }
        sb.append(String.format("Properties: %d%n", properties.length));
        for (i = 0; i < properties.length; ++i) {
            sb.append(String.format("%4d: Name=[%s], Type=[%s]%n", i + 1, properties[i].getName(), properties[i].getTypeName()));
        }
        sb.append(String.format("Checksum: %d.%n", typeDesc.getChecksum()));
    }

    private Map<String, IServerTypeDesc> cloneTypeMap(Map<String, IServerTypeDesc> typeMap, boolean isSystem) {
        if (typeMap.isEmpty()) {
            return typeMap;
        }
        IServerTypeDesc rootTypeDesc = typeMap.get(IServerTypeDesc.ROOT_TYPE_NAME);
        IServerTypeDesc rootSystemTypeDesc = typeMap.get("com.gigaspaces.SystemType");
        if (isSystem) {
            rootSystemTypeDesc = rootSystemTypeDesc.createCopy(null);
        } else {
            rootTypeDesc = rootTypeDesc.createCopy(null);
        }
        HashMap<String, IServerTypeDesc> typeMapCopy = new HashMap<String, IServerTypeDesc>(typeMap.size());
        typeMapCopy.put(null, rootTypeDesc);
        for (IServerTypeDesc subType : rootTypeDesc.getAssignableTypes()) {
            typeMapCopy.put(subType.getTypeName(), subType);
        }
        for (IServerTypeDesc subType : rootSystemTypeDesc.getAssignableTypes()) {
            typeMapCopy.put(subType.getTypeName(), subType);
        }
        return typeMapCopy;
    }

    public IServerTypeDesc getTypeDescriptorByObject(Object obj, ObjectType objectType) throws UnknownTypeException {
        String typeName;
        EntryType entryType;
        if (objectType == ObjectType.EXTERNAL_ENTRY) {
            entryType = EntryType.EXTERNAL_ENTRY;
            typeName = ((ExternalEntry)obj).getClassName();
        } else if (objectType == ObjectType.DOCUMENT) {
            entryType = EntryType.DOCUMENT_JAVA;
            typeName = ((SpaceDocument)obj).getTypeName();
        } else {
            entryType = EntryType.OBJECT_JAVA;
            typeName = obj.getClass().getName();
        }
        IServerTypeDesc serverTypeDesc = this._typeMap.get(typeName);
        if (SpaceTypeManager.requiresRegistration(serverTypeDesc, entryType)) {
            ITypeDesc typeDesc = this.createTypeDescByObject(obj, objectType);
            AddTypeDescResult result = this.createOrUpdateServerTypeDesc(typeName, typeDesc, entryType);
            serverTypeDesc = result.getServerTypeDesc();
        }
        return serverTypeDesc;
    }

    private ITypeDesc createTypeDescByObject(Object obj, ObjectType objectType) throws UnknownTypeException {
        switch (objectType) {
            case POJO: {
                return this.createPojoTypeDesc(obj.getClass(), null);
            }
            case ENTRY: {
                return this._typeDescFactory.createEntryTypeDesc((Entry)obj, obj.getClass().getName(), null, obj.getClass());
            }
            case DOCUMENT: {
                String typeName = ((SpaceDocument)obj).getTypeName();
                Class<?> type = ClientTypeDescRepository.getRealClass(typeName, null);
                if (type != null) {
                    return this.createPojoTypeDesc(type, null);
                }
                throw new UnknownTypeException("Type '" + typeName + "' is not registered in server.", typeName);
            }
            case EXTERNAL_ENTRY: {
                ExternalEntry externalEntry = (ExternalEntry)obj;
                return this._typeDescFactory.createExternalEntryTypeDesc(externalEntry, externalEntry.getClassName());
            }
            case ENTRY_PACKET: 
            case TEMPLATE_PACKET: {
                return ((ITransportPacket)obj).getTypeDescriptor();
            }
        }
        throw new IllegalArgumentException("Unsupported object type: " + (Object)((Object)objectType));
    }

    private ITypeDesc createPojoTypeDesc(Class<?> type, String codebase) {
        IServerTypeDesc serverTypeDesc = this._typeMap.get(type.getName());
        if (!SpaceTypeManager.requiresRegistration(serverTypeDesc, EntryType.OBJECT_JAVA)) {
            return serverTypeDesc.getTypeDesc();
        }
        Class<?> superType = type.getSuperclass();
        ITypeDesc superTypeDesc = superType == null ? null : this.createPojoTypeDesc(superType, codebase);
        ITypeDesc typeDesc = this._typeDescFactory.createPojoTypeDesc(type, codebase, superTypeDesc);
        this.createOrUpdateServerTypeDesc(type.getName(), typeDesc, EntryType.OBJECT_JAVA);
        return typeDesc;
    }

    public boolean isFifoType(IServerTypeDesc serverTypeDesc) {
        return serverTypeDesc.isActive() && serverTypeDesc.isFifoSupported();
    }

    private static void logServerTypeDesc(IServerTypeDesc serverTypeDesc, Level level) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Type name: [%s]%s%n", serverTypeDesc.getTypeName(), SpaceTypeManager.getClientAddressAddition()));
        sb.append(String.format("IsActive: %s%n", serverTypeDesc.isActive()));
        IServerTypeDesc[] superTypes = serverTypeDesc.getSuperTypes();
        sb.append(String.format("Super types: %d%n", superTypes.length));
        for (int i = 0; i < superTypes.length; ++i) {
            sb.append(String.format("%4d: Type=[%s]%n", i + 1, superTypes[i].getTypeName()));
        }
        IServerTypeDesc[] subTypes = serverTypeDesc.getAssignableTypes();
        sb.append(String.format("Sub types: %d%n", subTypes.length));
        for (int i = 0; i < subTypes.length; ++i) {
            sb.append(String.format("%4d: Type=[%s]%n", i + 1, subTypes[i].getTypeName()));
        }
        if (serverTypeDesc.isActive()) {
            ITypeDesc typeDesc = serverTypeDesc.getTypeDesc();
            PropertyInfo[] properties = typeDesc.getProperties();
            sb.append(String.format("Properties: %d%n", properties.length));
            for (int i = 0; i < properties.length; ++i) {
                sb.append(String.format("%4d: Name=[%s], Type=[%s]%n", i + 1, properties[i].getName(), properties[i].getTypeName()));
            }
            sb.append(String.format("Checksum: %d.%n", typeDesc.getChecksum()));
        }
        _logger.log(level, sb.toString());
    }

    private static void logTypeMap(Map<String, IServerTypeDesc> typeMap, Level level) {
        for (IServerTypeDesc typeDesc : typeMap.values()) {
            SpaceTypeManager.logServerTypeDesc(typeDesc, level);
        }
    }

    private static void logEnter(String methodName, String argName, Object argValue) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Entered " + methodName + ", " + argName + "=[" + argValue + "].");
        }
    }

    private static void logExit(String methodName, String argName, Object argValue) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Finished " + methodName + ", " + argName + "=[" + argValue + "].");
        }
    }

    public void loadSpaceTypes(SpaceURL url) throws DetailedUnusableEntryException {
        if (url != null) {
            SpaceTypeDescriptor[] typeDescriptors;
            SpaceInstanceConfig spaceInstanceConfig = (SpaceInstanceConfig)url.getCustomProperties().get("space-config");
            SpaceTypeDescriptor[] spaceTypeDescriptorArray = typeDescriptors = spaceInstanceConfig != null ? spaceInstanceConfig.getTypeDescriptors() : null;
            if (typeDescriptors != null) {
                for (SpaceTypeDescriptor typeDesc : typeDescriptors) {
                    this.addTypeDesc((ITypeDesc)typeDesc);
                }
            }
        }
    }
}

