/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.CompoundCustomTypeDataIndex;
import com.j_spaces.core.cache.CompoundIndexSegmentTypeData;
import com.j_spaces.core.cache.CustomMultiValueTypeDataIndex;
import com.j_spaces.core.cache.CustomTypeDataIndex;
import com.j_spaces.core.cache.MultiValueTypeDataIndex;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;

@InternalApi
public class TypeDataFactory {
    private final boolean _useEconomyHashMap;
    private final CacheManager _cacheManager;

    public TypeDataFactory(SpaceConfigReader configReader, CacheManager cacheManager) {
        this._useEconomyHashMap = configReader.getBooleanSpaceProperty("engine.use_economy_hashmap", "false");
        configReader.assertSpacePropertyNotExists("engine.extended-match.enabled-classes", "7.0.1", "8.0");
        this._cacheManager = cacheManager;
    }

    public boolean useEconomyHashMap() {
        return this._useEconomyHashMap;
    }

    public CacheManager getCcheManager() {
        return this._cacheManager;
    }

    public TypeData createTypeData(IServerTypeDesc serverTypeDesc) {
        return new TypeData(serverTypeDesc, this, this._cacheManager.getEngine().isLocalCache(), this._cacheManager.isResidentEntriesCachePolicy());
    }

    public TypeData createTypeDataOnDynamicIndexCreation(IServerTypeDesc serverTypeDesc, TypeData originalTypeData, TypeData.TypeDataRecreationReasons reason) {
        return new TypeData(serverTypeDesc, originalTypeData, reason);
    }

    public <K> TypeDataIndex<K> createTypeDataIndex(CacheManager cacheManager, ISpaceIndex index, int pos, int indexCreationNumber, Class<?> indexValueClass, ISpaceIndex.FifoGroupsIndexTypes fifoGroupsIndexType) {
        return new TypeDataIndex(cacheManager, index, pos, this._useEconomyHashMap, indexCreationNumber, indexValueClass, fifoGroupsIndexType);
    }

    public <K> TypeDataIndex<K> createMultiValuePerEntryTypeDataIndex(CacheManager cacheManager, ISpaceIndex index, int pos, int indexCreationNumber, ISpaceIndex.MultiValuePerEntryIndexTypes indexType) {
        return new MultiValueTypeDataIndex(cacheManager, index, pos, this._useEconomyHashMap, indexCreationNumber, indexType);
    }

    public <K> TypeDataIndex<K> createCustomTypeDataIndex(CacheManager cacheManager, ISpaceIndex index, int pos, int indexCreationNumber, ISpaceIndex.FifoGroupsIndexTypes fifoGroupsIndexType) {
        return new CustomTypeDataIndex(cacheManager, index, pos, indexCreationNumber, fifoGroupsIndexType);
    }

    public <K> TypeDataIndex<K> createCustomMultiValuePerEntryTypeDataIndex(CacheManager cacheManager, ISpaceIndex index, int pos, int indexCreationNumber, ISpaceIndex.MultiValuePerEntryIndexTypes indexType) {
        return new CustomMultiValueTypeDataIndex(cacheManager, index, pos, indexCreationNumber, indexType);
    }

    public <K> TypeDataIndex<K> createCompoundCustomTypeDataIndex(CacheManager cacheManager, ISpaceIndex index, CompoundIndexSegmentTypeData[] segments, int indexCreationNumber, int indexPosition, ISpaceIndex.FifoGroupsIndexTypes fifoGroupsIndexType) {
        return new CompoundCustomTypeDataIndex(cacheManager, index, segments, indexCreationNumber, indexPosition, fifoGroupsIndexType);
    }
}

