/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.AddEntryTypeIndexesSpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.AddEntryTypeIndexesSpaceOperationResult;
import com.gigaspaces.internal.cluster.node.IReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.operations.AbstractSpaceOperation;
import com.gigaspaces.internal.space.requests.AddTypeIndexesRequestInfo;

@InternalApi
public class AddEntryTypeIndexesSpaceOperation
extends AbstractSpaceOperation<AddEntryTypeIndexesSpaceOperationResult, AddEntryTypeIndexesSpaceOperationRequest> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(AddEntryTypeIndexesSpaceOperationRequest request, AddEntryTypeIndexesSpaceOperationResult result, SpaceImpl space, boolean oneway) throws Exception {
        ITypeDesc[] results = space.getEngine().getTypeManager().addIndexes(request.getTypeName(), request.getIndexes());
        result.setUpdatedTypeDescriptors(results);
        IReplicationOutContext context = space.getEngine().getReplicationNode().createContext();
        try {
            if (request.isFromGateway()) {
                ((ReplicationOutContext)context).setFromGateway(true);
            }
            AddTypeIndexesRequestInfo requestInfo = new AddTypeIndexesRequestInfo(request.getTypeName(), request.getIndexes(), null);
            requestInfo.setFromGateway(request.isFromGateway());
            space.getEngine().getReplicationNode().outDataTypeAddIndex(context, requestInfo);
            space.getEngine().getReplicationNode().execute(context);
        }
        finally {
            context.release();
        }
    }

    @Override
    public String getLogName(AddEntryTypeIndexesSpaceOperationRequest request, AddEntryTypeIndexesSpaceOperationResult result) {
        return "add indexes";
    }
}

